/*
 * monorail-handler.h
 *
 * Copyright (C) 2009 Collabora Ltd. <http://www.collabora.co.uk/>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __MONORAIL_HANDLER_H__
#define __MONORAIL_HANDLER_H__

#include <glib-object.h>

#include "empathy-ft-factory.h"

G_BEGIN_DECLS

#define MONORAIL_TYPE_HANDLER \
  (monorail_handler_get_type ())
#define MONORAIL_HANDLER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), MONORAIL_TYPE_HANDLER, \
   MonorailHandler))
#define MONORAIL_HANDLER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), MONORAIL_TYPE_HANDLER, \
   MonorailHandlerClass))
#define MONORAIL_IS_HANDLER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), MONORAIL_TYPE_HANDLER))
#define MONORAIL_IS_HANDLER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), MONORAIL_TYPE_HANDLER))
#define MONORAIL_HANDLER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), MONORAIL_TYPE_HANDLER, \
   MonorailHandlerClass))

typedef struct _MonorailHandler MonorailHandler;
typedef struct _MonorailHandlerClass MonorailHandlerClass;

struct _MonorailHandlerClass {
    GObjectClass parent_class;
};

struct _MonorailHandler {
    GObject parent;
};

GType monorail_handler_get_type (void);

MonorailHandler * monorail_handler_new (const gchar *handler_name,
    gboolean approver);
EmpathyFTFactory * monorail_handler_get_factory (MonorailHandler *self);
const gchar * monorail_handler_get_name (MonorailHandler *self);

G_END_DECLS

#endif /* #ifndef __MONORAIL_HANDLER_H__*/
