/*
 * incoming.c
 *
 * Copyright (C) 2009 Collabora Ltd. <http://www.collabora.co.uk/>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <hildon/hildon-fm.h>

#include "incoming.h"

static void
file_chooser_response (GtkDialog *dialog,
    gint response_id,
    IncomingData *data)
{
  GFile *dest;
  EmpathyFTFactory *factory;

  if (response_id == GTK_RESPONSE_OK)
    {
      factory = monorail_handler_get_factory (data->handler);

      dest = gtk_file_chooser_get_file (GTK_FILE_CHOOSER (dialog));

      if (dest == NULL)
        {
          hildon_banner_show_information (data->monorail_data->contact_window, NULL,
              "Invalid file");
          gtk_widget_show (GTK_WIDGET (dialog));
          return;
        }

      empathy_ft_factory_set_destination_for_incoming_handler (factory,
          data->ft_handler, dest);

      g_object_unref (dest);
    }
  else
    {
      empathy_ft_handler_cancel_transfer (data->ft_handler);
    }

  gtk_widget_destroy (GTK_WIDGET (dialog));

  monorail_transfers_dec (data->monorail_data, FALSE);

  g_object_unref (data->handler);
  g_object_unref (data->ft_handler);
  g_slice_free (IncomingData, data);
}

void
incoming_transfer (MonorailHandler *handler,
    EmpathyFTHandler *ft_handler,
    MonorailData *monorail_data)
{
  GtkWidget *dialog;
  IncomingData *data;

  monorail_transfers_inc (monorail_data, FALSE);

  data = g_slice_new0 (IncomingData);
  data->monorail_data = monorail_data;
  data->handler = g_object_ref (handler);
  data->ft_handler = g_object_ref (ft_handler);

  dialog = hildon_file_chooser_dialog_new (
      GTK_WINDOW (monorail_data->contact_window),
      GTK_FILE_CHOOSER_ACTION_SAVE);

  gtk_file_chooser_set_current_name (GTK_FILE_CHOOSER (dialog),
      empathy_ft_handler_get_filename (ft_handler));

  gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (dialog),
      "/home/user/MyDocs/.documents/");

  g_signal_connect (dialog, "response", G_CALLBACK (file_chooser_response),
      data);

  gtk_widget_show (dialog);
}

