/*
 * contact-chooser.h
 *
 * Copyright (C) 2009 Collabora Ltd. <http://www.collabora.co.uk/>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __MONORAIL_CONTACT_CHOOSER_H__
#define __MONORAIL_CONTACT_CHOOSER_H__

#include <glib-object.h>

#include <libosso-abook/osso-abook.h>

G_BEGIN_DECLS

#define MONORAIL_TYPE_CONTACT_CHOOSER \
  (monorail_contact_chooser_get_type ())
#define MONORAIL_CONTACT_CHOOSER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), MONORAIL_TYPE_CONTACT_CHOOSER, \
   MonorailContactChooser))
#define MONORAIL_CONTACT_CHOOSER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), MONORAIL_TYPE_CONTACT_CHOOSER, \
   MonorailContactChooserClass))
#define MONORAIL_IS_CONTACT_CHOOSER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), MONORAIL_TYPE_CONTACT_CHOOSER))
#define MONORAIL_IS_CONTACT_CHOOSER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), MONORAIL_TYPE_CONTACT_CHOOSER))
#define MONORAIL_CONTACT_CHOOSER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), MONORAIL_TYPE_CONTACT_CHOOSER, \
   MonorailContactChooserClass))

typedef struct _MonorailContactChooser MonorailContactChooser;
typedef struct _MonorailContactChooserClass MonorailContactChooserClass;

struct _MonorailContactChooserClass {
  OssoABookContactViewClass parent_class;
};

struct _MonorailContactChooser {
  OssoABookContactView parent;
};

GType monorail_contact_chooser_get_type (void);

GtkWidget * monorail_contact_chooser_new (void);

gboolean monorail_contact_chooser_can_send_to_roster_contact (
    MonorailContactChooser *self, OssoABookContact *roster_contact);
G_END_DECLS

#endif /* #ifndef __MONORAIL_CONTACT_CHOOSER_H__*/
