/*
 * approve.h
 *
 * Copyright (C) 2009 Collabora Ltd. <http://www.collabora.co.uk/>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <telepathy-glib/channel-dispatch-operation.h>

#include "monorail.h"

#ifndef __APPROVE_H__
#define __APPROVE_H__

typedef struct
{
  MonorailData *monorail_data;
  TpChannelDispatchOperation *operation;
  TpChannel *channel;
  GtkWidget *label;
  OssoABookRoster *abook;
  OssoABookWaitableClosure *abook_wait_closure;
  gchar *account_object_path;
  gchar *target_id;
  gchar *size_str;
  gchar *filename;
} ApproveData;

void approve_channel (MonorailHandler *handler,
    TpChannel **channels, TpChannelDispatchOperation *operation,
    GHashTable *cdo_properties, MonorailData *monorail_data);

#endif
