#include <glib.h>
#include <sharing-plugin-interface.h>
#include <sharing-transfer.h>
#include <conicconnection.h>
#include <osso-log.h>
#include <hildon/hildon.h>
#include <string.h>

#include "contact-chooser.h"
#include "monorail-handler.h"

#define DEBUG(format, ...) \
  monorail_debug ("%s: " format, G_STRFUNC, ##__VA_ARGS__)

static void
monorail_debug (const gchar *format,
    ...)
{
  va_list args;

  va_start (args, format);
  g_logv (G_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, format, args);
  va_end (args);
}

guint sharing_plugin_interface_init (gboolean* dead_mans_switch);
guint sharing_plugin_interface_uninit (gboolean* dead_mans_switch);
SharingPluginInterfaceSendResult sharing_plugin_interface_send (
		SharingTransfer* transfer, ConIcConnection* con,
		gboolean* dead_mans_switch);
SharingPluginInterfaceAccountSetupResult
sharing_plugin_interface_account_setup (
		GtkWindow* parent,
		SharingService* service, SharingAccount** worked_on,
		osso_context_t* osso);
SharingPluginInterfaceEditAccountResult
sharing_plugin_interface_edit_account (
		GtkWindow* parent,
		SharingAccount* account,
		ConIcConnection* con,
		gboolean* dead_mans_switch);
SharingPluginInterfaceAccountValidateResult
sharing_plugin_interface_account_validate (
		SharingAccount* account, ConIcConnection* con,
		gboolean *cont, gboolean* dead_mans_switch);

guint
sharing_plugin_interface_init (gboolean *dead_mans_switch)
{
    *dead_mans_switch = FALSE;
    return 0;
}

guint
sharing_plugin_interface_uninit (gboolean *dead_mans_switch)
{
    *dead_mans_switch = FALSE;
    DEBUG ("Cleaning up");
    return 0;
}


SharingPluginInterfaceAccountValidateResult
sharing_plugin_interface_account_validate (SharingAccount* account,
                                           ConIcConnection* con,
                                           gboolean *cont,
                                           gboolean* dead_mans_switch)
{
    *dead_mans_switch = FALSE;
    return SHARING_ACCOUNT_VALIDATE_SUCCESS;
}

SharingPluginInterfaceAccountSetupResult
sharing_plugin_interface_account_setup (
		GtkWindow* parent,
		SharingService* service, SharingAccount** worked_on,
		osso_context_t* osso)
{
  sharing_account_set_param (*worked_on, "username", "telepathylol");
  return SHARING_EDIT_ACCOUNT_SUCCESS;
}

SharingPluginInterfaceEditAccountResult
sharing_plugin_interface_edit_account (GtkWindow* parent,
                                       SharingAccount* account,
                                       ConIcConnection* con,
                                       gboolean* dead_mans_switch)
{
  GtkWidget *widget, *button;
  gint response;

  widget = gtk_dialog_new_with_buttons ("Edit account", parent,
      GTK_DIALOG_MODAL, NULL);
  button = gtk_dialog_add_button (GTK_DIALOG (widget),
      GTK_STOCK_DELETE, GTK_RESPONSE_REJECT);
  gtk_widget_show (button);

  response = gtk_dialog_run (GTK_DIALOG (widget));
  gtk_widget_destroy (widget);

  if (response == GTK_RESPONSE_REJECT)
    return SHARING_EDIT_ACCOUNT_DELETE;
  else
    return SHARING_EDIT_ACCOUNT_CANCELLED;
}

static gboolean
dead_mans_switch_timeout (gpointer user_data)
{
  gboolean *dead_mans_switch = user_data;
  DEBUG ("dead mans switch!");
  *dead_mans_switch = FALSE;
  return TRUE;
}

static void
new_ft_handler (MonorailHandler *handler,
    EmpathyFTHandler *ft_handler,
    gpointer user_data)
{
  DEBUG ("zomg new ft handler");
  /*
  g_signal_connect (ft_handler, "transfer-progress",
      G_CALLBACK (transfer_progress), NULL);
  g_signal_connect (ft_handler, "transfer-done",
      G_CALLBACK (transfer_done), NULL);
  g_signal_connect (ft_handler, "transfer-error",
      G_CALLBACK (transfer_error), NULL);
  */
}

SharingPluginInterfaceSendResult
sharing_plugin_interface_send (SharingTransfer* transfer,
                               ConIcConnection* con,
                               gboolean* dead_mans_switch)
{
    SharingEntry *entry = sharing_transfer_get_entry (transfer);
    /*
    SharingAccount *account = sharing_entry_get_account (entry);
    */
    SharingPluginInterfaceSendResult ret = SHARING_SEND_ERROR_CONNECTION;
    guint timeout_id = 0;
    GtkWidget *dialog;
    gint response;
    GList *list, *roster;
    GSList* p;
    OssoABookContact *contact;
    McAccount *mcaccount;
    MonorailHandler *handler;
    TpDBusDaemon *dbus;
    EmpathyFTFactory *factory;
    TpAccount *account;

    sharing_transfer_set_progress (transfer, 0.0);
    *dead_mans_switch = FALSE;

    DEBUG ("adding timeout");

    /*
     * add a timeout to keep changing the dead mans switch to FALSE. sorry
     */
    timeout_id = g_timeout_add_seconds (10, dead_mans_switch_timeout, dead_mans_switch);

    DEBUG ("set timeout");

    /*
     * pop up a dialog to get the user's choice of contact to send to
     * call gtk_dialog_run
     * get the response
     */
    DEBUG ("hm?");
    dialog = monorail_contact_chooser_new (NULL, "Choose contact");

    DEBUG ("about to run dialog");
    response = gtk_dialog_run (GTK_DIALOG (dialog));

    if (response != GTK_RESPONSE_OK)
      {
        g_source_remove (timeout_id);
        gtk_widget_destroy (dialog);
        DEBUG ("dialog was cancelled");
        return SHARING_SEND_CANCELLED;
      }

    DEBUG ("dialog got repsonse %i", response);

    list = osso_abook_contact_chooser_get_selection (OSSO_ABOOK_CONTACT_CHOOSER (dialog));
    contact = list->data; /* only one item */

    roster = osso_abook_contact_get_roster_contacts (list->data);

    /* TODO: don't just choose the first roster contact */
    contact = OSSO_ABOOK_CONTACT (roster->data);
    mcaccount = osso_abook_contact_get_account (contact);

    g_list_free (roster);
    g_list_free (list);
    gtk_widget_destroy (dialog);

    if (contact == NULL || mcaccount == NULL)
      {
        DEBUG ("contact or the mcaccount was NULL");
        g_source_remove (timeout_id);
        return SHARING_SEND_ERROR_UNKNOWN;
      }

    DEBUG ("got both contact and mcaccount");

    /*
     * find total bytes to do file transfer progress / total
     */
    guint64 total_bytes = 0;
    for (p = sharing_entry_get_media (entry); p; p = g_slist_next (p)) {
        SharingEntryMedia *media = p->data;
        if (!sharing_entry_media_get_sent (media)) {
            total_bytes += sharing_entry_media_get_size (media);
            ULOG_INFO_F("total_bytes = %llu", total_bytes);
        }
    }

    DEBUG ("found total bytes");

    if (!total_bytes)
      total_bytes = 1;
    guint64 sent_bytes = 0;

    DEBUG ("about to create new monorail handler");
    /*
     * create new monorail handler without approver on new bus name
     * MonorailSharingPlugin?
     * connect to its signals
     */
    handler = monorail_handler_new ("MonorailSharingPlugin", FALSE);
    g_signal_connect (handler, "new-ft-handler",
        G_CALLBACK (new_ft_handler), NULL);

    factory = monorail_handler_get_factory (handler);
    dbus = tp_dbus_daemon_dup (NULL);
    account = tp_account_new (dbus, tp_proxy_get_object_path (mcaccount), NULL);

    DEBUG ("now let's loop through media");

    /*
     * each file to transfer
     */
    for (p = sharing_entry_get_media (entry); p; p = g_slist_next (p)) {
            SharingEntryMedia* media = p->data;
            GFile *file;
            GMainLoop *loop;

            DEBUG ("sending %s", sharing_entry_media_get_title (media));

            if (sharing_entry_media_get_sent (media)) {
                DEBUG ("get_sent %d", sharing_entry_media_get_sent (media));
                continue;
            }

            if (!sharing_transfer_continue (transfer)) {
                ret = SHARING_SEND_CANCELLED;
                break;
            }

            file = g_file_new_for_path (sharing_entry_media_get_filename (media));

            empathy_ft_factory_new_transfer_outgoing (factory, account,
                osso_abook_contact_get_bound_name (contact), file,
                monorail_handler_get_name (handler));

            g_object_unref (file);

            DEBUG ("starting main loop");

            /* start a main loop */
            loop = g_main_loop_new (NULL, FALSE);
            g_main_loop_run (loop);
            g_main_loop_unref (loop);

            DEBUG ("exited main loop");

            /*
            guint64 media_size = sharing_entry_media_get_size (media);
            */

            gdouble progress_start = 1.0 - 0.9*((total_bytes - sent_bytes) / (gdouble)total_bytes);
            /*
            gdouble progress_end = 1.0 - 0.9*((total_bytes - (sent_bytes + media_size)) / (gdouble)total_bytes);
            */

            sharing_transfer_set_progress (transfer, progress_start);
            *dead_mans_switch = FALSE;

            sharing_entry_media_set_sent (media, TRUE);
            ret = SHARING_SEND_SUCCESS;
    }

    sharing_transfer_set_progress (transfer, 1.0);
    *dead_mans_switch = FALSE;

    g_source_remove (timeout_id);

    g_object_unref (dbus);
    g_object_unref (account);
    g_object_unref (handler);

    return ret;
}
