// created by jay 0.7 (c) 1998 Axel.Schreiner@informatik.uni-osnabrueck.de

#line 2 "cs-parser.jay"
//
// cs-parser.jay: The Parser for the C# compiler
//
// Authors: Miguel de Icaza (miguel@gnu.org)
//          Ravi Pratap     (ravi@ximian.com)
//          Marek Safar		(marek.safar@gmail.com)
//
// Dual Licensed under the terms of the GNU GPL and the MIT X11 license
//
// (C) 2001 Ximian, Inc (http://www.ximian.com)
// (C) 2004 Novell, Inc
//
// TODO:
//   (1) Figure out why error productions dont work.  `type-declaration' is a
//       great spot to put an `error' because you can reproduce it with this input:
//	 "public X { }"
//

using System.Text;
using System.IO;
using System;
using System.Collections.Generic;

namespace Mono.CSharp
{
	/// <summary>
	///    The C# Parser
	/// </summary>
	public class CSharpParser
	{
		[Flags]
		enum ParameterModifierType
		{
			Ref		= 1 << 1,
			Out		= 1 << 2,
			This	= 1 << 3,
			Params	= 1 << 4,
			Arglist	= 1 << 5,
			DefaultValue = 1 << 6,
			
			All = Ref | Out | This | Params | Arglist | DefaultValue
		}
		
		static readonly object ModifierNone = 0;
	
		NamespaceEntry  current_namespace;
		TypeContainer   current_container;
		DeclSpace	current_class;
		PropertyBase current_property;
		EventProperty current_event;
		EventField current_event_field;
		FieldBase current_field;
	
		/// <summary>
		///   Current block is used to add statements as we find
		///   them.  
		/// </summary>
		Block      current_block;
		
		BlockVariableDeclaration current_variable;

		Delegate   current_delegate;
		
		AnonymousMethodExpression current_anonymous_method;

		/// <summary>
		///   This is used by the unary_expression code to resolve
		///   a name against a parameter.  
		/// </summary>
		
		// FIXME: This is very ugly and it's very hard to reset it correctly
		// on all places, especially when some parameters are autogenerated.
		ParametersCompiled current_local_parameters;

		bool parsing_anonymous_method;

		///
		/// An out-of-band stack.
		///
		static Stack<object> oob_stack;

		///
		/// Controls the verbosity of the errors produced by the parser
		///
		static public int yacc_verbose_flag;

		/// 
		/// Used by the interactive shell, flags whether EOF was reached
		/// and an error was produced
		///
		public bool UnexpectedEOF;

		///
		/// The current file.
		///
		readonly CompilationSourceFile file;

		///
		/// Temporary Xml documentation cache.
		/// For enum types, we need one more temporary store.
		///
		string tmpComment;
		string enumTypeComment;
	       		
		/// Current attribute target
		string current_attr_target;
		
		ParameterModifierType valid_param_mod;
		
		bool default_parameter_used;

		/// When using the interactive parser, this holds the
		/// resulting expression
		public Class InteractiveResult;

		//
		// Keeps track of global data changes to undo on parser error
		//
		public Undo undo;
		
		Stack<Linq.QueryBlock> linq_clause_blocks;

		ModuleContainer module;
		
		readonly CompilerContext compiler;
		readonly LanguageVersion lang_version;
		readonly bool doc_support;
		readonly CompilerSettings settings;
		
		//
		// Instead of allocating carrier array everytime we
		// share the bucket for very common constructs which can never
		// be recursive
		//
		static List<Parameter> parameters_bucket = new List<Parameter> (6);
		
		//
		// Full AST support members
		//
		LocationsBag lbag;
		UsingsBag ubag;
		List<Tuple<Modifiers, Location>> mod_locations;
		Location parameterModifierLocation, savedLocation;
#line default

  /** error output stream.
      It should be changeable.
    */
  public System.IO.TextWriter ErrorOutput = System.Console.Out;

  /** simplified error message.
      @see <a href="#yyerror(java.lang.String, java.lang.String[])">yyerror</a>
    */
  public void yyerror (string message) {
    yyerror(message, null);
  }

  /* An EOF token */
  public int eof_token;

  /** (syntax) error message.
      Can be overwritten to control message format.
      @param message text to be displayed.
      @param expected vector of acceptable tokens, if available.
    */
  public void yyerror (string message, string[] expected) {
    if ((yacc_verbose_flag > 0) && (expected != null) && (expected.Length  > 0)) {
      ErrorOutput.Write (message+", expecting");
      for (int n = 0; n < expected.Length; ++ n)
        ErrorOutput.Write (" "+expected[n]);
        ErrorOutput.WriteLine ();
    } else
      ErrorOutput.WriteLine (message);
  }

  /** debugging support, requires the package jay.yydebug.
      Set to null to suppress debugging messages.
    */
//t  internal yydebug.yyDebug debug;

  protected const int yyFinal = 6;
//t // Put this array into a separate class so it is only initialized if debugging is actually used
//t // Use MarshalByRefObject to disable inlining
//t class YYRules : MarshalByRefObject {
//t  public static readonly string [] yyRule = {
//t    "$accept : compilation_unit",
//t    "compilation_unit : outer_declaration opt_EOF",
//t    "$$1 :",
//t    "compilation_unit : interactive_parsing $$1 opt_EOF",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives namespace_or_type_declarations opt_attributes",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives attribute_sections",
//t    "outer_declaration : error",
//t    "opt_EOF :",
//t    "opt_EOF : EOF",
//t    "extern_alias_directives : extern_alias_directive",
//t    "extern_alias_directives : extern_alias_directives extern_alias_directive",
//t    "extern_alias_directive : EXTERN_ALIAS IDENTIFIER IDENTIFIER SEMICOLON",
//t    "extern_alias_directive : EXTERN_ALIAS error",
//t    "using_directives : using_directive",
//t    "using_directives : using_directives using_directive",
//t    "using_directive : using_alias_directive",
//t    "using_directive : using_namespace_directive",
//t    "using_alias_directive : USING IDENTIFIER ASSIGN namespace_or_type_name SEMICOLON",
//t    "using_alias_directive : USING error",
//t    "using_namespace_directive : USING namespace_name SEMICOLON",
//t    "$$2 :",
//t    "$$3 :",
//t    "namespace_declaration : opt_attributes NAMESPACE qualified_identifier $$2 OPEN_BRACE $$3 opt_extern_alias_directives opt_using_directives opt_namespace_or_type_declarations CLOSE_BRACE opt_semicolon",
//t    "qualified_identifier : IDENTIFIER",
//t    "qualified_identifier : qualified_identifier DOT IDENTIFIER",
//t    "qualified_identifier : error",
//t    "opt_semicolon :",
//t    "opt_semicolon : SEMICOLON",
//t    "opt_comma :",
//t    "opt_comma : COMMA",
//t    "namespace_name : namespace_or_type_name",
//t    "opt_using_directives :",
//t    "opt_using_directives : using_directives",
//t    "opt_extern_alias_directives :",
//t    "opt_extern_alias_directives : extern_alias_directives",
//t    "opt_namespace_or_type_declarations :",
//t    "opt_namespace_or_type_declarations : namespace_or_type_declarations",
//t    "namespace_or_type_declarations : namespace_or_type_declaration",
//t    "namespace_or_type_declarations : namespace_or_type_declarations namespace_or_type_declaration",
//t    "namespace_or_type_declaration : type_declaration",
//t    "namespace_or_type_declaration : namespace_declaration",
//t    "type_declaration : class_declaration",
//t    "type_declaration : struct_declaration",
//t    "type_declaration : interface_declaration",
//t    "type_declaration : enum_declaration",
//t    "type_declaration : delegate_declaration",
//t    "opt_attributes :",
//t    "opt_attributes : attribute_sections",
//t    "attribute_sections : attribute_section",
//t    "attribute_sections : attribute_sections attribute_section",
//t    "$$4 :",
//t    "attribute_section : OPEN_BRACKET $$4 attribute_section_cont",
//t    "$$5 :",
//t    "attribute_section_cont : attribute_target COLON $$5 attribute_list opt_comma CLOSE_BRACKET",
//t    "attribute_section_cont : attribute_list opt_comma CLOSE_BRACKET",
//t    "attribute_target : IDENTIFIER",
//t    "attribute_target : EVENT",
//t    "attribute_target : RETURN",
//t    "attribute_target : error",
//t    "attribute_list : attribute",
//t    "attribute_list : attribute_list COMMA attribute",
//t    "$$6 :",
//t    "attribute : attribute_name $$6 opt_attribute_arguments",
//t    "attribute_name : namespace_or_type_name",
//t    "opt_attribute_arguments :",
//t    "opt_attribute_arguments : OPEN_PARENS attribute_arguments CLOSE_PARENS",
//t    "attribute_arguments :",
//t    "attribute_arguments : positional_or_named_argument",
//t    "attribute_arguments : named_attribute_argument",
//t    "attribute_arguments : attribute_arguments COMMA positional_or_named_argument",
//t    "attribute_arguments : attribute_arguments COMMA named_attribute_argument",
//t    "positional_or_named_argument : expression",
//t    "positional_or_named_argument : named_argument",
//t    "$$7 :",
//t    "named_attribute_argument : IDENTIFIER ASSIGN $$7 expression",
//t    "named_argument : IDENTIFIER COLON opt_named_modifier expression",
//t    "opt_named_modifier :",
//t    "opt_named_modifier : REF",
//t    "opt_named_modifier : OUT",
//t    "opt_class_member_declarations :",
//t    "opt_class_member_declarations : class_member_declarations",
//t    "class_member_declarations : class_member_declaration",
//t    "class_member_declarations : class_member_declarations class_member_declaration",
//t    "class_member_declaration : constant_declaration",
//t    "class_member_declaration : field_declaration",
//t    "class_member_declaration : method_declaration",
//t    "class_member_declaration : property_declaration",
//t    "class_member_declaration : event_declaration",
//t    "class_member_declaration : indexer_declaration",
//t    "class_member_declaration : operator_declaration",
//t    "class_member_declaration : constructor_declaration",
//t    "class_member_declaration : destructor_declaration",
//t    "class_member_declaration : type_declaration",
//t    "class_member_declaration : error",
//t    "$$8 :",
//t    "$$9 :",
//t    "$$10 :",
//t    "$$11 :",
//t    "struct_declaration : opt_attributes opt_modifiers opt_partial STRUCT $$8 type_declaration_name $$9 opt_class_base opt_type_parameter_constraints_clauses $$10 struct_body $$11 opt_semicolon",
//t    "struct_declaration : opt_attributes opt_modifiers opt_partial STRUCT error",
//t    "$$12 :",
//t    "struct_body : OPEN_BRACE $$12 opt_struct_member_declarations CLOSE_BRACE",
//t    "opt_struct_member_declarations :",
//t    "opt_struct_member_declarations : struct_member_declarations",
//t    "struct_member_declarations : struct_member_declaration",
//t    "struct_member_declarations : struct_member_declarations struct_member_declaration",
//t    "struct_member_declaration : constant_declaration",
//t    "struct_member_declaration : field_declaration",
//t    "struct_member_declaration : method_declaration",
//t    "struct_member_declaration : property_declaration",
//t    "struct_member_declaration : event_declaration",
//t    "struct_member_declaration : indexer_declaration",
//t    "struct_member_declaration : operator_declaration",
//t    "struct_member_declaration : constructor_declaration",
//t    "struct_member_declaration : type_declaration",
//t    "struct_member_declaration : destructor_declaration",
//t    "$$13 :",
//t    "constant_declaration : opt_attributes opt_modifiers CONST type IDENTIFIER $$13 constant_initializer opt_constant_declarators SEMICOLON",
//t    "opt_constant_declarators :",
//t    "opt_constant_declarators : constant_declarators",
//t    "constant_declarators : constant_declarator",
//t    "constant_declarators : constant_declarators constant_declarator",
//t    "constant_declarator : COMMA IDENTIFIER constant_initializer",
//t    "$$14 :",
//t    "constant_initializer : ASSIGN $$14 constant_initializer_expr",
//t    "constant_initializer : error",
//t    "constant_initializer_expr : constant_expression",
//t    "constant_initializer_expr : array_initializer",
//t    "$$15 :",
//t    "field_declaration : opt_attributes opt_modifiers member_type IDENTIFIER $$15 opt_field_initializer opt_field_declarators SEMICOLON",
//t    "$$16 :",
//t    "field_declaration : opt_attributes opt_modifiers FIXED simple_type IDENTIFIER $$16 fixed_field_size opt_fixed_field_declarators SEMICOLON",
//t    "field_declaration : opt_attributes opt_modifiers FIXED simple_type error SEMICOLON",
//t    "opt_field_initializer :",
//t    "$$17 :",
//t    "opt_field_initializer : ASSIGN $$17 variable_initializer",
//t    "opt_field_declarators :",
//t    "opt_field_declarators : field_declarators",
//t    "field_declarators : field_declarator",
//t    "field_declarators : field_declarators field_declarator",
//t    "field_declarator : COMMA IDENTIFIER",
//t    "$$18 :",
//t    "field_declarator : COMMA IDENTIFIER ASSIGN $$18 variable_initializer",
//t    "opt_fixed_field_declarators :",
//t    "opt_fixed_field_declarators : fixed_field_declarators",
//t    "fixed_field_declarators : fixed_field_declarator",
//t    "fixed_field_declarators : fixed_field_declarators fixed_field_declarator",
//t    "fixed_field_declarator : COMMA IDENTIFIER fixed_field_size",
//t    "$$19 :",
//t    "fixed_field_size : OPEN_BRACKET $$19 expression CLOSE_BRACKET",
//t    "fixed_field_size : OPEN_BRACKET error",
//t    "variable_initializer : expression",
//t    "variable_initializer : array_initializer",
//t    "variable_initializer : error",
//t    "$$20 :",
//t    "method_declaration : method_header $$20 method_body",
//t    "$$21 :",
//t    "$$22 :",
//t    "method_header : opt_attributes opt_modifiers member_type method_declaration_name OPEN_PARENS $$21 opt_formal_parameter_list CLOSE_PARENS $$22 opt_type_parameter_constraints_clauses",
//t    "$$23 :",
//t    "$$24 :",
//t    "method_header : opt_attributes opt_modifiers PARTIAL VOID method_declaration_name OPEN_PARENS $$23 opt_formal_parameter_list CLOSE_PARENS $$24 opt_type_parameter_constraints_clauses",
//t    "method_header : opt_attributes opt_modifiers member_type modifiers method_declaration_name OPEN_PARENS opt_formal_parameter_list CLOSE_PARENS",
//t    "method_body : block",
//t    "method_body : SEMICOLON",
//t    "opt_formal_parameter_list :",
//t    "opt_formal_parameter_list : formal_parameter_list",
//t    "formal_parameter_list : fixed_parameters",
//t    "formal_parameter_list : fixed_parameters COMMA parameter_array",
//t    "formal_parameter_list : fixed_parameters COMMA arglist_modifier",
//t    "formal_parameter_list : parameter_array COMMA error",
//t    "formal_parameter_list : fixed_parameters COMMA parameter_array COMMA error",
//t    "formal_parameter_list : arglist_modifier COMMA error",
//t    "formal_parameter_list : fixed_parameters COMMA ARGLIST COMMA error",
//t    "formal_parameter_list : parameter_array",
//t    "formal_parameter_list : arglist_modifier",
//t    "formal_parameter_list : error",
//t    "fixed_parameters : fixed_parameter",
//t    "fixed_parameters : fixed_parameters COMMA fixed_parameter",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type IDENTIFIER",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type IDENTIFIER OPEN_BRACKET CLOSE_BRACKET",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type error",
//t    "$$25 :",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type IDENTIFIER ASSIGN $$25 constant_expression",
//t    "opt_parameter_modifier :",
//t    "opt_parameter_modifier : parameter_modifiers",
//t    "parameter_modifiers : parameter_modifier",
//t    "parameter_modifiers : parameter_modifiers parameter_modifier",
//t    "parameter_modifier : REF",
//t    "parameter_modifier : OUT",
//t    "parameter_modifier : THIS",
//t    "parameter_array : opt_attributes params_modifier type IDENTIFIER",
//t    "parameter_array : opt_attributes params_modifier type IDENTIFIER ASSIGN constant_expression",
//t    "parameter_array : opt_attributes params_modifier type error",
//t    "params_modifier : PARAMS",
//t    "params_modifier : PARAMS parameter_modifier",
//t    "params_modifier : PARAMS params_modifier",
//t    "arglist_modifier : ARGLIST",
//t    "$$26 :",
//t    "$$27 :",
//t    "$$28 :",
//t    "property_declaration : opt_attributes opt_modifiers member_type member_declaration_name $$26 OPEN_BRACE $$27 accessor_declarations $$28 CLOSE_BRACE",
//t    "$$29 :",
//t    "$$30 :",
//t    "$$31 :",
//t    "indexer_declaration : opt_attributes opt_modifiers member_type indexer_declaration_name OPEN_BRACKET $$29 opt_formal_parameter_list CLOSE_BRACKET OPEN_BRACE $$30 accessor_declarations $$31 CLOSE_BRACE",
//t    "accessor_declarations : get_accessor_declaration",
//t    "accessor_declarations : get_accessor_declaration accessor_declarations",
//t    "accessor_declarations : set_accessor_declaration",
//t    "accessor_declarations : set_accessor_declaration accessor_declarations",
//t    "accessor_declarations : error",
//t    "$$32 :",
//t    "get_accessor_declaration : opt_attributes opt_modifiers GET $$32 accessor_body",
//t    "$$33 :",
//t    "set_accessor_declaration : opt_attributes opt_modifiers SET $$33 accessor_body",
//t    "accessor_body : block",
//t    "accessor_body : SEMICOLON",
//t    "accessor_body : error",
//t    "$$34 :",
//t    "$$35 :",
//t    "$$36 :",
//t    "$$37 :",
//t    "interface_declaration : opt_attributes opt_modifiers opt_partial INTERFACE $$34 type_declaration_name $$35 opt_class_base opt_type_parameter_constraints_clauses $$36 OPEN_BRACE opt_interface_member_declarations CLOSE_BRACE $$37 opt_semicolon",
//t    "interface_declaration : opt_attributes opt_modifiers opt_partial INTERFACE error",
//t    "opt_interface_member_declarations :",
//t    "opt_interface_member_declarations : interface_member_declarations",
//t    "interface_member_declarations : interface_member_declaration",
//t    "interface_member_declarations : interface_member_declarations interface_member_declaration",
//t    "interface_member_declaration : constant_declaration",
//t    "interface_member_declaration : field_declaration",
//t    "interface_member_declaration : method_declaration",
//t    "interface_member_declaration : property_declaration",
//t    "interface_member_declaration : event_declaration",
//t    "interface_member_declaration : indexer_declaration",
//t    "interface_member_declaration : operator_declaration",
//t    "interface_member_declaration : constructor_declaration",
//t    "interface_member_declaration : type_declaration",
//t    "$$38 :",
//t    "operator_declaration : opt_attributes opt_modifiers operator_declarator $$38 operator_body",
//t    "operator_body : block",
//t    "operator_body : SEMICOLON",
//t    "operator_type : type_expression_or_array",
//t    "operator_type : VOID",
//t    "$$39 :",
//t    "operator_declarator : operator_type OPERATOR overloadable_operator OPEN_PARENS $$39 opt_formal_parameter_list CLOSE_PARENS",
//t    "operator_declarator : conversion_operator_declarator",
//t    "overloadable_operator : BANG",
//t    "overloadable_operator : TILDE",
//t    "overloadable_operator : OP_INC",
//t    "overloadable_operator : OP_DEC",
//t    "overloadable_operator : TRUE",
//t    "overloadable_operator : FALSE",
//t    "overloadable_operator : PLUS",
//t    "overloadable_operator : MINUS",
//t    "overloadable_operator : STAR",
//t    "overloadable_operator : DIV",
//t    "overloadable_operator : PERCENT",
//t    "overloadable_operator : BITWISE_AND",
//t    "overloadable_operator : BITWISE_OR",
//t    "overloadable_operator : CARRET",
//t    "overloadable_operator : OP_SHIFT_LEFT",
//t    "overloadable_operator : OP_SHIFT_RIGHT",
//t    "overloadable_operator : OP_EQ",
//t    "overloadable_operator : OP_NE",
//t    "overloadable_operator : OP_GT",
//t    "overloadable_operator : OP_LT",
//t    "overloadable_operator : OP_GE",
//t    "overloadable_operator : OP_LE",
//t    "$$40 :",
//t    "conversion_operator_declarator : IMPLICIT OPERATOR type OPEN_PARENS $$40 opt_formal_parameter_list CLOSE_PARENS",
//t    "$$41 :",
//t    "conversion_operator_declarator : EXPLICIT OPERATOR type OPEN_PARENS $$41 opt_formal_parameter_list CLOSE_PARENS",
//t    "conversion_operator_declarator : IMPLICIT error",
//t    "conversion_operator_declarator : EXPLICIT error",
//t    "constructor_declaration : constructor_declarator constructor_body",
//t    "$$42 :",
//t    "$$43 :",
//t    "constructor_declarator : opt_attributes opt_modifiers IDENTIFIER $$42 OPEN_PARENS opt_formal_parameter_list CLOSE_PARENS $$43 opt_constructor_initializer",
//t    "constructor_body : block_prepared",
//t    "constructor_body : SEMICOLON",
//t    "opt_constructor_initializer :",
//t    "opt_constructor_initializer : constructor_initializer",
//t    "$$44 :",
//t    "constructor_initializer : COLON BASE OPEN_PARENS $$44 opt_argument_list CLOSE_PARENS",
//t    "$$45 :",
//t    "constructor_initializer : COLON THIS OPEN_PARENS $$45 opt_argument_list CLOSE_PARENS",
//t    "constructor_initializer : error",
//t    "$$46 :",
//t    "destructor_declaration : opt_attributes opt_modifiers TILDE $$46 IDENTIFIER OPEN_PARENS CLOSE_PARENS method_body",
//t    "$$47 :",
//t    "event_declaration : opt_attributes opt_modifiers EVENT type member_declaration_name $$47 opt_event_initializer opt_event_declarators SEMICOLON",
//t    "$$48 :",
//t    "$$49 :",
//t    "event_declaration : opt_attributes opt_modifiers EVENT type member_declaration_name OPEN_BRACE $$48 event_accessor_declarations $$49 CLOSE_BRACE",
//t    "opt_event_initializer :",
//t    "$$50 :",
//t    "opt_event_initializer : ASSIGN $$50 event_variable_initializer",
//t    "opt_event_declarators :",
//t    "opt_event_declarators : event_declarators",
//t    "event_declarators : event_declarator",
//t    "event_declarators : event_declarators event_declarator",
//t    "event_declarator : COMMA IDENTIFIER",
//t    "$$51 :",
//t    "event_declarator : COMMA IDENTIFIER ASSIGN $$51 event_variable_initializer",
//t    "$$52 :",
//t    "event_variable_initializer : $$52 variable_initializer",
//t    "event_accessor_declarations : add_accessor_declaration remove_accessor_declaration",
//t    "event_accessor_declarations : remove_accessor_declaration add_accessor_declaration",
//t    "event_accessor_declarations : add_accessor_declaration",
//t    "event_accessor_declarations : remove_accessor_declaration",
//t    "event_accessor_declarations : error",
//t    "$$53 :",
//t    "add_accessor_declaration : opt_attributes opt_modifiers ADD $$53 event_accessor_block",
//t    "$$54 :",
//t    "remove_accessor_declaration : opt_attributes opt_modifiers REMOVE $$54 event_accessor_block",
//t    "event_accessor_block : opt_semicolon",
//t    "event_accessor_block : block",
//t    "$$55 :",
//t    "$$56 :",
//t    "$$57 :",
//t    "enum_declaration : opt_attributes opt_modifiers ENUM type_declaration_name opt_enum_base $$55 OPEN_BRACE $$56 opt_enum_member_declarations $$57 CLOSE_BRACE opt_semicolon",
//t    "opt_enum_base :",
//t    "opt_enum_base : COLON type",
//t    "opt_enum_base : COLON error",
//t    "opt_enum_member_declarations :",
//t    "opt_enum_member_declarations : enum_member_declarations",
//t    "opt_enum_member_declarations : enum_member_declarations COMMA",
//t    "enum_member_declarations : enum_member_declaration",
//t    "enum_member_declarations : enum_member_declarations COMMA enum_member_declaration",
//t    "enum_member_declaration : opt_attributes IDENTIFIER",
//t    "$$58 :",
//t    "enum_member_declaration : opt_attributes IDENTIFIER $$58 ASSIGN constant_expression",
//t    "$$59 :",
//t    "$$60 :",
//t    "$$61 :",
//t    "delegate_declaration : opt_attributes opt_modifiers DELEGATE member_type type_declaration_name OPEN_PARENS $$59 opt_formal_parameter_list CLOSE_PARENS $$60 opt_type_parameter_constraints_clauses $$61 SEMICOLON",
//t    "opt_nullable :",
//t    "opt_nullable : INTERR_NULLABLE",
//t    "namespace_or_type_name : member_name",
//t    "namespace_or_type_name : qualified_alias_member IDENTIFIER opt_type_argument_list",
//t    "member_name : type_name",
//t    "member_name : namespace_or_type_name DOT IDENTIFIER opt_type_argument_list",
//t    "type_name : IDENTIFIER opt_type_argument_list",
//t    "opt_type_argument_list :",
//t    "opt_type_argument_list : OP_GENERICS_LT type_arguments OP_GENERICS_GT",
//t    "opt_type_argument_list : OP_GENERICS_LT error",
//t    "type_arguments : type",
//t    "type_arguments : type_arguments COMMA type",
//t    "$$62 :",
//t    "type_declaration_name : IDENTIFIER $$62 opt_type_parameter_list",
//t    "member_declaration_name : method_declaration_name",
//t    "method_declaration_name : type_declaration_name",
//t    "method_declaration_name : explicit_interface IDENTIFIER opt_type_parameter_list",
//t    "indexer_declaration_name : THIS",
//t    "indexer_declaration_name : explicit_interface THIS",
//t    "explicit_interface : IDENTIFIER opt_type_argument_list DOT",
//t    "explicit_interface : qualified_alias_member IDENTIFIER opt_type_argument_list DOT",
//t    "explicit_interface : explicit_interface IDENTIFIER opt_type_argument_list DOT",
//t    "opt_type_parameter_list :",
//t    "opt_type_parameter_list : OP_GENERICS_LT_DECL type_parameters OP_GENERICS_GT",
//t    "type_parameters : type_parameter",
//t    "type_parameters : type_parameters COMMA type_parameter",
//t    "type_parameter : opt_attributes opt_type_parameter_variance IDENTIFIER",
//t    "type_parameter : error",
//t    "type_and_void : type_expression_or_array",
//t    "type_and_void : VOID",
//t    "member_type : type_and_void",
//t    "type : type_expression_or_array",
//t    "type : VOID",
//t    "simple_type : type_expression",
//t    "simple_type : VOID",
//t    "parameter_type : type_expression_or_array",
//t    "parameter_type : VOID",
//t    "type_expression_or_array : type_expression",
//t    "type_expression_or_array : type_expression rank_specifiers",
//t    "type_expression : namespace_or_type_name opt_nullable",
//t    "type_expression : namespace_or_type_name pointer_stars",
//t    "type_expression : builtin_types opt_nullable",
//t    "type_expression : builtin_types pointer_stars",
//t    "type_expression : VOID pointer_stars",
//t    "type_list : base_type_name",
//t    "type_list : type_list COMMA base_type_name",
//t    "base_type_name : type",
//t    "base_type_name : error",
//t    "builtin_types : OBJECT",
//t    "builtin_types : STRING",
//t    "builtin_types : BOOL",
//t    "builtin_types : DECIMAL",
//t    "builtin_types : FLOAT",
//t    "builtin_types : DOUBLE",
//t    "builtin_types : integral_type",
//t    "integral_type : SBYTE",
//t    "integral_type : BYTE",
//t    "integral_type : SHORT",
//t    "integral_type : USHORT",
//t    "integral_type : INT",
//t    "integral_type : UINT",
//t    "integral_type : LONG",
//t    "integral_type : ULONG",
//t    "integral_type : CHAR",
//t    "primary_expression : primary_expression_or_type",
//t    "primary_expression : literal",
//t    "primary_expression : array_creation_expression",
//t    "primary_expression : parenthesized_expression",
//t    "primary_expression : default_value_expression",
//t    "primary_expression : invocation_expression",
//t    "primary_expression : element_access",
//t    "primary_expression : this_access",
//t    "primary_expression : base_access",
//t    "primary_expression : post_increment_expression",
//t    "primary_expression : post_decrement_expression",
//t    "primary_expression : object_or_delegate_creation_expression",
//t    "primary_expression : anonymous_type_expression",
//t    "primary_expression : typeof_expression",
//t    "primary_expression : sizeof_expression",
//t    "primary_expression : checked_expression",
//t    "primary_expression : unchecked_expression",
//t    "primary_expression : pointer_member_access",
//t    "primary_expression : anonymous_method_expression",
//t    "primary_expression : undocumented_expressions",
//t    "primary_expression_or_type : IDENTIFIER opt_type_argument_list",
//t    "primary_expression_or_type : IDENTIFIER GENERATE_COMPLETION",
//t    "primary_expression_or_type : member_access",
//t    "literal : boolean_literal",
//t    "literal : LITERAL",
//t    "literal : NULL",
//t    "boolean_literal : TRUE",
//t    "boolean_literal : FALSE",
//t    "open_parens_any : OPEN_PARENS",
//t    "open_parens_any : OPEN_PARENS_CAST",
//t    "close_parens : CLOSE_PARENS",
//t    "close_parens : COMPLETE_COMPLETION",
//t    "parenthesized_expression : OPEN_PARENS expression CLOSE_PARENS",
//t    "parenthesized_expression : OPEN_PARENS expression COMPLETE_COMPLETION",
//t    "member_access : primary_expression DOT IDENTIFIER opt_type_argument_list",
//t    "member_access : builtin_types DOT IDENTIFIER opt_type_argument_list",
//t    "member_access : BASE DOT IDENTIFIER opt_type_argument_list",
//t    "member_access : qualified_alias_member IDENTIFIER opt_type_argument_list",
//t    "member_access : primary_expression DOT GENERATE_COMPLETION",
//t    "member_access : primary_expression DOT IDENTIFIER GENERATE_COMPLETION",
//t    "member_access : builtin_types DOT GENERATE_COMPLETION",
//t    "member_access : builtin_types DOT IDENTIFIER GENERATE_COMPLETION",
//t    "invocation_expression : primary_expression open_parens_any opt_argument_list close_parens",
//t    "opt_object_or_collection_initializer :",
//t    "opt_object_or_collection_initializer : object_or_collection_initializer",
//t    "object_or_collection_initializer : OPEN_BRACE opt_member_initializer_list close_brace_or_complete_completion",
//t    "object_or_collection_initializer : OPEN_BRACE member_initializer_list COMMA CLOSE_BRACE",
//t    "opt_member_initializer_list :",
//t    "opt_member_initializer_list : member_initializer_list",
//t    "member_initializer_list : member_initializer",
//t    "member_initializer_list : member_initializer_list COMMA member_initializer",
//t    "member_initializer_list : member_initializer_list error",
//t    "member_initializer : IDENTIFIER ASSIGN initializer_value",
//t    "member_initializer : GENERATE_COMPLETION",
//t    "member_initializer : non_assignment_expression opt_COMPLETE_COMPLETION",
//t    "member_initializer : OPEN_BRACE expression_list CLOSE_BRACE",
//t    "member_initializer : OPEN_BRACE CLOSE_BRACE",
//t    "initializer_value : expression",
//t    "initializer_value : object_or_collection_initializer",
//t    "opt_argument_list :",
//t    "opt_argument_list : argument_list",
//t    "argument_list : argument_or_named_argument",
//t    "argument_list : argument_list COMMA argument",
//t    "argument_list : argument_list COMMA named_argument",
//t    "argument_list : argument_list COMMA",
//t    "argument_list : COMMA error",
//t    "argument : expression",
//t    "argument : non_simple_argument",
//t    "argument_or_named_argument : argument",
//t    "argument_or_named_argument : named_argument",
//t    "non_simple_argument : REF variable_reference",
//t    "non_simple_argument : OUT variable_reference",
//t    "non_simple_argument : ARGLIST OPEN_PARENS argument_list CLOSE_PARENS",
//t    "non_simple_argument : ARGLIST OPEN_PARENS CLOSE_PARENS",
//t    "variable_reference : expression",
//t    "element_access : primary_expression OPEN_BRACKET_EXPR expression_list_arguments CLOSE_BRACKET",
//t    "expression_list : expression",
//t    "expression_list : expression_list COMMA expression",
//t    "expression_list : expression_list error",
//t    "expression_list_arguments : expression_list_argument",
//t    "expression_list_arguments : expression_list_arguments COMMA expression_list_argument",
//t    "expression_list_argument : expression",
//t    "expression_list_argument : named_argument",
//t    "this_access : THIS",
//t    "base_access : BASE OPEN_BRACKET_EXPR expression_list_arguments CLOSE_BRACKET",
//t    "base_access : BASE OPEN_BRACKET error",
//t    "post_increment_expression : primary_expression OP_INC",
//t    "post_decrement_expression : primary_expression OP_DEC",
//t    "object_or_delegate_creation_expression : NEW new_expr_type open_parens_any opt_argument_list CLOSE_PARENS opt_object_or_collection_initializer",
//t    "object_or_delegate_creation_expression : NEW new_expr_type object_or_collection_initializer",
//t    "array_creation_expression : NEW new_expr_type OPEN_BRACKET_EXPR expression_list CLOSE_BRACKET opt_rank_specifier opt_array_initializer",
//t    "array_creation_expression : NEW new_expr_type rank_specifiers opt_array_initializer",
//t    "array_creation_expression : NEW rank_specifier array_initializer",
//t    "array_creation_expression : NEW new_expr_type OPEN_BRACKET CLOSE_BRACKET OPEN_BRACKET_EXPR error CLOSE_BRACKET",
//t    "array_creation_expression : NEW new_expr_type error",
//t    "$$63 :",
//t    "new_expr_type : $$63 simple_type",
//t    "anonymous_type_expression : NEW OPEN_BRACE anonymous_type_parameters_opt_comma CLOSE_BRACE",
//t    "anonymous_type_parameters_opt_comma : anonymous_type_parameters_opt",
//t    "anonymous_type_parameters_opt_comma : anonymous_type_parameters COMMA",
//t    "anonymous_type_parameters_opt :",
//t    "anonymous_type_parameters_opt : anonymous_type_parameters",
//t    "anonymous_type_parameters : anonymous_type_parameter",
//t    "anonymous_type_parameters : anonymous_type_parameters COMMA anonymous_type_parameter",
//t    "anonymous_type_parameter : IDENTIFIER ASSIGN variable_initializer",
//t    "anonymous_type_parameter : IDENTIFIER",
//t    "anonymous_type_parameter : member_access",
//t    "anonymous_type_parameter : error",
//t    "opt_rank_specifier :",
//t    "opt_rank_specifier : rank_specifiers",
//t    "rank_specifiers : rank_specifier",
//t    "rank_specifiers : rank_specifier rank_specifiers",
//t    "rank_specifier : OPEN_BRACKET CLOSE_BRACKET",
//t    "rank_specifier : OPEN_BRACKET dim_separators CLOSE_BRACKET",
//t    "dim_separators : COMMA",
//t    "dim_separators : dim_separators COMMA",
//t    "opt_array_initializer :",
//t    "opt_array_initializer : array_initializer",
//t    "array_initializer : OPEN_BRACE CLOSE_BRACE",
//t    "array_initializer : OPEN_BRACE variable_initializer_list opt_comma CLOSE_BRACE",
//t    "variable_initializer_list : variable_initializer",
//t    "variable_initializer_list : variable_initializer_list COMMA variable_initializer",
//t    "$$64 :",
//t    "typeof_expression : TYPEOF $$64 open_parens_any typeof_type_expression CLOSE_PARENS",
//t    "typeof_type_expression : type_and_void",
//t    "typeof_type_expression : unbound_type_name",
//t    "typeof_type_expression : error",
//t    "unbound_type_name : IDENTIFIER generic_dimension",
//t    "unbound_type_name : qualified_alias_member IDENTIFIER generic_dimension",
//t    "unbound_type_name : unbound_type_name DOT IDENTIFIER",
//t    "unbound_type_name : unbound_type_name DOT IDENTIFIER generic_dimension",
//t    "unbound_type_name : namespace_or_type_name DOT IDENTIFIER generic_dimension",
//t    "generic_dimension : GENERIC_DIMENSION",
//t    "qualified_alias_member : IDENTIFIER DOUBLE_COLON",
//t    "sizeof_expression : SIZEOF open_parens_any type CLOSE_PARENS",
//t    "checked_expression : CHECKED open_parens_any expression CLOSE_PARENS",
//t    "unchecked_expression : UNCHECKED open_parens_any expression CLOSE_PARENS",
//t    "pointer_member_access : primary_expression OP_PTR IDENTIFIER",
//t    "$$65 :",
//t    "anonymous_method_expression : DELEGATE opt_anonymous_method_signature $$65 block",
//t    "opt_anonymous_method_signature :",
//t    "opt_anonymous_method_signature : anonymous_method_signature",
//t    "$$66 :",
//t    "anonymous_method_signature : OPEN_PARENS $$66 opt_formal_parameter_list CLOSE_PARENS",
//t    "default_value_expression : DEFAULT open_parens_any type CLOSE_PARENS",
//t    "unary_expression : primary_expression",
//t    "unary_expression : BANG prefixed_unary_expression",
//t    "unary_expression : TILDE prefixed_unary_expression",
//t    "unary_expression : cast_expression",
//t    "cast_expression : OPEN_PARENS_CAST type CLOSE_PARENS prefixed_unary_expression",
//t    "prefixed_unary_expression : unary_expression",
//t    "prefixed_unary_expression : PLUS prefixed_unary_expression",
//t    "prefixed_unary_expression : MINUS prefixed_unary_expression",
//t    "prefixed_unary_expression : OP_INC prefixed_unary_expression",
//t    "prefixed_unary_expression : OP_DEC prefixed_unary_expression",
//t    "prefixed_unary_expression : STAR prefixed_unary_expression",
//t    "prefixed_unary_expression : BITWISE_AND prefixed_unary_expression",
//t    "multiplicative_expression : prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression STAR prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression DIV prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression PERCENT prefixed_unary_expression",
//t    "additive_expression : multiplicative_expression",
//t    "additive_expression : additive_expression PLUS multiplicative_expression",
//t    "additive_expression : additive_expression MINUS multiplicative_expression",
//t    "additive_expression : parenthesized_expression MINUS multiplicative_expression",
//t    "additive_expression : additive_expression AS type",
//t    "additive_expression : additive_expression IS type",
//t    "shift_expression : additive_expression",
//t    "shift_expression : shift_expression OP_SHIFT_LEFT additive_expression",
//t    "shift_expression : shift_expression OP_SHIFT_RIGHT additive_expression",
//t    "relational_expression : shift_expression",
//t    "relational_expression : relational_expression OP_LT shift_expression",
//t    "relational_expression : relational_expression OP_GT shift_expression",
//t    "relational_expression : relational_expression OP_LE shift_expression",
//t    "relational_expression : relational_expression OP_GE shift_expression",
//t    "equality_expression : relational_expression",
//t    "equality_expression : equality_expression OP_EQ relational_expression",
//t    "equality_expression : equality_expression OP_NE relational_expression",
//t    "and_expression : equality_expression",
//t    "and_expression : and_expression BITWISE_AND equality_expression",
//t    "exclusive_or_expression : and_expression",
//t    "exclusive_or_expression : exclusive_or_expression CARRET and_expression",
//t    "inclusive_or_expression : exclusive_or_expression",
//t    "inclusive_or_expression : inclusive_or_expression BITWISE_OR exclusive_or_expression",
//t    "conditional_and_expression : inclusive_or_expression",
//t    "conditional_and_expression : conditional_and_expression OP_AND inclusive_or_expression",
//t    "conditional_or_expression : conditional_and_expression",
//t    "conditional_or_expression : conditional_or_expression OP_OR conditional_and_expression",
//t    "null_coalescing_expression : conditional_or_expression",
//t    "null_coalescing_expression : conditional_or_expression OP_COALESCING null_coalescing_expression",
//t    "conditional_expression : null_coalescing_expression",
//t    "conditional_expression : null_coalescing_expression INTERR expression COLON expression",
//t    "assignment_expression : prefixed_unary_expression ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_MULT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_DIV_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_MOD_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_ADD_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SUB_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SHIFT_LEFT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SHIFT_RIGHT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_AND_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_OR_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_XOR_ASSIGN expression",
//t    "lambda_parameter_list : lambda_parameter",
//t    "lambda_parameter_list : lambda_parameter_list COMMA lambda_parameter",
//t    "lambda_parameter : parameter_modifier parameter_type IDENTIFIER",
//t    "lambda_parameter : parameter_type IDENTIFIER",
//t    "lambda_parameter : IDENTIFIER",
//t    "opt_lambda_parameter_list :",
//t    "opt_lambda_parameter_list : lambda_parameter_list",
//t    "lambda_expression_body : lambda_expression_body_simple",
//t    "lambda_expression_body : block",
//t    "$$67 :",
//t    "lambda_expression_body_simple : $$67 expression_or_error",
//t    "expression_or_error : expression",
//t    "expression_or_error : error",
//t    "$$68 :",
//t    "lambda_expression : IDENTIFIER ARROW $$68 lambda_expression_body",
//t    "$$69 :",
//t    "$$70 :",
//t    "lambda_expression : OPEN_PARENS_LAMBDA $$69 opt_lambda_parameter_list CLOSE_PARENS ARROW $$70 lambda_expression_body",
//t    "expression : assignment_expression",
//t    "expression : non_assignment_expression",
//t    "non_assignment_expression : conditional_expression",
//t    "non_assignment_expression : lambda_expression",
//t    "non_assignment_expression : query_expression",
//t    "non_assignment_expression : ARGLIST",
//t    "undocumented_expressions : REFVALUE OPEN_PARENS non_assignment_expression COMMA type CLOSE_PARENS",
//t    "undocumented_expressions : REFTYPE open_parens_any expression CLOSE_PARENS",
//t    "undocumented_expressions : MAKEREF open_parens_any expression CLOSE_PARENS",
//t    "constant_expression : expression",
//t    "boolean_expression : expression",
//t    "$$71 :",
//t    "$$72 :",
//t    "$$73 :",
//t    "$$74 :",
//t    "class_declaration : opt_attributes opt_modifiers opt_partial CLASS $$71 type_declaration_name $$72 opt_class_base opt_type_parameter_constraints_clauses $$73 OPEN_BRACE opt_class_member_declarations CLOSE_BRACE $$74 opt_semicolon",
//t    "opt_partial :",
//t    "opt_partial : PARTIAL",
//t    "opt_modifiers :",
//t    "opt_modifiers : modifiers",
//t    "modifiers : modifier",
//t    "modifiers : modifiers modifier",
//t    "modifier : NEW",
//t    "modifier : PUBLIC",
//t    "modifier : PROTECTED",
//t    "modifier : INTERNAL",
//t    "modifier : PRIVATE",
//t    "modifier : ABSTRACT",
//t    "modifier : SEALED",
//t    "modifier : STATIC",
//t    "modifier : READONLY",
//t    "modifier : VIRTUAL",
//t    "modifier : OVERRIDE",
//t    "modifier : EXTERN",
//t    "modifier : VOLATILE",
//t    "modifier : UNSAFE",
//t    "modifier : ASYNC",
//t    "opt_class_base :",
//t    "opt_class_base : COLON type_list",
//t    "opt_type_parameter_constraints_clauses :",
//t    "opt_type_parameter_constraints_clauses : type_parameter_constraints_clauses",
//t    "opt_type_parameter_constraints_clauses : error",
//t    "type_parameter_constraints_clauses : type_parameter_constraints_clause",
//t    "type_parameter_constraints_clauses : type_parameter_constraints_clauses type_parameter_constraints_clause",
//t    "type_parameter_constraints_clause : WHERE IDENTIFIER COLON type_parameter_constraints",
//t    "type_parameter_constraints : type_parameter_constraint",
//t    "type_parameter_constraints : type_parameter_constraints COMMA type_parameter_constraint",
//t    "type_parameter_constraint : type",
//t    "type_parameter_constraint : NEW OPEN_PARENS CLOSE_PARENS",
//t    "type_parameter_constraint : CLASS",
//t    "type_parameter_constraint : STRUCT",
//t    "opt_type_parameter_variance :",
//t    "opt_type_parameter_variance : type_parameter_variance",
//t    "type_parameter_variance : OUT",
//t    "type_parameter_variance : IN",
//t    "$$75 :",
//t    "block : OPEN_BRACE $$75 opt_statement_list block_end",
//t    "block_end : CLOSE_BRACE",
//t    "block_end : COMPLETE_COMPLETION",
//t    "$$76 :",
//t    "block_prepared : OPEN_BRACE $$76 opt_statement_list CLOSE_BRACE",
//t    "opt_statement_list :",
//t    "opt_statement_list : statement_list",
//t    "statement_list : statement",
//t    "statement_list : statement_list statement",
//t    "statement : block_variable_declaration",
//t    "statement : valid_declaration_statement",
//t    "statement : labeled_statement",
//t    "statement : error",
//t    "interactive_statement_list : interactive_statement",
//t    "interactive_statement_list : interactive_statement_list interactive_statement",
//t    "interactive_statement : block_variable_declaration",
//t    "interactive_statement : interactive_valid_declaration_statement",
//t    "interactive_statement : labeled_statement",
//t    "valid_declaration_statement : block",
//t    "valid_declaration_statement : empty_statement",
//t    "valid_declaration_statement : expression_statement",
//t    "valid_declaration_statement : selection_statement",
//t    "valid_declaration_statement : iteration_statement",
//t    "valid_declaration_statement : jump_statement",
//t    "valid_declaration_statement : try_statement",
//t    "valid_declaration_statement : checked_statement",
//t    "valid_declaration_statement : unchecked_statement",
//t    "valid_declaration_statement : lock_statement",
//t    "valid_declaration_statement : using_statement",
//t    "valid_declaration_statement : unsafe_statement",
//t    "valid_declaration_statement : fixed_statement",
//t    "interactive_valid_declaration_statement : block",
//t    "interactive_valid_declaration_statement : empty_statement",
//t    "interactive_valid_declaration_statement : interactive_expression_statement",
//t    "interactive_valid_declaration_statement : selection_statement",
//t    "interactive_valid_declaration_statement : iteration_statement",
//t    "interactive_valid_declaration_statement : jump_statement",
//t    "interactive_valid_declaration_statement : try_statement",
//t    "interactive_valid_declaration_statement : checked_statement",
//t    "interactive_valid_declaration_statement : unchecked_statement",
//t    "interactive_valid_declaration_statement : lock_statement",
//t    "interactive_valid_declaration_statement : using_statement",
//t    "interactive_valid_declaration_statement : unsafe_statement",
//t    "interactive_valid_declaration_statement : fixed_statement",
//t    "embedded_statement : valid_declaration_statement",
//t    "embedded_statement : block_variable_declaration",
//t    "embedded_statement : labeled_statement",
//t    "embedded_statement : error",
//t    "empty_statement : SEMICOLON",
//t    "$$77 :",
//t    "labeled_statement : IDENTIFIER COLON $$77 statement",
//t    "variable_type : variable_type_simple",
//t    "variable_type : variable_type_simple rank_specifiers",
//t    "variable_type_simple : primary_expression_or_type opt_nullable",
//t    "variable_type_simple : primary_expression_or_type pointer_stars",
//t    "variable_type_simple : builtin_types opt_nullable",
//t    "variable_type_simple : builtin_types pointer_stars",
//t    "variable_type_simple : VOID pointer_stars",
//t    "variable_type_simple : VOID",
//t    "pointer_stars : pointer_star",
//t    "pointer_stars : pointer_star pointer_stars",
//t    "pointer_star : STAR",
//t    "$$78 :",
//t    "block_variable_declaration : variable_type IDENTIFIER $$78 opt_local_variable_initializer opt_variable_declarators SEMICOLON",
//t    "$$79 :",
//t    "block_variable_declaration : CONST variable_type IDENTIFIER $$79 const_variable_initializer opt_const_declarators SEMICOLON",
//t    "opt_local_variable_initializer :",
//t    "opt_local_variable_initializer : ASSIGN block_variable_initializer",
//t    "opt_local_variable_initializer : error",
//t    "opt_variable_declarators :",
//t    "opt_variable_declarators : variable_declarators",
//t    "variable_declarators : variable_declarator",
//t    "variable_declarators : variable_declarators variable_declarator",
//t    "variable_declarator : COMMA IDENTIFIER",
//t    "variable_declarator : COMMA IDENTIFIER ASSIGN block_variable_initializer",
//t    "const_variable_initializer :",
//t    "const_variable_initializer : ASSIGN constant_initializer_expr",
//t    "opt_const_declarators :",
//t    "opt_const_declarators : const_declarators",
//t    "const_declarators : const_declarator",
//t    "const_declarators : const_declarators const_declarator",
//t    "const_declarator : COMMA IDENTIFIER ASSIGN constant_initializer_expr",
//t    "block_variable_initializer : variable_initializer",
//t    "block_variable_initializer : STACKALLOC simple_type OPEN_BRACKET_EXPR expression CLOSE_BRACKET",
//t    "block_variable_initializer : STACKALLOC simple_type",
//t    "expression_statement : statement_expression SEMICOLON",
//t    "expression_statement : statement_expression COMPLETE_COMPLETION",
//t    "interactive_expression_statement : interactive_statement_expression SEMICOLON",
//t    "interactive_expression_statement : interactive_statement_expression COMPLETE_COMPLETION",
//t    "statement_expression : expression",
//t    "interactive_statement_expression : expression",
//t    "interactive_statement_expression : error",
//t    "selection_statement : if_statement",
//t    "selection_statement : switch_statement",
//t    "if_statement : IF open_parens_any boolean_expression CLOSE_PARENS embedded_statement",
//t    "if_statement : IF open_parens_any boolean_expression CLOSE_PARENS embedded_statement ELSE embedded_statement",
//t    "$$80 :",
//t    "switch_statement : SWITCH open_parens_any expression CLOSE_PARENS OPEN_BRACE $$80 opt_switch_sections CLOSE_BRACE",
//t    "opt_switch_sections :",
//t    "opt_switch_sections : switch_sections",
//t    "switch_sections : switch_section",
//t    "switch_sections : switch_sections switch_section",
//t    "switch_sections : error",
//t    "$$81 :",
//t    "switch_section : switch_labels $$81 statement_list",
//t    "switch_labels : switch_label",
//t    "switch_labels : switch_labels switch_label",
//t    "switch_label : CASE constant_expression COLON",
//t    "switch_label : DEFAULT_COLON",
//t    "iteration_statement : while_statement",
//t    "iteration_statement : do_statement",
//t    "iteration_statement : for_statement",
//t    "iteration_statement : foreach_statement",
//t    "while_statement : WHILE open_parens_any boolean_expression CLOSE_PARENS embedded_statement",
//t    "do_statement : DO embedded_statement WHILE open_parens_any boolean_expression CLOSE_PARENS SEMICOLON",
//t    "$$82 :",
//t    "for_statement : FOR open_parens_any $$82 for_statement_cont",
//t    "for_statement_cont : opt_for_initializer SEMICOLON opt_for_condition SEMICOLON opt_for_iterator CLOSE_PARENS embedded_statement",
//t    "for_statement_cont : error",
//t    "opt_for_initializer :",
//t    "opt_for_initializer : for_initializer",
//t    "$$83 :",
//t    "for_initializer : variable_type IDENTIFIER $$83 opt_local_variable_initializer opt_variable_declarators",
//t    "for_initializer : statement_expression_list",
//t    "opt_for_condition :",
//t    "opt_for_condition : boolean_expression",
//t    "opt_for_iterator :",
//t    "opt_for_iterator : for_iterator",
//t    "for_iterator : statement_expression_list",
//t    "statement_expression_list : statement_expression",
//t    "statement_expression_list : statement_expression_list COMMA statement_expression",
//t    "foreach_statement : FOREACH open_parens_any type IN expression CLOSE_PARENS",
//t    "$$84 :",
//t    "foreach_statement : FOREACH open_parens_any type IDENTIFIER IN expression CLOSE_PARENS $$84 embedded_statement",
//t    "jump_statement : break_statement",
//t    "jump_statement : continue_statement",
//t    "jump_statement : goto_statement",
//t    "jump_statement : return_statement",
//t    "jump_statement : throw_statement",
//t    "jump_statement : yield_statement",
//t    "break_statement : BREAK SEMICOLON",
//t    "continue_statement : CONTINUE SEMICOLON",
//t    "goto_statement : GOTO IDENTIFIER SEMICOLON",
//t    "goto_statement : GOTO CASE constant_expression SEMICOLON",
//t    "goto_statement : GOTO DEFAULT SEMICOLON",
//t    "return_statement : RETURN opt_expression SEMICOLON",
//t    "throw_statement : THROW opt_expression SEMICOLON",
//t    "yield_statement : IDENTIFIER RETURN opt_expression SEMICOLON",
//t    "yield_statement : IDENTIFIER BREAK SEMICOLON",
//t    "opt_expression :",
//t    "opt_expression : expression",
//t    "try_statement : TRY block catch_clauses",
//t    "try_statement : TRY block FINALLY block",
//t    "try_statement : TRY block catch_clauses FINALLY block",
//t    "try_statement : TRY block error",
//t    "catch_clauses : catch_clause",
//t    "catch_clauses : catch_clauses catch_clause",
//t    "opt_identifier :",
//t    "opt_identifier : IDENTIFIER",
//t    "catch_clause : CATCH block",
//t    "$$85 :",
//t    "catch_clause : CATCH open_parens_any type opt_identifier CLOSE_PARENS $$85 block_prepared",
//t    "catch_clause : CATCH open_parens_any error",
//t    "checked_statement : CHECKED block",
//t    "unchecked_statement : UNCHECKED block",
//t    "$$86 :",
//t    "unsafe_statement : UNSAFE $$86 block",
//t    "lock_statement : LOCK open_parens_any expression CLOSE_PARENS embedded_statement",
//t    "$$87 :",
//t    "$$88 :",
//t    "fixed_statement : FIXED open_parens_any variable_type IDENTIFIER $$87 using_or_fixed_variable_initializer opt_variable_declarators CLOSE_PARENS $$88 embedded_statement",
//t    "$$89 :",
//t    "$$90 :",
//t    "using_statement : USING open_parens_any variable_type IDENTIFIER $$89 using_or_fixed_variable_initializer opt_variable_declarators CLOSE_PARENS $$90 embedded_statement",
//t    "using_statement : USING open_parens_any expression CLOSE_PARENS embedded_statement",
//t    "using_or_fixed_variable_initializer :",
//t    "using_or_fixed_variable_initializer : ASSIGN variable_initializer",
//t    "query_expression : first_from_clause query_body",
//t    "query_expression : nested_from_clause query_body",
//t    "query_expression : first_from_clause COMPLETE_COMPLETION",
//t    "query_expression : nested_from_clause COMPLETE_COMPLETION",
//t    "first_from_clause : FROM_FIRST IDENTIFIER IN expression",
//t    "first_from_clause : FROM_FIRST type IDENTIFIER IN expression",
//t    "nested_from_clause : FROM IDENTIFIER IN expression",
//t    "nested_from_clause : FROM type IDENTIFIER IN expression",
//t    "$$91 :",
//t    "from_clause : FROM IDENTIFIER IN $$91 expression",
//t    "$$92 :",
//t    "from_clause : FROM type IDENTIFIER IN $$92 expression",
//t    "query_body : opt_query_body_clauses select_or_group_clause opt_query_continuation",
//t    "query_body : opt_query_body_clauses COMPLETE_COMPLETION",
//t    "query_body : error",
//t    "$$93 :",
//t    "select_or_group_clause : SELECT $$93 expression",
//t    "$$94 :",
//t    "$$95 :",
//t    "select_or_group_clause : GROUP $$94 expression $$95 BY expression",
//t    "opt_query_body_clauses :",
//t    "opt_query_body_clauses : query_body_clauses",
//t    "query_body_clauses : query_body_clause",
//t    "query_body_clauses : query_body_clauses query_body_clause",
//t    "query_body_clause : from_clause",
//t    "query_body_clause : let_clause",
//t    "query_body_clause : where_clause",
//t    "query_body_clause : join_clause",
//t    "query_body_clause : orderby_clause",
//t    "$$96 :",
//t    "let_clause : LET IDENTIFIER ASSIGN $$96 expression",
//t    "$$97 :",
//t    "where_clause : WHERE $$97 expression",
//t    "$$98 :",
//t    "$$99 :",
//t    "$$100 :",
//t    "join_clause : JOIN IDENTIFIER IN $$98 expression ON $$99 expression EQUALS $$100 expression opt_join_into",
//t    "$$101 :",
//t    "$$102 :",
//t    "$$103 :",
//t    "join_clause : JOIN type IDENTIFIER IN $$101 expression ON $$102 expression EQUALS $$103 expression opt_join_into",
//t    "opt_join_into :",
//t    "opt_join_into : INTO IDENTIFIER",
//t    "$$104 :",
//t    "orderby_clause : ORDERBY $$104 orderings",
//t    "orderings : order_by",
//t    "$$105 :",
//t    "orderings : order_by COMMA $$105 orderings_then_by",
//t    "orderings_then_by : then_by",
//t    "$$106 :",
//t    "orderings_then_by : orderings_then_by COMMA $$106 then_by",
//t    "order_by : expression",
//t    "order_by : expression ASCENDING",
//t    "order_by : expression DESCENDING",
//t    "then_by : expression",
//t    "then_by : expression ASCENDING",
//t    "then_by : expression DESCENDING",
//t    "opt_query_continuation :",
//t    "$$107 :",
//t    "opt_query_continuation : INTO IDENTIFIER $$107 query_body",
//t    "interactive_parsing : EVAL_STATEMENT_PARSER EOF",
//t    "interactive_parsing : EVAL_USING_DECLARATIONS_UNIT_PARSER using_directives opt_COMPLETE_COMPLETION",
//t    "$$108 :",
//t    "interactive_parsing : EVAL_STATEMENT_PARSER $$108 interactive_statement_list opt_COMPLETE_COMPLETION",
//t    "interactive_parsing : EVAL_COMPILATION_UNIT_PARSER interactive_compilation_unit",
//t    "interactive_compilation_unit : opt_extern_alias_directives opt_using_directives",
//t    "interactive_compilation_unit : opt_extern_alias_directives opt_using_directives namespace_or_type_declarations",
//t    "opt_COMPLETE_COMPLETION :",
//t    "opt_COMPLETE_COMPLETION : COMPLETE_COMPLETION",
//t    "close_brace_or_complete_completion : CLOSE_BRACE",
//t    "close_brace_or_complete_completion : COMPLETE_COMPLETION",
//t  };
//t public static string getRule (int index) {
//t    return yyRule [index];
//t }
//t}
  protected static readonly string [] yyNames = {    
    "end-of-file",null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,"EOF","NONE","ERROR",
    "FIRST_KEYWORD","ABSTRACT","AS","ADD","BASE","BOOL","BREAK","BYTE",
    "CASE","CATCH","CHAR","CHECKED","CLASS","CONST","CONTINUE","DECIMAL",
    "DEFAULT","DELEGATE","DO","DOUBLE","ELSE","ENUM","EVENT","EXPLICIT",
    "EXTERN","FALSE","FINALLY","FIXED","FLOAT","FOR","FOREACH","GOTO",
    "IF","IMPLICIT","IN","INT","INTERFACE","INTERNAL","IS","LOCK","LONG",
    "NAMESPACE","NEW","NULL","OBJECT","OPERATOR","OUT","OVERRIDE",
    "PARAMS","PRIVATE","PROTECTED","PUBLIC","READONLY","REF","RETURN",
    "REMOVE","SBYTE","SEALED","SHORT","SIZEOF","STACKALLOC","STATIC",
    "STRING","STRUCT","SWITCH","THIS","THROW","TRUE","TRY","TYPEOF",
    "UINT","ULONG","UNCHECKED","UNSAFE","USHORT","USING","VIRTUAL","VOID",
    "VOLATILE","WHERE","WHILE","ARGLIST","PARTIAL","ARROW","FROM",
    "FROM_FIRST","JOIN","ON","EQUALS","SELECT","GROUP","BY","LET",
    "ORDERBY","ASCENDING","DESCENDING","INTO","INTERR_NULLABLE",
    "EXTERN_ALIAS","ASYNC","REFVALUE","REFTYPE","MAKEREF","GET","SET",
    "LAST_KEYWORD","OPEN_BRACE","CLOSE_BRACE","OPEN_BRACKET",
    "CLOSE_BRACKET","OPEN_PARENS","CLOSE_PARENS","DOT","COMMA","COLON",
    "SEMICOLON","TILDE","PLUS","MINUS","BANG","ASSIGN","OP_LT","OP_GT",
    "BITWISE_AND","BITWISE_OR","STAR","PERCENT","DIV","CARRET","INTERR",
    "DOUBLE_COLON","OP_INC","OP_DEC","OP_SHIFT_LEFT","OP_SHIFT_RIGHT",
    "OP_LE","OP_GE","OP_EQ","OP_NE","OP_AND","OP_OR","OP_MULT_ASSIGN",
    "OP_DIV_ASSIGN","OP_MOD_ASSIGN","OP_ADD_ASSIGN","OP_SUB_ASSIGN",
    "OP_SHIFT_LEFT_ASSIGN","OP_SHIFT_RIGHT_ASSIGN","OP_AND_ASSIGN",
    "OP_XOR_ASSIGN","OP_OR_ASSIGN","OP_PTR","OP_COALESCING",
    "OP_GENERICS_LT","OP_GENERICS_LT_DECL","OP_GENERICS_GT","LITERAL",
    "IDENTIFIER","OPEN_PARENS_LAMBDA","OPEN_PARENS_CAST",
    "GENERIC_DIMENSION","DEFAULT_COLON","OPEN_BRACKET_EXPR",
    "EVAL_STATEMENT_PARSER","EVAL_COMPILATION_UNIT_PARSER",
    "EVAL_USING_DECLARATIONS_UNIT_PARSER","GENERATE_COMPLETION",
    "COMPLETE_COMPLETION","UMINUS",
  };

  /** index-checked interface to yyNames[].
      @param token single character or %token value.
      @return token name or [illegal] or [unknown].
    */
//t  public static string yyname (int token) {
//t    if ((token < 0) || (token > yyNames.Length)) return "[illegal]";
//t    string name;
//t    if ((name = yyNames[token]) != null) return name;
//t    return "[unknown]";
//t  }

  int yyExpectingState;
  /** computes list of expected tokens on error by tracing the tables.
      @param state for which to compute the list.
      @return list of token names.
    */
  protected int [] yyExpectingTokens (int state){
    int token, n, len = 0;
    bool[] ok = new bool[yyNames.Length];
    if ((n = yySindex[state]) != 0)
      for (token = n < 0 ? -n : 0;
           (token < yyNames.Length) && (n+token < yyTable.Length); ++ token)
        if (yyCheck[n+token] == token && !ok[token] && yyNames[token] != null) {
          ++ len;
          ok[token] = true;
        }
    if ((n = yyRindex[state]) != 0)
      for (token = n < 0 ? -n : 0;
           (token < yyNames.Length) && (n+token < yyTable.Length); ++ token)
        if (yyCheck[n+token] == token && !ok[token] && yyNames[token] != null) {
          ++ len;
          ok[token] = true;
        }
    int [] result = new int [len];
    for (n = token = 0; n < len;  ++ token)
      if (ok[token]) result[n++] = token;
    return result;
  }
  protected string[] yyExpecting (int state) {
    int [] tokens = yyExpectingTokens (state);
    string [] result = new string[tokens.Length];
    for (int n = 0; n < tokens.Length;  n++)
      result[n++] = yyNames[tokens [n]];
    return result;
  }

  /** the generated parser, with debugging messages.
      Maintains a state and a value stack, currently with fixed maximum size.
      @param yyLex scanner.
      @param yydebug debug message writer implementing yyDebug, or null.
      @return result of the last reduction, if any.
      @throws yyException on irrecoverable parse error.
    */
  internal Object yyparse (yyParser.yyInput yyLex, Object yyd)
				 {
//t    this.debug = (yydebug.yyDebug)yyd;
    return yyparse(yyLex);
  }

  /** initial size and increment of the state/value stack [default 256].
      This is not final so that it can be overwritten outside of invocations
      of yyparse().
    */
  protected int yyMax;

  /** executed at the beginning of a reduce action.
      Used as $$ = yyDefault($1), prior to the user-specified action, if any.
      Can be overwritten to provide deep copy, etc.
      @param first value for $1, or null.
      @return first.
    */
  protected Object yyDefault (Object first) {
    return first;
  }

	static int[] global_yyStates;
	static object[] global_yyVals;
	protected bool use_global_stacks;
	object[] yyVals;					// value stack
	object yyVal;						// value stack ptr
	int yyToken;						// current input
	int yyTop;

  /** the generated parser.
      Maintains a state and a value stack, currently with fixed maximum size.
      @param yyLex scanner.
      @return result of the last reduction, if any.
      @throws yyException on irrecoverable parse error.
    */
  internal Object yyparse (yyParser.yyInput yyLex)
  {
    if (yyMax <= 0) yyMax = 256;		// initial size
    int yyState = 0;                   // state stack ptr
    int [] yyStates;               	// state stack 
    yyVal = null;
    yyToken = -1;
    int yyErrorFlag = 0;				// #tks to shift
	if (use_global_stacks && global_yyStates != null) {
		yyVals = global_yyVals;
		yyStates = global_yyStates;
   } else {
		yyVals = new object [yyMax];
		yyStates = new int [yyMax];
		if (use_global_stacks) {
			global_yyVals = yyVals;
			global_yyStates = yyStates;
		}
	}

    /*yyLoop:*/ for (yyTop = 0;; ++ yyTop) {
      if (yyTop >= yyStates.Length) {			// dynamically increase
        global::System.Array.Resize (ref yyStates, yyStates.Length+yyMax);
        global::System.Array.Resize (ref yyVals, yyVals.Length+yyMax);
      }
      yyStates[yyTop] = yyState;
      yyVals[yyTop] = yyVal;
//t      if (debug != null) debug.push(yyState, yyVal);

      /*yyDiscarded:*/ while (true) {	// discarding a token does not change stack
        int yyN;
        if ((yyN = yyDefRed[yyState]) == 0) {	// else [default] reduce (yyN)
          if (yyToken < 0) {
            yyToken = yyLex.advance() ? yyLex.token() : 0;
//t            if (debug != null)
//t              debug.lex(yyState, yyToken, yyname(yyToken), yyLex.value());
          }
          if ((yyN = yySindex[yyState]) != 0 && ((yyN += yyToken) >= 0)
              && (yyN < yyTable.Length) && (yyCheck[yyN] == yyToken)) {
//t            if (debug != null)
//t              debug.shift(yyState, yyTable[yyN], yyErrorFlag-1);
            yyState = yyTable[yyN];		// shift to yyN
            yyVal = yyLex.value();
            yyToken = -1;
            if (yyErrorFlag > 0) -- yyErrorFlag;
            goto continue_yyLoop;
          }
          if ((yyN = yyRindex[yyState]) != 0 && (yyN += yyToken) >= 0
              && yyN < yyTable.Length && yyCheck[yyN] == yyToken)
            yyN = yyTable[yyN];			// reduce (yyN)
          else
            switch (yyErrorFlag) {
  
            case 0:
              yyExpectingState = yyState;
              // yyerror(String.Format ("syntax error, got token `{0}'", yyname (yyToken)), yyExpecting(yyState));
//t              if (debug != null) debug.error("syntax error");
              if (yyToken == 0 /*eof*/ || yyToken == eof_token) throw new yyParser.yyUnexpectedEof ();
              goto case 1;
            case 1: case 2:
              yyErrorFlag = 3;
              do {
                if ((yyN = yySindex[yyStates[yyTop]]) != 0
                    && (yyN += Token.yyErrorCode) >= 0 && yyN < yyTable.Length
                    && yyCheck[yyN] == Token.yyErrorCode) {
//t                  if (debug != null)
//t                    debug.shift(yyStates[yyTop], yyTable[yyN], 3);
                  yyState = yyTable[yyN];
                  yyVal = yyLex.value();
                  goto continue_yyLoop;
                }
//t                if (debug != null) debug.pop(yyStates[yyTop]);
              } while (-- yyTop >= 0);
//t              if (debug != null) debug.reject();
              throw new yyParser.yyException("irrecoverable syntax error");
  
            case 3:
              if (yyToken == 0) {
//t                if (debug != null) debug.reject();
                throw new yyParser.yyException("irrecoverable syntax error at end-of-file");
              }
//t              if (debug != null)
//t                debug.discard(yyState, yyToken, yyname(yyToken),
//t  							yyLex.value());
              yyToken = -1;
              goto continue_yyDiscarded;		// leave stack alone
            }
        }
        int yyV = yyTop + 1-yyLen[yyN];
//t        if (debug != null)
//t          debug.reduce(yyState, yyStates[yyV-1], yyN, YYRules.getRule (yyN), yyLen[yyN]);
        yyVal = yyV > yyTop ? null : yyVals[yyV]; // yyVal = yyDefault(yyV > yyTop ? null : yyVals[yyV]);
        switch (yyN) {
case 1:
#line 376 "cs-parser.jay"
  {
		Lexer.check_incorrect_doc_comment ();
	  }
  break;
case 2:
#line 377 "cs-parser.jay"
  { Lexer.CompleteOnEOF = false; }
  break;
case 5:
  case_5();
  break;
case 6:
#line 393 "cs-parser.jay"
  {
		module.AddAttributes ((Attributes) yyVals[0+yyTop], current_namespace);
	  }
  break;
case 7:
  case_7();
  break;
case 12:
  case_12();
  break;
case 13:
#line 430 "cs-parser.jay"
  {
	  	syntax_error (GetLocation (yyVals[-1+yyTop]), "`alias' expected");   /* TODO: better*/
	  }
  break;
case 16:
  case_16();
  break;
case 17:
  case_17();
  break;
case 18:
  case_18();
  break;
case 19:
  case_19();
  break;
case 20:
  case_20();
  break;
case 21:
  case_21();
  break;
case 22:
  case_22();
  break;
case 23:
  case_23();
  break;
case 24:
  case_24();
  break;
case 25:
  case_25();
  break;
case 26:
  case_26();
  break;
case 31:
  case_31();
  break;
case 40:
  case_40();
  break;
case 41:
#line 618 "cs-parser.jay"
  {
		current_namespace.DeclarationFound = true;
	  }
  break;
case 49:
  case_49();
  break;
case 50:
  case_50();
  break;
case 51:
#line 667 "cs-parser.jay"
  {
		lexer.parsing_attribute_section = true;
	  }
  break;
case 52:
  case_52();
  break;
case 53:
  case_53();
  break;
case 54:
  case_54();
  break;
case 55:
#line 697 "cs-parser.jay"
  {
		yyVal = yyVals[-2+yyTop];
	  }
  break;
case 56:
  case_56();
  break;
case 57:
#line 706 "cs-parser.jay"
  { yyVal = "event"; }
  break;
case 58:
#line 707 "cs-parser.jay"
  { yyVal = "return"; }
  break;
case 59:
  case_59();
  break;
case 60:
#line 724 "cs-parser.jay"
  {
		yyVal = new List<Attribute> (4) { (Attribute) yyVals[0+yyTop] };
	  }
  break;
case 61:
  case_61();
  break;
case 62:
#line 738 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 63:
  case_63();
  break;
case 65:
#line 759 "cs-parser.jay"
  { yyVal = null; }
  break;
case 66:
#line 763 "cs-parser.jay"
  {
		yyVal = yyVals[-1+yyTop];
	  }
  break;
case 67:
#line 768 "cs-parser.jay"
  { yyVal = null; }
  break;
case 68:
  case_68();
  break;
case 69:
  case_69();
  break;
case 70:
  case_70();
  break;
case 71:
  case_71();
  break;
case 72:
#line 812 "cs-parser.jay"
  {
	  	yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 74:
#line 820 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 75:
  case_75();
  break;
case 76:
  case_76();
  break;
case 77:
#line 844 "cs-parser.jay"
  { yyVal = null; }
  break;
case 78:
#line 848 "cs-parser.jay"
  { 
		yyVal = Argument.AType.Ref;
	  }
  break;
case 79:
#line 852 "cs-parser.jay"
  { 
		yyVal = Argument.AType.Out;
	  }
  break;
case 94:
  case_94();
  break;
case 95:
#line 893 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 96:
  case_96();
  break;
case 97:
  case_97();
  break;
case 98:
  case_98();
  break;
case 99:
  case_99();
  break;
case 100:
#line 925 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);
	  }
  break;
case 101:
  case_101();
  break;
case 102:
#line 937 "cs-parser.jay"
  {
		lbag.AppendToMember (current_class, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 117:
  case_117();
  break;
case 118:
  case_118();
  break;
case 121:
#line 1006 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 122:
#line 1010 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 123:
  case_123();
  break;
case 124:
#line 1026 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 125:
  case_125();
  break;
case 126:
  case_126();
  break;
case 129:
  case_129();
  break;
case 130:
  case_130();
  break;
case 131:
  case_131();
  break;
case 132:
  case_132();
  break;
case 133:
#line 1105 "cs-parser.jay"
  {
		Report.Error (1641, GetLocation (yyVals[-1+yyTop]), "A fixed size buffer field must have the array size specifier after the field name");
	  }
  break;
case 135:
  case_135();
  break;
case 136:
  case_136();
  break;
case 139:
#line 1135 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 140:
#line 1139 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 141:
  case_141();
  break;
case 142:
#line 1152 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 143:
  case_143();
  break;
case 146:
#line 1171 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 147:
#line 1175 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 148:
  case_148();
  break;
case 149:
#line 1191 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 150:
  case_150();
  break;
case 151:
  case_151();
  break;
case 154:
  case_154();
  break;
case 155:
  case_155();
  break;
case 156:
  case_156();
  break;
case 157:
#line 1248 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.All;
	  }
  break;
case 158:
#line 1252 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 159:
  case_159();
  break;
case 160:
#line 1293 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.All;
	  }
  break;
case 161:
#line 1297 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 162:
  case_162();
  break;
case 163:
  case_163();
  break;
case 165:
#line 1373 "cs-parser.jay"
  { yyVal = null; }
  break;
case 166:
#line 1377 "cs-parser.jay"
  { yyVal = ParametersCompiled.EmptyReadOnlyParameters; }
  break;
case 168:
  case_168();
  break;
case 169:
  case_169();
  break;
case 170:
  case_170();
  break;
case 171:
  case_171();
  break;
case 172:
  case_172();
  break;
case 173:
  case_173();
  break;
case 174:
  case_174();
  break;
case 175:
#line 1436 "cs-parser.jay"
  {
		yyVal = new ParametersCompiled (new Parameter[] { (Parameter) yyVals[0+yyTop] } );
	  }
  break;
case 176:
#line 1440 "cs-parser.jay"
  {
		yyVal = new ParametersCompiled (new Parameter [] { new ArglistParameter (GetLocation (yyVals[0+yyTop])) }, true);
	  }
  break;
case 177:
  case_177();
  break;
case 178:
  case_178();
  break;
case 179:
  case_179();
  break;
case 180:
  case_180();
  break;
case 181:
  case_181();
  break;
case 182:
  case_182();
  break;
case 183:
#line 1515 "cs-parser.jay"
  {
	  	++lexer.parsing_block;
	  }
  break;
case 184:
  case_184();
  break;
case 185:
#line 1556 "cs-parser.jay"
  { yyVal = Parameter.Modifier.NONE; }
  break;
case 187:
  case_187();
  break;
case 188:
  case_188();
  break;
case 189:
  case_189();
  break;
case 190:
  case_190();
  break;
case 191:
  case_191();
  break;
case 192:
  case_192();
  break;
case 193:
  case_193();
  break;
case 194:
  case_194();
  break;
case 195:
  case_195();
  break;
case 196:
  case_196();
  break;
case 197:
#line 1654 "cs-parser.jay"
  {
		Error_DuplicateParameterModifier (GetLocation (yyVals[-1+yyTop]), Parameter.Modifier.PARAMS);
	  }
  break;
case 198:
  case_198();
  break;
case 199:
  case_199();
  break;
case 200:
  case_200();
  break;
case 201:
  case_201();
  break;
case 202:
  case_202();
  break;
case 203:
#line 1708 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Params | ParameterModifierType.DefaultValue;
	  }
  break;
case 204:
  case_204();
  break;
case 205:
#line 1738 "cs-parser.jay"
  {
		  lexer.PropertyParsing = false;
	  }
  break;
case 206:
  case_206();
  break;
case 211:
  case_211();
  break;
case 212:
  case_212();
  break;
case 213:
  case_213();
  break;
case 214:
  case_214();
  break;
case 215:
  case_215();
  break;
case 217:
  case_217();
  break;
case 218:
  case_218();
  break;
case 219:
#line 1880 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 220:
  case_220();
  break;
case 221:
  case_221();
  break;
case 222:
  case_222();
  break;
case 223:
  case_223();
  break;
case 224:
#line 1913 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);	  
	  }
  break;
case 229:
#line 1930 "cs-parser.jay"
  {
		Report.Error (525, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain fields or constants");
	  }
  break;
case 230:
#line 1934 "cs-parser.jay"
  {
		Report.Error (525, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain fields or constants");
	  }
  break;
case 235:
#line 1942 "cs-parser.jay"
  {
	  	Report.Error (567, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain operators");
	  }
  break;
case 236:
#line 1946 "cs-parser.jay"
  {
	  	Report.Error (526, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain contructors");
	  }
  break;
case 237:
#line 1950 "cs-parser.jay"
  {
	  	Report.Error (524, GetLocation (yyVals[0+yyTop]), "Interfaces cannot declare classes, structs, interfaces, delegates, or enumerations");
	  }
  break;
case 238:
#line 1956 "cs-parser.jay"
  {
	  }
  break;
case 239:
  case_239();
  break;
case 241:
#line 1983 "cs-parser.jay"
  { yyVal = null; }
  break;
case 243:
  case_243();
  break;
case 244:
#line 1999 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue;
	  }
  break;
case 245:
  case_245();
  break;
case 247:
#line 2045 "cs-parser.jay"
  { yyVal = Operator.OpType.LogicalNot; }
  break;
case 248:
#line 2046 "cs-parser.jay"
  { yyVal = Operator.OpType.OnesComplement; }
  break;
case 249:
#line 2047 "cs-parser.jay"
  { yyVal = Operator.OpType.Increment; }
  break;
case 250:
#line 2048 "cs-parser.jay"
  { yyVal = Operator.OpType.Decrement; }
  break;
case 251:
#line 2049 "cs-parser.jay"
  { yyVal = Operator.OpType.True; }
  break;
case 252:
#line 2050 "cs-parser.jay"
  { yyVal = Operator.OpType.False; }
  break;
case 253:
#line 2052 "cs-parser.jay"
  { yyVal = Operator.OpType.Addition; }
  break;
case 254:
#line 2053 "cs-parser.jay"
  { yyVal = Operator.OpType.Subtraction; }
  break;
case 255:
#line 2055 "cs-parser.jay"
  { yyVal = Operator.OpType.Multiply; }
  break;
case 256:
#line 2056 "cs-parser.jay"
  {  yyVal = Operator.OpType.Division; }
  break;
case 257:
#line 2057 "cs-parser.jay"
  { yyVal = Operator.OpType.Modulus; }
  break;
case 258:
#line 2058 "cs-parser.jay"
  { yyVal = Operator.OpType.BitwiseAnd; }
  break;
case 259:
#line 2059 "cs-parser.jay"
  { yyVal = Operator.OpType.BitwiseOr; }
  break;
case 260:
#line 2060 "cs-parser.jay"
  { yyVal = Operator.OpType.ExclusiveOr; }
  break;
case 261:
#line 2061 "cs-parser.jay"
  { yyVal = Operator.OpType.LeftShift; }
  break;
case 262:
#line 2062 "cs-parser.jay"
  { yyVal = Operator.OpType.RightShift; }
  break;
case 263:
#line 2063 "cs-parser.jay"
  { yyVal = Operator.OpType.Equality; }
  break;
case 264:
#line 2064 "cs-parser.jay"
  { yyVal = Operator.OpType.Inequality; }
  break;
case 265:
#line 2065 "cs-parser.jay"
  { yyVal = Operator.OpType.GreaterThan; }
  break;
case 266:
#line 2066 "cs-parser.jay"
  { yyVal = Operator.OpType.LessThan; }
  break;
case 267:
#line 2067 "cs-parser.jay"
  { yyVal = Operator.OpType.GreaterThanOrEqual; }
  break;
case 268:
#line 2068 "cs-parser.jay"
  { yyVal = Operator.OpType.LessThanOrEqual; }
  break;
case 269:
#line 2075 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue;
	  }
  break;
case 270:
  case_270();
  break;
case 271:
#line 2094 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue;
	  }
  break;
case 272:
  case_272();
  break;
case 273:
  case_273();
  break;
case 274:
  case_274();
  break;
case 275:
  case_275();
  break;
case 276:
  case_276();
  break;
case 277:
  case_277();
  break;
case 278:
  case_278();
  break;
case 280:
#line 2197 "cs-parser.jay"
  { current_block = null; yyVal = null; }
  break;
case 283:
#line 2209 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 284:
  case_284();
  break;
case 285:
#line 2219 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 286:
  case_286();
  break;
case 287:
  case_287();
  break;
case 288:
  case_288();
  break;
case 289:
  case_289();
  break;
case 290:
  case_290();
  break;
case 291:
  case_291();
  break;
case 292:
  case_292();
  break;
case 293:
  case_293();
  break;
case 294:
  case_294();
  break;
case 296:
#line 2328 "cs-parser.jay"
  {
	  	++lexer.parsing_block;
	  }
  break;
case 297:
  case_297();
  break;
case 300:
#line 2345 "cs-parser.jay"
  {
		current_event_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 301:
#line 2349 "cs-parser.jay"
  {
		current_event_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 302:
  case_302();
  break;
case 303:
#line 2362 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 304:
  case_304();
  break;
case 305:
  case_305();
  break;
case 306:
#line 2387 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 309:
  case_309();
  break;
case 310:
  case_310();
  break;
case 311:
  case_311();
  break;
case 312:
  case_312();
  break;
case 313:
  case_313();
  break;
case 314:
  case_314();
  break;
case 315:
  case_315();
  break;
case 316:
  case_316();
  break;
case 318:
  case_318();
  break;
case 319:
  case_319();
  break;
case 320:
  case_320();
  break;
case 321:
  case_321();
  break;
case 323:
  case_323();
  break;
case 324:
  case_324();
  break;
case 327:
#line 2542 "cs-parser.jay"
  {
	  	lbag.AddLocation (yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 329:
  case_329();
  break;
case 330:
  case_330();
  break;
case 331:
  case_331();
  break;
case 332:
  case_332();
  break;
case 333:
#line 2600 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out | ParameterModifierType.Params | ParameterModifierType.DefaultValue;
	  }
  break;
case 334:
  case_334();
  break;
case 335:
#line 2620 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = false;
	  }
  break;
case 336:
  case_336();
  break;
case 338:
  case_338();
  break;
case 340:
  case_340();
  break;
case 342:
  case_342();
  break;
case 343:
  case_343();
  break;
case 345:
  case_345();
  break;
case 346:
  case_346();
  break;
case 347:
  case_347();
  break;
case 348:
  case_348();
  break;
case 349:
#line 2718 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 350:
  case_350();
  break;
case 351:
  case_351();
  break;
case 353:
  case_353();
  break;
case 354:
  case_354();
  break;
case 355:
  case_355();
  break;
case 356:
  case_356();
  break;
case 357:
  case_357();
  break;
case 358:
  case_358();
  break;
case 360:
  case_360();
  break;
case 361:
  case_361();
  break;
case 362:
  case_362();
  break;
case 363:
  case_363();
  break;
case 364:
  case_364();
  break;
case 366:
#line 2836 "cs-parser.jay"
  {
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 367:
#line 2843 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 369:
  case_369();
  break;
case 371:
  case_371();
  break;
case 373:
  case_373();
  break;
case 375:
#line 2881 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 376:
  case_376();
  break;
case 377:
#line 2901 "cs-parser.jay"
  {
		yyVal = new ComposedCast (((MemberName) yyVals[-1+yyTop]).GetTypeExpression (), (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 378:
  case_378();
  break;
case 379:
#line 2910 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 380:
#line 2914 "cs-parser.jay"
  {
		yyVal = new ComposedCast (new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-1+yyTop])), (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 381:
  case_381();
  break;
case 382:
  case_382();
  break;
case 383:
  case_383();
  break;
case 384:
  case_384();
  break;
case 385:
#line 2952 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Object, GetLocation (yyVals[0+yyTop])); }
  break;
case 386:
#line 2953 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.String, GetLocation (yyVals[0+yyTop])); }
  break;
case 387:
#line 2954 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Bool, GetLocation (yyVals[0+yyTop])); }
  break;
case 388:
#line 2955 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Decimal, GetLocation (yyVals[0+yyTop])); }
  break;
case 389:
#line 2956 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Float, GetLocation (yyVals[0+yyTop])); }
  break;
case 390:
#line 2957 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Double, GetLocation (yyVals[0+yyTop])); }
  break;
case 392:
#line 2962 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.SByte, GetLocation (yyVals[0+yyTop])); }
  break;
case 393:
#line 2963 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Byte, GetLocation (yyVals[0+yyTop])); }
  break;
case 394:
#line 2964 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Short, GetLocation (yyVals[0+yyTop])); }
  break;
case 395:
#line 2965 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.UShort, GetLocation (yyVals[0+yyTop])); }
  break;
case 396:
#line 2966 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Int, GetLocation (yyVals[0+yyTop])); }
  break;
case 397:
#line 2967 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.UInt, GetLocation (yyVals[0+yyTop])); }
  break;
case 398:
#line 2968 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Long, GetLocation (yyVals[0+yyTop])); }
  break;
case 399:
#line 2969 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.ULong, GetLocation (yyVals[0+yyTop])); }
  break;
case 400:
#line 2970 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Char, GetLocation (yyVals[0+yyTop])); }
  break;
case 421:
  case_421();
  break;
case 422:
  case_422();
  break;
case 426:
#line 3017 "cs-parser.jay"
  { yyVal = new NullLiteral (GetLocation (yyVals[0+yyTop])); }
  break;
case 427:
#line 3021 "cs-parser.jay"
  { yyVal = new BoolLiteral (compiler.BuiltinTypes, true, GetLocation (yyVals[0+yyTop])); }
  break;
case 428:
#line 3022 "cs-parser.jay"
  { yyVal = new BoolLiteral (compiler.BuiltinTypes, false, GetLocation (yyVals[0+yyTop])); }
  break;
case 433:
  case_433();
  break;
case 434:
#line 3055 "cs-parser.jay"
  {
		yyVal = new ParenthesizedExpression ((Expression) yyVals[-1+yyTop]);
	  }
  break;
case 435:
  case_435();
  break;
case 436:
  case_436();
  break;
case 437:
  case_437();
  break;
case 438:
  case_438();
  break;
case 439:
#line 3086 "cs-parser.jay"
  {
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-2+yyTop], null,GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 440:
  case_440();
  break;
case 441:
#line 3094 "cs-parser.jay"
  {
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-2+yyTop], null, lexer.Location);
	  }
  break;
case 442:
  case_442();
  break;
case 443:
  case_443();
  break;
case 444:
#line 3110 "cs-parser.jay"
  { yyVal = null; }
  break;
case 446:
  case_446();
  break;
case 447:
  case_447();
  break;
case 448:
#line 3133 "cs-parser.jay"
  { yyVal = null; }
  break;
case 449:
#line 3137 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	}
  break;
case 450:
  case_450();
  break;
case 451:
  case_451();
  break;
case 452:
  case_452();
  break;
case 453:
  case_453();
  break;
case 454:
#line 3169 "cs-parser.jay"
  {
		yyVal = new CompletionElementInitializer (null, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 455:
  case_455();
  break;
case 456:
  case_456();
  break;
case 457:
  case_457();
  break;
case 460:
#line 3197 "cs-parser.jay"
  { yyVal = null; }
  break;
case 462:
  case_462();
  break;
case 463:
  case_463();
  break;
case 464:
  case_464();
  break;
case 465:
  case_465();
  break;
case 466:
  case_466();
  break;
case 467:
#line 3249 "cs-parser.jay"
  {
		yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 471:
  case_471();
  break;
case 472:
  case_472();
  break;
case 473:
  case_473();
  break;
case 474:
  case_474();
  break;
case 476:
  case_476();
  break;
case 477:
  case_477();
  break;
case 478:
  case_478();
  break;
case 479:
  case_479();
  break;
case 480:
  case_480();
  break;
case 481:
  case_481();
  break;
case 482:
#line 3336 "cs-parser.jay"
  {
	  	yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 484:
#line 3344 "cs-parser.jay"
  {
		yyVal = new This (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 485:
  case_485();
  break;
case 486:
  case_486();
  break;
case 487:
#line 3364 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PostIncrement, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 488:
#line 3371 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PostDecrement, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 489:
  case_489();
  break;
case 490:
  case_490();
  break;
case 491:
  case_491();
  break;
case 492:
  case_492();
  break;
case 493:
  case_493();
  break;
case 494:
  case_494();
  break;
case 495:
  case_495();
  break;
case 496:
#line 3437 "cs-parser.jay"
  {
		++lexer.parsing_type;
	  }
  break;
case 497:
  case_497();
  break;
case 498:
  case_498();
  break;
case 501:
#line 3464 "cs-parser.jay"
  { yyVal = null; }
  break;
case 503:
  case_503();
  break;
case 504:
  case_504();
  break;
case 505:
  case_505();
  break;
case 506:
  case_506();
  break;
case 507:
  case_507();
  break;
case 508:
  case_508();
  break;
case 512:
  case_512();
  break;
case 513:
  case_513();
  break;
case 514:
  case_514();
  break;
case 515:
#line 3540 "cs-parser.jay"
  {
		yyVal = 2;
	  }
  break;
case 516:
#line 3544 "cs-parser.jay"
  {
		yyVal = ((int) yyVals[-1+yyTop]) + 1;
	  }
  break;
case 517:
#line 3551 "cs-parser.jay"
  {
		yyVal = null;
	  }
  break;
case 518:
#line 3555 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 519:
  case_519();
  break;
case 520:
  case_520();
  break;
case 521:
  case_521();
  break;
case 522:
  case_522();
  break;
case 523:
#line 3599 "cs-parser.jay"
  {
	  	lexer.TypeOfParsing = true;
	  }
  break;
case 524:
  case_524();
  break;
case 527:
  case_527();
  break;
case 528:
  case_528();
  break;
case 529:
  case_529();
  break;
case 530:
  case_530();
  break;
case 531:
  case_531();
  break;
case 532:
  case_532();
  break;
case 533:
  case_533();
  break;
case 534:
  case_534();
  break;
case 535:
  case_535();
  break;
case 536:
  case_536();
  break;
case 537:
  case_537();
  break;
case 538:
  case_538();
  break;
case 539:
#line 3712 "cs-parser.jay"
  {
		start_anonymous (false, (ParametersCompiled) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 540:
#line 3716 "cs-parser.jay"
  {
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
	  }
  break;
case 541:
#line 3723 "cs-parser.jay"
  {
		yyVal = ParametersCompiled.Undefined;
	  }
  break;
case 543:
#line 3731 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 544:
  case_544();
  break;
case 545:
  case_545();
  break;
case 547:
#line 3755 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.LogicalNot, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 548:
#line 3759 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.OnesComplement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 550:
  case_550();
  break;
case 552:
#line 3780 "cs-parser.jay"
  { 
	  	yyVal = new Unary (Unary.Operator.UnaryPlus, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 553:
#line 3784 "cs-parser.jay"
  { 
		yyVal = new Unary (Unary.Operator.UnaryNegation, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 554:
#line 3788 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PreIncrement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 555:
#line 3792 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PreDecrement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 556:
#line 3796 "cs-parser.jay"
  {
		yyVal = new Indirection ((Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 557:
#line 3800 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.AddressOf, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 559:
  case_559();
  break;
case 560:
  case_560();
  break;
case 561:
  case_561();
  break;
case 563:
  case_563();
  break;
case 564:
#line 3832 "cs-parser.jay"
  {
		yyVal = new Binary (Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 565:
  case_565();
  break;
case 566:
#line 3841 "cs-parser.jay"
  {
		yyVal = new As ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 567:
#line 3845 "cs-parser.jay"
  {
		yyVal = new Is ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 569:
  case_569();
  break;
case 570:
  case_570();
  break;
case 572:
  case_572();
  break;
case 573:
  case_573();
  break;
case 574:
  case_574();
  break;
case 575:
  case_575();
  break;
case 577:
  case_577();
  break;
case 578:
  case_578();
  break;
case 580:
  case_580();
  break;
case 582:
  case_582();
  break;
case 584:
  case_584();
  break;
case 586:
  case_586();
  break;
case 588:
  case_588();
  break;
case 590:
  case_590();
  break;
case 592:
  case_592();
  break;
case 593:
#line 3969 "cs-parser.jay"
  {
		yyVal = new SimpleAssign ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 594:
  case_594();
  break;
case 595:
  case_595();
  break;
case 596:
  case_596();
  break;
case 597:
  case_597();
  break;
case 598:
  case_598();
  break;
case 599:
  case_599();
  break;
case 600:
  case_600();
  break;
case 601:
  case_601();
  break;
case 602:
  case_602();
  break;
case 603:
  case_603();
  break;
case 604:
  case_604();
  break;
case 605:
  case_605();
  break;
case 606:
  case_606();
  break;
case 607:
  case_607();
  break;
case 608:
  case_608();
  break;
case 609:
#line 4064 "cs-parser.jay"
  { yyVal = ParametersCompiled.EmptyReadOnlyParameters; }
  break;
case 610:
  case_610();
  break;
case 613:
#line 4079 "cs-parser.jay"
  {
		start_block (lexer.Location);
	  }
  break;
case 614:
  case_614();
  break;
case 616:
  case_616();
  break;
case 617:
  case_617();
  break;
case 618:
  case_618();
  break;
case 619:
  case_619();
  break;
case 620:
  case_620();
  break;
case 621:
  case_621();
  break;
case 627:
#line 4141 "cs-parser.jay"
  {
		yyVal = new ArglistAccess (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 628:
  case_628();
  break;
case 629:
  case_629();
  break;
case 630:
  case_630();
  break;
case 632:
#line 4170 "cs-parser.jay"
  {
		yyVal = new BooleanExpression ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 633:
#line 4183 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 634:
  case_634();
  break;
case 635:
  case_635();
  break;
case 636:
  case_636();
  break;
case 637:
  case_637();
  break;
case 638:
#line 4222 "cs-parser.jay"
  { yyVal = null; }
  break;
case 639:
#line 4224 "cs-parser.jay"
  { yyVal = yyVals[0+yyTop]; }
  break;
case 640:
  case_640();
  break;
case 643:
  case_643();
  break;
case 644:
  case_644();
  break;
case 645:
  case_645();
  break;
case 646:
  case_646();
  break;
case 647:
  case_647();
  break;
case 648:
  case_648();
  break;
case 649:
  case_649();
  break;
case 650:
  case_650();
  break;
case 651:
  case_651();
  break;
case 652:
  case_652();
  break;
case 653:
  case_653();
  break;
case 654:
  case_654();
  break;
case 655:
  case_655();
  break;
case 656:
  case_656();
  break;
case 657:
  case_657();
  break;
case 658:
  case_658();
  break;
case 660:
#line 4344 "cs-parser.jay"
  {
		current_container.AddBasesForPart (current_class, (List<FullNamedExpression>) yyVals[0+yyTop]);
	 }
  break;
case 662:
#line 4352 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 663:
  case_663();
  break;
case 664:
  case_664();
  break;
case 665:
  case_665();
  break;
case 666:
  case_666();
  break;
case 667:
  case_667();
  break;
case 668:
  case_668();
  break;
case 669:
  case_669();
  break;
case 670:
  case_670();
  break;
case 671:
#line 4441 "cs-parser.jay"
  {
		yyVal = new SpecialContraintExpr (SpecialConstraint.Class, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 672:
#line 4445 "cs-parser.jay"
  {
		yyVal = new SpecialContraintExpr (SpecialConstraint.Struct, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 673:
#line 4452 "cs-parser.jay"
  {
		yyVal = Variance.None;
	  }
  break;
case 674:
  case_674();
  break;
case 675:
#line 4466 "cs-parser.jay"
  {
		yyVal = Variance.Covariant;
	  }
  break;
case 676:
#line 4470 "cs-parser.jay"
  {
		yyVal = Variance.Contravariant;
	  }
  break;
case 677:
  case_677();
  break;
case 678:
#line 4495 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 679:
  case_679();
  break;
case 680:
  case_680();
  break;
case 681:
  case_681();
  break;
case 682:
  case_682();
  break;
case 687:
#line 4539 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 688:
#line 4543 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 690:
  case_690();
  break;
case 693:
#line 4567 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 694:
#line 4571 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 723:
  case_723();
  break;
case 724:
  case_724();
  break;
case 725:
  case_725();
  break;
case 726:
  case_726();
  break;
case 727:
  case_727();
  break;
case 730:
  case_730();
  break;
case 731:
  case_731();
  break;
case 732:
  case_732();
  break;
case 733:
  case_733();
  break;
case 734:
#line 4715 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 735:
#line 4719 "cs-parser.jay"
  {
		yyVal = new ComposedCast (new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-1+yyTop])), (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 736:
  case_736();
  break;
case 738:
  case_738();
  break;
case 739:
#line 4740 "cs-parser.jay"
  {
		yyVal = ComposedTypeSpecifier.CreatePointer (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 740:
  case_740();
  break;
case 741:
  case_741();
  break;
case 742:
  case_742();
  break;
case 743:
  case_743();
  break;
case 745:
  case_745();
  break;
case 746:
  case_746();
  break;
case 751:
  case_751();
  break;
case 752:
  case_752();
  break;
case 753:
#line 4829 "cs-parser.jay"
  {
		Report.Error (145, lexer.Location, "A const field requires a value to be provided");
	  }
  break;
case 754:
  case_754();
  break;
case 759:
  case_759();
  break;
case 761:
  case_761();
  break;
case 762:
  case_762();
  break;
case 763:
  case_763();
  break;
case 764:
#line 4879 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 765:
#line 4883 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 766:
#line 4884 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 767:
  case_767();
  break;
case 768:
  case_768();
  break;
case 769:
  case_769();
  break;
case 772:
  case_772();
  break;
case 773:
  case_773();
  break;
case 774:
#line 4952 "cs-parser.jay"
  {
		start_block (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 775:
  case_775();
  break;
case 776:
  case_776();
  break;
case 778:
  case_778();
  break;
case 779:
  case_779();
  break;
case 780:
  case_780();
  break;
case 781:
#line 4996 "cs-parser.jay"
  {
		current_block = current_block.CreateSwitchBlock (lexer.Location);
	  }
  break;
case 782:
#line 5000 "cs-parser.jay"
  {
		yyVal = new SwitchSection ((List<SwitchLabel>) yyVals[-2+yyTop], current_block);
	  }
  break;
case 783:
  case_783();
  break;
case 784:
  case_784();
  break;
case 785:
  case_785();
  break;
case 786:
#line 5029 "cs-parser.jay"
  {
		yyVal = new SwitchLabel (null, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 791:
  case_791();
  break;
case 792:
  case_792();
  break;
case 793:
  case_793();
  break;
case 794:
#line 5068 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 795:
  case_795();
  break;
case 796:
  case_796();
  break;
case 797:
#line 5096 "cs-parser.jay"
  { yyVal = new EmptyStatement (lexer.Location); }
  break;
case 799:
  case_799();
  break;
case 800:
  case_800();
  break;
case 802:
#line 5117 "cs-parser.jay"
  { yyVal = null; }
  break;
case 804:
#line 5122 "cs-parser.jay"
  { yyVal = new EmptyStatement (lexer.Location); }
  break;
case 808:
  case_808();
  break;
case 809:
  case_809();
  break;
case 810:
  case_810();
  break;
case 811:
  case_811();
  break;
case 818:
  case_818();
  break;
case 819:
  case_819();
  break;
case 820:
  case_820();
  break;
case 821:
  case_821();
  break;
case 822:
  case_822();
  break;
case 823:
  case_823();
  break;
case 824:
  case_824();
  break;
case 825:
  case_825();
  break;
case 826:
  case_826();
  break;
case 829:
#line 5277 "cs-parser.jay"
  {
		yyVal = new TryCatch ((Block) yyVals[-1+yyTop], (List<Catch>) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]), false);
	  }
  break;
case 830:
  case_830();
  break;
case 831:
  case_831();
  break;
case 832:
  case_832();
  break;
case 833:
  case_833();
  break;
case 834:
  case_834();
  break;
case 837:
#line 5330 "cs-parser.jay"
  {
		yyVal = new Catch ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 838:
  case_838();
  break;
case 839:
#line 5349 "cs-parser.jay"
  {
		yyVal = yyVals[-1+yyTop];
	  }
  break;
case 840:
  case_840();
  break;
case 841:
#line 5367 "cs-parser.jay"
  {
		yyVal = new Checked ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 842:
#line 5374 "cs-parser.jay"
  {
		yyVal = new Unchecked ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 843:
  case_843();
  break;
case 844:
#line 5384 "cs-parser.jay"
  {
		yyVal = new Unsafe ((Block) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }
  break;
case 845:
  case_845();
  break;
case 846:
  case_846();
  break;
case 847:
  case_847();
  break;
case 848:
  case_848();
  break;
case 849:
  case_849();
  break;
case 850:
  case_850();
  break;
case 851:
  case_851();
  break;
case 852:
  case_852();
  break;
case 853:
#line 5467 "cs-parser.jay"
  {
		Report.Error (210, lexer.Location, "You must provide an initializer in a fixed or using statement declaration");
	  }
  break;
case 854:
  case_854();
  break;
case 855:
  case_855();
  break;
case 856:
  case_856();
  break;
case 857:
  case_857();
  break;
case 858:
  case_858();
  break;
case 859:
  case_859();
  break;
case 860:
  case_860();
  break;
case 861:
  case_861();
  break;
case 862:
  case_862();
  break;
case 863:
#line 5567 "cs-parser.jay"
  {
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 864:
  case_864();
  break;
case 865:
#line 5582 "cs-parser.jay"
  {
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 866:
  case_866();
  break;
case 867:
  case_867();
  break;
case 869:
  case_869();
  break;
case 870:
#line 5627 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 871:
  case_871();
  break;
case 872:
  case_872();
  break;
case 873:
  case_873();
  break;
case 874:
  case_874();
  break;
case 878:
  case_878();
  break;
case 884:
#line 5685 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 885:
  case_885();
  break;
case 886:
#line 5703 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 887:
  case_887();
  break;
case 888:
  case_888();
  break;
case 889:
  case_889();
  break;
case 890:
  case_890();
  break;
case 891:
  case_891();
  break;
case 892:
  case_892();
  break;
case 893:
  case_893();
  break;
case 894:
  case_894();
  break;
case 895:
  case_895();
  break;
case 897:
#line 5845 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 898:
#line 5852 "cs-parser.jay"
  {
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 899:
  case_899();
  break;
case 901:
  case_901();
  break;
case 902:
  case_902();
  break;
case 904:
  case_904();
  break;
case 905:
  case_905();
  break;
case 906:
#line 5898 "cs-parser.jay"
  {
		yyVal = new Linq.OrderByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[0+yyTop]);	
	  }
  break;
case 907:
#line 5902 "cs-parser.jay"
  {
		yyVal = new Linq.OrderByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
	  }
  break;
case 908:
#line 5906 "cs-parser.jay"
  {
		yyVal = new Linq.OrderByDescending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
	  }
  break;
case 909:
#line 5913 "cs-parser.jay"
  {
		yyVal = new Linq.ThenByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[0+yyTop]);	
	  }
  break;
case 910:
#line 5917 "cs-parser.jay"
  {
		yyVal = new Linq.ThenByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
	  }
  break;
case 911:
#line 5921 "cs-parser.jay"
  {
		yyVal = new Linq.ThenByDescending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
	  }
  break;
case 913:
  case_913();
  break;
case 914:
  case_914();
  break;
case 917:
  case_917();
  break;
case 918:
  case_918();
  break;
#line default
        }
        yyTop -= yyLen[yyN];
        yyState = yyStates[yyTop];
        int yyM = yyLhs[yyN];
        if (yyState == 0 && yyM == 0) {
//t          if (debug != null) debug.shift(0, yyFinal);
          yyState = yyFinal;
          if (yyToken < 0) {
            yyToken = yyLex.advance() ? yyLex.token() : 0;
//t            if (debug != null)
//t               debug.lex(yyState, yyToken,yyname(yyToken), yyLex.value());
          }
          if (yyToken == 0) {
//t            if (debug != null) debug.accept(yyVal);
            return yyVal;
          }
          goto continue_yyLoop;
        }
        if (((yyN = yyGindex[yyM]) != 0) && ((yyN += yyState) >= 0)
            && (yyN < yyTable.Length) && (yyCheck[yyN] == yyState))
          yyState = yyTable[yyN];
        else
          yyState = yyDgoto[yyM];
//t        if (debug != null) debug.shift(yyStates[yyTop], yyState);
	 goto continue_yyLoop;
      continue_yyDiscarded: ;	// implements the named-loop continue: 'continue yyDiscarded'
      }
    continue_yyLoop: ;		// implements the named-loop continue: 'continue yyLoop'
    }
  }

/*
 All more than 3 lines long rules are wrapped into a method
*/
void case_5()
#line 383 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			Attributes attrs = (Attributes) yyVals[0+yyTop];
			Report.Error (1730, attrs.Attrs [0].Location,
				"Assembly and module attributes must precede all other elements except using clauses and extern alias declarations");
		}
	  }

void case_7()
#line 395 "cs-parser.jay"
{
		if (yyToken == Token.EXTERN_ALIAS)
			Report.Error (439, lexer.Location, "An extern alias declaration must precede all other elements");
		else
			Error_SyntaxError (yyToken);
	  }

void case_12()
#line 415 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		string s = lt.Value;
		if (s != "alias"){
			syntax_error (lt.Location, "`alias' expected");
		} else if (lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (lt.Location, "external alias");
		} else {
			lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop]; 
			current_namespace.AddUsingExternalAlias (lt.Value, lt.Location, Report);
		}
	  }

void case_16()
#line 440 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_17()
#line 445 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_18()
#line 453 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		if (lang_version != LanguageVersion.ISO_1 && lt.Value == "global") {
			Report.Warning (440, 2, lt.Location,
			 "An alias named `global' will not be used when resolving `global::'. The global namespace will be used instead");
		}

		current_namespace.AddUsingAlias (lt.Value, (MemberName) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		ubag.AddUsingAlias (GetLocation (yyVals[-4+yyTop]), lt, GetLocation (yyVals[-2+yyTop]), (MemberName) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }

void case_19()
#line 464 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_20()
#line 472 "cs-parser.jay"
{
		current_namespace.AddUsing ((MemberName) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		ubag.AddUsing (GetLocation (yyVals[-2+yyTop]), (MemberName) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }

void case_21()
#line 485 "cs-parser.jay"
{
		Attributes attrs = (Attributes) yyVals[-2+yyTop];
		MemberName name = (MemberName) yyVals[0+yyTop];
		if (attrs != null) {
			bool valid_global_attrs = true;
			if ((current_namespace.DeclarationFound || current_namespace != file.NamespaceContainer)) {
				valid_global_attrs = false;
			} else {
				foreach (var a in attrs.Attrs) {
					if (a.ExplicitTarget == "assembly" || a.ExplicitTarget == "module")
						continue;
						
					valid_global_attrs = false;
					break;
				}
			}
			
			if (!valid_global_attrs)
				Report.Error (1671, name.Location, "A namespace declaration cannot have modifiers or attributes");
		}
		
		current_namespace = new NamespaceEntry (module, current_namespace, file, name.GetName ());
		current_class = current_namespace.SlaveDeclSpace;
		current_container = current_class.PartialContainer;
		
		module.AddAttributes (attrs, current_namespace);
		
		ubag.DeclareNamespace (GetLocation (yyVals[-1+yyTop]), name);
	  }

void case_22()
#line 515 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
		ubag.OpenNamespace (GetLocation (yyVals[0+yyTop]));
	  }

void case_23()
#line 521 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null)
			lbag.AddLocation (current_namespace, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
		else
			lbag.AddLocation (current_namespace, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-1+yyTop]));
		
		current_namespace = current_namespace.Parent;
		current_class = current_namespace.SlaveDeclSpace;
		current_container = current_class.PartialContainer;
		ubag.CloseNamespace (GetLocation (yyVals[-1+yyTop]));
		ubag.EndNamespace (GetLocation (yyVals[-1+yyTop]));
	  }

void case_24()
#line 537 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new MemberName (lt.Value, lt.Location);
	  }

void case_25()
#line 542 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-2+yyTop], lt.Value, lt.Location);		
	  }

void case_26()
#line 547 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new MemberName ("<invalid>", lexer.Location);
	  }

void case_31()
#line 565 "cs-parser.jay"
{
		MemberName name = (MemberName) yyVals[0+yyTop];

		if (name.TypeArguments != null)
			syntax_error (lexer.Location, "namespace name expected");

		yyVal = name;
	  }

void case_40()
#line 597 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			TypeContainer ds = (TypeContainer)yyVals[0+yyTop];

			if ((ds.ModFlags & (Modifiers.PRIVATE | Modifiers.PROTECTED)) != 0){
				Report.Error (1527, ds.Location, 
				"Namespace elements cannot be explicitly declared as private, protected or protected internal");
			}

			/* Here is a trick, for explicit attributes we don't know where they belong to until*/
			/* we parse succeeding declaration hence we parse them as normal and re-attach them*/
			/* when we know whether they are global (assembly:, module:) or local (type:).*/
			if (ds.OptAttributes != null) {
				ds.OptAttributes.ConvertGlobalAttributes (ds, current_namespace, !current_namespace.DeclarationFound && current_namespace == file.NamespaceContainer);
			}
		}
		current_namespace.DeclarationFound = true;
	  }

void case_49()
#line 647 "cs-parser.jay"
{
		var sect = (List<Attribute>) yyVals[0+yyTop];
		yyVal = new Attributes (sect);
	  }

void case_50()
#line 652 "cs-parser.jay"
{
		Attributes attrs = yyVals[-1+yyTop] as Attributes;
		var sect = (List<Attribute>) yyVals[0+yyTop];
		if (attrs == null)
			attrs = new Attributes (sect);
		else
			attrs.AddAttributes (sect);
		yyVal = attrs;
	  }

void case_52()
#line 669 "cs-parser.jay"
{
		lexer.parsing_attribute_section = false;
		yyVal = yyVals[0+yyTop];
	  }

void case_53()
#line 677 "cs-parser.jay"
{
		current_attr_target = (string) yyVals[-1+yyTop];
		if (current_attr_target == "assembly" || current_attr_target == "module") {
			Lexer.check_incorrect_doc_comment ();
		}
	  }

void case_54()
#line 684 "cs-parser.jay"
{
		/* when attribute target is invalid*/
		if (current_attr_target == string.Empty)
			yyVal = new List<Attribute> (0);
		else
			yyVal = yyVals[-2+yyTop];
	  
		current_attr_target = null;
		lexer.parsing_attribute_section = false;
 	  }

void case_56()
#line 702 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = CheckAttributeTarget (lt.Value, lt.Location);
	  }

void case_59()
#line 709 "cs-parser.jay"
{
		if (yyToken == Token.IDENTIFIER) {
			Error_SyntaxError (yyToken);
			yyVal = null;
		} else {
			string name = GetTokenName (yyToken);
			yyVal = CheckAttributeTarget (name, GetLocation (yyVals[0+yyTop]));
		}
	  }

void case_61()
#line 726 "cs-parser.jay"
{
		var attrs = (List<Attribute>) yyVals[-2+yyTop];
		attrs.Add ((Attribute) yyVals[0+yyTop]);

		yyVal = attrs;
	  }

void case_63()
#line 740 "cs-parser.jay"
{
		--lexer.parsing_block;
		MemberName mname = (MemberName) yyVals[-2+yyTop];
		if (mname.IsGeneric) {
			Report.Error (404, lexer.Location,
				      "'<' unexpected: attributes cannot be generic");
		}

		Arguments [] arguments = (Arguments []) yyVals[0+yyTop];
		ATypeNameExpression expr = mname.GetTypeExpression ();
		yyVal = new Attribute (current_attr_target, expr, arguments, mname.Location, lexer.IsEscapedIdentifier (mname));
	  }

void case_68()
#line 770 "cs-parser.jay"
{
	  	Arguments a = new Arguments (4);
		a.Add ((Argument) yyVals[0+yyTop]);
		yyVal = new Arguments [] { a, null };
	  }

void case_69()
#line 776 "cs-parser.jay"
{
	  	Arguments a = new Arguments (4);
		a.Add ((Argument) yyVals[0+yyTop]);  
		yyVal = new Arguments [] { null, a };
	  }

void case_70()
#line 782 "cs-parser.jay"
{
		Arguments[] o = (Arguments[]) yyVals[-2+yyTop];
		if (o [1] != null) {
			Report.Error (1016, ((Argument) yyVals[0+yyTop]).Expr.Location, "Named attribute arguments must appear after the positional arguments");
			o [0] = new Arguments (4);
		}
		
		Arguments args = ((Arguments) o [0]);
		if (args.Count > 0 && !(yyVals[0+yyTop] is NamedArgument) && args [args.Count - 1] is NamedArgument)
			Error_NamedArgumentExpected ((NamedArgument) args [args.Count - 1]);
		
		args.Add ((Argument) yyVals[0+yyTop]);
		lbag.AppendTo (args, GetLocation (yyVals[-1+yyTop]));
	  }

void case_71()
#line 797 "cs-parser.jay"
{
		Arguments[] o = (Arguments[]) yyVals[-2+yyTop];
		if (o [1] == null) {
			o [1] = new Arguments (4);
		}

		((Arguments) o [1]).Add ((Argument) yyVals[0+yyTop]);
		lbag.AppendTo (o[1], GetLocation (yyVals[-1+yyTop]));
	  }

void case_75()
#line 822 "cs-parser.jay"
{
	  	--lexer.parsing_block;
	  	var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		yyVal = new NamedArgument (lt.Value, lt.Location, (Expression) yyVals[0+yyTop]);	  
	  }

void case_76()
#line 831 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.V_3)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "named argument");
			
		/* Avoid boxing in common case (no modifier)*/
		var arg_mod = yyVals[-1+yyTop] == null ? Argument.AType.None : (Argument.AType) yyVals[-1+yyTop];
			
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		yyVal = new NamedArgument (lt.Value, lt.Location, (Expression) yyVals[0+yyTop], arg_mod);
	  }

void case_94()
#line 878 "cs-parser.jay"
{
		Report.Error (1519, lexer.Location, "Unexpected symbol `{0}' in class, struct, or interface member declaration",
			GetSymbolName (yyToken));
		yyVal = null;
		lexer.parsing_generic_declaration = false;
	  }

void case_96()
#line 895 "cs-parser.jay"
{ 
		MemberName name = MakeName ((MemberName) yyVals[0+yyTop]);
		push_current_class (new Struct (current_namespace, current_class, name, (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]), yyVals[-3+yyTop]);
	  }

void case_97()
#line 901 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		current_class.SetParameterInfo ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support)
			current_container.DocComment = Lexer.consume_doc_comment ();

		lbag.AddMember (current_class, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]));
	  }

void case_98()
#line 912 "cs-parser.jay"
{
		--lexer.parsing_declaration;	  
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_99()
#line 918 "cs-parser.jay"
{
		lbag.AppendToMember (current_class, GetLocation (yyVals[0+yyTop]));
		yyVal = pop_current_class ();
	  }

void case_101()
#line 930 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_117()
#line 972 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var mod = (Modifiers) yyVals[-3+yyTop];
		current_field = new Const (current_class, (FullNamedExpression) yyVals[-1+yyTop], mod, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
		current_container.AddConstant ((Const) current_field);
		
		if ((mod & Modifiers.STATIC) != 0) {
			Report.Error (504, current_field.Location, "The constant `{0}' cannot be marked static", current_field.GetSignatureForError ());
		}
		
		yyVal = current_field;
	  }

void case_118()
#line 985 "cs-parser.jay"
{
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		current_field.Initializer = (ConstInitializer) yyVals[-2+yyTop];
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		current_field = null;
	  }

void case_123()
#line 1015 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (ConstInitializer) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_125()
#line 1028 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = new ConstInitializer (current_field, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_126()
#line 1034 "cs-parser.jay"
{
		Report.Error (145, lexer.Location, "A const field requires a value to be provided");
		yyVal = null;
	  }

void case_129()
#line 1049 "cs-parser.jay"
{
	  	lexer.parsing_generic_declaration = false;

		FullNamedExpression type = (FullNamedExpression) yyVals[-1+yyTop];
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			Report.Error (670, GetLocation (yyVals[-1+yyTop]), "Fields cannot have void type");
			
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		current_field = new Field (current_class, type, (Modifiers) yyVals[-2+yyTop], new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-3+yyTop]);
		current_container.AddField (current_field);
		yyVal = current_field;
	  }

void case_130()
#line 1064 "cs-parser.jay"
{ 
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
			
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[0+yyTop]));
		yyVal = current_field;
		current_field = null;
	  }

void case_131()
#line 1077 "cs-parser.jay"
{ 
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "fixed size buffers");

		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		current_field = new FixedField (current_class, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop],
			new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
			
		current_container.AddField (current_field);
	  }

void case_132()
#line 1088 "cs-parser.jay"
{
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
	    }

		current_field.Initializer = (ConstInitializer) yyVals[-2+yyTop];	    
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = current_field;
	    current_field = null;
	  }

void case_135()
#line 1111 "cs-parser.jay"
{
	  	++lexer.parsing_block;
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  	start_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_136()
#line 1117 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		current_field.Initializer = (Expression) yyVals[0+yyTop];
		lbag.AppendToMember (current_field, GetLocation (yyVals[-2+yyTop]));
		end_block (lexer.Location);
		current_local_parameters = null;
	  }

void case_141()
#line 1144 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), null);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_143()
#line 1154 "cs-parser.jay"
{
		--lexer.parsing_block;
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];	  
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (Expression) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_148()
#line 1180 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];	  
		yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (ConstInitializer) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_150()
#line 1193 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = new ConstInitializer (current_field, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_151()
#line 1199 "cs-parser.jay"
{
		Report.Error (443, lexer.Location, "Value or constant expected");
		yyVal = null;
	  }

void case_154()
#line 1209 "cs-parser.jay"
{
		/* It has to be here for the parent to safely restore artificial block*/
	  	Error_SyntaxError (yyToken);
	  	yyVal = null;
	  }

void case_155()
#line 1218 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.NotAllowed;

		/* Add it early in the case of body being eof for full aot*/
		current_container.AddMethod ((Method) yyVals[0+yyTop]);
	  }

void case_156()
#line 1226 "cs-parser.jay"
{
		Method method = (Method) yyVals[-2+yyTop];
		method.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (current_container.Kind == MemberKind.Interface && method.Block != null) {
			Report.Error (531, method.Location, "`{0}': interface members cannot have a definition", method.GetSignatureForError ());
		}

		current_local_parameters = null;

		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_159()
#line 1254 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;
		valid_param_mod = 0;
		MemberName name = (MemberName) yyVals[-6+yyTop];
		current_local_parameters = (ParametersCompiled) yyVals[-3+yyTop];

		GenericMethod generic = null;
		if (name.TypeArguments != null) {
			generic = new GenericMethod (current_namespace, current_class, name,
						     (FullNamedExpression) yyVals[-7+yyTop], current_local_parameters);

			generic.SetParameterInfo ((List<Constraints>) yyVals[0+yyTop]);
		} else if (yyVals[0+yyTop] != null) {
			Report.Error (80, GetLocation (yyVals[0+yyTop]),
				"Constraints are not allowed on non-generic declarations");
		}

		Method method = new Method (current_class, generic, (FullNamedExpression) yyVals[-7+yyTop], (Modifiers) yyVals[-8+yyTop],
				     name, current_local_parameters, (Attributes) yyVals[-9+yyTop]);
				     
		if (yyVals[0+yyTop] != null && ((method.ModFlags & Modifiers.OVERRIDE) != 0 || method.IsExplicitImpl)) {
			Report.Error (460, method.Location,
				"`{0}': Cannot specify constraints for overrides and explicit interface implementation methods",
				method.GetSignatureForError ());
		}

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		lbag.AddMember (method, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = method;
	  }

void case_162()
#line 1299 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;
		valid_param_mod = 0;

		MemberName name = (MemberName) yyVals[-6+yyTop];
		current_local_parameters = (ParametersCompiled) yyVals[-3+yyTop];

		if (yyVals[-1+yyTop] != null && name.TypeArguments == null)
			Report.Error (80, lexer.Location,
				      "Constraints are not allowed on non-generic declarations");

		Method method;
		GenericMethod generic = null;
		if (name.TypeArguments != null) {
			generic = new GenericMethod (current_namespace, current_class, name,
				new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-7+yyTop])),
				current_local_parameters);

			generic.SetParameterInfo ((List<Constraints>) yyVals[0+yyTop]);
		}

		var modifiers = (Modifiers) yyVals[-9+yyTop];


		const Modifiers invalid_partial_mod = Modifiers.AccessibilityMask | Modifiers.ABSTRACT | Modifiers.EXTERN |
			Modifiers.NEW | Modifiers.OVERRIDE | Modifiers.SEALED | Modifiers.VIRTUAL;

		if ((modifiers & invalid_partial_mod) != 0) {
			Report.Error (750, name.Location, "A partial method cannot define access modifier or " +
       			"any of abstract, extern, new, override, sealed, or virtual modifiers");
			modifiers &= ~invalid_partial_mod;
		}

		if ((current_class.ModFlags & Modifiers.PARTIAL) == 0) {
			Report.Error (751, name.Location, "A partial method must be declared within a " +
       			"partial class or partial struct");
		}
		
		modifiers |= Modifiers.PARTIAL | Modifiers.PRIVATE;
		
		method = new Method (current_class, generic, new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-7+yyTop])),
				     modifiers, name, current_local_parameters, (Attributes) yyVals[-10+yyTop]);

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		/* TODO: lbag, push void*/
		StoreModifierLocation (Modifiers.PARTIAL, GetLocation (yyVals[-8+yyTop]));
		lbag.AddMember (method, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = method;
	  }

void case_163()
#line 1354 "cs-parser.jay"
{
		MemberName name = (MemberName) yyVals[-3+yyTop];
		Report.Error (1585, name.Location, 
			"Member modifier `{0}' must precede the member type and name", ModifiersExtensions.Name ((Modifiers) yyVals[-4+yyTop]));

		Method method = new Method (current_class, null, (FullNamedExpression) yyVals[-5+yyTop],
					    0, name, (ParametersCompiled) yyVals[-1+yyTop], (Attributes) yyVals[-7+yyTop]);

		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		yyVal = method;
	  }

void case_168()
#line 1383 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[0+yyTop];
	  	yyVal = new ParametersCompiled (pars_list.ToArray ());
	  	lbag.AddLocation (yyVal, lbag.GetLocations (pars_list));
	  }

void case_169()
#line 1389 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[-2+yyTop];
		pars_list.Add ((Parameter) yyVals[0+yyTop]);

		yyVal = new ParametersCompiled (pars_list.ToArray ()); 
	  }

void case_170()
#line 1396 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[-2+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[0+yyTop])));
		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  }

void case_171()
#line 1402 "cs-parser.jay"
{
		if (yyVals[-2+yyTop] != null)
			Report.Error (231, ((Parameter) yyVals[-2+yyTop]).Location, "A params parameter must be the last parameter in a formal parameter list");

		yyVal = new ParametersCompiled (new Parameter[] { (Parameter) yyVals[-2+yyTop] } );			
	  }

void case_172()
#line 1409 "cs-parser.jay"
{
		if (yyVals[-2+yyTop] != null)
			Report.Error (231, ((Parameter) yyVals[-2+yyTop]).Location, "A params parameter must be the last parameter in a formal parameter list");

		var pars_list = (List<Parameter>) yyVals[-4+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[-2+yyTop])));

		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  }

void case_173()
#line 1419 "cs-parser.jay"
{
		Report.Error (257, GetLocation (yyVals[-2+yyTop]), "An __arglist parameter must be the last parameter in a formal parameter list");

		yyVal = new ParametersCompiled (new Parameter [] { new ArglistParameter (GetLocation (yyVals[-2+yyTop])) }, true);
	  }

void case_174()
#line 1425 "cs-parser.jay"
{
		Report.Error (257, GetLocation (yyVals[-2+yyTop]), "An __arglist parameter must be the last parameter in a formal parameter list");

		var pars_list = (List<Parameter>) yyVals[-4+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[-2+yyTop])));

		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  }

void case_177()
#line 1442 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = ParametersCompiled.EmptyReadOnlyParameters;
	  }

void case_178()
#line 1450 "cs-parser.jay"
{
		parameters_bucket.Clear ();
		Parameter p = (Parameter) yyVals[0+yyTop];
		parameters_bucket.Add (p);
		
		default_parameter_used = p.HasDefaultValue;
		yyVal = parameters_bucket;
	  }

void case_179()
#line 1459 "cs-parser.jay"
{
		var pars = (List<Parameter>) yyVals[-2+yyTop];
		Parameter p = (Parameter) yyVals[0+yyTop];
		if (p != null) {
			if (p.HasExtensionMethodModifier)
				Report.Error (1100, p.Location, "The parameter modifier `this' can only be used on the first parameter");
			else if (!p.HasDefaultValue && default_parameter_used)
				Report.Error (1737, p.Location, "Optional parameter cannot precede required parameters");

			default_parameter_used |= p.HasDefaultValue;
			pars.Add (p);
			
			lbag.AppendTo (pars, GetLocation (yyVals[-1+yyTop]));
		}
		
		yyVal = yyVals[-2+yyTop];
	  }

void case_180()
#line 1483 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Parameter.Modifier) yyVals[-2+yyTop], (Attributes) yyVals[-3+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_181()
#line 1492 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		Report.Error (1552, lt.Location, "Array type specifier, [], must appear before parameter name");
		yyVal = new Parameter ((FullNamedExpression) yyVals[-3+yyTop], lt.Value, (Parameter.Modifier) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_182()
#line 1502 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);	  
	  	Location l = GetLocation (yyVals[0+yyTop]);
		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], "NeedSomeGeneratorHere", (Parameter.Modifier) yyVals[-2+yyTop], (Attributes) yyVals[-3+yyTop], l);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_184()
#line 1517 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		if (lang_version <= LanguageVersion.V_3) {
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "optional parameter");
		}
		
		Parameter.Modifier mod = (Parameter.Modifier) yyVals[-5+yyTop];
		if (mod != Parameter.Modifier.NONE) {
			switch (mod) {
			case Parameter.Modifier.REF:
			case Parameter.Modifier.OUT:
				Report.Error (1741, GetLocation (yyVals[-5+yyTop]), "Cannot specify a default value for the `{0}' parameter",
					Parameter.GetModifierSignature (mod));
				break;
				
			case Parameter.Modifier.This:
				Report.Error (1743, GetLocation (yyVals[-5+yyTop]), "Cannot specify a default value for the `{0}' parameter",
					Parameter.GetModifierSignature (mod));
				break;
			default:
				throw new NotImplementedException (mod.ToString ());
			}
				
			mod = Parameter.Modifier.NONE;
		}
		
		if ((valid_param_mod & ParameterModifierType.DefaultValue) == 0)
			Report.Error (1065, GetLocation (yyVals[-2+yyTop]), "Optional parameter is not valid in this context");
		
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		yyVal = new Parameter ((FullNamedExpression) yyVals[-4+yyTop], lt.Value, mod, (Attributes) yyVals[-6+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation, GetLocation (yyVals[-2+yyTop])); /* parameterModifierLocation should be ignored when mod == NONE*/
		
		if (yyVals[0+yyTop] != null)
			((Parameter) yyVal).DefaultValue = new DefaultParameterValueExpression ((Expression) yyVals[0+yyTop]);
	  }

void case_187()
#line 1562 "cs-parser.jay"
{
		yyVal = yyVals[0+yyTop];
		parameterModifierLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_188()
#line 1567 "cs-parser.jay"
{
		Parameter.Modifier p2 = (Parameter.Modifier)yyVals[0+yyTop];
  		Parameter.Modifier mod = (Parameter.Modifier)yyVals[-1+yyTop] | p2;
  		if (((Parameter.Modifier)yyVals[-1+yyTop] & p2) == p2) {
  			Error_DuplicateParameterModifier (lexer.Location, p2);
  		} else {
	  		switch (mod & ~Parameter.Modifier.This) {
  				case Parameter.Modifier.REF:
					Report.Error (1101, lexer.Location, "The parameter modifiers `this' and `ref' cannot be used altogether");
  					break;
   				case Parameter.Modifier.OUT:
					Report.Error (1102, lexer.Location, "The parameter modifiers `this' and `out' cannot be used altogether");
  					break;
  				default:
 					Report.Error (1108, lexer.Location, "A parameter cannot have specified more than one modifier");
 					break;
 			}
  		}
  		yyVal = mod;
	  }

void case_189()
#line 1591 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Ref) == 0)
	  		Error_ParameterModifierNotValid ("ref", GetLocation (yyVals[0+yyTop]));
	  		
	  	yyVal = Parameter.Modifier.REF;
	  }

void case_190()
#line 1598 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Out) == 0)
	  		Error_ParameterModifierNotValid ("out", GetLocation (yyVals[0+yyTop]));
	  
	  	yyVal = Parameter.Modifier.OUT;
	  }

void case_191()
#line 1605 "cs-parser.jay"
{
		if ((valid_param_mod & ParameterModifierType.This) == 0)
	  		Error_ParameterModifierNotValid ("this", GetLocation (yyVals[0+yyTop]));

	  	if (lang_version <= LanguageVersion.ISO_2)
	  		FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "extension methods");
	  			
		yyVal = Parameter.Modifier.This;
	  }

void case_192()
#line 1618 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new ParamsParameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Attributes) yyVals[-3+yyTop], lt.Location);
	  }

void case_193()
#line 1623 "cs-parser.jay"
{
		Report.Error (1751, GetLocation (yyVals[-4+yyTop]), "Cannot specify a default value for a parameter array");
		
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new ParamsParameter ((FullNamedExpression) yyVals[-3+yyTop], lt.Value, (Attributes) yyVals[-5+yyTop], lt.Location);		
	  }

void case_194()
#line 1630 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_195()
#line 1638 "cs-parser.jay"
{
		if ((valid_param_mod & ParameterModifierType.Params) == 0)
			Report.Error (1670, (GetLocation (yyVals[0+yyTop])), "The `params' modifier is not allowed in current context");
	  }

void case_196()
#line 1643 "cs-parser.jay"
{
		Parameter.Modifier mod = (Parameter.Modifier)yyVals[0+yyTop];
		if ((mod & Parameter.Modifier.This) != 0) {
			Report.Error (1104, GetLocation (yyVals[-1+yyTop]), "The parameter modifiers `this' and `params' cannot be used altogether");
		} else {
			Report.Error (1611, GetLocation (yyVals[-1+yyTop]), "The params parameter cannot be declared as ref or out");
		}	  
	  }

void case_198()
#line 1659 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Arglist) == 0)
	  		Report.Error (1669, GetLocation (yyVals[0+yyTop]), "__arglist is not valid in this context");
	  }

void case_199()
#line 1670 "cs-parser.jay"
{
		if (doc_support)
			tmpComment = Lexer.consume_doc_comment ();
	  }

void case_200()
#line 1675 "cs-parser.jay"
{
		var type = (FullNamedExpression) yyVals[-3+yyTop];
		current_property = new Property (current_class, type, (Modifiers) yyVals[-4+yyTop],
			(MemberName) yyVals[-2+yyTop], (Attributes) yyVals[-5+yyTop]);
			
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			Report.Error (547, GetLocation (yyVals[-3+yyTop]), "`{0}': property or indexer cannot have void type", current_property.GetSignatureForError ());					
			
		current_container.AddProperty ((Property)current_property);
		lbag.AddMember (current_property, GetModifierLocations (), GetLocation (yyVals[0+yyTop]));
		
		lexer.PropertyParsing = true;
	  }

void case_201()
#line 1689 "cs-parser.jay"
{
		lexer.PropertyParsing = false;
		
		if (doc_support)
			current_property.DocComment = ConsumeStoredComment ();				
	  }

void case_202()
#line 1696 "cs-parser.jay"
{
		lbag.AppendToMember (current_property, GetLocation (yyVals[0+yyTop]));
		current_property = null;
	  }

void case_204()
#line 1710 "cs-parser.jay"
{
		valid_param_mod = 0;
		var type = (FullNamedExpression) yyVals[-6+yyTop];
		Indexer indexer = new Indexer (current_class, type,
			(MemberName)yyVals[-5+yyTop], (Modifiers) yyVals[-7+yyTop], (ParametersCompiled) yyVals[-2+yyTop], (Attributes) yyVals[-8+yyTop]);
			
		current_property = indexer;

  		current_container.AddIndexer (indexer);
		lbag.AddMember (current_property, GetModifierLocations (), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
  		
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			Report.Error (620, GetLocation (yyVals[-6+yyTop]), "`{0}': indexer return type cannot be `void'", indexer.GetSignatureForError ());  		

		if (indexer.Parameters.IsEmpty) {
			Report.Error (1551, GetLocation (yyVals[-4+yyTop]), "Indexers must have at least one parameter");
		}

		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}

		lexer.PropertyParsing = true;
	  }

void case_206()
#line 1740 "cs-parser.jay"
{ 
		if (doc_support)
			current_property.DocComment = ConsumeStoredComment ();
			
		lbag.AppendToMember (current_property, GetLocation (yyVals[-1+yyTop]));
		current_property = null;		
	  }

void case_211()
#line 1756 "cs-parser.jay"
{
	  	if (yyToken == Token.CLOSE_BRACE) {
	  		Report.Error (548, lexer.Location, "`{0}': property or indexer must have at least one accessor", current_property.GetSignatureForError ());
		} else {
			if (yyToken == Token.SEMICOLON)
				Report.Error (1597, lexer.Location, "Semicolon after method or accessor block is not valid");
			else
				Report.Error (1014, GetLocation (yyVals[0+yyTop]), "A get or set accessor expected");
		}
	  }

void case_212()
#line 1770 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != ModifierNone && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "access modifiers on properties");
		}
	  
		if (current_property.Get != null) {
			Report.Error (1007, GetLocation (yyVals[0+yyTop]), "Property accessor already defined");
		}
		
		if (current_property is Indexer) {
			current_property.Get = new Indexer.GetIndexerMethod (current_property, (Modifiers) yyVals[-1+yyTop], ((Indexer)current_property).ParameterInfo.Clone (),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		} else {
			current_property.Get = new Property.GetMethod (current_property,
				(Modifiers) yyVals[-1+yyTop], (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		}	
	  
		current_local_parameters = current_property.Get.ParameterInfo;	  
		lbag.AddMember (current_property.Get, GetModifierLocations ());
		lexer.PropertyParsing = false;
	  }

void case_213()
#line 1792 "cs-parser.jay"
{
	  	if (yyVals[0+yyTop] != null) {
	  		current_property.Get.Block = (ToplevelBlock) yyVals[0+yyTop];			
	  	
			if (current_container.Kind == MemberKind.Interface) {
				Report.Error (531, current_property.Get.Block.StartLocation,
					"`{0}': interface members cannot have a definition", current_property.Get.GetSignatureForError ());
			}		
		}
	  
		current_local_parameters = null;
		lexer.PropertyParsing = true;

		if (doc_support)
			if (Lexer.doc_state == XmlCommentState.Error)
				Lexer.doc_state = XmlCommentState.NotAllowed;
	  }

void case_214()
#line 1813 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != ModifierNone && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "access modifiers on properties");
		}
		
		if (current_property.Set != null) {
			Report.Error (1007, GetLocation (yyVals[0+yyTop]), "Property accessor already defined");
		}
	  
		if (current_property is Indexer) {
			current_property.Set = new Indexer.SetIndexerMethod (current_property, (Modifiers) yyVals[-1+yyTop],
				ParametersCompiled.MergeGenerated (compiler,
				((Indexer)current_property).ParameterInfo, true, new Parameter (
					current_property.TypeExpression, "value", Parameter.Modifier.NONE, null, GetLocation (yyVals[0+yyTop])),
					null),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		} else {
			current_property.Set = new Property.SetMethod (current_property, (Modifiers) yyVals[-1+yyTop], 
				ParametersCompiled.CreateImplicitParameter (current_property.TypeExpression, GetLocation (yyVals[0+yyTop])),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		}
		
		current_local_parameters = current_property.Set.ParameterInfo;	
		lbag.AddMember (current_property.Set, GetModifierLocations ());
		lexer.PropertyParsing = false;
	  }

void case_215()
#line 1840 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {		
			current_property.Set.Block = (ToplevelBlock) yyVals[0+yyTop];
		
			if (current_container.Kind == MemberKind.Interface) {
				Report.Error (531, current_property.Set.Block.StartLocation,
					"`{0}': interface members cannot have a definition", current_property.Set.GetSignatureForError ());
			}
		}
		
		current_local_parameters = null;
		lexer.PropertyParsing = true;

		if (doc_support
			&& Lexer.doc_state == XmlCommentState.Error)
			Lexer.doc_state = XmlCommentState.NotAllowed;
	  }

void case_217()
#line 1862 "cs-parser.jay"
{
		lbag.AppendToMember (lbag.LastMember, GetLocation (yyVals[0+yyTop]));
	  	yyVal = null;
	  }

void case_218()
#line 1867 "cs-parser.jay"
{
	  	Error_SyntaxError (1043, yyToken, "Invalid accessor body");
	  	yyVal = null;
	  }

void case_220()
#line 1882 "cs-parser.jay"
{
		MemberName name = MakeName ((MemberName) yyVals[0+yyTop]);
		push_current_class (new Interface (current_namespace, current_class, name, (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]), yyVals[-3+yyTop]);
		lbag.AddMember (current_class, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]));		
	  }

void case_221()
#line 1889 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		current_class.SetParameterInfo ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support) {
			current_container.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
	  }

void case_222()
#line 1900 "cs-parser.jay"
{
		--lexer.parsing_declaration;	  
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_223()
#line 1906 "cs-parser.jay"
{
	    lbag.AppendToMember (current_class, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = pop_current_class ();
	  }

void case_239()
#line 1958 "cs-parser.jay"
{
		OperatorDeclaration decl = (OperatorDeclaration) yyVals[-2+yyTop];
		if (decl != null) {
			Operator op = new Operator (
				current_class, decl.optype, decl.ret_type, (Modifiers) yyVals[-3+yyTop], 
				current_local_parameters,
				(ToplevelBlock) yyVals[0+yyTop], (Attributes) yyVals[-4+yyTop], decl.location);

			if (doc_support) {
				op.DocComment = tmpComment;
				Lexer.doc_state = XmlCommentState.Allowed;
			}

			/* Note again, checking is done in semantic analysis*/
			current_container.AddOperator (op);

			lbag.AddMember (op, GetModifierLocations (), lbag.GetLocations (decl));
		}
		
		current_local_parameters = null;
	  }

void case_243()
#line 1989 "cs-parser.jay"
{
		Report.Error (590, GetLocation (yyVals[0+yyTop]), "User-defined operators cannot return void");
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_245()
#line 2001 "cs-parser.jay"
{
		valid_param_mod = 0;

		Location loc = GetLocation (yyVals[-5+yyTop]);
		Operator.OpType op = (Operator.OpType) yyVals[-4+yyTop];
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];
		
		int p_count = current_local_parameters.Count;
		if (p_count == 1) {
			if (op == Operator.OpType.Addition)
				op = Operator.OpType.UnaryPlus;
			else if (op == Operator.OpType.Subtraction)
				op = Operator.OpType.UnaryNegation;
		}
		
		if (IsUnaryOperator (op)) {
			if (p_count == 2) {
				Report.Error (1020, loc, "Overloadable binary operator expected");
			} else if (p_count != 1) {
				Report.Error (1535, loc, "Overloaded unary operator `{0}' takes one parameter",
					Operator.GetName (op));
			}
		} else {
			if (p_count > 2) {
				Report.Error (1534, loc, "Overloaded binary operator `{0}' takes two parameters",
					Operator.GetName (op));
			} else if (p_count != 2) {
				Report.Error (1019, loc, "Overloadable unary operator expected");
			}
		}
		
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (op, (FullNamedExpression) yyVals[-6+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_270()
#line 2077 "cs-parser.jay"
{
		valid_param_mod = 0;

		Location loc = GetLocation (yyVals[-5+yyTop]);
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];  
		  
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (Operator.OpType.Implicit, (FullNamedExpression) yyVals[-4+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_272()
#line 2096 "cs-parser.jay"
{
		valid_param_mod = 0;
		
		Location loc = GetLocation (yyVals[-5+yyTop]);
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];  
		  
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (Operator.OpType.Explicit, (FullNamedExpression) yyVals[-4+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_273()
#line 2111 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
		yyVal = new OperatorDeclaration (Operator.OpType.Implicit, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_274()
#line 2117 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  	yyVal = new OperatorDeclaration (Operator.OpType.Explicit, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_275()
#line 2127 "cs-parser.jay"
{ 
		Constructor c = (Constructor) yyVals[-1+yyTop];
		c.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (doc_support)
			c.DocComment = ConsumeStoredComment ();

		current_container.AddConstructor (c);

		current_local_parameters = null;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_276()
#line 2146 "cs-parser.jay"
{
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		valid_param_mod = ParameterModifierType.All;
	  }

void case_277()
#line 2155 "cs-parser.jay"
{
		valid_param_mod = 0;
		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];  
		
		/**/
		/* start block here, so possible anonymous methods inside*/
		/* constructor initializer can get correct parent block*/
		/**/
	  	start_block (lexer.Location);
	  }

void case_278()
#line 2166 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-6+yyTop];
		var mods = (Modifiers) yyVals[-7+yyTop];
		ConstructorInitializer ci = (ConstructorInitializer) yyVals[0+yyTop];

		Constructor c = new Constructor (current_class, lt.Value, mods,
			(Attributes) yyVals[-8+yyTop], current_local_parameters, ci, lt.Location);
		
		if (lt.Value != current_container.MemberName.Name) {
			Report.Error (1520, c.Location, "Class, struct, or interface method must have a return type");
		} else if ((mods & Modifiers.STATIC) != 0) {
			if ((mods & Modifiers.AccessibilityMask) != 0){
				Report.Error (515, c.Location,
					"`{0}': static constructor cannot have an access modifier",
					c.GetSignatureForError ());
			}
			if (ci != null) {
				Report.Error (514, c.Location,
					"`{0}': static constructor cannot have an explicit `this' or `base' constructor call",
					c.GetSignatureForError ());
			
			}
		}
		
		lbag.AddMember (c, GetModifierLocations (), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = c;
	  }

void case_284()
#line 2211 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		yyVal = new ConstructorBaseInitializer ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_286()
#line 2221 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		yyVal = new ConstructorThisInitializer ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_287()
#line 2227 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_288()
#line 2235 "cs-parser.jay"
{
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}
		
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  }

void case_289()
#line 2244 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		if (lt.Value != current_container.MemberName.Name){
			Report.Error (574, lt.Location, "Name of destructor must match name of class");
		} else if (current_container.Kind != MemberKind.Class){
			Report.Error (575, lt.Location, "Only class types can contain destructor");
		}
		
		Destructor d = new Destructor (current_class, (Modifiers) yyVals[-6+yyTop],
			ParametersCompiled.EmptyReadOnlyParameters, (Attributes) yyVals[-7+yyTop], lt.Location);
		if (doc_support)
			d.DocComment = ConsumeStoredComment ();
		  
		d.Block = (ToplevelBlock) yyVals[0+yyTop];
		current_container.AddMethod (d);
		lbag.AddMember (d, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[-1+yyTop]));

		current_local_parameters = null;
	  }

void case_290()
#line 2269 "cs-parser.jay"
{
		current_event_field = new EventField (current_class, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop], (MemberName) yyVals[0+yyTop], (Attributes) yyVals[-4+yyTop]);
		current_container.AddEvent (current_event_field);
		
		if (current_event_field.MemberName.Left != null) {
			Report.Error (71, current_event_field.Location, "`{0}': An explicit interface implementation of an event must use property syntax",
			current_event_field.GetSignatureForError ());
		}
		
		yyVal = current_event_field;
	  }

void case_291()
#line 2283 "cs-parser.jay"
{
		if (doc_support) {
			current_event_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lbag.AddMember (current_event_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		current_event_field = null;
	  }

void case_292()
#line 2296 "cs-parser.jay"
{
		current_event = new EventProperty (current_class, (FullNamedExpression) yyVals[-2+yyTop], (Modifiers) yyVals[-4+yyTop], (MemberName) yyVals[-1+yyTop], (Attributes) yyVals[-5+yyTop]);
		current_container.AddEvent (current_event);
		lbag.AddMember (current_event, GetModifierLocations (), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		
		lexer.EventParsing = true;
	  }

void case_293()
#line 2304 "cs-parser.jay"
{
		if (current_container.Kind == MemberKind.Interface)
			Report.Error (69, GetLocation (yyVals[-2+yyTop]), "Event in interface cannot have add or remove accessors");
	  
		lexer.EventParsing = false;
	  }

void case_294()
#line 2311 "cs-parser.jay"
{
		if (doc_support) {
			current_event.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lbag.AppendToMember (current_event, GetLocation (yyVals[-1+yyTop]));
	  	current_event = null;	
		current_local_parameters = null;
	  }

void case_297()
#line 2330 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		current_event_field.Initializer = (Expression) yyVals[0+yyTop];
	  }

void case_302()
#line 2354 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), null);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_304()
#line 2364 "cs-parser.jay"
{
		--lexer.parsing_block;
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];	  
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (Expression) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_305()
#line 2373 "cs-parser.jay"
{
		if (current_container.Kind == MemberKind.Interface) {
			Report.Error (68, lexer.Location, "`{0}': event in interface cannot have an initializer",
				current_event_field.GetSignatureForError ());
		}
		
	  	if ((current_event_field.ModFlags & Modifiers.ABSTRACT) != 0) {
			Report.Error (74, lexer.Location, "`{0}': abstract event cannot have an initializer",
				current_event_field.GetSignatureForError ());
	  	}		
	  }

void case_309()
#line 2394 "cs-parser.jay"
{
		Report.Error (65, lexer.Location, "`{0}': event property must have both add and remove accessors",
			current_event.GetSignatureForError ());
	  }

void case_310()
#line 2399 "cs-parser.jay"
{
		Report.Error (65, lexer.Location, "`{0}': event property must have both add and remove accessors",
			current_event.GetSignatureForError ());
	  }

void case_311()
#line 2404 "cs-parser.jay"
{ 
		Report.Error (1055, GetLocation (yyVals[0+yyTop]), "An add or remove accessor expected");
		yyVal = null;
	  }

void case_312()
#line 2412 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] != ModifierNone) {
			Report.Error (1609, GetLocation (yyVals[-1+yyTop]), "Modifiers cannot be placed on event accessor declarations");
	  	}
	  	
	  	current_event.Add = new EventProperty.AddDelegateMethod (current_event, (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		current_local_parameters = current_event.Add.ParameterInfo;
		
		lbag.AddMember (current_event.Add, GetModifierLocations ());
		lexer.EventParsing = false;		
	  }

void case_313()
#line 2424 "cs-parser.jay"
{
		lexer.EventParsing = true;
	  
	  	current_event.Add.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (current_container.Kind == MemberKind.Interface) {
			Report.Error (531, current_event.Add.Block.StartLocation,
				"`{0}': interface members cannot have a definition", current_event.Add.GetSignatureForError ());
		}
		
		current_local_parameters = null;
	  }

void case_314()
#line 2440 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] != ModifierNone) {
			Report.Error (1609, GetLocation (yyVals[-1+yyTop]), "Modifiers cannot be placed on event accessor declarations");
	  	}
	  	
	  	current_event.Remove = new EventProperty.RemoveDelegateMethod (current_event, (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		current_local_parameters = current_event.Remove.ParameterInfo;

		lbag.AddMember (current_event.Remove, GetModifierLocations ());
		lexer.EventParsing = false;		
	  }

void case_315()
#line 2452 "cs-parser.jay"
{
		lexer.EventParsing = true;
	  
	  	current_event.Remove.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (current_container.Kind == MemberKind.Interface) {
			Report.Error (531, current_event.Remove.Block.StartLocation,
				"`{0}': interface members cannot have a definition", current_event.Remove.GetSignatureForError ());
		}
		
		current_local_parameters = null;
	  }

void case_316()
#line 2468 "cs-parser.jay"
{
		Report.Error (73, lexer.Location, "An add or remove accessor must have a body");
		yyVal = null;
	  }

void case_318()
#line 2480 "cs-parser.jay"
{
		if (doc_support)
			enumTypeComment = Lexer.consume_doc_comment ();
	  }

void case_319()
#line 2485 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;

		MemberName name = (MemberName) yyVals[-3+yyTop];
		if (name.IsGeneric) {
			Report.Error (1675, name.Location, "Enums cannot have type parameters");
		}
		
		push_current_class (new Enum (current_namespace, current_class, (TypeExpression) yyVals[-2+yyTop], (Modifiers) yyVals[-5+yyTop], MakeName (name), (Attributes) yyVals[-6+yyTop]), null);
	  }

void case_320()
#line 2497 "cs-parser.jay"
{
	  	/* here will be evaluated after CLOSE_BLACE is consumed.*/
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_321()
#line 2503 "cs-parser.jay"
{
		if (doc_support)
			current_class.DocComment = enumTypeComment;
			
		--lexer.parsing_declaration;

/*			if (doc_support)*/
/*				em.DocComment = ev.DocComment;*/

		lbag.AddMember (current_class, GetModifierLocations (), GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-1+yyTop]));
		yyVal = pop_current_class ();
	  }

void case_323()
#line 2520 "cs-parser.jay"
{
	 	var te = yyVals[0+yyTop] as TypeExpression;
		if (te == null || !EnumSpec.IsValidUnderlyingType (te.Type)) {
			Enum.Error_1008 (GetLocation (yyVals[0+yyTop]), Report);
			yyVal = null;
		} else {
			yyVal = yyVals[0+yyTop];
		}
	 }

void case_324()
#line 2530 "cs-parser.jay"
{
	 	Error_TypeExpected (GetLocation (yyVals[-1+yyTop]));
		yyVal = null;
	 }

void case_329()
#line 2548 "cs-parser.jay"
{
	  	lbag.AddLocation (yyVals[-2+yyTop], GetLocation (yyVals[-1+yyTop]));
	  	yyVal = yyVals[0+yyTop];
	  }

void case_330()
#line 2556 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
	  	var em = new EnumMember ((Enum) current_class, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-1+yyTop]);
	  	((Enum) current_class).AddEnumMember (em);

		if (doc_support) {
			em.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}

		yyVal = em;
	  }

void case_331()
#line 2569 "cs-parser.jay"
{
	  	++lexer.parsing_block;
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}
	  }

void case_332()
#line 2577 "cs-parser.jay"
{ 
		--lexer.parsing_block;
		
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
	  	var em = new EnumMember ((Enum) current_class, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
	  	em.Initializer = new ConstInitializer (em, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  	((Enum) current_class).AddEnumMember (em);
		
		if (doc_support)
			em.DocComment = ConsumeStoredComment ();

		yyVal = em;
	  }

void case_334()
#line 2602 "cs-parser.jay"
{
		valid_param_mod = 0;

		MemberName name = MakeName ((MemberName) yyVals[-4+yyTop]);
		ParametersCompiled p = (ParametersCompiled) yyVals[-1+yyTop];

		Delegate del = new Delegate (current_namespace, current_class, (FullNamedExpression) yyVals[-5+yyTop],
					     (Modifiers) yyVals[-7+yyTop], name, p, (Attributes) yyVals[-8+yyTop]);

		ubag.PushTypeDeclaration (del);
		ubag.PopTypeDeclaration ();
		current_container.AddDelegate (del);
		current_delegate = del;
		lexer.ConstraintsParsing = true;
	  }

void case_336()
#line 2622 "cs-parser.jay"
{
		if (doc_support) {
			current_delegate.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
	  
		current_delegate.SetParameterInfo ((List<Constraints>) yyVals[-2+yyTop]);
		lbag.AddMember (current_delegate, GetModifierLocations (), GetLocation (yyVals[-10+yyTop]), GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[0+yyTop]));

		yyVal = current_delegate;

		current_delegate = null;
	  }

void case_338()
#line 2640 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "nullable types");
	  
	  	yyVal = ComposedTypeSpecifier.CreateNullable (GetLocation (yyVals[0+yyTop]));
	  }

void case_340()
#line 2651 "cs-parser.jay"
{
		var lt1 = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var lt2 = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		
		yyVal = new MemberName (lt1.Value, lt2.Value, (TypeArguments) yyVals[0+yyTop], lt1.Location);
	  }

void case_342()
#line 2662 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));		
	  }

void case_343()
#line 2671 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberName (lt.Value, (TypeArguments)yyVals[0+yyTop], lt.Location);	  
	  }

void case_345()
#line 2683 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "generics");	  
	  
		yyVal = yyVals[-1+yyTop];
	  }

void case_346()
#line 2690 "cs-parser.jay"
{
		Error_TypeExpected (lexer.Location);
		yyVal = new TypeArguments ();
	  }

void case_347()
#line 2698 "cs-parser.jay"
{
		TypeArguments type_args = new TypeArguments ();
		type_args.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = type_args;
	  }

void case_348()
#line 2704 "cs-parser.jay"
{
		TypeArguments type_args = (TypeArguments) yyVals[-2+yyTop];
		type_args.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = type_args;
	  }

void case_350()
#line 2720 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new MemberName (lt.Value, (TypeArguments)yyVals[0+yyTop], lt.Location);
	  }

void case_351()
#line 2729 "cs-parser.jay"
{
	  	MemberName mn = (MemberName)yyVals[0+yyTop];
	  	if (mn.TypeArguments != null)
	  		syntax_error (mn.Location, string.Format ("Member `{0}' cannot declare type arguments",
	  			mn.GetSignatureForError ()));
	  }

void case_353()
#line 2740 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;	  
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-2+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
	  }

void case_354()
#line 2749 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;	  
		yyVal = new MemberName (TypeContainer.DefaultIndexerName, GetLocation (yyVals[0+yyTop]));
	  }

void case_355()
#line 2754 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
		yyVal = new MemberName ((MemberName) yyVals[-1+yyTop], TypeContainer.DefaultIndexerName, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_356()
#line 2762 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new MemberName (lt.Value, (TypeArguments) yyVals[-1+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_357()
#line 2768 "cs-parser.jay"
{
		var lt1 = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var lt2 = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		
		yyVal = new MemberName (lt1.Value, lt2.Value, (TypeArguments) yyVals[-1+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_358()
#line 2776 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[-1+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_360()
#line 2786 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "generics");
	  
		yyVal = yyVals[-1+yyTop];
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_361()
#line 2797 "cs-parser.jay"
{
		TypeArguments type_args = new TypeArguments ();
		type_args.Add ((FullNamedExpression)yyVals[0+yyTop]);
		yyVal = type_args;
	  }

void case_362()
#line 2803 "cs-parser.jay"
{
		TypeArguments type_args = (TypeArguments) yyVals[-2+yyTop];
		type_args.Add ((FullNamedExpression)yyVals[0+yyTop]);
		yyVal = type_args;
		lbag.AddLocation (yyVals[0+yyTop], GetLocation (yyVals[0+yyTop]));
	  }

void case_363()
#line 2813 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken)yyVals[0+yyTop];
		yyVal = new TypeParameterName (lt.Value, (Attributes)yyVals[-2+yyTop], (Variance) yyVals[-1+yyTop], lt.Location);
  	  }

void case_364()
#line 2818 "cs-parser.jay"
{
  	  	if (GetTokenName (yyToken) == "type")
			Report.Error (81, GetLocation (yyVals[0+yyTop]), "Type parameter declaration must be an identifier not a type");
		else
			Error_SyntaxError (yyToken);
			
  	  	yyVal = new TypeParameterName ("", null, lexer.Location);
  	  }

void case_369()
#line 2852 "cs-parser.jay"
{
	  	Expression.Error_VoidInvalidInTheContext (GetLocation (yyVals[0+yyTop]), Report);
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_371()
#line 2861 "cs-parser.jay"
{
	  	Expression.Error_VoidInvalidInTheContext (GetLocation (yyVals[0+yyTop]), Report);
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_373()
#line 2870 "cs-parser.jay"
{
	  	Report.Error (1536, GetLocation (yyVals[0+yyTop]), "Invalid parameter type `void'");
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_376()
#line 2886 "cs-parser.jay"
{
		MemberName name = (MemberName) yyVals[-1+yyTop];

		if (yyVals[0+yyTop] != null) {
			yyVal = new ComposedCast (name.GetTypeExpression (), (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			if (name.Left == null && name.Name == "var")
				yyVal = new VarExpr (name.Location);
			else
				yyVal = name.GetTypeExpression ();
		}
	  }

void case_378()
#line 2903 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null)
			yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_381()
#line 2919 "cs-parser.jay"
{
		var types = new List<FullNamedExpression> (2);
		types.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = types;
	  }

void case_382()
#line 2925 "cs-parser.jay"
{
		var types = (List<FullNamedExpression>) yyVals[-2+yyTop];
		types.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = types;
	  }

void case_383()
#line 2934 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is ComposedCast) {
			Report.Error (1521, GetLocation (yyVals[0+yyTop]), "Invalid base type `{0}'", ((ComposedCast)yyVals[0+yyTop]).GetSignatureForError ());
		}
		yyVal = yyVals[0+yyTop];
	  }

void case_384()
#line 2941 "cs-parser.jay"
{
	  	Error_TypeExpected (lexer.Location);
		yyVal = null;
	  }

void case_421()
#line 3003 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new SimpleName (lt.Value, (TypeArguments)yyVals[0+yyTop], lt.Location);	  
	  }

void case_422()
#line 3007 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
	       yyVal = new CompletionSimpleName (MemberName.MakeName (lt.Value, null), lt.Location);
	  }

void case_433()
#line 3048 "cs-parser.jay"
{
		yyVal = new ParenthesizedExpression ((Expression) yyVals[-1+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_435()
#line 3060 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_436()
#line 3066 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_437()
#line 3072 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (new BaseThis (GetLocation (yyVals[-3+yyTop])), lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_438()
#line 3078 "cs-parser.jay"
{
		var lt1 = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var lt2 = (Tokenizer.LocatedToken) yyVals[-1+yyTop];

		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (TypeArguments) yyVals[0+yyTop], lt1.Location);
	  }

void case_440()
#line 3087 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, lt.Location);
	  }

void case_442()
#line 3095 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, lt.Location);
 	  }

void case_443()
#line 3103 "cs-parser.jay"
{
		yyVal = new Invocation ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_446()
#line 3116 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] == null) {
	  		yyVal = CollectionOrObjectInitializers.Empty;
	  		/* TODO: lbag*/
	  	} else {
	  		yyVal = new CollectionOrObjectInitializers ((List<Expression>) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  	}
	  }

void case_447()
#line 3126 "cs-parser.jay"
{
	  	yyVal = new CollectionOrObjectInitializers ((List<Expression>) yyVals[-2+yyTop], GetLocation (yyVals[-3+yyTop]));
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_450()
#line 3142 "cs-parser.jay"
{
	  	var a = new List<Expression> ();
	  	a.Add ((Expression) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_451()
#line 3148 "cs-parser.jay"
{
	  	var a = (List<Expression>)yyVals[-2+yyTop];
	  	a.Add ((Expression) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_452()
#line 3153 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		yyVal = yyVals[-1+yyTop];
	  }

void case_453()
#line 3161 "cs-parser.jay"
{
	  	var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
	  	yyVal = new ElementInitializer (lt.Value, (Expression)yyVals[0+yyTop], lt.Location);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_455()
#line 3170 "cs-parser.jay"
{
		CompletionSimpleName csn = yyVals[-1+yyTop] as CompletionSimpleName;
		if (csn == null)
			yyVal = new CollectionElementInitializer ((Expression)yyVals[-1+yyTop]);
		else
			yyVal = new CompletionElementInitializer (csn.Prefix, csn.Location);
	  }

void case_456()
#line 3178 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] == null)
			yyVal = null;
		else
	  		yyVal = new CollectionElementInitializer ((List<Expression>)yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_457()
#line 3185 "cs-parser.jay"
{
	  	Report.Error (1920, GetLocation (yyVals[-1+yyTop]), "An element initializer cannot be empty");
		yyVal = null;
	  }

void case_462()
#line 3203 "cs-parser.jay"
{ 
		Arguments list = new Arguments (4);
		list.Add ((Argument) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_463()
#line 3209 "cs-parser.jay"
{
		Arguments list = (Arguments) yyVals[-2+yyTop];
		if (list [list.Count - 1] is NamedArgument)
			Error_NamedArgumentExpected ((NamedArgument) list [list.Count - 1]);
		
		list.Add ((Argument) yyVals[0+yyTop]);
		lbag.AppendTo (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_464()
#line 3219 "cs-parser.jay"
{
		Arguments list = (Arguments) yyVals[-2+yyTop];
		NamedArgument a = (NamedArgument) yyVals[0+yyTop];
		for (int i = 0; i < list.Count; ++i) {
			NamedArgument na = list [i] as NamedArgument;
			if (na != null && na.Name == a.Name)
				Report.Error (1740, na.Location, "Named argument `{0}' specified multiple times",
					na.Name);
		}
		
		list.Add (a);
		lbag.AppendTo (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_465()
#line 3234 "cs-parser.jay"
{
	  	Report.Error (839, GetLocation (yyVals[0+yyTop]), "An argument is missing");
	  	yyVal = yyVals[-1+yyTop];
	  }

void case_466()
#line 3239 "cs-parser.jay"
{
	  	Report.Error (839, GetLocation (yyVals[-1+yyTop]), "An argument is missing");
	  	yyVal = null;
	  }

void case_471()
#line 3260 "cs-parser.jay"
{ 
		yyVal = new Argument ((Expression) yyVals[0+yyTop], Argument.AType.Ref);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_472()
#line 3265 "cs-parser.jay"
{ 
		yyVal = new Argument ((Expression) yyVals[0+yyTop], Argument.AType.Out);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_473()
#line 3270 "cs-parser.jay"
{
		yyVal = new Argument (new Arglist ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop])));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_474()
#line 3275 "cs-parser.jay"
{
		yyVal = new Argument (new Arglist (GetLocation (yyVals[-2+yyTop])));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_476()
#line 3287 "cs-parser.jay"
{
		yyVal = new ElementAccess ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_477()
#line 3295 "cs-parser.jay"
{
		var list = new List<Expression> (4);
		list.Add ((Expression) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_478()
#line 3301 "cs-parser.jay"
{
		var list = (List<Expression>) yyVals[-2+yyTop];
		list.Add ((Expression) yyVals[0+yyTop]);
		lbag.AppendTo (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_479()
#line 3307 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		yyVal = yyVals[-1+yyTop];
	  }

void case_480()
#line 3315 "cs-parser.jay"
{
		Arguments args = new Arguments (4);
		args.Add ((Argument) yyVals[0+yyTop]);
		yyVal = args;
	  }

void case_481()
#line 3321 "cs-parser.jay"
{
		Arguments args = (Arguments) yyVals[-2+yyTop];
		if (args [args.Count - 1] is NamedArgument && !(yyVals[0+yyTop] is NamedArgument))
			Error_NamedArgumentExpected ((NamedArgument) args [args.Count - 1]);
	  
		args.Add ((Argument) yyVals[0+yyTop]);
		lbag.AppendTo (args, GetLocation (yyVals[-1+yyTop]));
		yyVal = args;	  
	  }

void case_485()
#line 3349 "cs-parser.jay"
{
	  	yyVal = new ElementAccess (new BaseThis (GetLocation (yyVals[-3+yyTop])), (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_486()
#line 3354 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		yyVal = new ElementAccess (null, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_489()
#line 3376 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			if (lang_version <= LanguageVersion.ISO_2)
				FeatureIsNotAvailable (GetLocation (yyVals[-5+yyTop]), "object initializers");
				
			yyVal = new NewInitialize ((FullNamedExpression) yyVals[-4+yyTop], (Arguments) yyVals[-2+yyTop], (CollectionOrObjectInitializers) yyVals[0+yyTop], GetLocation (yyVals[-5+yyTop]));
		} else {
			yyVal = new New ((FullNamedExpression) yyVals[-4+yyTop], (Arguments) yyVals[-2+yyTop], GetLocation (yyVals[-5+yyTop]));
		}
		
		lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_490()
#line 3389 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "collection initializers");
	  
		yyVal = new NewInitialize ((FullNamedExpression) yyVals[-1+yyTop], null, (CollectionOrObjectInitializers) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_491()
#line 3401 "cs-parser.jay"
{
		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-5+yyTop], (List<Expression>) yyVals[-3+yyTop],
				new ComposedTypeSpecifier (((List<Expression>) yyVals[-3+yyTop]).Count, GetLocation (yyVals[-4+yyTop])) {
	  				Next = (ComposedTypeSpecifier) yyVals[-1+yyTop]
			  	}, (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-6+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_492()
#line 3409 "cs-parser.jay"
{
	  	if (yyVals[0+yyTop] == null)
	  		Report.Error (1586, GetLocation (yyVals[-3+yyTop]), "Array creation must have array size or array initializer");

		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-2+yyTop], (ComposedTypeSpecifier) yyVals[-1+yyTop], (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
	  }

void case_493()
#line 3416 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "implicitly typed arrays");
	  
		yyVal = new ImplicitlyTypedArrayCreation ((ComposedTypeSpecifier) yyVals[-1+yyTop], (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_494()
#line 3423 "cs-parser.jay"
{
		Report.Error (178, GetLocation (yyVals[-1+yyTop]), "Invalid rank specifier, expecting `,' or `]'");
		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-5+yyTop], null, GetLocation (yyVals[-6+yyTop]));
	  }

void case_495()
#line 3428 "cs-parser.jay"
{
		Error_SyntaxError (1526, yyToken, "Unexpected symbol");
		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_497()
#line 3439 "cs-parser.jay"
{
		--lexer.parsing_type;
		yyVal = yyVals[0+yyTop];
	  }

void case_498()
#line 3447 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
	  		FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "anonymous types");

		yyVal = new NewAnonymousType ((List<AnonymousTypeParameter>) yyVals[-1+yyTop], current_container, GetLocation (yyVals[-3+yyTop]));
		
		/* TODO: lbag comma location*/
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_503()
#line 3470 "cs-parser.jay"
{
	  	var a = new List<AnonymousTypeParameter> (4);
	  	a.Add ((AnonymousTypeParameter) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_504()
#line 3476 "cs-parser.jay"
{
	  	var a = (List<AnonymousTypeParameter>) yyVals[-2+yyTop];
	  	a.Add ((AnonymousTypeParameter) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_505()
#line 3485 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken)yyVals[-2+yyTop];
	  	yyVal = new AnonymousTypeParameter ((Expression)yyVals[0+yyTop], lt.Value, lt.Location);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_506()
#line 3491 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken)yyVals[0+yyTop];
	  	yyVal = new AnonymousTypeParameter (new SimpleName (lt.Value, lt.Location),
	  		lt.Value, lt.Location);
	  }

void case_507()
#line 3497 "cs-parser.jay"
{
	  	MemberAccess ma = (MemberAccess) yyVals[0+yyTop];
	  	yyVal = new AnonymousTypeParameter (ma, ma.Name, ma.Location);
	  }

void case_508()
#line 3502 "cs-parser.jay"
{
		Report.Error (746, lexer.Location,
			"Invalid anonymous type member declarator. Anonymous type members must be a member assignment, simple name or member access expression");
		yyVal = null;
	  }

void case_512()
#line 3517 "cs-parser.jay"
{
	  	((ComposedTypeSpecifier) yyVals[-1+yyTop]).Next = (ComposedTypeSpecifier) yyVals[0+yyTop];
	  	yyVal = yyVals[-1+yyTop];
	  }

void case_513()
#line 3525 "cs-parser.jay"
{
		yyVal = ComposedTypeSpecifier.CreateArrayDimension (1, GetLocation (yyVals[-1+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_514()
#line 3530 "cs-parser.jay"
{
		yyVal = ComposedTypeSpecifier.CreateArrayDimension ((int)yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_519()
#line 3560 "cs-parser.jay"
{
		var ai = new ArrayInitializer (0, GetLocation (yyVals[-1+yyTop]));
		ai.VariableDeclaration = current_variable;
		lbag.AddLocation (ai, GetLocation (yyVals[0+yyTop]));
		yyVal = ai;
	  }

void case_520()
#line 3567 "cs-parser.jay"
{
		var ai = new ArrayInitializer ((List<Expression>) yyVals[-2+yyTop], GetLocation (yyVals[-3+yyTop]));
		ai.VariableDeclaration = current_variable;
		if (yyVals[-1+yyTop] != null) {
			lbag.AddLocation (ai, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddLocation (ai, GetLocation (yyVals[0+yyTop]));
		}
		yyVal = ai;
	  }

void case_521()
#line 3581 "cs-parser.jay"
{
		var list = new List<Expression> (4);
		list.Add ((Expression) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_522()
#line 3587 "cs-parser.jay"
{
		var list = (List<Expression>) yyVals[-2+yyTop];
		list.Add ((Expression) yyVals[0+yyTop]);
		lbag.AppendTo (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_524()
#line 3601 "cs-parser.jay"
{
	  	lexer.TypeOfParsing = false;
		yyVal = new TypeOf ((FullNamedExpression) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_527()
#line 3612 "cs-parser.jay"
{
	 	Error_TypeExpected (lexer.Location);
	 	yyVal = null;
	 }

void case_528()
#line 3620 "cs-parser.jay"
{  
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];

		yyVal = new SimpleName (lt.Value, (int) yyVals[0+yyTop], lt.Location);
	  }

void case_529()
#line 3626 "cs-parser.jay"
{
		var lt1 = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var lt2 = (Tokenizer.LocatedToken) yyVals[-1+yyTop];

		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (int) yyVals[0+yyTop], lt1.Location);
	  }

void case_530()
#line 3633 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		
		yyVal = new MemberAccess ((Expression) yyVals[-2+yyTop], lt.Value, lt.Location);		
	  }

void case_531()
#line 3639 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (int) yyVals[0+yyTop], lt.Location);		
	  }

void case_532()
#line 3645 "cs-parser.jay"
{
		var te = ((MemberName) yyVals[-3+yyTop]).GetTypeExpression ();
		if (te.HasTypeArguments)
			Error_TypeExpected (GetLocation (yyVals[0+yyTop]));

		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (te, lt.Value, (int) yyVals[0+yyTop], lt.Location);		
	  }

void case_533()
#line 3657 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "generics");

		yyVal = yyVals[0+yyTop];
	  }

void case_534()
#line 3667 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		if (lang_version == LanguageVersion.ISO_1)
			FeatureIsNotAvailable (lt.Location, "namespace alias qualifier");

		yyVal = lt;		
	  }

void case_535()
#line 3678 "cs-parser.jay"
{ 
		yyVal = new SizeOf ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_536()
#line 3686 "cs-parser.jay"
{
		yyVal = new CheckedExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_537()
#line 3694 "cs-parser.jay"
{
		yyVal = new UnCheckedExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_538()
#line 3702 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new MemberAccess (new Indirection ((Expression) yyVals[-2+yyTop], GetLocation (yyVals[-1+yyTop])), lt.Value, lt.Location);
	  }

void case_544()
#line 3733 "cs-parser.jay"
{
		valid_param_mod = 0;
	  	yyVal = yyVals[-1+yyTop];
	  }

void case_545()
#line 3741 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "default value expression");

		yyVal = new DefaultValueExpression ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_550()
#line 3765 "cs-parser.jay"
{
		yyVal = new Cast ((FullNamedExpression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_559()
#line 3806 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Multiply, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_560()
#line 3811 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Division, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_561()
#line 3816 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Modulus, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_563()
#line 3825 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Addition, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_565()
#line 3834 "cs-parser.jay"
{
	  	/* Shift/Reduce conflict*/
		yyVal = new Binary (Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
  	  }

void case_569()
#line 3851 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LeftShift, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_570()
#line 3856 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.RightShift, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_572()
#line 3865 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LessThan, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_573()
#line 3870 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.GreaterThan, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_574()
#line 3875 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LessThanOrEqual, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_575()
#line 3880 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.GreaterThanOrEqual, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_577()
#line 3889 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Equality, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_578()
#line 3894 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Inequality, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_580()
#line 3903 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.BitwiseAnd, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_582()
#line 3912 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.ExclusiveOr, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_584()
#line 3921 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.BitwiseOr, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_586()
#line 3930 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LogicalAnd, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_588()
#line 3939 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LogicalOr, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_590()
#line 3948 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "null coalescing operator");
			
		yyVal = new Nullable.NullCoalescingOperator ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_592()
#line 3959 "cs-parser.jay"
{
		yyVal = new Conditional (new BooleanExpression ((Expression) yyVals[-4+yyTop]), (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_594()
#line 3971 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.Multiply, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_595()
#line 3976 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.Division, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_596()
#line 3981 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.Modulus, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_597()
#line 3986 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.Addition, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_598()
#line 3991 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_599()
#line 3996 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.LeftShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_600()
#line 4001 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.RightShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_601()
#line 4006 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.BitwiseAnd, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_602()
#line 4011 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.BitwiseOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_603()
#line 4016 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.ExclusiveOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_604()
#line 4024 "cs-parser.jay"
{
		var pars = new List<Parameter> (4);
		pars.Add ((Parameter) yyVals[0+yyTop]);

		yyVal = pars;
	  }

void case_605()
#line 4031 "cs-parser.jay"
{
		var pars = (List<Parameter>) yyVals[-2+yyTop];
		Parameter p = (Parameter)yyVals[0+yyTop];
		if (pars[0].GetType () != p.GetType ()) {
			Report.Error (748, p.Location, "All lambda parameters must be typed either explicitly or implicitly");
		}
		
		pars.Add (p);
		yyVal = pars;
	  }

void case_606()
#line 4045 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];

		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Parameter.Modifier) yyVals[-2+yyTop], null, lt.Location);
	  }

void case_607()
#line 4051 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];

		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, Parameter.Modifier.NONE, null, lt.Location);
	  }

void case_608()
#line 4057 "cs-parser.jay"
{
	  	var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new ImplicitLambdaParameter (lt.Value, lt.Location);
	  }

void case_610()
#line 4065 "cs-parser.jay"
{ 
		var pars_list = (List<Parameter>) yyVals[0+yyTop];
		yyVal = new ParametersCompiled (pars_list.ToArray ());
	  }

void case_614()
#line 4081 "cs-parser.jay"
{
		Block b = end_block (lexer.Location);
		b.IsCompilerGenerated = true;
		b.AddStatement (new ContextualReturn ((Expression) yyVals[0+yyTop]));
		yyVal = b;
	  }

void case_616()
#line 4092 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);	
		yyVal = EmptyExpression.Null;
	  }

void case_617()
#line 4100 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		Parameter p = new ImplicitLambdaParameter (lt.Value, lt.Location);
		start_anonymous (true, new ParametersCompiled (p), GetLocation (yyVals[-1+yyTop]));
	  }

void case_618()
#line 4106 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_619()
#line 4111 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "lambda expressions");
	  
	  	valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }

void case_620()
#line 4118 "cs-parser.jay"
{
	  	valid_param_mod = 0;
		start_anonymous (true, (ParametersCompiled) yyVals[-2+yyTop], GetLocation (yyVals[-4+yyTop]));
	  }

void case_621()
#line 4123 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_628()
#line 4146 "cs-parser.jay"
{
		yyVal = new RefValueExpr ((Expression) yyVals[-3+yyTop], (FullNamedExpression) yyVals[-1+yyTop], GetLocation (yyVals[-5+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_629()
#line 4151 "cs-parser.jay"
{
		yyVal = new RefTypeExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_630()
#line 4156 "cs-parser.jay"
{
		yyVal = new MakeRefExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));	  
	  }

void case_634()
#line 4185 "cs-parser.jay"
{
		MemberName name = MakeName ((MemberName) yyVals[0+yyTop]);
		Class c = new Class (current_namespace, current_class, name, (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]);
		if (((c.ModFlags & Modifiers.STATIC) != 0) && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (c.Location, "static classes");
		}
			
		push_current_class (c, yyVals[-3+yyTop]);
	  }

void case_635()
#line 4196 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		current_class.SetParameterInfo ((List<Constraints>) yyVals[0+yyTop]);
		lbag.AddMember (current_class, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]));

		if (doc_support) {
			current_container.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
	  }

void case_636()
#line 4208 "cs-parser.jay"
{
		--lexer.parsing_declaration;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_637()
#line 4214 "cs-parser.jay"
{
		lbag.AppendToMember (current_class, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = pop_current_class ();
	  }

void case_640()
#line 4229 "cs-parser.jay"
{
	    mod_locations = null;
		yyVal = ModifierNone;
	  }

void case_643()
#line 4239 "cs-parser.jay"
{ 
		var m1 = (Modifiers) yyVals[-1+yyTop];
		var m2 = (Modifiers) yyVals[0+yyTop];

		if ((m1 & m2) != 0) {
			Report.Error (1004, lexer.Location - ModifiersExtensions.Name (m2).Length,
				"Duplicate `{0}' modifier", ModifiersExtensions.Name (m2));
		} else if ((m2 & Modifiers.AccessibilityMask) != 0 && (m1 & Modifiers.AccessibilityMask) != 0 &&
			((m2 | m1 & Modifiers.AccessibilityMask) != (Modifiers.PROTECTED | Modifiers.INTERNAL))) {
			Report.Error (107, lexer.Location - ModifiersExtensions.Name (m2).Length,
				"More than one protection modifier specified");
		}
		
		yyVal = m1 | m2;
	  }

void case_644()
#line 4258 "cs-parser.jay"
{
		yyVal = Modifiers.NEW;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
		
		if (current_container == module)
			Report.Error (1530, GetLocation (yyVals[0+yyTop]), "Keyword `new' is not allowed on namespace elements");
	  }

void case_645()
#line 4266 "cs-parser.jay"
{
		yyVal = Modifiers.PUBLIC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_646()
#line 4271 "cs-parser.jay"
{
		yyVal = Modifiers.PROTECTED;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_647()
#line 4276 "cs-parser.jay"
{
		yyVal = Modifiers.INTERNAL;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_648()
#line 4281 "cs-parser.jay"
{
		yyVal = Modifiers.PRIVATE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_649()
#line 4286 "cs-parser.jay"
{
		yyVal = Modifiers.ABSTRACT;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_650()
#line 4291 "cs-parser.jay"
{
		yyVal = Modifiers.SEALED;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_651()
#line 4296 "cs-parser.jay"
{
		yyVal = Modifiers.STATIC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_652()
#line 4301 "cs-parser.jay"
{
		yyVal = Modifiers.READONLY;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_653()
#line 4306 "cs-parser.jay"
{
		yyVal = Modifiers.VIRTUAL;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_654()
#line 4311 "cs-parser.jay"
{
		yyVal = Modifiers.OVERRIDE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_655()
#line 4316 "cs-parser.jay"
{
		yyVal = Modifiers.EXTERN;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_656()
#line 4321 "cs-parser.jay"
{
		yyVal = Modifiers.VOLATILE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_657()
#line 4326 "cs-parser.jay"
{
		yyVal = Modifiers.UNSAFE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
		if (!settings.Unsafe)
			Error_UnsafeCodeNotAllowed (GetLocation (yyVals[0+yyTop]));
	  }

void case_658()
#line 4333 "cs-parser.jay"
{
		yyVal = Modifiers.ASYNC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_663()
#line 4354 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	 }

void case_664()
#line 4362 "cs-parser.jay"
{
		var constraints = new List<Constraints> (1);
		constraints.Add ((Constraints) yyVals[0+yyTop]);
		yyVal = constraints;
	  }

void case_665()
#line 4368 "cs-parser.jay"
{
		var constraints = (List<Constraints>) yyVals[-1+yyTop];
		Constraints new_constraint = (Constraints)yyVals[0+yyTop];

		foreach (Constraints c in constraints) {
			if (new_constraint.TypeParameter.Value == c.TypeParameter.Value) {
				Report.Error (409, new_constraint.Location,
					"A constraint clause has already been specified for type parameter `{0}'",
					new_constraint.TypeParameter.Value);
			}
		}

		constraints.Add (new_constraint);
		yyVal = constraints;
	  }

void case_666()
#line 4387 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new Constraints (new SimpleMemberName (lt.Value, lt.Location), (List<FullNamedExpression>) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
	  }

void case_667()
#line 4395 "cs-parser.jay"
{
		var constraints = new List<FullNamedExpression> (1);
		constraints.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = constraints;
	  }

void case_668()
#line 4401 "cs-parser.jay"
{
		var constraints = (List<FullNamedExpression>) yyVals[-2+yyTop];
		var prev = constraints [constraints.Count - 1] as SpecialContraintExpr;
		if (prev != null && (prev.Constraint & SpecialConstraint.Constructor) != 0) {			
			Report.Error (401, GetLocation (yyVals[-1+yyTop]), "The `new()' constraint must be the last constraint specified");
		}
		
		prev = yyVals[0+yyTop] as SpecialContraintExpr;
		if (prev != null) {
			if ((prev.Constraint & (SpecialConstraint.Class | SpecialConstraint.Struct)) != 0) {
				Report.Error (449, prev.Location, "The `class' or `struct' constraint must be the first constraint specified");			
			} else {
			 	prev = constraints [0] as SpecialContraintExpr;
			 	if (prev != null && (prev.Constraint & SpecialConstraint.Struct) != 0) {			
					Report.Error (451, GetLocation (yyVals[0+yyTop]), "The `new()' constraint cannot be used with the `struct' constraint");
				}
			}
		}

		constraints.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = constraints;
	  }

void case_669()
#line 4427 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is ComposedCast)
			Report.Error (706, GetLocation (yyVals[0+yyTop]), "Invalid constraint type `{0}'", ((ComposedCast)yyVals[0+yyTop]).GetSignatureForError ());
	  
	  	yyVal = yyVals[0+yyTop];
	  }

void case_670()
#line 4434 "cs-parser.jay"
{
		yyVal = new SpecialContraintExpr (SpecialConstraint.Constructor, GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_674()
#line 4454 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.V_3)
			FeatureIsNotAvailable (lexer.Location, "generic type variance");

		yyVal = yyVals[0+yyTop];
	  }

void case_677()
#line 4488 "cs-parser.jay"
{
		++lexer.parsing_block;
		start_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_679()
#line 4500 "cs-parser.jay"
{
	 	--lexer.parsing_block;
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_680()
#line 4505 "cs-parser.jay"
{
	 	--lexer.parsing_block;
		yyVal = end_block (lexer.Location);
	  }

void case_681()
#line 4514 "cs-parser.jay"
{
		++lexer.parsing_block;
		current_block.StartLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_682()
#line 4519 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_690()
#line 4546 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_723()
#line 4610 "cs-parser.jay"
{
		  Report.Error (1023, GetLocation (yyVals[0+yyTop]), "An embedded statement may not be a declaration or labeled statement");
		  yyVal = null;
	  }

void case_724()
#line 4615 "cs-parser.jay"
{
		  Report.Error (1023, GetLocation (yyVals[0+yyTop]), "An embedded statement may not be a declaration or labeled statement");
		  yyVal = null;
	  }

void case_725()
#line 4620 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_726()
#line 4628 "cs-parser.jay"
{
		/* Uses lexer.Location because semicolon location is not kept in quick mode*/
		yyVal = new EmptyStatement (lexer.Location);
	  }

void case_727()
#line 4636 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		LabeledStatement labeled = new LabeledStatement (lt.Value, current_block, lt.Location);

		current_block.AddLabel (labeled);
		current_block.AddStatement (labeled);
	  }

void case_730()
#line 4649 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] is VarExpr)
			yyVals[-1+yyTop] = new SimpleName ("var", ((VarExpr) yyVals[-1+yyTop]).Location);
	  
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_731()
#line 4665 "cs-parser.jay"
{ 
		/* Ok, the above "primary_expression" is there to get rid of*/
		/* both reduce/reduce and shift/reduces in the grammar, it should*/
		/* really just be "type_name".  If you use type_name, a reduce/reduce*/
		/* creeps up.  If you use namespace_or_type_name (which is all we need*/
		/* really) two shift/reduces appear.*/
		/* */

		/* So the super-trick is that primary_expression*/
		/* can only be either a SimpleName or a MemberAccess. */
		/* The MemberAccess case arises when you have a fully qualified type-name like :*/
		/* Foo.Bar.Blah i;*/
		/* SimpleName is when you have*/
		/* Blah i;*/
		
		Expression expr = (Expression) yyVals[-1+yyTop];
		if (yyVals[0+yyTop] == null) {
			SimpleName sn = expr as SimpleName;
			if (sn != null && sn.Name == "var")
				yyVal = new VarExpr (sn.Location);
			else
				yyVal = yyVals[-1+yyTop];
		} else if (expr is ATypeNameExpression) {
			yyVal = new ComposedCast ((ATypeNameExpression)expr, (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			Error_ExpectingTypeName (expr);
			yyVal = null;
		}
	  }

void case_732()
#line 4695 "cs-parser.jay"
{
		ATypeNameExpression expr = yyVals[-1+yyTop] as ATypeNameExpression;

		if (expr != null) {
			yyVal = new ComposedCast (expr, (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			Error_ExpectingTypeName ((Expression)yyVals[-1+yyTop]);
			yyVal = expr;
		}
	  }

void case_733()
#line 4706 "cs-parser.jay"
{
		if (yyVals[0+yyTop] == null)
			yyVal = yyVals[-1+yyTop];
		else
			yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_736()
#line 4721 "cs-parser.jay"
{
		Expression.Error_VoidInvalidInTheContext (GetLocation (yyVals[0+yyTop]), Report);
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_738()
#line 4730 "cs-parser.jay"
{
	  	((ComposedTypeSpecifier) yyVals[-1+yyTop]).Next = (ComposedTypeSpecifier) yyVals[0+yyTop];
	  	yyVal = yyVals[-1+yyTop];
	  }

void case_740()
#line 4745 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockVariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_741()
#line 4752 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
		lbag.AppendTo (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_742()
#line 4758 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.Constant, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockConstantDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_743()
#line 4765 "cs-parser.jay"
{
		if (current_variable.Initializer != null) {
			lbag.AddLocation (current_variable, GetLocation (yyVals[-6+yyTop]), savedLocation, GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddLocation (current_variable, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = current_variable;;
		current_variable = null;
	  }

void case_745()
#line 4779 "cs-parser.jay"
{
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
		lbag.AppendTo (current_variable, GetLocation (yyVals[-1+yyTop]));
	  }

void case_746()
#line 4784 "cs-parser.jay"
{
	  	if (yyToken == Token.OPEN_BRACKET_EXPR) {
			Report.Error (650, lexer.Location,
				"Syntax error, bad array declarator. To declare a managed array the rank specifier precedes the variable's identifier. To declare a fixed size buffer field, use the fixed keyword before the field type");
		} else {
			Error_SyntaxError (yyToken);
		}
	  }

void case_751()
#line 4806 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];	  
		var li = new LocalVariable (current_variable.Variable, lt.Value, lt.Location);
		var d = new BlockVariableDeclaration.Declarator (li, null);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-1+yyTop]));
	  }

void case_752()
#line 4815 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];	  
		var li = new LocalVariable (current_variable.Variable, lt.Value, lt.Location);
		var d = new BlockVariableDeclaration.Declarator (li, (Expression) yyVals[0+yyTop]);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_754()
#line 4831 "cs-parser.jay"
{
		savedLocation = GetLocation (yyVals[-1+yyTop]);
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
	  }

void case_759()
#line 4849 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];	  
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.Constant, lt.Location);
		var d = new BlockVariableDeclaration.Declarator (li, (Expression) yyVals[0+yyTop]);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_761()
#line 4862 "cs-parser.jay"
{
		yyVal = new StackAlloc ((Expression) yyVals[-3+yyTop], (Expression) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_762()
#line 4867 "cs-parser.jay"
{
		Report.Error (1575, GetLocation (yyVals[-1+yyTop]), "A stackalloc expression requires [] after type");
		yyVal = new StackAlloc ((Expression) yyVals[0+yyTop], null, GetLocation (yyVals[-1+yyTop]));		
	  }

void case_763()
#line 4875 "cs-parser.jay"
{
		yyVal = yyVals[-1+yyTop];
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_767()
#line 4893 "cs-parser.jay"
{
		ExpressionStatement s = yyVals[0+yyTop] as ExpressionStatement;
		if (s == null) {
			Expression.Error_InvalidExpressionStatement (Report, GetLocation (yyVals[0+yyTop]));
			s = EmptyExpressionStatement.Instance;
		}

		yyVal = new StatementExpression (s);
	  }

void case_768()
#line 4906 "cs-parser.jay"
{
		Expression expr = (Expression) yyVals[0+yyTop];
		ExpressionStatement s;

	        s = new OptionalAssign (new SimpleName ("$retval", lexer.Location), expr, lexer.Location);
		yyVal = new StatementExpression (s);
	  }

void case_769()
#line 4914 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_772()
#line 4928 "cs-parser.jay"
{ 
		if (yyVals[0+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
		
		yyVal = new If ((BooleanExpression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_773()
#line 4937 "cs-parser.jay"
{
		yyVal = new If ((BooleanExpression) yyVals[-4+yyTop], (Statement) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-6+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
		
		if (yyVals[-2+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[-2+yyTop]));
		if (yyVals[0+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_775()
#line 4954 "cs-parser.jay"
{
		yyVal = new Switch ((Expression) yyVals[-5+yyTop], (ExplicitBlock) current_block.Explicit, (List<SwitchSection>) yyVals[-1+yyTop], GetLocation (yyVals[-7+yyTop]));	
		end_block (GetLocation (yyVals[0+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_776()
#line 4963 "cs-parser.jay"
{
		Report.Warning (1522, 1, current_block.StartLocation, "Empty switch block"); 
		yyVal = new List<SwitchSection> ();
	  }

void case_778()
#line 4972 "cs-parser.jay"
{
		var sections = new List<SwitchSection> (4);

		sections.Add ((SwitchSection) yyVals[0+yyTop]);
		yyVal = sections;
	  }

void case_779()
#line 4979 "cs-parser.jay"
{
		var sections = (List<SwitchSection>) yyVals[-1+yyTop];

		sections.Add ((SwitchSection) yyVals[0+yyTop]);
		yyVal = sections;
	  }

void case_780()
#line 4986 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);	  
		yyVal = new List<SwitchSection> ();
	  }

void case_783()
#line 5005 "cs-parser.jay"
{
		var labels = new List<SwitchLabel> (2);

		labels.Add ((SwitchLabel) yyVals[0+yyTop]);
		yyVal = labels;
	  }

void case_784()
#line 5012 "cs-parser.jay"
{
		var labels = (List<SwitchLabel>) (yyVals[-1+yyTop]);
		labels.Add ((SwitchLabel) yyVals[0+yyTop]);

		yyVal = labels;
	  }

void case_785()
#line 5022 "cs-parser.jay"
{
	 	yyVal = new SwitchLabel ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	 	lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	 }

void case_791()
#line 5041 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		yyVal = new While ((BooleanExpression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_792()
#line 5053 "cs-parser.jay"
{
		yyVal = new Do ((Statement) yyVals[-5+yyTop], (BooleanExpression) yyVals[-2+yyTop], GetLocation (yyVals[-6+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_793()
#line 5061 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[0+yyTop]));
		current_block.IsCompilerGenerated = true;
	  }

void case_795()
#line 5077 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		For f = new For ((Statement) yyVals[-6+yyTop], (BooleanExpression) yyVals[-4+yyTop], (Statement) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-9+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, current_block.StartLocation, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));

		yyVal = end_block (GetLocation (yyVals[-5+yyTop]));
	  }

void case_796()
#line 5089 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = end_block (current_block.StartLocation);
	  }

void case_799()
#line 5102 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockVariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_800()
#line 5109 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
	  }

void case_808()
#line 5133 "cs-parser.jay"
{
	  	var sl = yyVals[-2+yyTop] as StatementList;
	  	if (sl == null) {
	  		sl = new StatementList ((Statement) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop]);
			lbag.AddStatement (sl, GetLocation (yyVals[-1+yyTop]));
	  	} else {
	  		sl.Add ((Statement) yyVals[0+yyTop]);
	  		lbag.AppendTo (sl, GetLocation (yyVals[-1+yyTop]));
	  	}
	  		
		yyVal = sl;
	  }

void case_809()
#line 5149 "cs-parser.jay"
{
		Report.Error (230, GetLocation (yyVals[-5+yyTop]), "Type and identifier are both required in a foreach statement");
		yyVal = null;
	  }

void case_810()
#line 5154 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[-5+yyTop]));
		current_block.IsCompilerGenerated = true;
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.ForeachVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		yyVal = li;
	  }

void case_811()
#line 5163 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Foreach f = new Foreach ((Expression) yyVals[-6+yyTop], (LocalVariable) yyVals[-1+yyTop], (Expression) yyVals[-3+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-8+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = end_block (GetLocation (yyVals[-2+yyTop]));
	  }

void case_818()
#line 5186 "cs-parser.jay"
{
		yyVal = new Break (GetLocation (yyVals[-1+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_819()
#line 5194 "cs-parser.jay"
{
		yyVal = new Continue (GetLocation (yyVals[-1+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_820()
#line 5202 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new Goto (lt.Value, GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_821()
#line 5208 "cs-parser.jay"
{
		yyVal = new GotoCase ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_822()
#line 5213 "cs-parser.jay"
{
		yyVal = new GotoDefault (GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_823()
#line 5221 "cs-parser.jay"
{
		yyVal = new Return ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_824()
#line 5229 "cs-parser.jay"
{
		yyVal = new Throw ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_825()
#line 5237 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		string s = lt.Value;
		if (s != "yield"){
			Report.Error (1003, lt.Location, "; expected");
		} else if (yyVals[-1+yyTop] == null) {
			Report.Error (1627, GetLocation (yyVals[0+yyTop]), "Expression expected after yield return");
		} else if (lang_version == LanguageVersion.ISO_1){
			FeatureIsNotAvailable (lt.Location, "iterators");
		}
		
		current_block.ParametersBlock.TopBlock.IsIterator = true;
		yyVal = new Yield ((Expression) yyVals[-1+yyTop], lt.Location);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_826()
#line 5253 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		string s = lt.Value;
		if (s != "yield"){
			Report.Error (1003, lt.Location, "; expected");
		} else if (lang_version == LanguageVersion.ISO_1){
			FeatureIsNotAvailable (lt.Location, "iterators");
		}
		
		current_block.ParametersBlock.TopBlock.IsIterator = true;
		yyVal = new YieldBreak (lt.Location);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_830()
#line 5279 "cs-parser.jay"
{
		yyVal = new TryFinally ((Statement) yyVals[-2+yyTop], (Block) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_831()
#line 5284 "cs-parser.jay"
{
		yyVal = new TryFinally (new TryCatch ((Block) yyVals[-3+yyTop], (List<Catch>) yyVals[-2+yyTop], GetLocation (yyVals[-4+yyTop]), true), (Block) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_832()
#line 5289 "cs-parser.jay"
{
		Report.Error (1524, GetLocation (yyVals[-2+yyTop]), "Expected catch or finally");
		yyVal = null;
	  }

void case_833()
#line 5297 "cs-parser.jay"
{
		var l = new List<Catch> (2);

		l.Add ((Catch) yyVals[0+yyTop]);
		yyVal = l;
	  }

void case_834()
#line 5304 "cs-parser.jay"
{
		var l = (List<Catch>) yyVals[-1+yyTop];
		
		Catch c = (Catch) yyVals[0+yyTop];
		if (l [0].IsGeneral) {
			Report.Error (1017, c.loc, "Try statement already has an empty catch block");
		} else {
			if (c.IsGeneral)
				l.Insert (0, c);
			else
				l.Add (c);
		}
		
		yyVal = l;
	  }

void case_838()
#line 5332 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[-3+yyTop]));
		var c = new Catch (current_block, GetLocation (yyVals[-4+yyTop]));
		c.TypeExpression = (FullNamedExpression) yyVals[-2+yyTop];

		if (yyVals[-1+yyTop] != null) {
			var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
			c.Variable = new LocalVariable (current_block, lt.Value, lt.Location);
			current_block.AddLocalName (c.Variable);
		}

		lbag.AddLocation (c, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = c;
	  }

void case_840()
#line 5351 "cs-parser.jay"
{
	  	if (yyToken == Token.CLOSE_PARENS) {
			Report.Error (1015, lexer.Location,
				"A type that derives from `System.Exception', `object', or `string' expected");
		} else {
			Error_SyntaxError (yyToken);
		}
		
		yyVal = new Catch (null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_843()
#line 5379 "cs-parser.jay"
{
		if (!settings.Unsafe)
			Error_UnsafeCodeNotAllowed (GetLocation (yyVals[0+yyTop]));
	  }

void case_845()
#line 5389 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		yyVal = new Lock ((Expression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_846()
#line 5400 "cs-parser.jay"
{
	    start_block (GetLocation (yyVals[-2+yyTop]));
	    
		current_block.IsCompilerGenerated = true;
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.FixedVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new Fixed.VariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_847()
#line 5410 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
	  }

void case_848()
#line 5415 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Fixed f = new Fixed ((Fixed.VariableDeclaration) yyVals[-1+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-9+yyTop]));
		current_block.AddStatement (f);
		lbag.AddStatement (f, GetLocation (yyVals[-8+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = end_block (GetLocation (yyVals[-2+yyTop]));
	  }

void case_849()
#line 5428 "cs-parser.jay"
{
	    start_block (GetLocation (yyVals[-2+yyTop]));
	    
		current_block.IsCompilerGenerated = true;
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.UsingVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new Using.VariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_850()
#line 5438 "cs-parser.jay"
{
		yyVal = current_variable;	  
		current_variable = null;
	  }

void case_851()
#line 5443 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Using u = new Using ((Using.VariableDeclaration) yyVals[-1+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-9+yyTop]));
		lbag.AddStatement (u, GetLocation (yyVals[-8+yyTop]), GetLocation (yyVals[-2+yyTop]));
		current_block.AddStatement (u);
		yyVal = end_block (GetLocation (yyVals[-2+yyTop]));
	  }

void case_852()
#line 5453 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Using u = new Using ((Expression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (u, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
		yyVal = u;
	  }

void case_854()
#line 5469 "cs-parser.jay"
{
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
		yyVal = current_variable;
	  }

void case_855()
#line 5480 "cs-parser.jay"
{
		lexer.query_parsing = false;
			
		Linq.AQueryClause from = yyVals[-1+yyTop] as Linq.AQueryClause;
			
		from.Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = from;
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_856()
#line 5492 "cs-parser.jay"
{
		Linq.AQueryClause from = yyVals[-1+yyTop] as Linq.AQueryClause;
			
		from.Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = from;
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_857()
#line 5503 "cs-parser.jay"
{
	        lexer.query_parsing = false;
		yyVal = yyVals[-1+yyTop];

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_858()
#line 5510 "cs-parser.jay"
{
	        yyVal = yyVals[-1+yyTop];
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_859()
#line 5519 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		yyVal = new Linq.QueryExpression (new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-3+yyTop])));
	  }

void case_860()
#line 5527 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		yyVal = new Linq.QueryExpression (
			new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-4+yyTop])) {
				IdentifierType = (FullNamedExpression)yyVals[-3+yyTop]
			}
		);
	  }

void case_861()
#line 5542 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		yyVal = new Linq.QueryExpression (new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-3+yyTop])));
	  }

void case_862()
#line 5550 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		yyVal = new Linq.QueryExpression (
			new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-4+yyTop])) {
				IdentifierType = (FullNamedExpression)yyVals[-3+yyTop]
			}
		);
	  }

void case_864()
#line 5569 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		yyVal = new Linq.SelectMany ((Linq.QueryBlock)current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);
	  }

void case_866()
#line 5584 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);

		yyVal = new Linq.SelectMany ((Linq.QueryBlock)current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-5+yyTop])) {
			IdentifierType = (FullNamedExpression)yyVals[-4+yyTop]
		};
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);
	  }

void case_867()
#line 5601 "cs-parser.jay"
{
	  	Linq.AQueryClause head = (Linq.AQueryClause)yyVals[-1+yyTop];
		
		if (yyVals[0+yyTop] != null)
			head.Next = (Linq.AQueryClause)yyVals[0+yyTop];
				
		if (yyVals[-2+yyTop] != null) {
			Linq.AQueryClause clause = (Linq.AQueryClause)yyVals[-2+yyTop];
			clause.Tail.Next = head;
			head = clause;
		}
		
		yyVal = head;
	  }

void case_869()
#line 5617 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_871()
#line 5629 "cs-parser.jay"
{
		yyVal = new Linq.Select ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_872()
#line 5636 "cs-parser.jay"
{
	  	if (linq_clause_blocks == null)
	  		linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  	linq_clause_blocks.Push ((Linq.QueryBlock)current_block);
	  }

void case_873()
#line 5644 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_874()
#line 5651 "cs-parser.jay"
{
		yyVal = new Linq.GroupBy ((Linq.QueryBlock)current_block, (Expression)yyVals[-3+yyTop], linq_clause_blocks.Pop (), (Expression)yyVals[0+yyTop], GetLocation (yyVals[-5+yyTop]));
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_878()
#line 5667 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-1+yyTop]).Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-1+yyTop];
	  }

void case_885()
#line 5687 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
	  	yyVal = new Linq.Let ((Linq.QueryBlock) current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
	  	
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);
	  }

void case_887()
#line 5705 "cs-parser.jay"
{
		yyVal = new Linq.Where ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_888()
#line 5715 "cs-parser.jay"
{
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_889()
#line 5723 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_890()
#line 5731 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_891()
#line 5739 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
	  
		var outer_selector = linq_clause_blocks.Pop ();
		var block = linq_clause_blocks.Pop ();

		var lt = (Tokenizer.LocatedToken) yyVals[-10+yyTop];	
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		Linq.RangeVariable into;
		
		if (yyVals[0+yyTop] == null) {
			into = sn;
	  		yyVal = new Linq.Join (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, GetLocation (yyVals[-11+yyTop]));
		} else {
			/**/
			/* Set equals right side parent to beginning of linq query, it is not accessible therefore cannot cause name collisions*/
			/**/
			var parent = block.Parent;
			while (parent is Linq.QueryBlock) {
				parent = parent.Parent;
			}
			current_block.Parent = parent;
			
			((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		
			lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
			into = new Linq.RangeVariable (lt.Value, lt.Location);

			yyVal = new Linq.GroupJoin (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, into, GetLocation (yyVals[-11+yyTop]));	
		}

		current_block = block.Parent;
		((Linq.QueryBlock)current_block).AddRangeVariable (into);
	  }

void case_892()
#line 5775 "cs-parser.jay"
{
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_893()
#line 5783 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_894()
#line 5791 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_895()
#line 5799 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
	  
		var outer_selector = linq_clause_blocks.Pop ();
		var block = linq_clause_blocks.Pop ();
		
		var lt = (Tokenizer.LocatedToken) yyVals[-10+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		Linq.RangeVariable into;
		
		if (yyVals[0+yyTop] == null) {
			into = sn;		
	  		yyVal = new Linq.Join (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, GetLocation (yyVals[-12+yyTop])) {
	  			IdentifierType = (FullNamedExpression)yyVals[-11+yyTop]
	  		};
		} else {
			/**/
			/* Set equals right side parent to beginning of linq query, it is not accessible therefore cannot cause name collisions*/
			/**/
			var parent = block.Parent;
			while (parent is Linq.QueryBlock) {
				parent = parent.Parent;
			}
			current_block.Parent = parent;
		
			((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		
			lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
			into = new Linq.RangeVariable (lt.Value, lt.Location); /* TODO:*/
			
			yyVal = new Linq.GroupJoin (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, into, GetLocation (yyVals[-12+yyTop])) {
	  			IdentifierType = (FullNamedExpression)yyVals[-11+yyTop]
	  		};			
		}
		
		current_block = block.Parent;
		((Linq.QueryBlock)current_block).AddRangeVariable (into);		
	  }

void case_899()
#line 5854 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		yyVal = yyVals[0+yyTop];
	  }

void case_901()
#line 5865 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_902()
#line 5872 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-3+yyTop]).Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-3+yyTop];
	  }

void case_904()
#line 5881 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock ((Linq.QueryBlock) current_block, lexer.Location);	 
	 }

void case_905()
#line 5888 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-3+yyTop]).Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-3+yyTop];
	 }

void case_913()
#line 5928 "cs-parser.jay"
{
		/* query continuation block is not linked with query block but with block*/
		/* before. This means each query can use same range variable names for*/
		/* different identifiers.*/

		current_block.SetEndLocation (GetLocation (yyVals[-1+yyTop]));
		current_block = current_block.Parent;
	
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);		
	  }

void case_914()
#line 5944 "cs-parser.jay"
{
		var current_block = linq_clause_blocks.Pop ();	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
  		yyVal = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, null, rv, GetLocation (yyVals[-3+yyTop])) {
  			next = (Linq.AQueryClause)yyVals[0+yyTop]
  		};
	  }

void case_917()
#line 5971 "cs-parser.jay"
{ 
		current_container = new Class (current_namespace, current_class, new MemberName ("<InteractiveExpressionClass>"), Modifiers.PUBLIC, null);
		current_class = current_container;

		/* (ref object retval)*/
		Parameter [] mpar = new Parameter [1];
		mpar [0] = new Parameter (new TypeExpression (compiler.BuiltinTypes.Object, Location.Null), "$retval", Parameter.Modifier.REF, null, Location.Null);

		ParametersCompiled pars = new ParametersCompiled (mpar);
		var mods = Modifiers.PUBLIC | Modifiers.STATIC;
		if (settings.Unsafe)
			mods |= Modifiers.UNSAFE;

		current_local_parameters = pars;
		Method method = new Method (
			current_class,
			null, /* generic*/
			new TypeExpression (compiler.BuiltinTypes.Void, Location.Null),
			mods,
			new MemberName ("Host"),
			pars,
			null /* attributes */);
			
		current_container.AddMethod (method);			

		oob_stack.Push (method);
		++lexer.parsing_block;
		start_block (lexer.Location);
	  }

void case_918()
#line 6001 "cs-parser.jay"
{
		--lexer.parsing_block;
		Method method = (Method) oob_stack.Pop ();

		method.Block = (ToplevelBlock) end_block(lexer.Location);

		InteractiveResult = (Class) pop_current_class ();
		current_local_parameters = null;
	  }

#line default
   static readonly short [] yyLhs  = {              -1,
    0,    4,    0,    1,    1,    1,    1,    2,    2,   10,
   10,   11,   11,   12,   12,   13,   13,   14,   14,   15,
   20,   21,   18,   19,   19,   19,   23,   23,   24,   24,
   17,    6,    6,    5,    5,   22,   22,    7,    7,   25,
   25,   26,   26,   26,   26,   26,    8,    8,    9,    9,
   34,   32,   37,   33,   33,   35,   35,   35,   35,   36,
   36,   41,   38,   39,   40,   40,   42,   42,   42,   42,
   42,   43,   43,   47,   44,   46,   48,   48,   48,   49,
   49,   50,   50,   51,   51,   51,   51,   51,   51,   51,
   51,   51,   51,   51,   64,   66,   69,   70,   28,   28,
   72,   68,   71,   71,   73,   73,   74,   74,   74,   74,
   74,   74,   74,   74,   74,   74,   77,   52,   78,   78,
   79,   79,   80,   82,   76,   76,   81,   81,   87,   53,
   91,   53,   53,   86,   94,   86,   88,   88,   95,   95,
   96,   97,   96,   92,   92,   98,   98,   99,  100,   90,
   90,   93,   93,   93,  103,   54,  106,  107,  101,  108,
  109,  101,  101,  102,  102,  105,  105,  112,  112,  112,
  112,  112,  112,  112,  112,  112,  112,  113,  113,  116,
  116,  116,  119,  116,  117,  117,  120,  120,  121,  121,
  121,  114,  114,  114,  122,  122,  122,  115,  124,  126,
  127,   55,  129,  130,  131,   57,  125,  125,  125,  125,
  125,  135,  132,  136,  133,  134,  134,  134,  137,  138,
  139,  141,   29,   29,  140,  140,  142,  142,  143,  143,
  143,  143,  143,  143,  143,  143,  143,  146,   58,  145,
  145,  147,  147,  150,  144,  144,  149,  149,  149,  149,
  149,  149,  149,  149,  149,  149,  149,  149,  149,  149,
  149,  149,  149,  149,  149,  149,  149,  149,  152,  151,
  153,  151,  151,  151,   59,  156,  158,  154,  155,  155,
  157,  157,  162,  160,  163,  160,  160,  164,   60,  166,
   56,  169,  170,   56,  165,  172,  165,  167,  167,  173,
  173,  174,  175,  174,  176,  171,  168,  168,  168,  168,
  168,  180,  177,  181,  178,  179,  179,  183,  185,  186,
   30,  182,  182,  182,  184,  184,  184,  187,  187,  188,
  189,  188,  190,  191,  192,   31,  193,  193,   16,   16,
  194,  194,  197,  196,  196,  196,  198,  198,  200,   63,
  123,  104,  104,  128,  128,  201,  201,  201,  199,  199,
  202,  202,  203,  203,  205,  205,   85,   75,   75,   89,
   89,  118,  118,  148,  148,  206,  206,  206,  206,  206,
  210,  210,  211,  211,  209,  209,  209,  209,  209,  209,
  209,  212,  212,  212,  212,  212,  212,  212,  212,  212,
  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,
  213,  213,  213,  213,  213,  213,  213,  213,  213,  213,
  214,  214,  214,  215,  215,  215,  235,  235,  236,  236,
  237,  237,  217,  217,  234,  234,  234,  234,  234,  234,
  234,  234,  219,  238,  238,  239,  239,  240,  240,  242,
  242,  242,  243,  243,  243,  243,  243,  244,  244,  161,
  161,  248,  248,  248,  248,  248,  250,  250,  249,  249,
  251,  251,  251,  251,  252,  220,  247,  247,  247,  253,
  253,  254,  254,  221,  222,  222,  223,  224,  225,  225,
  216,  216,  216,  216,  216,  259,  255,  226,  260,  260,
  261,  261,  262,  262,  263,  263,  263,  263,  256,  256,
  207,  207,  258,  258,  264,  264,  257,  257,   84,   84,
  265,  265,  266,  227,  267,  267,  267,  268,  268,  268,
  268,  268,  269,  195,  228,  229,  230,  231,  271,  232,
  270,  270,  273,  272,  218,  274,  274,  274,  274,  276,
  275,  275,  275,  275,  275,  275,  275,  277,  277,  277,
  277,  278,  278,  278,  278,  278,  278,  279,  279,  279,
  280,  280,  280,  280,  280,  281,  281,  281,  282,  282,
  283,  283,  284,  284,  285,  285,  286,  286,  287,  287,
  288,  288,  289,  289,  289,  289,  289,  289,  289,  289,
  289,  289,  289,  290,  290,  291,  291,  291,  292,  292,
  293,  293,  296,  294,  295,  295,  298,  297,  299,  300,
  297,   45,   45,  245,  245,  245,  245,  233,  233,  233,
   83,  302,  303,  304,  305,  306,   27,   62,   62,   61,
   61,  110,  110,  307,  307,  307,  307,  307,  307,  307,
  307,  307,  307,  307,  307,  307,  307,  307,   65,   65,
   67,   67,   67,  308,  308,  309,  310,  310,  311,  311,
  311,  311,  204,  204,  312,  312,  314,  111,  315,  315,
  316,  159,  313,  313,  317,  317,  318,  318,  318,  318,
  322,  322,  323,  323,  323,  320,  320,  320,  320,  320,
  320,  320,  320,  320,  320,  320,  320,  320,  324,  324,
  324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
  324,  338,  338,  338,  338,  325,  339,  321,  340,  340,
  341,  341,  341,  341,  341,  341,  208,  208,  342,  344,
  319,  347,  319,  343,  343,  343,  345,  345,  350,  350,
  351,  351,  346,  346,  348,  348,  352,  352,  353,  349,
  349,  349,  326,  326,  337,  337,  354,  355,  355,  327,
  327,  356,  356,  359,  357,  358,  358,  360,  360,  360,
  363,  361,  362,  362,  364,  364,  328,  328,  328,  328,
  365,  366,  370,  367,  369,  369,  371,  371,  375,  374,
  374,  372,  372,  373,  373,  377,  376,  376,  368,  378,
  368,  329,  329,  329,  329,  329,  329,  379,  380,  381,
  381,  381,  382,  383,  384,  384,  385,  385,  330,  330,
  330,  330,  386,  386,  388,  388,  387,  389,  387,  387,
  331,  332,  390,  335,  333,  392,  393,  336,  394,  395,
  334,  334,  391,  391,  301,  301,  301,  301,  396,  396,
  398,  398,  400,  399,  401,  399,  397,  397,  397,  405,
  403,  406,  407,  403,  402,  402,  408,  408,  409,  409,
  409,  409,  409,  414,  410,  415,  411,  416,  417,  418,
  412,  420,  421,  422,  412,  419,  419,  424,  413,  423,
  427,  423,  426,  429,  426,  425,  425,  425,  428,  428,
  428,  404,  430,  404,    3,    3,  431,    3,    3,  432,
  432,  246,  246,  241,  241,
  };
   static readonly short [] yyLen = {           2,
    2,    0,    3,    2,    4,    3,    1,    0,    1,    1,
    2,    4,    2,    1,    2,    1,    1,    5,    2,    3,
    0,    0,   11,    1,    3,    1,    0,    1,    0,    1,
    1,    0,    1,    0,    1,    0,    1,    1,    2,    1,
    1,    1,    1,    1,    1,    1,    0,    1,    1,    2,
    0,    3,    0,    6,    3,    1,    1,    1,    1,    1,
    3,    0,    3,    1,    0,    3,    0,    1,    1,    3,
    3,    1,    1,    0,    4,    4,    0,    1,    1,    0,
    1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    0,    0,    0,    0,   13,    5,
    0,    4,    0,    1,    1,    2,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    0,    9,    0,    1,
    1,    2,    3,    0,    3,    1,    1,    1,    0,    8,
    0,    9,    6,    0,    0,    3,    0,    1,    1,    2,
    2,    0,    5,    0,    1,    1,    2,    3,    0,    4,
    2,    1,    1,    1,    0,    3,    0,    0,   10,    0,
    0,   11,    8,    1,    1,    0,    1,    1,    3,    3,
    3,    5,    3,    5,    1,    1,    1,    1,    3,    4,
    6,    4,    0,    7,    0,    1,    1,    2,    1,    1,
    1,    4,    6,    4,    1,    2,    2,    1,    0,    0,
    0,   10,    0,    0,    0,   13,    1,    2,    1,    2,
    1,    0,    5,    0,    5,    1,    1,    1,    0,    0,
    0,    0,   15,    5,    0,    1,    1,    2,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    0,    5,    1,
    1,    1,    1,    0,    7,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    0,    7,
    0,    7,    2,    2,    2,    0,    0,    9,    1,    1,
    0,    1,    0,    6,    0,    6,    1,    0,    8,    0,
    9,    0,    0,   10,    0,    0,    3,    0,    1,    1,
    2,    2,    0,    5,    0,    2,    2,    2,    1,    1,
    1,    0,    5,    0,    5,    1,    1,    0,    0,    0,
   12,    0,    2,    2,    0,    1,    2,    1,    3,    2,
    0,    5,    0,    0,    0,   13,    0,    1,    1,    3,
    1,    4,    2,    0,    3,    2,    1,    3,    0,    3,
    1,    1,    3,    1,    2,    3,    4,    4,    0,    3,
    1,    3,    3,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    2,    2,    2,    2,    2,    2,
    1,    3,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    2,    2,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    3,    3,    4,    4,    4,    3,    3,    4,
    3,    4,    4,    0,    1,    3,    4,    0,    1,    1,
    3,    2,    3,    1,    2,    3,    2,    1,    1,    0,
    1,    1,    3,    3,    2,    2,    1,    1,    1,    1,
    2,    2,    4,    3,    1,    4,    1,    3,    2,    1,
    3,    1,    1,    1,    4,    3,    2,    2,    6,    3,
    7,    4,    3,    7,    3,    0,    2,    4,    1,    2,
    0,    1,    1,    3,    3,    1,    1,    1,    0,    1,
    1,    2,    2,    3,    1,    2,    0,    1,    2,    4,
    1,    3,    0,    5,    1,    1,    1,    2,    3,    3,
    4,    4,    1,    2,    4,    4,    4,    3,    0,    4,
    0,    1,    0,    4,    4,    1,    2,    2,    1,    4,
    1,    2,    2,    2,    2,    2,    2,    1,    3,    3,
    3,    1,    3,    3,    3,    3,    3,    1,    3,    3,
    1,    3,    3,    3,    3,    1,    3,    3,    1,    3,
    1,    3,    1,    3,    1,    3,    1,    3,    1,    3,
    1,    5,    3,    3,    3,    3,    3,    3,    3,    3,
    3,    3,    3,    1,    3,    3,    2,    1,    0,    1,
    1,    1,    0,    2,    1,    1,    0,    4,    0,    0,
    7,    1,    1,    1,    1,    1,    1,    6,    4,    4,
    1,    1,    0,    0,    0,    0,   15,    0,    1,    0,
    1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    0,    2,
    0,    1,    1,    1,    2,    4,    1,    3,    1,    3,
    1,    1,    0,    1,    1,    1,    0,    4,    1,    1,
    0,    4,    0,    1,    1,    2,    1,    1,    1,    1,
    1,    2,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    0,    4,    1,    2,
    2,    2,    2,    2,    2,    1,    1,    2,    1,    0,
    6,    0,    7,    0,    2,    1,    0,    1,    1,    2,
    2,    4,    0,    2,    0,    1,    1,    2,    4,    1,
    5,    2,    2,    2,    2,    2,    1,    1,    1,    1,
    1,    5,    7,    0,    8,    0,    1,    1,    2,    1,
    0,    3,    1,    2,    3,    1,    1,    1,    1,    1,
    5,    7,    0,    4,    7,    1,    0,    1,    0,    5,
    1,    0,    1,    0,    1,    1,    1,    3,    6,    0,
    9,    1,    1,    1,    1,    1,    1,    2,    2,    3,
    4,    3,    3,    3,    4,    3,    0,    1,    3,    4,
    5,    3,    1,    2,    0,    1,    2,    0,    7,    3,
    2,    2,    0,    3,    5,    0,    0,   10,    0,    0,
   10,    5,    0,    2,    2,    2,    2,    2,    4,    5,
    4,    5,    0,    5,    0,    6,    3,    2,    1,    0,
    3,    0,    0,    6,    0,    1,    1,    2,    1,    1,
    1,    1,    1,    0,    5,    0,    3,    0,    0,    0,
   12,    0,    0,    0,   13,    0,    2,    0,    3,    1,
    0,    4,    1,    0,    4,    1,    2,    2,    1,    2,
    2,    0,    0,    4,    2,    3,    0,    4,    2,    2,
    3,    0,    1,    1,    1,
  };
   static readonly short [] yyDefRed = {            0,
    7,    0,    0,    0,    0,    0,    0,    2,    0,    0,
   10,   13,    0,  915,    0,    0,  919,    0,    0,   14,
   16,   17,    9,    1,    0,    0,    0,   11,    0,  769,
    0,  387,    0,  393,  400,    0,    0,    0,  388,    0,
    0,    0,  390,  428,    0,  389,    0,    0,    0,    0,
  396,    0,  398,    0,  426,  385,    0,  392,  394,    0,
  386,    0,  484,    0,  427,    0,  523,  397,  399,    0,
  843,  395,    0,    0,    0,  627,    0,    0,    0,    0,
    0,  677,    0,  726,    0,    0,    0,    0,    0,    0,
    0,    0,  425,    0,  619,    0,  768,  709,    0,    0,
  391,    0,    0,  402,  403,    0,  405,  406,  407,  408,
  409,  410,  411,  412,  413,  414,  415,  416,  417,  418,
  419,  420,  423,  424,  623,  551,    0,  549,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  624,
  622,  625,  626,  693,  695,    0,  691,  694,  710,  712,
  713,  714,  715,  716,  717,  718,  719,  720,  721,  711,
    0,    0,    0,  770,  771,  787,  788,  789,  790,  812,
  813,  814,  815,  816,  817,    0,    0,    0,   19,    0,
    0,    0,  339,    0,  341,  923,   15,  916,    3,   51,
    0,    0,    0,   41,   38,   40,   42,   43,   44,   45,
   46,   49,   12,    0,    0,    0,  818,  429,  430,  841,
    0,    0,    0,    0,    0,  404,    0,  819,    0,  543,
  539,  542,  725,  767,  696,  723,  722,  724,  697,  698,
  699,  700,  701,  702,  703,  704,  705,  706,  707,  708,
    0,    0,    0,  793,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  828,    0,  401,    0,
    0,    0,    0,    0,    0,  842,    0,    0,    0,  739,
  735,    0,    0,    0,    0,    0,    0,  368,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  548,  552,  553,
  547,  557,  556,  554,  555,    0,    0,  617,  727,  534,
    0,  422,  421,    0,    0,    0,    0,  338,    0,  733,
  734,    0,  487,  488,    0,    0,    0,  731,  732,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  918,  692,  740,  730,    0,  765,  766,
  869,  886,    0,    0,    0,  898,  857,  855,  879,    0,
    0,  877,  880,  881,  882,  883,  858,  856,    0,    0,
    0,  343,    0,   20,    0,    0,    0,   39,  649,  655,
  647,    0,  644,  654,  648,  646,  645,  652,  650,  651,
  657,  653,  656,  658,    0,    0,  642,   50,  486,    0,
    0,  482,  483,    0,  480,    0,  742,    0,    0,    0,
    0,  763,  764,    0,    0,    0,  631,    0,  822,  820,
  632,    0,    0,  508,    0,    0,    0,  499,    0,  503,
  513,  515,    0,  495,    0,    0,    0,    0,    0,  490,
    0,  493,    0,  497,  370,  823,    0,    0,  824,  832,
    0,    0,    0,  833,    0,    0,  844,    0,    0,  738,
    0,  380,    0,  376,  377,    0,  375,  378,  379,    0,
    0,    0,  558,    0,    0,  690,    0,    0,  685,  687,
  688,  689,  433,  434,  826,    0,    0,    0,  346,  347,
    0,  190,  189,  191,    0,    0,    0,    0,  372,    0,
  604,    0,    0,  438,    0,  441,    0,  439,  538,    0,
    0,    0,    0,    0,  467,  470,    0,    0,  462,  469,
  468,    0,  593,  594,  595,  596,  597,  598,  599,  600,
  601,  603,  602,  559,  561,  560,  566,  567,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  590,    0,    0,  512,    0,    0,    0,
    0,    0,    0,    0,  870,  872,  868,    0,  878,    0,
    0,  340,   59,   57,   58,    0,    0,   52,    0,    0,
   60,   62,   26,   24,    0,    0,    0,  639,    0,  643,
  437,    0,  485,    0,  536,    0,  545,  177,  198,    0,
    0,  167,    0,    0,    0,  178,  540,    0,  846,  796,
    0,  807,  794,    0,  798,    0,    0,    0,  821,    0,
    0,    0,  498,    0,  514,  516,    0,    0,  454,    0,
    0,  450,    0,    0,  477,    0,  518,  492,    0,  154,
  519,  152,  153,  521,    0,  535,    0,  837,    0,  830,
    0,  834,  527,    0,    0,    0,  365,    0,  525,    0,
    0,  537,    0,  849,    0,  861,    0,  859,    0,    0,
  629,  630,  679,  680,  678,  686,  825,  612,  618,  611,
    0,  728,    0,  345,  607,    0,    0,    0,  550,  442,
  436,  440,  435,  476,  475,  472,  471,    0,  466,  431,
  432,  443,    0,    0,  746,    0,    0,  887,  863,    0,
  888,    0,  884,    0,  899,    0,    0,    0,    0,  867,
   18,  342,   53,    0,    0,    0,    0,    0,    0,  367,
  349,    0,  633,    0,    0,   79,   78,    0,  481,    0,
    0,    0,    0,    0,  187,    0,  544,    0,    0,    0,
    0,    0,  799,    0,    0,    0,    0,    0,  845,  505,
  504,  457,    0,    0,  924,  925,  446,  452,    0,  455,
    0,  479,    0,    0,    0,    0,    0,  774,  840,    0,
  831,  533,  528,    0,    0,  524,    0,  852,    0,  791,
  862,  860,    0,  616,  615,  614,  348,  606,  605,  620,
  474,    0,  464,  463,  592,    0,  760,  745,    0,    0,
    0,  749,    0,  865,    0,  892,    0,  907,  908,  901,
  871,  873,  913,    0,   61,   55,    0,   63,   25,   22,
    0,    0,    0,  318,    0,  224,    0,  100,    0,   76,
  754,  127,  128,    0,    0,    0,  757,  196,  197,    0,
  188,    0,    0,    0,  170,  179,  171,  173,    0,    0,
    0,    0,  803,    0,  808,  809,    0,    0,  456,  458,
  459,  453,  447,  451,    0,  510,    0,  478,  489,  445,
  522,  520,    0,  836,    0,    0,  529,    0,    0,  628,
    0,  473,    0,    0,  741,  750,  864,    0,    0,    0,
  885,    0,    0,    0,    0,    0,    0,   68,   69,   72,
   73,    0,  333,    0,  350,  324,  323,    0,  634,  220,
   96,    0,  743,  758,  182,    0,  194,    0,    0,    0,
  792,  854,    0,    0,    0,  810,  773,  494,  491,  780,
    0,  786,    0,    0,  778,    0,  783,  838,  532,  531,
    0,  621,    0,    0,  866,  889,    0,    0,    0,  903,
    0,  914,    0,   74,   66,    0,    0,    0,  364,    0,
    0,  361,  319,    0,    0,    0,    0,    0,  183,    0,
  174,  172,  847,  800,    0,    0,  805,    0,    0,  775,
  779,    0,  784,    0,  850,    0,  752,    0,  893,  910,
  911,  904,  874,   54,    0,   70,   71,    0,    0,  676,
  675,    0,  674,    0,  360,    0,    0,    0,    0,    0,
  759,  181,    0,  193,    0,    0,  811,  785,    0,  681,
  839,    0,  761,    0,    0,    0,   75,    0,    0,  334,
  363,  362,    0,  320,    0,  328,  384,  383,    0,  381,
  663,    0,  635,    0,  664,  221,   97,  184,  848,  795,
    0,  851,  890,    0,  905,    0,    0,    0,    0,    0,
    0,    0,    0,  665,    0,    0,    0,    0,  894,   28,
   23,  335,    0,    0,  329,  382,    0,    0,    0,  101,
   98,  682,    0,    0,    0,    0,  321,  671,    0,  672,
  669,    0,  667,   94,    0,   93,    0,    0,   82,   84,
   85,   86,   87,   88,   89,   90,   91,   92,  155,    0,
    0,  237,  229,  230,  231,  232,  233,  234,  235,  236,
    0,    0,  227,    0,    0,    0,  891,    0,  336,  332,
    0,    0,    0,  636,   83,    0,  280,  275,  279,    0,
  222,  228,  115,  107,  108,  109,  110,  111,  112,  113,
  114,  116,    0,    0,  105,   99,  897,  895,  670,  668,
    0,    0,    0,    0,    0,    0,    0,  288,    0,    0,
  238,    0,    0,  246,    0,  165,  156,  164,    0,  102,
  106,    0,    0,  274,    0,    0,  273,    0,    0,    0,
    0,  354,    0,  352,    0,    0,  199,    0,    0,    0,
    0,    0,  637,  223,  117,    0,  351,    0,    0,    0,
    0,  131,    0,    0,    0,    0,    0,    0,  157,    0,
    0,  203,    0,  355,    0,  241,  240,  239,  252,  251,
  248,  253,  254,  247,  266,  265,  258,  259,  255,  257,
  256,  260,  249,  250,  261,  262,  268,  267,  263,  264,
    0,    0,  292,    0,  271,  133,    0,  269,  160,    0,
    0,  135,    0,  356,    0,    0,  200,    0,    0,    0,
  353,  244,  126,  124,    0,    0,  296,    0,    0,    0,
    0,    0,    0,    0,  277,    0,    0,    0,    0,  139,
    0,    0,    0,    0,  357,  358,    0,    0,    0,    0,
    0,  121,  311,    0,  293,    0,    0,  305,    0,    0,
    0,  300,    0,  151,    0,    0,    0,    0,  146,    0,
    0,  289,    0,  136,    0,  130,  140,  158,  163,  211,
    0,  201,    0,    0,    0,    0,  125,    0,  118,  122,
    0,    0,    0,  307,    0,  308,  297,    0,    0,  291,
  301,  272,    0,    0,  132,  147,  270,  161,  287,    0,
  278,  282,  142,    0,    0,    0,  208,  210,  204,  245,
  123,  312,  314,  294,    0,    0,  306,  303,  150,  148,
    0,    0,    0,    0,  159,  212,  214,  202,    0,    0,
    0,  305,  162,  283,  285,  143,    0,    0,  205,  316,
  317,  313,  315,  304,    0,    0,  218,  217,  216,  213,
  215,    0,    0,    0,  206,  284,  286,
  };
  protected static readonly short [] yyDgoto  = {             6,
    7,   24,    8,   25,    9,   26,  191,  610,  380,   10,
   11,   27,   20,   21,   22,  276,  182,  194,  595,  738,
  922, 1049, 1420,  735,  195,  196,  197,  198,  199,  200,
  201,  202,  588,  386,  589,  590,  834,  591,  592,  838,
  736,  917,  918,  919,  224,  526, 1015,  748, 1117, 1118,
 1119, 1120, 1121, 1122, 1123, 1124, 1125, 1126, 1127, 1128,
  405,  599, 1214,  849, 1028,  986, 1063, 1101, 1086, 1145,
 1173, 1144, 1174, 1175, 1058, 1295, 1272, 1320, 1321, 1322,
  851, 1318,  852,  653, 1190, 1283, 1237, 1308,  454, 1301,
 1277, 1337,  817, 1306, 1309, 1310, 1404, 1338, 1339, 1335,
 1129, 1197, 1156, 1215,  611, 1285, 1384, 1303, 1401,  406,
  225,  612,  613,  614,  615,  616,  753,  507, 1033,  754,
  508,  756, 1217, 1241, 1352, 1313, 1386, 1218, 1288, 1409,
 1432, 1353, 1354, 1430, 1417, 1418,  847,  985, 1085, 1141,
 1199, 1142, 1143, 1191, 1248, 1221, 1192,  278, 1271, 1317,
 1194, 1302, 1299, 1130, 1158, 1211, 1381, 1343, 1041, 1382,
  527, 1425, 1426, 1210, 1298, 1274, 1330, 1325, 1296, 1362,
 1367, 1328, 1331, 1332, 1412, 1368, 1326, 1327, 1422, 1410,
 1411,  844,  928, 1054, 1026, 1079, 1055, 1056, 1093,  978,
 1077, 1105,  474,  183,   99,  382,  185,  501,  925,  842,
 1229,  981,  982, 1022,  740,  279,  357,  472,  258, 1059,
 1060,  101,  102,  259,  104,  105,  106,  107,  108,  109,
  110,  111,  112,  113,  114,  115,  116,  117,  118,  119,
  120,  121,  122,  123,  124,  211,  712,  889,  450,  640,
  777,  641,  642,  882,  125,  188,  646,  528,  529,  530,
  531,  706,  414,  415,  253,  887,  648,  358,  255,  437,
  438,  439,  440,  443,  655,  265,  670,  671,  793,  221,
  420,  222,  419,  126,  127,  128,  129,  130,  131,  132,
  133,  134,  135,  136,  137,  138,  139,  140,  141,  510,
  511,  512,  689,  690,  806,  691,  142,  497,  304,  901,
  143,  432,  845,  984, 1083, 1195,  407, 1064, 1065, 1112,
 1113, 1023,  487,  286,  685, 1071,  488,  489,  226,  227,
  228,  146,  147,  148,  229,  230,  231,  232,  233,  234,
  235,  236,  237,  238,  239,  240,  160,  241,  498,  161,
  162,  272,  717,  566,  820,  751,  606,  855,  818,  821,
  822,  856,  857,  242,  163,  164,  165,  953,  893,  954,
  955,  956, 1002,  957,  166,  167,  168,  169,  623,  425,
  624,  874,  995,  625,  872,  626,  997,  998,  170,  171,
  172,  173,  174,  175,  260,  463,  464,  895, 1004,  268,
  871,  762, 1035,  799, 1042,  176,  368,  177,  369,  823,
  908,  370,  578,  730,  727,  728,  913,  371,  372,  373,
  374,  375,  376,  827,  568,  825, 1008, 1088, 1147,  910,
 1045, 1104,  725,  574,  726,  969,  912,  970, 1046,  914,
   15,   17,
  };
  protected static readonly short [] yySindex = {         -151,
    0, -209, -107,   23,  140,    0,  328,    0,  140,   23,
    0,    0,  198,    0, 6308,  140,    0, -171,  -32,    0,
    0,    0,    0,    0,  328,  268,  140,    0,  286,    0,
  -20,    0,  348,    0,    0,  185,10950,  378,    0, -227,
  315, 6464,    0,    0, -227,    0, -227, -227, -157, -227,
    0, -227,    0,  142,    0,    0,10045,    0,    0, -227,
    0, -227,    0,10045,    0,  343,    0,    0,    0,  185,
    0,    0, -227,  420, -227,    0, 7729, 7885,  449, -227,
 -227,    0,10045,    0,10720,10720,10720,10720,10720,10720,
10720,10720,    0,   92,    0,10791,    0,    0,  410,  334,
    0,  634,  340,    0,    0,  456,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  826,    0,  672,  124,
  524,  504,  571,  454,  469,  514,  471, -264,  523,    0,
    0,    0,    0,    0,    0, 2538,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  458,  535,  118,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, -186, -183,  268,    0,  119,
  562,  577,    0,  530,    0,    0,    0,    0,    0,    0,
  268, 4841,  268,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  760,  605,10180,    0,    0,    0,    0,
10045, -227, -227,  298,  634,    0,  618,    0,10791,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  711,  145,10950,    0,10791,10045,  691,  697,10045,10045,
 8295,  489,   93,  709,11395,  281,    0,  714,    0,  718,
10791,10045,  722,  492, -227,    0,10045,  343, 9505,    0,
    0,  420,10045,  420, -203,  382,  683,    0,  535,  340,
 -114,  687,10045,10045,10045, 6620, -256,    0,    0,    0,
    0,    0,    0,    0,    0,  734,10045,    0,    0,    0,
 4110,    0,    0,11363,  126,  753,  729,    0, -271,    0,
    0,   77,    0,    0,  728,10180, 9235,    0,    0,10720,
10045,10045,10045,10045,10045,10045,10045,10045,10045,10045,
10045,10720,10720,10720,10791,10791,10720,10720,10720,10720,
10720,10720,10720,10720,10720,10720,10720,10720,10720,10720,
10720,10720,10045,    0,    0,    0,    0,  535,    0,    0,
    0,    0,11439,11463,  743,    0,    0,    0,    0, -226,
  598,    0,    0,    0,    0,    0,    0,    0,  268,  268,
  750,    0,  759,    0,  729, -181, 4841,    0,    0,    0,
    0, -168,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, -174,12240,    0,    0,    0,  729,
  194,    0,    0,  623,    0,  801,    0,  809,    6,  343,
 -227,    0,    0,  764, 7400, -223,    0,  795,    0,    0,
    0,  811,  813,    0,  279,    0,  818,    0,  814,    0,
    0,    0,  639,    0, 8138,  644,10045,  709, 9235,    0,
 7088,    0,  420,    0,    0,    0,  815,  820,    0,    0,
  185,  343,  101,    0, 7105,  823,    0,  827,  772,    0,
  828,    0,10045,    0,    0,  903,    0,    0,    0,10045,
  907,  829,    0,  834,  836,    0, -250, 6620,    0,    0,
    0,    0,    0,    0,    0,  837,  343, 6620,    0,    0,
 -232,    0,    0,    0,  420,  126,  787,11507,    0,  838,
    0,  839,10720,    0,  205,    0,  373,    0,    0,  650,
10045,10045,  843,  952,    0,    0,  -66,  841,    0,    0,
    0,  672,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  672,  672,
  124,  124,  524,  524,  524,  524,  504,  504,  571,  454,
  469,  514,  471,    0,  842, -201,    0,10045,  -28,  798,
    1,  821,  857,10045,    0,    0,    0,  883,    0,  -16,
  729,    0,    0,    0,    0,  126,  562,    0,  866,  869,
    0,    0,    0,    0,  871,11531,  830,    0, -147,    0,
    0,  466,    0,10180,    0,  868,    0,    0,    0,  507,
  875,    0,  877,  878,  879,    0,    0,10045,    0,    0,
  840,    0,    0,  880,    0,  881,10045,  959,    0, 6464,
 6464, 7556,    0, 8295,    0,    0, 9640,  270,    0, -230,
 -148,    0,  831,  844,    0,  -38,    0,    0,  885,    0,
    0,    0,    0,    0,  886,    0,  895,    0, 7261,    0,
  343,    0,    0,  420,  355,  416,    0,  845,    0,  892,
  896,    0, 6464,    0, 6464,    0,10045,    0,10045,10791,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 7712,    0,10791,    0,    0,  847,11363,  924,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 9100,    0,    0,
    0,    0, 9370,10045,    0, 7244,  897,    0,    0,  977,
    0,  979,    0,  626,    0,  901,10045,10045,  858,    0,
    0,    0,    0,  750,  909,  906,  862,  914,  830,    0,
    0,  912,    0, 1027, 1031,    0,    0,10045,    0, 9775,
  915,  507,11507,  510,    0,10791,    0,   28, 1037, 1040,
  930,  922,    0,10045,10045,  933,10045, 1026,    0,    0,
    0,    0,   71, 9910,    0,    0,    0,    0, 8003,    0,
 1054,    0,  535,10045,  946, 7556,  947,    0,    0,  900,
    0,    0,    0,  902,  363,    0,  905,    0,  922,    0,
    0,    0,  942,    0,    0,    0,    0,    0,    0,    0,
    0,  167,    0,    0,    0,11395,    0,    0,  908,  943,
  897,    0,10045,    0,10045,    0,10045,    0,    0,    0,
    0,    0,    0,  750,    0,    0,10315,    0,    0,    0,
  957,  917, 7417,    0,  830,    0,  830,    0,  830,    0,
    0,    0,    0,  911,  954,  915,    0,    0,    0, -167,
    0, -150,  960,  963,    0,    0,    0,    0,  962, 7556,
  897, -201,    0,  964,    0,    0,  961, 6464,    0,    0,
    0,    0,    0,    0,  969,    0,  709,    0,    0,    0,
    0,    0, -199,    0,  970,  363,    0,  920,  897,    0,
  343,    0,  921,  965,    0,    0,    0,10045,  995,10045,
    0,10045,  997,  208,  869,  168,  481,    0,    0,    0,
    0,   23,    0, -138,    0,    0,    0,  980,    0,    0,
    0,  971,    0,    0,    0,  273,    0,  972, 1093, 1094,
    0,    0,  983,  897,10045,    0,    0,    0,    0,    0,
10045,    0,  990, -194,    0, -194,    0,    0,    0,    0,
  991,    0,10045, 7244,    0,    0, 1012,  708,  993,    0,
10045,    0,  992,    0,    0,10315,  140,    6,    0,  508,
  316,    0,    0,  989,  989,  989, 9775,  998,    0,10045,
    0,    0,    0,    0,  999,  881,    0, 6464, 1000,    0,
    0, 6620,    0, 1003,    0, 1002,    0,10045,    0,    0,
    0,    0,    0,    0,10045,    0,    0,  268, 1004,    0,
    0,  956,    0, -138,    0,  268, 7573,  108,  108,  108,
    0,    0,10045,    0, 6464, 6464,    0,    0, 6620,    0,
    0, 6464,    0, 1016,10045,10045,    0,  268, 1009,    0,
    0,    0,  967,    0, 1006,    0,    0,    0, 1007,    0,
    0,  968,    0, 1038,    0,    0,    0,    0,    0,    0,
 6620,    0,    0, 1033,    0, 1011,  108,    0, 1020,  268,
 7573, 1017, 1028,    0, 1030, 1034, 1035,10045,    0,    0,
    0,    0, 1013, 1011,    0,    0,  321,  -81,  268,    0,
    0,    0, 1041,10045, 1029,10045,    0,    0, 1039,    0,
    0, 1042,    0,    0,12240,    0, 1036,  -81,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  138,
12240,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1047,  268,    0,  268, 1011,  984,    0, 1041,    0,    0,
 1048,  321,11135,    0,    0,  235,    0,    0,    0,11203,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1057,  268,    0,    0,    0,    0,    0,    0,
10791,10791,   98,11395,  294,  420, 1088,    0,  126, 8225,
    0, 1121,    0,    0, 1011,    0,    0,    0, 1011,    0,
    0, 1010, 1014,    0,10791, -146,    0,10791, 1014, 1018,
 1059,    0,  126,    0, 1060, 9051,    0, 1065, 1019, -235,
  260, 1352,    0,    0,    0,  126,    0, 1071, 1022, 1070,
 1067,    0, 1073, 1075, 1076,    6, 1068, 1078,    0, 1081,
 1086,    0,  729,    0,  597,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1085, -180,    0, 1077,    0,    0, 1090,    0,    0, 1089,
 1091,    0, 1083,    0,    6,    6,    0,    6, 1087, 1092,
    0,    0,    0,    0, 1096,  -78,    0, 1114,    6, 1205,
 1115,    6,    6,  235,    0, 7556, 1046, 1116, 1083,    0,
 1118, 1119,   69, 1123,    0,    0,    6, 9775, 1079, 1120,
 1096,    0,    0,12240,    0,  268,  268,    0, 1100, 1125,
 1114,    0, 1122,    0,10045, 1101, 1127, 1115,    0, 1132,
 1148,    0, -170,    0, 1140,    0,    0,    0,    0,    0,
12240,    0,   69,   69, 1099, 1150,    0, -180,    0,    0,
  251, 1131,12240,    0,12240,    0,    0, 7556, 1142,    0,
    0,    0, 1136, 1090,    0,    0,    0,    0,    0, -160,
    0,    0,    0,  108,  719, 1156,    0,    0,    0,    0,
    0,    0,    0,    0, 1179, 1261,    0,    0,    0,    0,
  108, 1155, 1162, 7556,    0,    0,    0,    0,   69,  376,
  376,    0,    0,    0,    0,    0,   64,   64,    0,    0,
    0,    0,    0,    0, 9235, 9235,    0,    0,    0,    0,
    0, 1159, 1165, 1166,    0,    0,    0,
  };
  protected static readonly short [] yyRindex = {         1870,
    0,    0, 6776, 1870,    0,    0, 1530,    0, 2055,  988,
    0,    0,    0,    0,    0, 2055,    0,    0,   43,    0,
    0,    0,    0,    0, 1530, 1111, 1939,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1174,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,11575,    0,    0, 1167,    0,    0,    0,
    0,    0,    0, 1167,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  210,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 3543,    0,    0,    0,    0,    0,  240,
    0, 4109, 3701,    0,    0, 3951,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 4497,    0, 4564, 4904,
 5105, 5440, 5641, 5775, 5909, 6043,  494, 4196, 1160,    0,
    0,    0,    0,    0,    0,   43,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1124,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  782,  782, 2128,    0,  405,
 1168,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 2195,  713, 2264,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 3054,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1177,    0,    0,    0,    0, 3054,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 2786,    0, 4394, -228, 2931,    0,    0, 3213, 2931,
 -228,    0,    0,    0,    0,  -43,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1167,    0,    0,    0,
    0,    0,    0, 1180, 4264,    0, 3054,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  -45,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 2374,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   29,    0,    0,    0,    0,    0,    0,    0, 2331, 1497,
    0,    0,    0,    0, 2641,    0,  120,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  310,10868,    0,    0,    0, 3054,
 3859,    0,    0,    0,    0,    0,    0,    0,11235,    0,
    0,    0,    0,    0, 1170,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  374,  735,    0,    0, 1187,    0,
    0,    0,    0,    0,  -34,    0,    0, 3635, 1193,    0,
    0,    0, -154,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1282,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  -14,    0,    0,
    0,    0,    0,    0,    0,    0, 7868,    0,    0,    0,
    0,    0,    0,    0, -140,  630,    0,    0,    0, 1194,
    0,    0,    0,    0, 3054,    0, 3054,    0,    0,    0,
    0,    0,   56,    0,    0,    0,    0,  117,    0,    0,
    0, 4667,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 4734, 4837,
 4971, 5038, 5172, 5239, 5306, 5373, 5507, 5574, 5708, 5842,
 5976, 6110, 6177,    0,    0,  679,    0,    0, -228,    0,
 -228,    0,    0,    0,    0,    0,    0, 3017,    0,    0,
 2641,    0,    0,    0,    0,  670,  100,    0,    0, 1197,
    0,    0,    0,    0, 1202,    0,    0,    0,    0,    0,
    0,10450,    0,    0,    0,  694,    0,    0,    0,11599,
    0,    0,  707,  723,  727,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1200,    0,    0,    0,    0,
    0,    0,    0, 1209,    0,    0,    0, 3385,    0,    0,
   57,    0,   73, 3319,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1211,    0,    0,    0,    0,    0,
    0,    0,    0, -243,  539,  656,    0,    0,    0,    0,
 1212,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  203,    0,    0,    0, 1213,    0,    0,    0,
    0,    0,    0,  329,    0,  538,    0,    0,    0,    0,
    0,    0,    0, 1220,    0,  665,    0,    0,    0,    0,
    0, 1214,    0, 1173, 1175,    0,    0,    0,    0,    0,
 1216,11643,    0,11667,    0,    0,    0,11319,    0,    0,
    0,  730,    0, 1218,    0,    0,    0, 1630,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 3477,    0, 3793, 1227,    0,    0,    0, 1224,
    0,    0,    0,    0,  539,    0,    0,    0,  730,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  675,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  745,    0,    0,    0,
    0,  161,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1222,    0,    0,    0,    0,
    0,    0,  748,  751,    0,    0,    0,    0,    0,    0,
 1228,  679,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 3635,    0,    0,    0,
    0,    0, 1235,    0,    0,  539,    0,  777, 1228,    0,
 7868,    0,  505,  560,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  129, 1197, 8291,    0,    0,    0,    0,
    0,11730,    0, -121,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  572,    0,  586,    0,    0,
    0,    0,    0, 1213, 1232,    0,    0,    0,    0,    0,
    0,    0,    0, 1238,    0, 6932,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  445,  570,    0,
    0,    0,    0,    0,    0,    0,11798,11235,    0, 1201,
    0,    0,    0,  151,  151,  151,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1249,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,11952,    0,    0,
    0,    0,    0, -121,    0, -275,    0, 1255, 1255, 1255,
    0,    0,    0,    0,    0,    0,    0,    0, -222,    0,
    0,    0,    0,    0,    0,    0,    0,11995,    0,    0,
    0,    0,    0,    0, 1257,    0,    0,    0,  153,    0,
    0,    0,    0,  451,    0,    0,    0,    0,    0,    0,
 1258,    0,    0,    0,    0, 1982, 1253,  486,    0, -255,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1802,    0,    0,    0, 8453, 8817,    0,
    0,    0,  614,    0,    0,    0,    0,    0,    0,    0,
    0,  351,    0,    0,11021,    0,    0, 8544,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
11103,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 8908,    0, 8635, 1802,    0,    0,  614,    0,    0,
    0,    0,  310,    0,    0,    0,    0,    0,    0,  310,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 8726,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 4393,  391,    0, 8952,    0,
    0,    0, 9021,    0, 1802,    0,    0,    0, 1802,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  715,    0, 1263,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  786,    0,  552,    0,    0,
    0,    0,    0,    0,    0,11235,  755,    0,    0,    0,
    0,    0, 1259,    0,  604,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  762,    0,    0,    0,    0,    0,    0,
    0,    0, 1260,    0,11235,11235,    0,11279,    0,    0,
    0,    0,    0,    0, 1264, 4671,    0, 1265,11235,10585,
 1266,11235,11235,    0,    0,    0,    0,    0, 1270,    0,
    0,    0,12205,    0,    0,    0,11235,    0,    0,    0,
 1271,    0,    0,  317,    0,12132,12162,    0,    0,    0,
 1275,    0,    0,    0,    0,    0,    0, 1276,    0,    0,
    0,    0,  485,    0,  763,    0,    0,    0,    0,    0,
  799,    0,12038,12073,    0,    0,    0,    0,    0,    0,
    0,    0, 1317,    0, 1370,    0,    0,    0,  768,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  526,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  526,    0,    0,    0,    0,    0,    0,    0,12205,11841,
11884,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1193, 1193,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,
  };
  protected static readonly short [] yyGindex = {            0,
    0, 1609,    0,    0,    7,   -4, -162,  -19, 1610,    0,
 1628, 1648,  701,    0,    0,    2,    0,    0,    0,    0,
    0,    0, -719, -617, -177, -569,    0,    0,    0,    0,
    0, -141,    0,    0,    0,  822,    0,  928,    0,    0,
    0,    0,  678,  688,  -15, -189,    0,    0,    0,    0,
  537, -723, -646, -504, -497, -488, -470, -384, -335,-1023,
-1071,    0, -513,    0,  179,    0, -990,    0,    0,    0,
    0,    0,    0,  495,   36,  305,    0,    0,    0,  345,
 -953,    0, -233, -253, 1072,    0,    0,    0, -786,  296,
    0,    0, -442,    0,    0,  362,    0,    0,  337,    0,
    0,  368,    0, -301, -831,    0,    0,    0,    0,  487,
  -12,    0,    0,  918,  923,  926,    0, -467,    0,    0,
 -549,  934,  475,    0, -964,    0,    0,    0,    0,    0,
    0,    0,    0,  262,    0,    0,    0,    0,    0,    0,
    0,    0,  540,    0,    0,    0,    0, -279,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  555,    0,
 -443,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  276,    0,    0,  358,    0,    0,  364,  366,  282,    0,
    0,    0,    0,    0,    0,    0,    0,  610,    0,    0,
    0,    0,  -37,    0,  -13,  -92,    0,    0,  450,    0,
  506,    0,  673,    0, 1229, -245, -220,  -52,  685,    0,
  621,    0,   -6,   35,    0,    0,    8,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, -224,    0,  517,    0,    0, -419,    0,
    0,    0,  925,    0, -257, -118, 1069, 1005,    0,  994,
    0, 1183, 1392, 1106,    0,    0,  824, 1660,    0,    0,
    0,    0, 1082,    0,    0,    0,    0,    0, -465,    0,
    0,    0,    0,    0, 1134,    0,  491,  835,  771,  833,
 1368, 1369, 1373, 1375, 1367,    0, 1371,    0,    0,    0,
 1044,    0,  825,    0,    0,    0,    0,    0,    0,    0,
    0, -238,    0,    0,    0,    0, -391,    0,  655,    0,
  580,    0,  671,    0,    0,    0,  749, -469,  -11, -265,
   -7,    0, 1606,    0,   38,    0,   47,   52,   63,   65,
   67,   94,  111,  115,  137,  139,    0, -594,    0,   -5,
    0,    0,  887,    0, -532,    0,    0,    0,  789,    0,
  936,    0,  899, -402,    0,    0,    0,    0,    0,    0,
  807,    0,    0,  812,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  832,    0,    0,    0,    0,
    0,    0,    0,    0,   -8,    0, 1300,    0,    0,    0,
  966,    0,    0,    0,    0,    0, -159,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1400,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  625,    0,
    0,    0,    0,    0,    0,    0,    0,  737,    0,    0,
    0,    0,
  };
  protected static readonly short [] yyTable = {            97,
  452,  303,   98,  144,  184,  649,  192,  145,  654,  455,
   16,  178,  428,  388,  600,  379,  413,  378,  686,  181,
  491,  271,  622,  210,  509,  482,  436,  354,  692,  903,
  215,  217,  448, 1031,  471,  768,  769,  787, 1066, 1067,
  696,  257,  922, 1153,  216,  782,   12,  311,  257,  103,
  319,  408,  149,  264,  715,  263,  950,  266,  477, 1160,
  755,  150,  310,  184,  184,  318,  151,  287,  951,  361,
  627,  103,  361,  951,  583, 1293,  103,  152,  798,  153,
  800,  154,  184,  742,  179, 1379, 1092,  593,  935, 1244,
  473,  325,  216,  216,  216,  216,  216,  216,  216,  216,
  584,  371,  596, 1402,    1,  937,  597,  778,  155, 1231,
  246,  327,  277,  282,  493,  373,  683,  979,  247,    5,
 1172,  303,  575,  576,  743,  156,  413,  366,  344,  157,
   97,  306,  585,   98,  144,  351,  775,  567,  145,  344,
  693,   47,  208,  344,  782,  515, 1019,  352,  744,   14,
 1172,  158,  362,  159,  516,  362,  344,  363,  192,  364,
  363,   47,  364,  303, 1403,  365,  366,  598,  365,  366,
  494,  387,   47,  366, 1114,  745,  684, 1323,  716,  480,
  103, 1245,  694,  149,   47,  667,  300,  643,  344,  770,
  412,  209,  150,  628,  647,  416,  776,  151,  782, 1294,
  577,  388,  858, 1380,  861,  184,    2,   13,  152,  301,
  153,  371,  154,  371,  514,  371,  371,  782,  371,  470,
  371,  952,  491,  475,  779,  841,  952,  479,  509,  190,
  427,  184,  491,  431,  433,  586,  215,  424,  408,  155,
  367,  184,  478,  377,  215,  180,  458,  184,  594,  936,
  216,  466, 1361,  468,  418,  467,  156,  431,  216,  248,
  157,  608,  371,  469,  371,  719,  938,  371,  484,  485,
 1232,    3,    4,    5,  490,  300,  373,  103,  492, 1385,
  426,  257,  158,  947,  159,  860,  190,  184,  496,  190,
  184, 1395,  582, 1396,  721,   47,  457,  973,  301,  922,
  412,  525,   18,  103,  710,  533,  534,  535,  536,  537,
  538,  539,  540,  541,  542,  543,  667,  601,  303, 1427,
  103,  184,  184,  683, 1350,  460,  782,  216,  922,  897,
  783,  929,  448,  930,  784,  931,  500,  565,  943,  216,
  216,  216,  303,  891,  216,  216,  609,  204,  444,  184,
  184,  205,  684, 1204,  881,  383, 1091,  296,  731,  192,
  711,  300,  875, 1061, 1357,  890,  961,  184,  863,  461,
  547,  548,  184,  190, 1107, 1133,    5,  876,  876,  761,
    2,  460,  580,  683,  301,  335,  661,  587, 1387, 1388,
  300,  640,  448, 1405,  186,  190,  640, 1206,  570,  572,
  640,  206, 1205, 1037, 1281,  297,  659,  617,  660,  436,
 1413,  994,  684,  301,  413,  640,  359,  509, 1133,  621,
 1164,  336,  701,  449,  703, 1176,  627,  942,  627,   82,
  959,  645,  960,  525,  298,  652,  190,  879, 1428,  922,
 1069, 1070,  640,  784, 1419,  922, 1062, 1072,  658,  660,
 1164,  668, 1134, 1311, 1312,  876, 1314,  676,  445,  103,
  446,  640,  208,  361,  678,  299,  666, 1333,   64,   64,
 1340, 1341,   64,  509,   18, 1223,  490,  875,  875, 1224,
  492,  300,  627,  449,  688, 1356,  490,  461,  732,  659,
  492,  660,  359,  517,  184, 1134,  853, 1165,  381,  359,
  337,  338,  518, 1040,  301,  705,  705,  251,  300,  252,
  298,  209, 1157, 1392,  447,  300,  659,  302,  660,  422,
  216,  643,  103,  813,  780,  873,  359, 1165, 1116, 1132,
  359,  301,  103,  359,  359,  359,  298,  902,  301,  713,
  359,  602,  622,  461,  360,  303,  362,  974, 1116, 1207,
   82,  363,  718,  364,  208,  875,  219,  300,  724,  365,
  366,  243,  886,  244,  245, 1393,  249,  602,  250,  686,
  455,  423, 1132,  465, 1163,  465,  261,  736,  262,  640,
  301,  638,  184,  300,   23,   32,  267,   34,  412,  269,
   35,  273, 1108,  302, 1135,   39,  284,  285, 1208,   43,
   82, 1136,  431,  209, 1163,  638,  301,  337,   46, 1196,
 1137,  766,  298,  475,   29,   51,  652,  301,  317,  302,
   53,  645, 1109,  298,   56,   82,  736,  215, 1138,  465,
  700,  640,  638,  647, 1246,  190,   58, 1135,   59, 1166,
  988,  216,   61, 1110, 1136,  184, 1167,  921,  791,  774,
   68,   69,  989, 1137,   72, 1168,  337,  274,  632,  300,
  203,  801,  639,  802,  103,  103,  184,  906,  300, 1166,
  300, 1138,  906, 1169,  906,  805, 1167,  906,  906,  184,
  906,  906,  301,  184,  220, 1168,  639,  300, 1024,  666,
  308,  301,  525,  301,  790,  302,  308,  525,  815,  100,
  652,  906,  582, 1169,  302,  309,  302,  103,   82,  103,
  301,  831,  832,  639, 1139,  803,  666,  999,  270,  187,
  184,  100,  207,  302,  270,  666,  100,  187,  807,  267,
 1025,  317,  850,  853,  427,  587,  491,  305,  308,  184,
  506,   82,  184,  344,  300,  344,  506,  460,  431,  587,
 1090,  877,  218,  383,  972,  906, 1034, 1139,  880, 1170,
  461,  280,  280, 1140,  344,  344,  270,  301,  888,  449,
  652,  746,  308,  491,  792,  301,  344,  462,  747,  344,
  280,  465,  792,  909,  344,  301,  921,  794,  909, 1170,
  909,  862,  344,  909,  909,  344,  909,  909,  702, 1068,
  270, 1020,  184,  732,  270,  491, 1140,  907, 1171,  909,
  532,  911,  502, 1021,  752,  502,  662,  909,  283,  503,
  184,  920,  503,  303,  600,  662,  307,  549,  550,  184,
  100,  504,  587,  320,  504,  587,  347,  587, 1171,  587,
  587,  587,  587,  587,  587,  587,  587,  587,  587,  587,
  281,  975,  330,  976,  652, 1048,  348,  441,  330,  281,
  587,  442,  587, 1344,  587,  331,  587,  587,  587,  350,
  388,  909, 1150, 1193,  356,  762,  900,  762,  927,  762,
 1193,  900,  587,  900,  341,  342,  900,  900,  688,  900,
  900,  661,  965,  587,  967,  344,  968,  349,  343,  344,
  661, 1227,  252,  280,  980,  587,  344, 1234,  902,  344,
  344,  353,  103,  902, 1240,  902,  339,  340,  902,  902,
  587,  902,  902,  344,  290, 1397,  290,  100,  977,  280,
  751,  290,  751,  383,  751,  427,  362,  618,  455,  280,
  180,  363,  180,  364,  180,  280,  385, 1006,  652,  365,
  366,  384,  896,  100,  192, 1013,  192,  896,  192,  896,
  920, 1416,  896,  896,  900,  896,  896,  345,  346,  359,
  100,  427, 1018,  359,  427,  344,  359,  659,  359,  828,
  829, 1433, 1434,  359,  640,  280,  344,   35,  280,  640,
  490,  603, 1044,  640,  492,  604,  902,  344,  192, 1047,
  608,  344,  608,  208,  980,  312, 1053,  635,  640,  301,
  924,  636,  644,  184,  344,  409,  442,  427,  704,  280,
  280,  410,  604,  337,  313,  314,  337,  490,  192, 1074,
  968,  492,  103,   65,  417,  640,  103,   65,  344,  344,
  896,  344,  344,   56,  315,  748,  344,  280,  280,  748,
  421,  744,  209,  744,  640,  316,  332,  333,  334,  490,
 1053, 1010, 1011,  492,  853,  429,  753,  184,  753,  103,
  103,  430, 1103,  103,  451,  168,  103,  168, 1115, 1131,
  349, 1406, 1407,  184,  349,  309,  344,  129, 1148,  129,
  427,  175,  456,  175,  129,  176,  459,  176, 1115,  476,
  853,  507,  853,  481,  423,  103,  423,  507,  495,  100,
    4,  553,  554,  555,  556,   67,  198,   67,  198,  169,
 1238,  169, 1131,  513, 1115,  423,  423,  134,  349,  134,
  875,  875, 1111, 1238,  295,  141,  295,  141,  184,  184,
  302,  301,  302, 1198,  519,  423,  184,  530,  530,  280,
 1289,  349, 1290,  423, 1115,  349,  423,  344,  349,  573,
  349,  640,  640, 1029, 1030,  349,  305,  184,  184,  629,
  184,  605,  100,  551,  552,  581, 1219,  557,  558,  607,
  619,  630,  100,  631,  633,  656,  634, 1111,  674, 1219,
  657,  184,  280,  672,  184, 1219,  677,  673,  675,  349,
  679,  680, 1219,  695,  681,  321,  682,  709, 1247,  698,
  697,  687,  708,  713,  720,  714, 1202, 1203,  288,  289,
  290,  291,  292,  293,  294,  295,  322,  323,  324,  325,
  326,  327,  328,  329,  330,  331,  723,  722,  729,  733,
 1230,  734,  737, 1233,   35,  757,  741,  750,   35,  758,
  759,  760,  767,  765,  764,  785,  763,  186,  786,   35,
  788,  795,  796,  808,   35,  781,  810,  797,   35,  819,
  824,   35,  826,  830,  833,  837, 1324,  836,  839,  840,
  280,  829,  846,   35,   35,  843,  848,  854,   35,   35,
  652, 1198,  867, 1351,   35,  868,   35,   35,   35,   35,
  869,  870,  427,  876,   35,  878, 1363, 1365,   35,  885,
   35,  445,  900,  892,  100,  100,  894,  905,  896, 1373,
   35,  898,   35,   35,  904,   35,  923,  932,  933,   35,
  924,  946,  939, 1351, 1351,  940,  941,  948,  945,  792,
  958,  966,  963,  280,  964,  983,   35,  971,  991,  992,
  987,  990,  652,  993,   35,   35, 1000,  100, 1009,  100,
 1014, 1005, 1027, 1073,  280, 1012, 1032,    4, 1040, 1036,
 1043,   47, 1051, 1038, 1050, 1076, 1062,  280, 1080, 1081,
 1089,  280,   47, 1078, 1082, 1090, 1094,   47,  652, 1351,
 1097,   47, 1106, 1098,   47, 1099, 1146, 1421, 1421, 1100,
 1177, 1102, 1154, 1149, 1429, 1429,   47,   47, 1151,  525,
  525,   47,   47, 1161, 1152,  591,  483,   47, 1179,   47,
   47,   47,   47, 1200, 1209, 1222, 1225,   47, 1236, 1239,
 1226,   47, 1242,   47, 1235, 1243, 1273,  280, 1245, 1275,
  280, 1276, 1278,   47, 1279, 1280,   47, 1282,   47, 1284,
 1286, 1287,   47,  483, 1292, 1307, 1297, 1300, 1315, 1304,
 1334, 1305, 1345, 1316, 1389,  544,  545,  546, 1319,   47,
  483,  483,  483,  483,  483,  483,  483,  483,  483,  483,
  483,  483,  483,  483,  483,  483, 1329, 1336, 1348, 1349,
 1346, 1355, 1372, 1393, 1359, 1358,   48, 1394,  591, 1370,
  280, 1375, 1377,  591, 1399,  591,  591,  591,  591,  591,
  591,  591,  591,  591,  591,  591, 1369, 1374, 1378, 1383,
 1390, 1398, 1408, 1392, 1414, 1435,  591,  280,  591,    8,
  591, 1415,  591,  591,  591, 1436, 1437,  829,  829,  541,
  729,  827,   31,  501,  797,  829,  829,  829,  829,  829,
  609,  829,  829,  502,  829,  829,  829,  829,  829,  829,
  829,  829,  100,  460,  610,   29,  829,   21,  829,  829,
  829,  829,  829,  829,  801,  500,  829,   29,  483,  322,
  829,  829,  526,  829,  829,  829,  591,  747,   30,  219,
  755,   95,  802,   30,  835,  829,  756,  829,  747,  829,
  829,  776,  804,  829,  777,  829,  829,  829,  829,  829,
  829,  829,  829,  829,  829,  829,  829,  673,  829,  806,
  661,  829,  829,  326,  683,  829,  829,  661,  351,  772,
  344,  640,  640,  189,  137,  193, 1249,   28,  119,  298,
  144,  829,  829,  829,  138,  120,  699,  829,  829,  299,
  145,  829,   19, 1016, 1155,  915,  829,  829,  829,  829,
  829,  835, 1391, 1017,  829, 1360,  829,  739, 1201, 1400,
 1347, 1342,  829,  829, 1376,  864, 1216, 1228, 1250, 1431,
  865, 1162,  100,  866, 1159,  859,  100, 1424, 1371, 1095,
 1366, 1364, 1423,  669, 1291, 1220, 1052,  829,  829,  829,
  829, 1096,  829,  884,  707,  773,  814,  520,  829,  749,
  949,  280,  812,  254,  559,  771,  560,  563, 1084,  100,
  100,  561,  564,  100,  562,  962,  100, 1251, 1252, 1253,
 1254, 1180, 1255, 1256, 1257, 1258, 1259, 1260, 1261, 1262,
  809, 1087, 1263, 1264, 1265, 1266, 1267, 1268, 1269, 1270,
 1039,  355, 1007,   48,  934,  100,  906,   48,  944,   48,
 1001,   48,  662,   48,  899,  280,   48, 1003,   48,   48,
  579,   48, 1178,   48,    0,   48,  996,   48,   48,   48,
   48,  280, 1075,   48,   48,    0,    0,    0,    0,   48,
   48,   48,   48,   48,    0,    0,   48,   48,   48,    0,
   48,   27,   48,   48,   48,   48,   48,   48,   48,   48,
    0,   48,   48,   48,   48,    0,    0,   48,   48,   48,
    0,   48,    0,    0,    0,    0,   48,   48,    0,   48,
   48,    0,   48,   48,   48,    0,  280,  280,   48,    0,
    0,    0,    0,    0,  280,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   48,    0,    0,    0,   48,
   48,    0,    0,    0,    0,  280,  280,    0,  280,   34,
    0,    0,   48,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  772,  772,    0,    0,  280,
    0,    0,  280,  772,  772,  772,  772,  772,    0,  772,
  772,    0,  772,  772,  772,  772,  772,  772,  772,    0,
    0,    0,  483,   48,  772,    0,  772,  772,  772,  772,
  772,  772,    0,    0,  772,    0,    0,    0,  772,  772,
    0,  772,  772,  772,    0,    0,    0,    0,   33,    0,
    0,    0,    0,  772,    0,  772,    0,  772,  772,    0,
    0,  772,    0,  772,  772,  772,  772,  772,  772,  772,
  772,  772,  772,  772,  772,    0,  772,    0,    0,  772,
  772,    0,    0,  772,  772,    0,    0,    0,    0,    0,
    0,   27,    0,    0,    0,    0,    0,    0,    0,  772,
  772,  772,    0,    0,    0,  772,  772,    0,    0,  772,
    0,    0,    0,    0,  772,  772,  772,  772,  772,    0,
    0,    0,  772,    0,  772,    0,    0,    0,    0,    0,
  772,  772,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  772,  772,  772,  772,    0,
  772,    0,    0,    0,   32,    0,  772,   27,   27,    0,
    0,    0,   27,    0,    0,    0,   27,    0,   27,    0,
    0,   27,    0,   27,   27,    0,   27,    0,   27,    0,
   27,    0,   27,   27,   27,   27,    0,    0,   27,   27,
    0,    0,    0,    0,   27,    0,   27,   27,   27,    0,
    0,   27,   27,   27,    0,   27,    0,    0,   27,    0,
   27,   27,   27,   27,    0,    0,    0,   27,   27,   27,
    0,    0,   27,   27,   27,    0,   34,  920,    0,    0,
   34,   27,   27,    0,   27,   27,    0,   27,   27,   27,
    0,   34,    0,   27,    0,    0,   34,    0,    0,    0,
   34,    0,    0,   34,    0,    0,    0,    0,    0,    0,
   27,    0,    0,    0,    0,   34,   34,    0,   27,   27,
   34,   34,    0,    0,    0,    0,   34,   27,   34,   34,
   34,   34,    0,    0,    0,    0,   34,    0,    0,    0,
   34,    0,   34,    0,   47,   33,    0,    0,    0,   33,
    0,    0,   34,    0,   34,   34,    0,   34,    0,    0,
   33,   34,    0,    0,    0,   33,    0,    0,   27,   33,
    0,    0,   33,    0,    0,    0,    0,    0,   34,    0,
    0,    0,    0,    0,   33,   33,    0,   34,   27,   33,
   33,    0,   27,    0,    0,   33,    0,   33,   33,   33,
   33,    0,    0,   27,    0,   33,    0,    0,   27,   33,
    0,   33,   27,    6,    0,   27,    0,    0,    0,    0,
    0,   33,    0,    0,   33,    0,   33,   27,   27,    0,
   33,    0,   27,   27,    0,    0,    0,    0,   27,    0,
   27,   27,   27,   27,    0,    0,    0,   33,   27,    0,
    0,    0,   27,    0,   27,   33,   33,    0,    0,    0,
    0,   32,    0,    0,   27,   32,    0,   27,    0,   27,
    0,    0,    0,   27,    0,    0,   32,    0,    0,    0,
  921,   32,    0,    0,    0,   32,    0,    0,   32,    0,
   27,    0,    0,    0,    0,    0,    0,    0,   27,   27,
   32,   32,    0,    0,    0,   32,   32,    0,    0,    0,
    0,   32,    0,   32,   32,   32,   32,    0,    0,    0,
    0,   32,    0,    0,    0,   32,    0,   32,    0,    0,
    0,    0,    0,    0,  920,    0,    0,   32,   47,    0,
   32,    0,   32,    0,    0,    0,   32,    0,    0,   47,
    0,    0,    0,    0,   47,    0,    0,    0,   47,    0,
    0,   47,    0,   32,    0,    0,    0,    0,    0,    0,
    0,    0,   32,   47,   47,    0,    0,    0,   47,   47,
    0,    0,    0,    0,   47,    0,   47,   47,   47,   47,
    0,    0,    0,    0,   47,    0,    0,    0,   47,    0,
   47,   47,    0,    0,    0,   47,    0,    0,    0,    0,
   47,    0,    0,   47,    0,   47,   47,    0,    0,   47,
    0,   47,    0,    0,    0,   47,    0,    0,   47,    0,
    0,    0,    0,    0,    0,    0,   47,    0,    0,    0,
   47,   47,    0,    0,    0,   47,   47,    0,    0,    0,
    0,   47,    0,   47,   47,   47,   47,    0,    0,    0,
    0,   47,    0,    0,    0,   47,    0,   47,    0,    0,
    6,    0,    0,    0,   48,    0,    0,   47,    0,    0,
   47,    0,   47,    0,    0,   48,   47,    0,    0,    0,
   48,    0,    0,    0,   48,    0,    0,   48,    0,    0,
    0,    0,    0,   47,    0,    0,    0,    0,    0,   48,
   48,    0,    0,    0,   48,   48,    0,    0,    0,    0,
   48,    0,   48,   48,   48,   48,    0,    0,    0,    0,
   48,    0,    0,    0,   48,    0,   48,  921,    0,    0,
    0,   47,    0,    0,    0,    0,   48,    0,    0,   48,
    0,   48,   47,    0,    0,   48,    0,   47,    0,    0,
    0,   47,    0,    0,   47,    0,    0,    0,    0,    0,
    0,    0,   48,    0,    0,    0,   47,   47,    0,  511,
    0,   47,   47,    0,  511,  511,    0,   47,    0,   47,
   47,   47,   47,    0,    0,    0,    0,   47,    0,    0,
    0,   47,    0,   47,    0,    0,    0,  511,    0,    0,
    0,    0,    0,   47,    0,    0,   47,  511,   47,    0,
  511,  511,   47,    0,    0,  511,    0,    0,  511,    0,
  511,    0,  511,  511,  511,  511,    0,    0,    0,   47,
  511,    0,    0,    0,  511,    0,    0,    0,  511,    0,
    0,    0,    0,    0,    0,    0,  511,    0,    0,  511,
    0,  511,  511,    0,    0,    0,    0,  511,    0,  511,
  511,  511,  511,  511,  511,  511,  511,  511,  511,  511,
    0,    0,  511,    0,    0,    0,    0,    0,    0,  511,
  511,    0,  511,  511,  511,  511,  511,  511,  511,    0,
  511,  511,    0,  511,  511,  511,  511,  511,  511,  511,
  511,  511,  511,    0,  511,  511,  511,  511,  511,  511,
  511,  511,  511,  511,  511,  511,  511,  511,  511,  511,
  511,  511,  511,  511,  511,  511,    0,    0,  511,    0,
  511,    0,  511,   30,    0,  511,    0,    0,    0,    0,
  511,   31,   32,   33,   34,    0,    0,   35,   36,    0,
   37,   38,   39,   40,   41,   42,   43,    0,    0,    0,
    0,    0,   44,    0,   45,   46,   47,   48,   49,   50,
    0,    0,   51,    0,    0,    0,   52,   53,    0,   54,
   55,   56,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   57,    0,   58,    0,   59,   60,    0,    0,   61,
    0,   62,   63,   64,   65,   66,   67,   68,   69,   70,
   71,   72,   73,    0,   74,    0,    0,   75,   76,    0,
    0,   77,   78,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  344,   79,   80,   81,
    0,  344,  344,   82,    0,    0,    0,   83,    0,    0,
    0,    0,   84,   85,   86,   87,   88,    0,    0,    0,
   89,    0,   90,    0,  344,    0,    0,    0,   91,   92,
    0,    0,    0,    0,  344,    0,    0,  344,  344,    0,
    0,    0,  344,    0,    0,  344,    0,  344,    0,  344,
  344,  344,  344,   93,   94,   95,   96,  344,    0,    0,
    0,  344,    0,    0,  186,  344,    0,    0,    0,    0,
    0,    0,    0,  344,    0,    0,  344,    0,  344,  344,
    0,    0,    0,    0,  344,    0,  344,  344,  344,  344,
  344,  344,  344,  344,  344,  344,  344,  344,    0,  344,
    0,    0,    0,    0,    0,    0,  344,  344,  344,  344,
  344,  344,  344,  344,  344,  344,    0,  344,  344,    0,
    0,  344,  344,  344,  344,  344,    0,    0,  344,  344,
    0,    0,    0,  344,  344,  344,  344,  344,  344,  344,
  344,  737,    0,    0,    0,    0,  737,  737,    0,    0,
    0,    0,  344,    0,    0,  344,    0,  344,    0,  344,
    0,    0,  344,    0,    0,    0,    0,  344,    0,  737,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  737,
    0,    0,  737,  737,    0,    0,    0,  737,    0,    0,
  737,    0,  737,    0,  737,  737,  737,  737,    0,    0,
    0,    0,  737,    0,    0,    0,  737,    0,    0,    0,
  737,    0,    0,    0,    0,    0,    0,    0,  737,    0,
    0,  737,    0,  737,  737,    0,    0,    0,    0,  737,
    0,  737,  737,  737,  737,  737,  737,  737,  737,  737,
  737,  737,    0,    0,  737,    0,    0,    0,    0,    0,
    0,  737,  737,  737,  737,  737,  737,    0,  737,  737,
  737,    0,  737,  737,    0,    0,  737,  737,  737,  737,
    0,    0,    0,  737,  737,    0,    0,    0,  737,  737,
  737,  737,  737,  737,  737,  737,  337,    0,    0,    0,
    0,  337,  337,    0,    0,    0,    0,  737,    0,    0,
  737,    0,  737,    0,  737,    0,    0,  737,    0,    0,
    0,    0,  737,    0,  337,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  337,    0,    0,  337,  337,    0,
    0,    0,  337,    0,    0,  337,    0,  337,    0,  337,
  337,  337,  337,    0,    0,    0,    0,  337,    0,    0,
    0,  337,    0,    0,    0,  337,    0,    0,    0,    0,
    0,    0,    0,  337,    0,    0,  337,    0,  337,  337,
    0,    0,  912,    0,  337,    0,  337,  337,  337,  337,
  337,  337,  337,  337,  337,  337,  337,    0,    0,  337,
    0,    0,    0,    0,    0,    0,  337,  337,  337,  337,
  337,  337,    0,  337,  337,  337,    0,  337,  337,  344,
    0,  337,  337,  337,  337,  344,    0,    0,  337,  337,
    0,    0,    0,  337,  337,  337,  337,  337,  337,  337,
  337,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  337,    0,    0,  337,    0,  337,    0,  337,
    0,  344,  337,    0,    0,  912,    0,  337,    0,    0,
  912,    0,  912,  912,  912,  912,  912,  912,  912,  912,
  912,  912,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  912,    0,  912,    0,  912,    0,  912,
  912,  912,  344,    0,    0,    0,    0,  344,    0,  344,
  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,
  344,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  344,  344,  344,  344,  344,  344,  344,  344,  344,    0,
  344,  344,    0,  344,  344,  344,  344,  344,  344,  344,
  344,  344,  344,  912,  344,  344,  344,  344,  344,  344,
  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,
  344,  344,  344,  344,  344,  344,    0,    0,  374,    0,
  344,    0,  344,  374,  374,  344,    0,    0,    0,    0,
  344,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  374,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  374,    0,    0,  374,
  374,    0,    0,    0,  374,    0,    0,  374,    0,  374,
    0,  374,  374,  374,  374,    0,    0,    0,    0,  374,
    0,    0,    0,  374,    0,    0,    0,  374,    0,    0,
    0,    0,    0,    0,    0,  374,    0,    0,  374,    0,
  374,  374,    0,    0,    0,    0,  374,    0,  374,  374,
  374,  374,  374,  374,  374,  374,  374,  374,  374,    0,
    0,  374,    0,    0,  513,    0,    0,    0,  374,  374,
  513,  374,  374,  374,    0,  374,  374,  374,    0,  374,
  374,    0,    0,  374,  374,  374,  374,    0,    0,    0,
  374,  374,    0,    0,    0,  374,  374,  374,  374,  374,
  374,  374,  374,    0,    0,    0,  513,    0,    0,    0,
    0,    0,    0,    0,  374,    0,    0,  374,    0,  374,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  374,
  344,    0,    0,    0,    0,    0,  344,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  513,    0,    0,
    0,    0,  513,    0,  513,  513,  513,  513,  513,  513,
  513,  513,  513,  513,  513,    0,    0,    0,    0,    0,
    0,    0,  344,    0,  513,  513,  513,  513,  513,  513,
  513,  513,  513,  513,    0,  513,  513,    0,  513,  513,
  513,  513,  513,  513,  513,  513,  513,  513,    0,  513,
  513,  513,  513,  513,  513,  513,  513,  513,  513,  513,
  513,  513,  513,  513,  513,  513,  513,  513,  513,  513,
  513,    0,  509,    0,    0,    0,    0,  513,  509,    0,
    0,    0,    0,    0,    0,  513,    0,    0,    0,    0,
    0,  344,    0,    0,  344,    0,  344,  344,    0,    0,
    0,  344,  344,    0,    0,  344,  344,  344,  344,  344,
  344,  344,  344,  344,  509,  344,  344,  344,  344,  344,
  344,  344,  344,  344,  344,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  344,  344,    0,    0,    0,
    0,    0,    0,  344,  344,    0,  344,    0,    0,    0,
    0,  344,    0,    0,    0,  509,    0,    0,    0,    0,
  509,    0,  509,  509,  509,  509,  509,  509,  509,  509,
  509,  509,  509,    0,    0,    0,    0,    0,    0,    0,
  344,    0,  509,  509,    0,  509,  509,  509,  509,  509,
  509,  509,    0,  509,  509,    0,  509,  509,  509,  509,
  509,  509,  509,  509,  509,  509,    0,  509,  509,  509,
  509,  509,  509,  509,  509,  509,  509,  509,  509,  509,
  509,  509,  509,  509,  509,  509,  509,  509,  509,    0,
  517,    0,    0,    0,    0,  509,  517,    0,  509,  344,
    0,    0,    0,  509,    0,    0,    0,    0,    0,    0,
  344,    0,  344,    0,  344,    0,    0,  344,    0,  344,
  344,    0,  344,  344,  344,  344,  344,  344,  344,  344,
  344,  344,  517,  344,  344,  344,  344,  344,  344,  344,
  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,
  344,  344,  344,  344,  344,    0,    0,    0,    0,  344,
    0,  344,  401,    0,  344,    0,    0,    0,    0,  344,
    0,    0,    0,  517,    0,    0,    0,    0,  517,    0,
  517,  517,  517,  517,  517,  517,  517,  517,  517,  517,
  517,    0,    0,    0,    0,    0,    0,    0,  401,    0,
    0,  517,    0,  517,  517,  517,  517,  517,  517,  517,
    0,  517,  517,    0,  517,  517,  517,  517,  517,  517,
  517,  517,  517,  517,    0,  517,  517,  517,  517,  517,
  517,  517,  517,  517,  517,  517,  517,  517,  517,  517,
  517,  517,  517,  517,  517,  517,  517,    0,  444,    0,
    0,    0,    0,  517,  444,    0,  517,    0,    0,    0,
    0,  517,    0,    0,    0,    0,    0,    0,  337,    0,
  401,  401,  401,  401,    0,  401,    0,  401,  401,    0,
  401,  401,  401,  401,  401,    0,  401,  401,  401,  401,
  444,  401,  401,  401,  401,  401,  401,  401,  401,  401,
  401,  401,  401,  401,  401,  401,  401,  401,  401,  401,
  401,  401,  401,    0,    0,    0,    0,  337,    0,  401,
  344,    0,  401,    0,    0,    0,    0,  401,    0,    0,
    0,  444,    0,    0,    0,    0,  444,    0,  444,  444,
  444,  444,  444,  444,  444,  444,  444,  444,  444,    0,
    0,    0,    0,    0,    0,    0,  344,    0,    0,  444,
    0,  444,  444,  444,  444,  444,  444,  444,    0,  444,
  444,    0,  444,  444,  444,  444,  444,  444,  444,  444,
  444,  444,    0,  444,  444,  444,  444,  444,  444,  444,
  444,  444,  444,  444,  444,  444,  444,  444,  444,  444,
  444,  444,  444,  444,  444,    0,  404,    0,    0,    0,
    0,  444,  404,    0,  444,    0,    0,    0,    0,  444,
    0,    0,    0,    0,    0,    0,    0,  344,  344,  344,
  344,  344,    0,    0,    0,  344,  344,    0,  344,  344,
  344,  344,  344,  344,  344,  344,  344,  344,  404,  344,
  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,
  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,
  344,    0,    0,    0,    0,    0,    0,  344,    0,    0,
  344,    0,    0,    0,    0,  344,    0,    0,    0,  404,
    0,    0,    0,    0,  404,    0,  404,  404,  404,  404,
  404,  404,  404,  404,  404,  404,  404,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  404,    0,  404,
  404,  404,  404,  404,  404,  404,    0,  404,    0,    0,
  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
    0,  404,  404,  404,  404,  404,  404,  404,  404,  404,
  404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
  404,  404,  404,    0,  546,  499,    0,    0,    0,  404,
  546,    0,  404,    0,   32,    0,   34,  404,    0,   35,
    0,    0,    0,    0,   39,    0,    0,    0,   43,    0,
    0,    0,    0,    0,    0,    0,    0,   46,    0,    0,
    0,    0,    0,    0,   51,    0,  546,    0,    0,   53,
    0,    0,    0,   56,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   58,    0,   59,    0,    0,
    0,   61,    0,    0,    0,    0,    0,    0,    0,   68,
   69,    0,    0,   72,    0,    0,  274,  546,    0,    0,
    0,  589,  546,    0,  546,  546,  546,  546,  546,  546,
  546,  546,  546,  546,  546,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  546,    0,  546,    0,  546,
    0,  546,  546,  546,    0,  546,  546,    0,  546,  546,
  546,  546,  546,  546,  546,  546,  546,  546,    0,    0,
    0,  546,  546,  546,  546,  546,  546,  546,  546,  546,
  546,  546,  546,  546,  546,  546,  546,  546,  546,  344,
  546,    0,    0,    0,    0,  344,  305,    0,    0,    0,
    0,    0,    0,    0,  589,  546,    0,    0,    0,  589,
    0,  589,  589,  589,  589,  589,  589,  589,  589,  589,
  589,  589,    0,    0,    0,    0,    0,  344,    0,    0,
    0,  344,  589,    0,  589,    0,  589,    0,  589,  589,
  589,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  589,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  344,    0,    0,    0,    0,  344,    0,  344,
  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,
  344,    0,  589,    0,    0,    0,    0,    0,    0,  344,
  344,  344,  344,  344,  344,  344,  344,  344,  344,    0,
  344,  344,    0,    0,  344,  344,  344,  344,  344,  369,
    0,  344,  344,  366,    0,  369,  344,  344,  344,  344,
  344,  344,  344,  344,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  344,  366,    0,  344,    0,
  344,    0,  344,    0,    0,  344,    0,  369,    0,  366,
  344,  369,    0,    0,  366,    0,    0,  243,    0,  366,
    0,  366,  366,  366,  366,    0,    0,    0,    0,  366,
    0,    0,    0,  366,    0,    0,    0,  366,    0,    0,
    0,    0,    0,    0,    0,  366,    0,    0,  366,    0,
  366,    0,  369,    0,    0,    0,    0,  369,    0,  369,
  369,  369,  369,  369,  369,  369,  369,  369,  369,  369,
    0,  366,  558,    0,    0,    0,    0,    0,  558,  369,
  369,    0,  369,  369,  369,    0,  369,  369,  369,    0,
  369,  369,    0,    0,  369,  369,  369,  369,    0,    0,
    0,  369,  369,    0,    0,    0,  369,  369,  369,  369,
  369,  369,  369,  369,  558,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  369,    0,    0,  369,  366,
  369,    0,    0,    0,    0,    0,    0,    0,    0,  562,
  369,    0,    0,    0,    0,  562,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  558,    0,    0,    0,    0,
  558,    0,  558,  558,  558,  558,  558,  558,  558,  558,
  558,  558,  558,    0,    0,    0,    0,    0,    0,    0,
    0,  562,    0,  558,    0,  558,    0,  558,    0,  558,
  558,  558,    0,  558,  558,    0,    0,  558,  558,  558,
  558,  558,  558,  558,  558,  558,    0,    0,    0,  558,
  558,  558,  558,  558,  558,  558,  558,    0,    0,    0,
    0,    0,  562,    0,    0,    0,    0,  562,  558,  562,
  562,  562,  562,  562,  562,  562,  562,  562,  562,  562,
    0,    0,  565,  558,    0,    0,    0,    0,  565,    0,
  562,   47,  562,   47,  562,    0,  562,  562,  562,    0,
  562,  562,    0,    0,  562,  562,  562,  562,    0,    0,
    0,  562,  562,    0,   47,    0,  562,  562,  562,  562,
  562,  562,  562,  562,  565,    0,    0,   47,    0,    0,
    0,    0,   47,    0,    0,  562,    0,   47,    0,   47,
   47,   47,   47,    0,    0,   47,    0,   47,    0,  563,
  562,   47,    0,    0,    0,  563,    0,    0,    0,    0,
    0,    0,    0,   47,    0,  565,   47,    0,   47,    0,
  565,    0,  565,  565,  565,  565,  565,  565,  565,  565,
  565,  565,  565,    0,    0,    0,    0,    0,    0,   47,
    0,  563,    0,  565,    0,  565,    0,  565,    0,  565,
  565,  565,    0,  565,  565,    0,    0,  565,  565,  565,
  565,    0,    0,    0,  565,  565,    0,    0,    0,  565,
  565,  565,  565,  565,  565,  565,  565,    0,    0,    0,
    0,    0,  563,    0,    0,    0,    0,  563,  565,  563,
  563,  563,  563,  563,  563,  563,  563,  563,  563,  563,
    0,    0,  564,  565,    0,    0,    0,    0,  564,    0,
  563,  389,  563,    0,  563,    0,  563,  563,  563,    0,
  563,  563,    0,    0,  563,  563,  563,  563,    0,    0,
    0,  563,  563,    0,  390,    0,  563,  563,  563,  563,
  563,  563,  563,  563,  564,    0,    0,  391,    0,    0,
    0,  392,  393,    0,    0,  563,    0,  394,    0,  395,
  396,  397,  398,    0,    0,    0,    0,  399,    0,  568,
  563,  400,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  401,    0,  564,  402,    0,  403,    0,
  564,    0,  564,  564,  564,  564,  564,  564,  564,  564,
  564,  564,  564,    0,    0,    0,    0,    0,    0,  404,
    0,    0,    0,  564,    0,  564,    0,  564,    0,  564,
  564,  564,    0,  564,  564,    0,    0,  564,  564,  564,
  564,    0,    0,    0,  564,  564,  569,    0,    0,  564,
  564,  564,  564,  564,  564,  564,  564,    0,    0,    0,
    0,    0,  568,    0,    0,    0,    0,  568,  564,  568,
  568,  568,  568,  568,  568,  568,  568,  568,  568,  568,
    0,    0,    0,  564,    0,    0,    0,    0,    0,    0,
  568,    0,  568,    0,  568,    0,  568,  568,  568,    0,
    0,    0,    0,    0,  568,  568,  568,  568,    0,    0,
    0,  568,  568,  570,    0,    0,  568,  568,  568,  568,
  568,  568,  568,  568,    0,    0,    0,    0,    0,  569,
    0,    0,    0,    0,  569,  568,  569,  569,  569,  569,
  569,  569,  569,  569,  569,  569,  569,    0,    0,    0,
  568,    0,    0,    0,    0,    0,    0,  569,    0,  569,
    0,  569,    0,  569,  569,  569,    0,    0,    0,    0,
    0,  569,  569,  569,  569,    0,    0,    0,  569,  569,
  571,    0,    0,  569,  569,  569,  569,  569,  569,  569,
  569,    0,    0,    0,    0,    0,  570,    0,    0,    0,
    0,  570,  569,  570,  570,  570,  570,  570,  570,  570,
  570,  570,  570,  570,    0,    0,    0,  569,    0,    0,
    0,    0,    0,    0,  570,    0,  570,    0,  570,    0,
  570,  570,  570,    0,    0,    0,    0,    0,  570,  570,
  570,  570,    0,    0,    0,  570,  570,  572,    0,    0,
  570,  570,  570,  570,  570,  570,  570,  570,    0,    0,
    0,    0,    0,  571,    0,    0,    0,    0,  571,  570,
  571,  571,  571,  571,  571,  571,  571,  571,  571,  571,
  571,    0,    0,    0,  570,    0,    0,    0,    0,    0,
    0,  571,    0,  571,    0,  571,    0,  571,  571,  571,
    0,    0,    0,    0,    0,  571,  571,  571,  571,    0,
    0,    0,  571,  571,  573,    0,    0,    0,    0,  571,
  571,  571,  571,  571,  571,    0,    0,    0,    0,    0,
  572,    0,    0,    0,    0,  572,  571,  572,  572,  572,
  572,  572,  572,  572,  572,  572,  572,  572,    0,    0,
    0,  571,    0,    0,    0,    0,    0,    0,  572,    0,
  572,    0,  572,    0,  572,  572,  572,    0,    0,    0,
    0,    0,  572,  572,  572,  572,    0,    0,    0,  572,
  572,  574,    0,    0,    0,    0,  572,  572,  572,  572,
  572,  572,    0,    0,    0,    0,    0,  573,    0,    0,
    0,    0,  573,  572,  573,  573,  573,  573,  573,  573,
  573,  573,  573,  573,  573,    0,    0,    0,  572,    0,
    0,    0,    0,    0,    0,  573,    0,  573,    0,  573,
    0,  573,  573,  573,    0,    0,    0,    0,    0,  573,
  573,  573,  573,    0,    0,    0,  573,  573,  575,    0,
    0,    0,    0,  573,  573,  573,  573,  573,  573,    0,
    0,    0,    0,    0,  574,    0,    0,    0,    0,  574,
  573,  574,  574,  574,  574,  574,  574,  574,  574,  574,
  574,  574,    0,    0,    0,  573,    0,    0,    0,    0,
    0,    0,  574,    0,  574,    0,  574,    0,  574,  574,
  574,    0,    0,    0,    0,    0,  574,  574,  574,  574,
    0,    0,    0,  574,  574,  576,    0,    0,    0,    0,
  574,  574,  574,  574,  574,  574,    0,    0,    0,    0,
    0,  575,    0,    0,    0,    0,  575,  574,  575,  575,
  575,  575,  575,  575,  575,  575,  575,  575,  575,    0,
    0,    0,  574,    0,    0,    0,    0,    0,    0,  575,
    0,  575,    0,  575,    0,  575,  575,  575,    0,    0,
    0,    0,    0,  575,  575,  575,  575,    0,    0,    0,
  575,  575,  577,    0,    0,    0,    0,  575,  575,  575,
  575,  575,  575,    0,    0,    0,    0,    0,  576,    0,
    0,    0,    0,  576,  575,  576,  576,  576,  576,  576,
  576,  576,  576,  576,  576,  576,    0,    0,    0,  575,
    0,    0,    0,    0,    0,    0,  576,    0,  576,    0,
  576,    0,  576,  576,  576,    0,    0,    0,    0,    0,
    0,    0,  576,  576,    0,    0,    0,  576,  576,  578,
    0,    0,    0,    0,    0,    0,  576,  576,  576,  576,
    0,    0,    0,    0,    0,  577,    0,    0,    0,    0,
  577,  576,  577,  577,  577,  577,  577,  577,  577,  577,
  577,  577,  577,    0,    0,    0,  576,    0,    0,    0,
    0,    0,    0,  577,    0,  577,    0,  577,    0,  577,
  577,  577,    0,    0,    0,    0,    0,    0,    0,  577,
  577,    0,    0,    0,  577,  577,  579,    0,    0,    0,
    0,    0,    0,  577,  577,  577,  577,    0,    0,    0,
    0,    0,  578,    0,    0,    0,    0,  578,  577,  578,
  578,  578,  578,  578,  578,  578,  578,  578,  578,  578,
    0,    0,    0,  577,    0,    0,    0,    0,    0,    0,
  578,    0,  578,    0,  578,    0,  578,  578,  578,    0,
    0,    0,    0,    0,    0,    0,  578,  578,    0,    0,
    0,  578,  578,  580,    0,    0,    0,    0,    0,    0,
  578,  578,  578,  578,    0,    0,    0,    0,    0,  579,
    0,    0,    0,    0,  579,  578,  579,  579,  579,  579,
  579,  579,  579,  579,  579,  579,  579,    0,    0,    0,
  578,    0,    0,    0,    0,    0,    0,  579,    0,  579,
    0,  579,    0,  579,  579,  579,    0,    0,    0,    0,
    0,    0,    0,  579,  579,    0,    0,    0,  579,  579,
  581,    0,    0,    0,    0,    0,    0,    0,    0,  579,
  579,    0,    0,    0,    0,    0,  580,    0,    0,    0,
    0,  580,  579,  580,  580,  580,  580,  580,  580,  580,
  580,  580,  580,  580,    0,    0,    0,  579,    0,    0,
    0,    0,    0,    0,  580,    0,  580,    0,  580,    0,
  580,  580,  580,    0,    0,    0,    0,    0,    0,    0,
  580,  580,    0,    0,    0,  580,  580,  582,    0,    0,
    0,    0,    0,    0,    0,    0,  580,  580,    0,    0,
    0,    0,    0,  581,    0,    0,    0,    0,  581,  580,
  581,  581,  581,  581,  581,  581,  581,  581,  581,  581,
  581,    0,    0,    0,  580,    0,    0,    0,    0,    0,
    0,  581,    0,  581,    0,  581,    0,  581,  581,  581,
    0,    0,    0,    0,    0,    0,    0,    0,  581,    0,
    0,    0,  581,  581,  583,    0,    0,    0,    0,    0,
    0,    0,    0,  581,  581,    0,    0,    0,    0,    0,
  582,    0,    0,    0,    0,  582,  581,  582,  582,  582,
  582,  582,  582,  582,  582,  582,  582,  582,    0,    0,
    0,  581,    0,    0,    0,    0,    0,    0,  582,    0,
  582,    0,  582,    0,  582,  582,  582,    0,    0,    0,
    0,    0,    0,    0,    0,  582,    0,    0,    0,  582,
  582,  584,    0,    0,    0,    0,    0,    0,    0,    0,
  582,  582,    0,    0,    0,    0,    0,  583,    0,    0,
    0,    0,  583,  582,  583,  583,  583,  583,  583,  583,
  583,  583,  583,  583,  583,    0,    0,    0,  582,    0,
    0,    0,    0,    0,    0,  583,    0,  583,    0,  583,
    0,  583,  583,  583,    0,    0,    0,    0,    0,    0,
    0,    0,  583,    0,    0,    0,    0,  583,  585,    0,
    0,    0,    0,    0,    0,    0,    0,  583,  583,    0,
    0,    0,    0,    0,  584,    0,    0,    0,    0,  584,
  583,  584,  584,  584,  584,  584,  584,  584,  584,  584,
  584,  584,    0,    0,    0,  583,    0,    0,    0,    0,
    0,    0,  584,    0,  584,    0,  584,    0,  584,  584,
  584,    0,    0,    0,    0,    0,    0,    0,    0,  584,
    0,    0,    0,    0,  584,  586,    0,    0,    0,    0,
    0,    0,    0,    0,  584,  584,    0,    0,    0,    0,
    0,  585,    0,    0,    0,    0,  585,  584,  585,  585,
  585,  585,  585,  585,  585,  585,  585,  585,  585,    0,
    0,    0,  584,    0,    0,    0,    0,    0,    0,  585,
    0,  585,    0,  585,    0,  585,  585,  585,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  585,  588,    0,    0,    0,    0,    0,    0,    0,
    0,  585,  585,    0,    0,    0,    0,    0,  586,    0,
    0,    0,    0,  586,  585,  586,  586,  586,  586,  586,
  586,  586,  586,  586,  586,  586,    0,    0,    0,  585,
    0,    0,    0,    0,    0,    0,  586,    0,  586,    0,
  586,    0,  586,  586,  586,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  586,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  586,  586,
    0,    0,    0,    0,    0,  588,    0,    0,    0,    0,
  588,  586,  588,  588,  588,  588,  588,  588,  588,  588,
  588,  588,  588,    0,    0,    0,  586,    0,    0,    0,
    0,    0,    0,  588,    0,  588,    0,  588,    0,  588,
  588,  588,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   30,    0,  588,    0,    0,    0,    0,
    0,   31,   32,   33,   34,    0,  588,   35,   36,    0,
   37,   38,   39,   40,   41,   42,   43,    0,  588,    0,
    0,    0,   44,    0,   45,   46,   47,   48,   49,   50,
    0,    0,   51,  588,    0,    0,   52,   53,    0,   54,
   55,   56,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   57,    0,   58,    0,   59,   60,    0,    0,   61,
    0,   62,   63,   64,   65,   66,   67,   68,   69,   70,
   71,   72,   73,    0,   74,    0,    0,   75,   76,    0,
    0,   77,   78,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   79,   80,   81,
    0,    0,    0,   82,    0,    0,    0,   83,    0,    0,
    0,    0,   84,   85,   86,   87,   88,    0,    0,    0,
   89,    0,   90,    0,    0,    0,    0,    0,   91,   92,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  223,
    0,    0,    0,   93,   94,   95,   96,   31,   32,   33,
   34,    0,    0,   35,   36,    0,   37,   38,   39,   40,
   41,   42,   43,    0,    0,    0,    0,    0,   44,    0,
   45,   46,   47,   48,   49,   50,    0,    0,   51,    0,
    0,    0,   52,   53,    0,   54,   55,   56,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   57,    0,   58,
    0,   59,   60,    0,    0,   61,    0,   62,   63,   64,
   65,   66,   67,   68,   69,   70,   71,   72,   73,    0,
   74,    0,    0,   75,   76,    0,    0,   77,   78,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   79,   80,   81,    0,    0,    0,   82,
    0,    0,    0,   83,    0,    0,    0,    0,   84,   85,
   86,   87,   88,    0,    0,    0,   89,    0,   90,    0,
    0,    0,    0,    0,   91,   92,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  486,    0,    0,    0,   93,
   94,   95,   96,   31,   32,   33,   34,    0,    0,   35,
   36,    0,   37,   38,   39,   40,   41,   42,   43,    0,
    0,    0,    0,    0,   44,    0,   45,   46,   47,   48,
   49,   50,    0,    0,   51,    0,    0,    0,   52,   53,
    0,   54,   55,   56,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   57,    0,   58,    0,   59,   60,    0,
    0,   61,    0,   62,   63,   64,   65,   66,   67,   68,
   69,   70,   71,   72,   73,    0,   74,    0,    0,   75,
   76,    0,    0,   77,   78,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   79,
   80,   81,    0,    0,    0,   82,    0,    0,    0,   83,
    0,    0,    0,    0,   84,   85,   86,   87,   88,    0,
    0,    0,   89,    0,   90,    0,    0,    0,    0,    0,
   91,   92,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  917,    0,    0,    0,   93,   94,   95,   96,  917,
  917,  917,  917,    0,    0,  917,  917,    0,  917,  917,
  917,  917,  917,  917,  917,    0,    0,    0,    0,    0,
  917,    0,  917,  917,  917,  917,  917,  917,    0,    0,
  917,    0,    0,    0,  917,  917,    0,  917,  917,  917,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  917,
    0,  917,    0,  917,  917,    0,    0,  917,    0,  917,
  917,  917,  917,  917,  917,  917,  917,  917,  917,  917,
  917,    0,  917,    0,    0,  917,  917,    0,    0,  917,
  917,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  917,  917,  917,    0,    0,
    0,  917,    0,    0,    0,  917,    0,    0,    0,    0,
  917,  917,  917,  917,  917,    0,    0,    0,  917,    0,
  917,    0,    0,    0,    0,    0,  917,  917,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  781,    0,    0,
    0,  917,  917,  917,  917,  781,  781,  781,  781,    0,
    0,  781,  781,    0,  781,  781,  781,  781,  781,  781,
  781,    0,    0,    0,    0,    0,  781,    0,  781,  781,
  781,  781,  781,  781,    0,    0,  781,    0,    0,    0,
  781,  781,    0,  781,  781,  781,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  781,    0,  781,    0,  781,
  781,    0,    0,  781,    0,  781,  781,  781,  781,  781,
  781,  781,  781,  781,  781,  781,  781,    0,  781,    0,
    0,  781,  781,    0,    0,  781,  781,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  781,  781,  781,    0,    0,    0,  781,    0,    0,
    0,  781,    0,    0,    0,    0,  781,  781,  781,  781,
  781,    0,    0,    0,  781,    0,  781,    0,    0,    0,
    0,    0,  781,  781,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  650,    0,    0,    0,  781,  781,  781,
  781,   31,   32,    0,   34,    0,    0,   35,  212,    0,
  663,    0,   39,   40,   41,    0,   43,    0,    0,   32,
    0,   34,   44,    0,   35,   46,    0,    0,    0,   39,
    0,    0,   51,   43,    0,    0,    0,   53,    0,   54,
   55,   56,   46,    0,    0,    0,    0,    0,    0,   51,
    0,    0,    0,   58,   53,   59,   60,    0,   56,   61,
    0,    0,   63,    0,   65,    0,   67,   68,   69,  213,
   58,   72,   59,    0,    0,    0,   61,    0,   76,    0,
    0,   77,   78,    0,   68,   69,    0,    0,   72,    0,
    0,  664,    0,    0,    0,    0,    0,   79,   80,   81,
    0,    0,    0,  451,  651,    0,    0,   83,    0,    0,
    0,    0,    0,   85,   86,   87,   88,    0,    0,    0,
   89,    0,   90,    0,    0,    0,    0,    0,   91,   92,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  650,
    0,    0,    0,   93,  256,   95,   96,   31,   32,    0,
   34,    0,    0,   35,  212,    0,  789,    0,   39,   40,
   41,  665,   43,    0,    0,   32,    0,   34,   44,    0,
   35,   46,    0,    0,    0,   39,    0,    0,   51,   43,
    0,    0,    0,   53,    0,   54,   55,   56,   46,    0,
    0,    0,    0,    0,    0,   51,    0,    0,    0,   58,
   53,   59,   60,  816,   56,   61,    0,    0,   63,    0,
   65,    0,   67,   68,   69,  213,   58,   72,   59,    0,
    0,    0,   61,    0,   76,    0,    0,   77,   78,    0,
   68,   69,    0,    0,   72,    0,    0,  274,    0,    0,
    0,    0,    0,   79,   80,   81,    0,    0,    0,  451,
    0,    0,    0,   83,    0,    0,    0,    0,    0,   85,
   86,   87,   88,    0,    0,    0,   89,    0,   90,    0,
    0,    0,    0,    0,   91,   92,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  620,    0,    0,    0,   93,
  256,   95,   96,   31,   32,    0,   34,    0,    0,   35,
  212,    0,  926,    0,   39,   40,   41,  305,   43,    0,
    0,   32,    0,   34,   44,    0,   35,   46,    0,    0,
    0,   39,    0,    0,   51,   43,    0,    0,    0,   53,
    0,   54,   55,   56,   46,    0,    0,    0,    0,    0,
    0,   51,    0,    0,    0,   58,   53,   59,   60,    0,
   56,   61,    0,    0,   63,    0,   65,    0,   67,   68,
   69,  213,   58,   72,   59,    0,   74,    0,   61,    0,
   76,    0,    0,   77,   78,    0,   68,   69,    0,    0,
   72,    0,    0,  274,    0,    0,    0,    0,    0,   79,
   80,   81,    0,    0,    0,    0,    0,    0,    0,   83,
    0,    0,    0,    0,    0,   85,   86,   87,   88,    0,
    0,    0,   89,    0,   90,    0,    0,    0,    0,    0,
   91,   92,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  650,    0,    0,    0,   93,  256,   95,   96,   31,
   32,    0,   34,    0,    0,   35,  212,    0, 1057,    0,
   39,   40,   41,  305,   43,    0,    0,   32,    0,   34,
   44,    0,   35,   46,    0,    0,    0,   39,    0,    0,
   51,   43,    0,    0,    0,   53,    0,   54,   55,   56,
   46,    0,    0,    0,    0,    0,    0,   51,    0,    0,
    0,   58,   53,   59,   60,    0,   56,   61,    0,    0,
   63,    0,   65,    0,   67,   68,   69,  213,   58,   72,
   59,    0,    0,    0,   61,    0,   76,    0,    0,   77,
   78,    0,   68,   69,    0,    0,   72,    0,    0,  274,
    0,    0,    0,    0,    0,   79,   80,   81,    0,    0,
    0,  451,    0,    0,    0,   83,    0,    0,    0,    0,
    0,   85,   86,   87,   88,    0,    0,    0,   89,    0,
   90,    0,    0,    0,    0,    0,   91,   92,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  804,    0,    0,
    0,   93,  256,   95,   96,   31,   32,    0,   34,    0,
    0,   35,  212,    0,    0,    0,   39,   40,   41,  305,
   43,    0,    0,   32,    0,   34,   44,    0,   35,   46,
    0,    0,    0,   39,    0,    0,   51,   43,    0,    0,
    0,   53,    0,   54,   55,   56,   46,    0,    0,    0,
    0,    0,    0,   51,    0,    0,    0,   58,   53,   59,
   60,    0,   56,   61,    0,    0,   63,    0,   65,    0,
   67,   68,   69,  213,   58,   72,   59,    0,    0,    0,
   61,    0,   76,    0,    0,   77,   78,    0,   68,   69,
    0,    0,   72,    0,    0,  274,    0,    0,    0,    0,
    0,   79,   80,   81,    0,    0,    0,    0,    0,    0,
    0,   83,    0,    0,    0,    0,    0,   85,   86,   87,
   88,    0,    0,    0,   89,    0,   90,    0,    0,    0,
    0,    0,   91,   92,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  613,    0,    0,    0,   93,  256,   95,
   96,  613,  613,    0,  613,    0,    0,  613,  613,    0,
    0,    0,  613,  613,  613,  275,  613,    0,    0,   32,
    0,   34,  613,    0,   35,  613,    0,    0,    0,   39,
    0,    0,  613,   43,    0,    0,    0,  613,    0,  613,
  613,  613,   46,    0,    0,    0,    0,    0,    0,   51,
    0,    0,    0,  613,   53,  613,  613,    0,   56,  613,
    0,    0,  613,    0,  613,    0,  613,  613,  613,  613,
   58,  613,   59,    0,    0,    0,   61,    0,  613,    0,
    0,  613,  613,    0,   68,   69,    0,    0,   72,    0,
    0,  274,    0,    0,    0,    0,    0,  613,  613,  613,
    0,    0,    0,    0,    0,    0,    0,  613,    0,    0,
    0,    0,    0,  613,  613,  613,  613,    0,    0,    0,
  613,    0,  613,    0,    0,    0,    0,    0,  613,  613,
    0,    0,    0,    0,    0,    0,   31,   32,    0,   34,
    0,    0,   35,  212,    0,    0,    0,   39,   40,   41,
    0,   43,    0,  613,  613,  613,  613,   44,    0,    0,
   46,    0,    0,    0,    0,    0,    0,   51,    0,    0,
    0,  281,   53,    0,   54,   55,   56,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   58,    0,
   59,   60,    0,    0,   61,    0,    0,   63,    0,   65,
    0,   67,   68,   69,  213,    0,   72,    0,    0,    0,
    0,    0,    0,   76,    0,    0,   77,   78,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   79,   80,   81,    0,    0,    0,  637,  883,
    0,    0,   83,    0,    0,    0,    0,    0,   85,   86,
   87,   88,    0,    0,    0,   89,    0,   90,    0,    0,
    0,    0,    0,   91,   92,    0,    0,    0,    0,    0,
    0,   31,   32,    0,   34,    0,    0,   35,  212,    0,
    0,    0,   39,   40,   41,    0,   43,    0,   93,  638,
   95,   96,   44,    0,    0,   46,    0,    0,  639,    0,
    0,    0,   51,    0,    0,    0,    0,   53,    0,   54,
   55,   56,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   58,    0,   59,   60,    0,    0,   61,
    0,    0,   63,    0,   65,    0,   67,   68,   69,  213,
    0,   72,    0,    0,    0,    0,    0,    0,   76,    0,
    0,   77,   78,    0,    0,  389,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   79,   80,   81,
    0,    0,    0,  637,    0,    0,    0,   83,  390,    0,
    0,    0,    0,   85,   86,   87,   88,    0,    0,    0,
   89,  391,   90,    0,    0,    0,  393,    0,   91,   92,
    0,  394,    0,  395,  396,  397,  398,    0,    0,    0,
    0,  399,    0,    0,    0,  400,    0,    0,    0, 1212,
  434,    0,  344,   93,  638,   95,   96,  401,   31,   32,
  402,   34,  403,  639,   35,  212,    0,    0,    0,   39,
   40,   41,    0,   43,    0,    0,    0,    0,    0,   44,
    0,    0,   46,  404,    0,    0,    0,    0,  344,   51,
    0,    0,    0,    0,   53,    0,   54,   55,   56,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   58,    0,   59,   60,    0,    0,   61,    0,    0,   63,
    0,   65,    0,   67,   68,   69,  213,    0,   72,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1213,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   79,   80,   81,    0,    0,    0,
  344,  344,  344,  344,   83,    0,    0,  344,  344,    0,
    0,  344,  344,  344,  344,  344,  344,  344,  344,  344,
    0,  344,  344,  344,  344,  344,  344,  344,  344,  344,
  344,  344,  344,  344,  344,  344,  344,  344,  344,  344,
  344,  344,  344,    0,    0,    0,    0,    0,    0,  344,
   93,  435,  344,   47,    0,    0,    0,   47,    0,   47,
    0,    0,   47,    0,   47,   47,    0,   47,    0,   47,
    0,   47,    0,   47,   47,   47,   47,    0,    0,   47,
   47,    0,    0,    0,    0,   47,    0,   47,   47,   47,
    0,    0,   47,    0,   47,    0,   47,    0,    0,   47,
    0,   47,   47,   47,   47,    0,    0,    0,   47,   47,
   47,    0,    0,   47,   47,   47,    0,    0,    0,    0,
    0,    0,   47,   47,    0,   47,   47,    0,   47,   47,
   47,    0,    0,    0,   47,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   47,    0,    0,    0,   47,    0,
   47,   47,    0,   47,    0,   47,   47,    0,   47,   80,
   47,    0,   47,    0,   47,   47,   47,   47,   47,    0,
   47,   47,    0,    0,    0,    0,   47,    0,   47,   47,
   47,    0,    0,   47,    0,   47,    0,   47,    0,    0,
   47,    0,   47,   47,   47,   47,    0,    0,    0,   47,
   47,   47,    0,    0,   47,   47,   47,    0,    0,   47,
    0,    0,    0,   47,   47,    0,   47,   47,    0,   47,
   47,   47,    0,    0,    0,   47,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   47,    0,    0,    0,   47,
    0,   47,   47,    0,   47,    0,   47,   47,    0,   47,
   81,   47,    0,   47,    0,   47,   47,   47,   47,   47,
    0,   47,   47,    0,    0,    0,    0,   47,    0,   47,
   47,   47,    0,    0,   47,    0,   47,    0,   47,    0,
    0,   47,    0,   47,   47,   47,   47,    0,    0,    0,
   47,   47,   47,    0,    0,   47,   47,   47,    0,    0,
   47,    0,    0,    0,   47,   47,    0,   47,   47,    0,
   47,   47,   47,    0,    0,    0,   47,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   47,    0,    0,    0,
   47,    0,   47,   47,    0,   47,    0,   47,   47,    0,
   47,  103,   47,    0,   47,    0,   47,   47,   47,   47,
   47,    0,   47,   47,    0,    0,    0,    0,   47,    0,
   47,   47,   47,    0,    0,   47,    0,   47,    0,   47,
    0,    0,   47,    0,   47,   47,   47,   47,    0,    0,
    0,   47,   47,   47,    0,    0,   47,   47,   47,    0,
    0,   47,    0,    0,    0,   47,   47,    0,   47,   47,
    0,   47,   47,   47,    0,    0,    0,   47,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   47,    0,    0,
    0,   47,    0,   47,   47,    0,   47,    0,   47,   47,
    0,   47,  104,   47,    0,   47,    0,   47,   47,   47,
   47,   47,    0,   47,   47,    0,    0,    0,    0,   47,
    0,   47,   47,   47,    0,    0,   47,    0,   47,    0,
   47,    0,    0,   47,    0,   47,   47,   47,   47,    0,
    0,    0,   47,   47,   47,    0,    0,   47,   47,   47,
    0,    0,   47,    0,    0,    0,   47,   47,    0,   47,
   47,    0,   47,   47,   47,    0,    0,    0,   47,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   47,    0,
    0,    0,   47,    0,   47,   47,    0,   47,    0,   47,
   47,    0,   47,  225,   47,    0,   47,    0,   47,   47,
   47,   47,    0,    0,   47,   47,    0,    0,    0,    0,
   47,    0,   47,   47,   47,    0,    0,   47,    0,   47,
    0,   47,  344,    0,   47,    0,   47,   47,   47,   47,
    0,    0,    0,   47,   47,   47,    0,    0,   47,   47,
   47,    0,    0,   47,    0,  344,    0,   47,   47,    0,
   47,   47,    0,   47,   47,   47,    0,    0,  344,   47,
    0,    0,    0,  344,    0,    0,  344,    0,  344,    0,
  344,  344,  344,  344,    0,    0,   47,    0,  344,    0,
    0,    0,  344,    0,  226,    0,  344,    0,    0,    0,
    0,  365,    0,    0,  344,    0,    0,  344,    0,  344,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  365,    0,    0,    0,  344,    0,
  344,  389,    0,    0,    0,    0,    0,  365,    0,  344,
    0,  276,  365,  344,   47,  242,    0,  365,    0,  365,
  365,  365,  365,    0,  390,    0,  344,  365,    0,    0,
    0,  365,    0,    0,    0,  365,    0,  391,    0,    0,
    0,    0,  393,  365,    0,    0,  365,  394,  365,  395,
  396,  397,  398,   31,   32,    0,   34,  399,  344,   35,
  212,  400,    0,    0,   39,   40,   41,    0,   43,  365,
    0,    0,    0,  401,   44,    0,  402,   46,  403,    0,
    0,    0,    0,    0,   51,    0,    0,    0,    0,   53,
    0,   54,   55,   56,    0,  521,    0,    0,    0,  404,
    0,    0,  522,    0,    0,   58,    0,   59,   60,    0,
    0,   61,    0,    0,   63,    0,   65,    0,   67,   68,
   69,  213,    0,   72,    0,    0,    0,  365,    0,    0,
  523,    0,    0,   77,   78,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   79,
   80,   81,    0,    0,    0,    0,    0, 1226,    0,   83,
  811,    0,  524,    0,    0,   85,   86,   87,   88,    0,
    0,    0,   89,    0,   90,    0,    0,    0,    0,    0,
   91,   92,    0,    0,    0,    0,    0,    0,   31,   32,
    0,   34,    0,    0,   35,  212,    0,    0,    0,   39,
   40,   41,    0,   43,    0,   93,  411,   95,   96,   44,
    0,    0,   46,    0,    0,    0,    0,    0,    0,   51,
    0,    0,    0,    0,   53,    0,   54,   55,   56,    0,
  521,    0,    0,    0,    0,    0,    0,  522,    0,    0,
   58,    0,   59,   60,    0,    0,   61,    0,    0,   63,
    0,   65,    0,   67,   68,   69,  213,    0,   72,    0,
    0,    0,    0,    0,    0,  523,    0,    0,   77,   78,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   79,   80,   81,    0,    0,    0,
    0,    0,    0,    0,   83,    0,    0,  524,    0,    0,
   85,   86,   87,   88,    0,    0,    0,   89,    0,   90,
    0,    0,    0,    0,    0,   91,   92,    0,    0,    0,
    0,    0,    0,   31,   32,    0,   34,    0,    0,   35,
  212,    0,    0,    0,   39,   40,   41,    0,   43,    0,
   93,  411,   95,   96,   44,    0,    0,   46,    0,    0,
    0,    0,    0,    0,   51,    0,    0,    0,    0,   53,
    0,   54,   55,   56,    0,  521,    0,    0,    0,    0,
    0,    0,  522,    0,    0,   58,    0,   59,   60,    0,
    0,   61,    0,    0,   63,    0,   65,    0,   67,   68,
   69,  213,    0,   72,    0,    0,    0,    0,    0,    0,
  523,    0,    0,   77,   78,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   79,
   80,   81,    0,    0,    0,    0,    0,    0,    0,   83,
    0,    0,    0,    0,    0,   85,   86,   87,   88,    0,
    0,    0,   89,    0,   90,    0,    0,    0,    0,    0,
   91,   92,    0,    0,    0,    0,    0,    0,   31,   32,
    0,   34,    0,    0,   35,  212,    0,    0,    0,   39,
   40,   41,    0,   43,    0,   93,  411,   95,   96,   44,
    0,    0,   46,    0,    0,    0,    0,    0,    0,   51,
    0,    0,    0,    0,   53,    0,   54,   55,   56,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   58,    0,   59,   60,    0,    0,   61,    0,    0,   63,
    0,   65,    0,   67,   68,   69,  213,    0,   72,    0,
    0,   74,    0,    0,    0,   76,    0,    0,   77,   78,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   79,   80,   81,    0,    0,    0,
    0,    0,    0,    0,   83,    0,    0,    0,    0,    0,
   85,   86,   87,   88,    0,    0,    0,   89,    0,   90,
    0,    0,    0,    0,    0,   91,   92,    0,    0,    0,
    0,    0,    0,   31,   32,    0,   34,    0,    0,   35,
  212,    0,    0,    0,   39,   40,   41,    0,   43,    0,
   93,  256,   95,   96,   44,    0,    0,   46,    0,    0,
    0,    0,    0,    0,   51,    0,    0,    0,    0,   53,
    0,   54,   55,   56,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   58,    0,   59,   60,    0,
    0,   61,    0,    0,   63,    0,   65,    0,   67,   68,
   69,  213,    0,   72,    0,    0,    0,    0,    0,    0,
   76,    0,    0,   77,   78,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   79,
   80,   81,    0,    0,    0,    0,  772,    0,    0,   83,
    0,    0,    0,    0,    0,   85,   86,   87,   88,    0,
    0,    0,   89,    0,   90,    0,    0,    0,    0,    0,
   91,   92,    0,    0,    0,    0,    0,    0,   31,   32,
    0,   34,    0,    0,   35,  212,    0,    0,    0,   39,
   40,   41,    0,   43,    0,   93,  256,   95,   96,   44,
    0,    0,   46,    0,    0,    0,    0,    0,    0,   51,
    0,    0,    0,    0,   53,    0,   54,   55,   56,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   58,    0,   59,   60,    0,    0,   61,    0,    0,   63,
    0,   65,    0,   67,   68,   69,  213,    0,   72,    0,
    0,    0,    0,    0,    0,   76,    0,    0,   77,   78,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   79,   80,   81,    0,    0,    0,
  451,    0,    0,    0,   83,    0,    0,    0,    0,    0,
   85,   86,   87,   88,    0,    0,    0,   89,    0,   90,
    0,    0,    0,    0,    0,   91,   92,    0,    0,    0,
    0,    0,    0,   31,   32,    0,   34,    0,    0,   35,
  212,    0,    0,    0,   39,   40,   41,    0,   43,    0,
   93,  256,   95,   96,   44,    0,    0,   46,    0,    0,
    0,    0,    0,    0,   51,    0,    0,    0,    0,   53,
    0,   54,   55,   56,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   58,    0,   59,   60,    0,
    0,   61,    0,    0,   63,    0,   65,    0,   67,   68,
   69,  213,    0,   72,    0,    0,    0,    0,    0,    0,
   76,    0,    0,   77,   78,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   79,
   80,   81,    0,    0,    0,  445,    0,    0,    0,   83,
    0,    0,    0,    0,    0,   85,   86,   87,   88,    0,
    0,    0,   89,    0,   90,    0,    0,    0,    0,    0,
   91,   92,    0,    0,    0,    0,    0,    0,   31,   32,
    0,   34,    0,    0,   35,  212,    0,    0,    0,   39,
   40,   41,    0,   43,    0,   93,  256,   95,   96,   44,
    0,    0,   46,    0,    0,    0,    0,    0,    0,   51,
    0,    0,    0,    0,   53,    0,   54,   55,   56,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   58,    0,   59,   60,    0,    0,   61,    0,    0,   63,
    0,   65,    0,   67,   68,   69,  213,    0,   72,    0,
    0,    0,    0,    0,    0,   76,    0,    0,   77,   78,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   79,   80,   81,    0,    0,    0,
    0,    0,    0,    0,   83,    0,    0,    0,    0,    0,
   85,   86,   87,   88,    0,    0,    0,   89,    0,   90,
    0,    0,    0,    0,    0,   91,   92,    0,    0,    0,
    0,    0,    0,   31,   32,    0,   34,    0,    0,   35,
  212,    0,    0,    0,   39,   40,   41,    0,   43,    0,
   93,  256,   95,   96,   44,    0,    0,   46,    0,    0,
    0,    0,    0,    0,   51,    0,    0,    0,    0,   53,
    0,   54,   55,   56,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   58,    0,   59,   60,    0,
    0,   61,    0,    0,   63,    0,   65,    0,   67,   68,
   69,  213,    0,   72,    0,    0,    0,    0,    0,    0,
   76,    0,    0,   77,   78,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   79,
   80,   81,    0,    0,    0,    0,    0,    0,    0,   83,
    0,    0,    0,    0,    0,   85,   86,   87,   88,    0,
    0,    0,   89,    0,   90,    0,    0,    0,    0,    0,
   91,   92,    0,    0,    0,    0,    0,    0,   31,   32,
    0,   34,    0,    0,   35,  212,    0,    0,    0,   39,
   40,   41,    0,   43,    0,   93,  411,   95,   96,   44,
    0,    0,   46,    0,    0,    0,    0,    0,    0,   51,
    0,    0,    0,    0,   53,    0,   54,   55,   56,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   58,    0,   59,   60,    0,    0,   61,    0,    0,   63,
    0,   65,    0,   67,   68,   69,  213,    0,   72,    0,
    0,    0,    0,    0,    0,   76,    0,    0,   77,   78,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   79,   80,   81,    0,    0,    0,
    0,    0,    0,    0,   83,    0,    0,    0,    0,    0,
   85,   86,   87,   88,    0,    0,    0,   89,    0,   90,
    0,    0,    0,    0,    0,   91,   92,    0,    0,    0,
    0,    0,    0,   77,   77,    0,   77,    0,    0,   77,
   77,    0,    0,    0,   77,   77,   77,    0,   77,    0,
   93,  916,   95,   96,   77,    0,    0,   77,    0,    0,
    0,    0,    0,    0,   77,    0,    0,    0,    0,   77,
    0,   77,   77,   77,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   77,    0,   77,   77,    0,
    0,   77,    0,    0,   77,    0,   77,    0,   77,   77,
   77,   77,    0,   77,    0,    0,    0,    0,    0,    0,
   77,    0,    0,   77,   77,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   77,
   77,   77,    0,    0,    0,    0,    0,    0,    0,   77,
    0,    0,    0,    0,    0,   77,   77,   77,   77,    0,
    0,    0,   77,    0,   77,    0,    0,    0,    0,    0,
   77,   77,    0,    0,    0,    0,    0,    0,  149,  149,
    0,  149,    0,    0,  149,  149,    0,    0,    0,  149,
  149,  149,    0,  149,    0,   77,   77,   77,   77,  149,
    0,    0,  149,    0,    0,    0,    0,    0,    0,  149,
    0,    0,    0,    0,  149,    0,  149,  149,  149,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  149,    0,  149,  149,    0,    0,  149,    0,    0,  149,
    0,  149,    0,  149,  149,  149,  149,    0,  149,    0,
    0,    0,    0,    0,    0,  149,    0,    0,  149,  149,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  149,  149,  149,    0,    0,    0,
    0,    0,    0,    0,  149,    0,    0,    0,    0,    0,
  149,  149,  149,  149,    0,    0,    0,  149,    0,  149,
    0,    0,    0,    0,    0,  149,  149,    0,    0,    0,
    0,    0,    0,   31,   32,    0,   34,    0,    0,   35,
  212,    0,    0,    0,   39,   40,   41,    0,   43,    0,
  149,  149,  149,  149,   44,    0,    0,   46,    0,    0,
    0,    0,    0,    0,   51,    0,    0,    0,    0,   53,
    0,   54,   55,   56,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   58,    0,   59,   60,    0,
    0,   61,    0,    0,   63,    0,   65,    0,   67,   68,
   69,  213,    0,   72,    0,   32,    0,   34,    0,    0,
   35,    0,    0,    0,    0,   39,    0,    0,    0,   43,
    0,    0,    0,    0,    0,    0,    0,    0,   46,   79,
   80,   81,    0,    0,    0,   51,    0,    0,    0,   83,
   53,    0,    0,    0,   56,   85,   86,   87,   88,    0,
    0,    0,   89,    0,   90,    0,   58,    0,   59,    0,
   91,   92,   61,    0,    0,    0,    0,    0,    0,    0,
   68,   69,    0,    0,   72,    0,    0,  274,    0,    0,
  641,    0,  641,    0,  641,   93,  214,  641,   96,  641,
  641,    0,  641,    0,  641,    0,  641,    0,  641,  641,
  641,    0,    0,    0,  641,  641,    0,    0,    0,    0,
  641,    0,  641,  641,    0,    0,    0,  641,    0,    0,
    0,  641,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  641,  641,    0,  641,    0,    0,    0,  641,
  641,    0,    0,    0,    0,    0,    0,  641,  641,    0,
    0,  641,    0,    0,  641,    0,    0,  305,    0,  641,
    0,    0,    0,   31,   32,    0,   34,    0,    0,   35,
  212,    0,    0,    0,   39,   40,   41,    0,   43,    0,
  641,  641,    0,    0,   44,    0,    0,   46,    0,    0,
    0,    0,    0,  641,   51,    0,    0,    0,    0,   53,
    0,   54,   55,   56,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   58,    0,   59,   60,    0,
    0,   61,    0,    0,   63,    0,   65,    0,   67,   68,
   69,  213,    0,   72,  641,  640,   74,  640,    0,    0,
  640,    0,  640,  640,    0,  640,    0,  640,    0,  640,
    0,  640,  640,  640,    0,    0,    0,  640,  640,   79,
   80,   81,    0,  640,    0,  640,  640,    0,    0,   83,
  640,    0,    0,    0,  640,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  640,    0,  640,    0,
    0,    0,  640,  640,    0,    0,    0,    0,    0,    0,
  640,  640,    0,    0,  640,    0,    0,  640,    0,    0,
    0,    0,  640,    0,    0,   93,  214,  640,    0,  640,
    0,    0,  640,    0,  640,  640,    0,  640,    0,  640,
    0,  640,    0,  640,  640,  640,    0,    0,    0,  640,
  640,    0,    0,    0,    0,  640,  640,  640,  640,   32,
    0,   34,  640,    0,   35,    0,  640, 1181,    0,   39,
    0,  596,    0,   43,    0,  597, 1182, 1183,  640,    0,
  640, 1184,   46,    0,  640,  640,    0, 1185,    0,   51,
    0,    0,  640,  640,   53,    0,  640,  640,   56,  640,
    0,    0,    0,    0,  640,    0,    0,    0,    0,    0,
   58,    0,   59,    0,    0,    0,   61,    0,    0,    0,
    0,    0,    0,    0,   68,   69,    0,   32,   72,   34,
    0, 1186,   35,    0,    0, 1181, 1187,   39,    0,  596,
    0,   43,    0,  597, 1182, 1183,    0,    0,    0, 1184,
   46,    0,    0,    0,    0, 1185,    0,   51,    0,   47,
    0,   47,   53,    0,   47,    0,   56,    0,    0,   47,
 1188,    0,    0,   47,    0,    0,    0,    0,   58,  640,
   59,    0,   47,    0,   61,    0,    0,    0,    0,   47,
    0,    0,   68,   69,   47,    0,   72,    0,   47, 1186,
   47,    0,   47,   47, 1187,   47,    0,   47,   47,    0,
   47, 1189,   47,   47,    0,    0,   47,   47,    0,   47,
    0,    0,    0,    0,   47,   47,   47,    0,   47,    0,
    0,   47,    0,   47,    0,    0,    0,    0,   47,    0,
    0,    0,   47,   47,   47,   47,   47,    0,   47,    0,
    0,   47,    0,   47,   47,    0,   47,   47,    0,    0,
   47,    0,    0,   47,    0,  166,   47,    0,   47,   47,
    0,    0,   47,   47,    0,   47,    0,    0,   47, 1189,
    0,    0,   47,    0,   47,    0,   47,   32,    0,   34,
    0,   47,   35,    0,   47,    0,   47,   39,    0,    0,
   47,   43,    0,   47,    0,    0,    0,  166,   47,   47,
   46,   47,   47,    0,    0,   47,    0,   51,    0,   32,
    0,   34,   53,    0,   35,    0,   56,    0,  502,   39,
    0,    0,    0,   43,    0,  503,    0,    0,   58,    0,
   59,    0,   46,    0,   61,    0,    0,  504,    0,   51,
    0,    0,   68,   69,   53,   47,   72,    0,   56,  505,
    0,    0,    0,   32,    0,   34,    0,    0,   35,    0,
   58,    0,   59,   39,    0,    0,   61,   43,    0,    0,
    0,    0,    0,    0,   68,   69,   46,   32,   72,   34,
    0,  453,   35,   51,    0,   47,    0,   39,   53,    0,
    0,   43,   56,    0,    0,    0,    0,    0,    0,    0,
   46,    0,    0,    0,   58,    0,   59,   51,    0,    0,
   61,    0,   53,    0,    0,    0,   56,    0,   68,   69,
    0,   32,   72,   34,    0,  274,   35,    0,   58,  506,
   59,   39,    0,    0,   61,   43,    0,    0,    0,    0,
    0,    0,   68,   69,   46,   32,   72,   34,    0,  274,
   35,   51,    0,    0,    0,   39,   53,    0,    0,   43,
   56,  305,    0,    0,    0,    0,    0,    0,   46,    0,
    0,    0,   58,    0,   59,   51,    0,    0,   61,    0,
   53,    0,    0,    0,   56,    0,   68,   69,    0,  496,
   72,  496,    0,  505,  496,    0,   58,    0,   59,  496,
    0,    0,   61,  496,    0,  569,    0,    0,    0,    0,
   68,   69,  496,  185,   72,  185,    0,  664,  185,  496,
    0,    0,    0,  185,  496,    0,    0,  185,  496,  571,
    0,    0,    0,    0,    0,    0,  185,    0,    0,    0,
  496,    0,  496,  185,    0,    0,  496,    0,  185,    0,
    0,    0,  185,    0,  496,  496,    0,  195,  496,  195,
    0,  496,  195,    0,  185,    0,  185,  195,    0,    0,
  185,  195,    0,  305,    0,    0,    0,    0,  185,  185,
  195,  186,  185,  186,    0,  185,  186,  195,    0,    0,
    0,  186,  195,    0,    0,  186,  195,  305,    0,    0,
    0,    0,    0,    0,  186,    0,    0,    0,  195,    0,
  195,  186,    0,    0,  195,    0,  186,    0,    0,    0,
  186,    0,  195,  195,    0,    0,  195,    0,    0,  195,
    0,    0,  186,    0,  186,    0,    0,    0,  186,    0,
   34,  496,    0,    0,    0,    0,  186,  186,    0,    0,
  186,   34,    0,  186,    0,    0,   34,    0,    0,    0,
   34,    0,    0,   34,    0,  185,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   34,   34,    0,    0,    0,
   34,   34,    0,    0,    0,    0,   34,    0,   34,   34,
   34,   34,    0,    0,    0,    0,   34,    0,    0,    0,
   34,    0,   34,    0,    0,    0,    0,    0,   32,  195,
    0,    0,   34,    0,   34,   34,    0,   34,    0,   32,
    0,   34,    0,    0,   32,    0,    0,    0,   32,    0,
    0,   32,    0,  186,    0,    0,    0,    0,   34,    0,
    0,    0,    0,   32,   32,    0,   34,   34,   32,   32,
    0,   27,    0,    0,   32,    0,   32,   32,   32,   32,
    0,    0,    0,    0,   32,    0,    0,    0,   32,    0,
   32,    0,    0,    0,   27,    0,    0,    0,    0,    0,
   32,    0,    0,   32,    0,   32,    0,   27,    0,   32,
    0,    0,   27,    0,   27,    0,   27,   27,    0,   27,
   27,   27,   27,    0,    0,   27,   32,   27,    0,    0,
    0,   27,    0,    0,   32,   32,    0,   27,    0,    0,
    0,    0,    0,   27,    0,    0,   27,    0,   27,    0,
   27,    0,    0,    0,    0,   27,    0,    0,    0,    0,
   27,    0,   27,   27,   27,   27,    0,    0,    0,   27,
   27,    0,    0,    0,   27,    0,    0,   27,   27,    0,
    0,    0,   47,    0,    0,    0,   27,    0,    0,   27,
    0,   27,    0,   47,    0,    0,    0,    0,   47,    0,
    0,    0,   47,    0,    0,   47,    0,    0,    0,    0,
    0,    0,   27,    0,    0,    0,    0,   47,   47,    0,
   27,   27,   47,   47,    0,   47,    0,    0,   47,    0,
   47,   47,   47,   47,    0,    0,   47,    0,   47,    0,
    0,   47,   47,    0,   47,   47,    0,    0,   47,    0,
    0,    0,    0,    0,   47,    0,    0,   47,    0,   47,
   47,   47,    0,   47,    0,   47,   47,    0,   47,    0,
    0,   47,    0,   47,   47,   47,   47,    0,    0,    0,
   47,   47,    0,    0,    0,   47,    0,   47,   36,    0,
    0,   47,    0,    0,    0,    0,    0,   47,    0,    0,
   47,    0,   47,   47,   47,    0,   47,    0,    0,   47,
    0,    0,    0,    0,   47,    0,   47,   47,   47,   47,
    0,    0,    0,   47,   47,    0,   47,    0,   47,    0,
    0,   37,    0,    0,    0,    0,    0,    0,    0,   47,
   47,    0,    0,   47,   47,   47,    0,    0,    0,   47,
    0,   47,   47,   47,   47,    0,    0,    0,    0,   47,
    0,    0,   47,   47,    0,    0,   47,    0,    0,    0,
   47,   47,    0,    0,  207,   47,    0,    0,   47,    0,
   47,    0,    0,    0,    0,   47,    0,    0,    0,    0,
    0,    0,   47,    0,   47,    0,    0,    0,   47,    0,
    0,   47,    0,   47,    0,   47,   47,    0,   47,  209,
   47,   47,   47,   47,    0,   47,   47,    0,   47,    0,
    0,    0,   47,    0,    0,    0,    0,    0,   47,    0,
    0,    0,    0,   47,   47,   47,    0,   47,   47,   47,
   47,   47,   47,   47,    0,    0,    0,    0,   47,    0,
    0,    0,   47,    0,    0,    0,    0,    0,   47,    0,
   47,    0,    0,    0,   47,    0,    0,   47,  309,   47,
  389,   47,    0,    0,    0,    0,   47,    0,    0,    0,
    0,   47,    0,   47,   47,   47,   47,    0,    0,    0,
   47,   47,    0,  390,    0,   47,    0,    0,  310,    0,
    0,    0,    0,    0,    0,    0,  391,   47,    0,    0,
   47,  393,   47,    0,    0,    0,  394,    0,  395,  396,
  397,  398,    0,    0,    0,    0,  399,    0,    0,    0,
  400,    0,    0,   47,    0,    0,    0,   47,   47,    0,
    0,    0,  401,    0,    0,  402,    0,  403,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  404,
  };
  protected static readonly short [] yyCheck = {            15,
  254,   94,   15,   15,   18,  449,   26,   15,  451,  255,
    4,   16,  246,  191,  406,  178,  206,  177,  488,   18,
  286,   74,  425,   36,  304,  283,  251,  146,  498,  816,
   37,   37,  253,  987,  273,  630,  631,  655, 1029, 1030,
  508,   57,    0, 1115,   37,  268,  256,  100,   64,   15,
  103,  193,   15,   66,  256,   64,  256,   70,  279, 1131,
  610,   15,  100,   77,   78,  103,   15,   83,  268,  256,
  294,   37,  256,  268,  256,  256,   42,   15,  673,   15,
  675,   15,   96,  597,  256,  256, 1077,  256,  256,  325,
  294,  367,   85,   86,   87,   88,   89,   90,   91,   92,
  282,  256,  277,  264,  256,  256,  281,  256,   15,  256,
  268,  367,   77,   78,  371,  256,  367,  256,  276,    0,
 1144,  214,  349,  350,  272,   15,  316,  371,  357,   15,
  146,   96,  314,  146,  146,  400,  367,  358,  146,  368,
  373,  417,  370,  372,  367,  417,  978,  412,  296,  257,
 1174,   15,  339,   15,  426,  339,  385,  344,  178,  346,
  344,  417,  346,  256,  325,  352,  353,  342,  352,  353,
  427,  191,  294,  417,  256,  323,  427,  256,  380,  294,
  146,  417,  415,  146,  306,  465,  390,  445,  417,  632,
  206,  419,  146,  417,  448,  211,  427,  146,  421,  380,
  427,  379,  752,  374,  754,  219,  358,  417,  146,  413,
  146,  366,  146,  368,  307,  370,  371,  256,  373,  272,
  375,  421,  488,  276,  373,  739,  421,  280,  508,  368,
  246,  245,  498,  249,  250,  417,  243,  243,  380,  146,
  427,  255,  280,  427,  251,  417,  262,  261,  417,  417,
  243,  267, 1324,  269,  219,  268,  146,  273,  251,  417,
  146,  256,  417,  269,  419,  294,  417,  422,  284,  285,
  417,  423,  424,  425,  286,  390,  417,  243,  286, 1351,
  245,  297,  146,  878,  146,  753,  368,  301,  297,  368,
  304, 1363,  385, 1365,  294,  417,  261,  915,  413,  257,
  316,  317,  335,  269,  371,  321,  322,  323,  324,  325,
  326,  327,  328,  329,  330,  331,  596,  410,  411,  256,
  286,  335,  336,  367,  256,  371,  256,  320,  256,  795,
  369,  845,  367,  847,  373,  849,  301,  353,  871,  332,
  333,  334,  435,  786,  337,  338,  341,  368,  256,  363,
  364,  372,  367,  256,  774,  372, 1076,  266,  375,  379,
  427,  390,  765,  256, 1318,  785,  899,  381,  341,  269,
  335,  336,  386,  368, 1094, 1099,  257,  349,  350,  618,
  358,  427,  381,  427,  413,  262,  286,  386, 1353, 1354,
  390,  272,  427, 1384,  427,  368,  277, 1184,  363,  364,
  281,  422,  305,  998, 1236,  314,  256,  420,  256,  634,
 1401,  944,  427,  413,  604,  296,  256,  697, 1142,  425,
 1144,  298,  515,  367,  517, 1145,  371,  870,  373,  366,
  896,  447,  898,  449,  343,  451,  368,  367,  375,  367,
 1035, 1036,  323,  373, 1409,  373,  339, 1042,  461,  462,
 1174,  465, 1099, 1285, 1286,  427, 1288,  473,  366,  425,
  368,  342,  370,  256,  480,  374,  465, 1299,  369,  370,
 1302, 1303,  373,  753,  335, 1195,  488,  349,  350, 1199,
  488,  390,  427,  427,  497, 1317,  498,  371,  581,  339,
  498,  339,  375,  417,  508, 1142,  750, 1144,  380,  339,
  377,  378,  426,  366,  413,  521,  522,  366,  390,  368,
  343,  419,  375,  263,  422,  390,  366,  426,  366,  375,
  513,  779,  488,  713,  643,  764,  366, 1174, 1098, 1099,
  370,  413,  498,  373,  374,  375,  343,  371,  413,  373,
  380,  374,  945,  427,  427,  638,  339,  380, 1118,  256,
  366,  344,  568,  346,  370,  427,   40,  390,  574,  352,
  353,   45,  783,   47,   48,  315,   50,  374,   52, 1039,
  816,  427, 1142,  371, 1144,  373,   60,  368,   62,  263,
  413,  272,  596,  390,  257,  265,   70,  267,  604,   73,
  270,   75,  272,  426, 1099,  275,   80,   81,  305,  279,
  366, 1099,  618,  419, 1174,  296,  413,  368,  288,  375,
 1099,  627,  343,  666,  417,  295,  632,  413,  102,  426,
  300,  637,  302,  343,  304,  366,  417,  634, 1099,  427,
  426,  315,  323,  887,  375,  368,  316, 1142,  318, 1144,
  368,  634,  322,  323, 1142,  659, 1144,  837,  661,  380,
  330,  331,  380, 1142,  334, 1144,  417,  337,  380,  390,
  375,  677,  272,  679,  630,  631,  680,  339,  390, 1174,
  390, 1142,  344, 1144,  346,  691, 1174,  349,  350,  693,
  352,  353,  413,  697,  370, 1174,  296,  390,  373,  339,
  357,  413,  708,  413,  659,  426,  357,  713,  714,   15,
  716,  373,  795, 1174,  426,  372,  426,  673,  366,  675,
  413,  727,  728,  323, 1099,  680,  366,  951,  385,   19,
  734,   37,  375,  426,  385,  375,   42,   27,  693,  213,
  415,  215,  748,  987,  750,  734, 1002,  417,  357,  753,
  367,  366,  756,  370,  390,  372,  373,  256,  764,  256,
  375,  767,  375,  372,  914,  427,  990, 1142,  774, 1144,
  269,   77,   78, 1099,  391,  392,  385,  413,  784,  253,
  786,  306,  357, 1039,  420,  413,  372,  286,  313,  375,
   96,  265,  420,  339,  411,  413,  976,  372,  344, 1174,
  346,  756,  419,  349,  350,  422,  352,  353,  426, 1033,
  385,  294,  816,  896,  385, 1071, 1142,  823, 1144,  825,
  320,  827,  306,  306,  308,  306,  366,  373,  370,  313,
  834,  837,  313,  916, 1216,  375,  417,  337,  338,  843,
  146,  325,  339,  378,  325,  834,  383,  344, 1174,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
  366,  371,  367,  373,  870, 1018,  388,  369,  373,  375,
  367,  373,  369, 1306,  371,  380,  373,  374,  375,  399,
 1048,  427, 1106, 1153,  417,  371,  339,  373,  843,  375,
 1160,  344,  389,  346,  381,  382,  349,  350,  901,  352,
  353,  366,  908,  400,  910,  357,  912,  384,  395,  396,
  375, 1203,  368,  219,  924,  412,  368, 1209,  339,  371,
  372,  389,  878,  344, 1216,  346,  393,  394,  349,  350,
  427,  352,  353,  385,  373, 1368,  375,  243,  922,  245,
  371,  380,  373,  372,  375,  951,  339,  421, 1184,  255,
  369,  344,  371,  346,  373,  261,  417,  963,  964,  352,
  353,  375,  339,  269,  369,  971,  371,  344,  373,  346,
  976, 1404,  349,  350,  427,  352,  353,  397,  398,  366,
  286,  987,  977,  370,  990,  372,  373,  461,  375,  354,
  355, 1425, 1426,  380,  272,  301,  357,    0,  304,  277,
 1002,  369, 1008,  281, 1002,  373,  427,  368, 1018, 1015,
  371,  372,  373,  370, 1024,  372, 1026,  369,  296,  413,
  414,  373,  369, 1027,  385,  256,  373, 1033,  369,  335,
  336,  417,  373,  368,  391,  392,  371, 1039, 1048, 1045,
 1046, 1039,  998,  369,  417,  323, 1002,  373,  369,  370,
  427,  372,  373,  374,  411,  371,  417,  363,  364,  375,
  340,  373,  419,  375,  342,  422,  385,  386,  387, 1071,
 1080,  354,  355, 1071, 1318,  375,  373, 1081,  375, 1035,
 1036,  375, 1088, 1039,  366,  369, 1042,  371, 1098, 1099,
  366,  363,  364, 1097,  370,  372,  372,  373, 1104,  375,
 1106,  369,  375,  371,  380,  369,  375,  371, 1118,  417,
  371,  367,  373,  417,  370, 1071,  372,  373,  375,  425,
    0,  341,  342,  343,  344,  371,  369,  373,  371,  369,
 1213,  371, 1142,  371, 1144,  391,  392,  373,  414,  375,
  349,  350, 1097, 1226,  373,  373,  375,  375, 1152, 1153,
  373,  413,  375, 1156,  417,  411, 1160,  371,  372,  465,
 1243,  366, 1245,  419, 1174,  370,  422,  372,  373,  417,
  375,  363,  364,  985,  986,  380,  417, 1181, 1182,  375,
 1184,  371,  488,  339,  340,  417, 1190,  345,  346,  371,
  417,  371,  498,  371,  367,  371,  373, 1152,  417, 1203,
  371, 1205,  508,  371, 1208, 1209,  294,  371,  371,  414,
  294,  373, 1216,  417,  371,  380,  371,  256, 1221,  371,
  373,  375,  370,  373,  417,  374, 1181, 1182,   85,   86,
   87,   88,   89,   90,   91,   92,  401,  402,  403,  404,
  405,  406,  407,  408,  409,  410,  380,  417,  356,  374,
 1205,  373,  372, 1208,  257,  371,  417,  380,  261,  373,
  373,  373,  294,  373,  375,  371,  417,  427,  373,  272,
  366,  417,  371,  417,  277,  422,  343,  372,  281,  373,
  294,  284,  294,  373,  417,  370, 1296,  369,  417,  366,
  596,    0,  256,  296,  297,  374,  256,  373,  301,  302,
 1306, 1304,  256, 1313,  307,  256,  309,  310,  311,  312,
  371,  380, 1318,  371,  317,  280, 1326, 1327,  321,  256,
  323,  366,  371,  367,  630,  631,  417,  375,  417, 1335,
  333,  417,  335,  336,  417,  338,  370,  417,  375,  342,
  414,  371,  373, 1353, 1354,  373,  375,  369,  375,  420,
  371,  347,  422,  659,  380,  366,  359,  351,  256,  256,
  380,  380, 1368,  371,  367,  368,  367,  673,  347,  675,
  369,  371,  374,  348,  680,  373,  369,  257,  366,  371,
  369,  261,  417,  374,  371,  367,  339,  693,  373,  373,
  348,  697,  272,  417,  417,  375,  367,  277, 1404, 1409,
  374,  281,  380,  366,  284,  366,  356, 1410, 1411,  366,
  417,  367,  367,  375, 1417, 1418,  296,  297,  370, 1425,
 1426,  301,  302,  367,  373,  256,  283,  307,  371,  309,
  310,  311,  312,  367,  337,  305,  417,  317,  370,  370,
  417,  321,  368,  323,  417,  417,  366,  753,  417,  370,
  756,  375,  370,  333,  370,  370,  336,  380,  338,  372,
  370,  366,  342,  320,  370,  373,  380,  368,  372,  371,
  256,  371,  417,  372,  366,  332,  333,  334,  373,  359,
  337,  338,  339,  340,  341,  342,  343,  344,  345,  346,
  347,  348,  349,  350,  351,  352,  373,  373,  371,  371,
  375,  369,  371,  315,  375,  417,    0,  367,  339,  375,
  816,  375,  371,  344,  369,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,  417,  417,  371,  380,
  371,  380,  367,  263,  370,  367,  367,  843,  369,    0,
  371,  370,  373,  374,  375,  371,  371,  256,  257,  366,
  417,  375,  375,  367,  375,  264,  265,  266,  267,  268,
  371,  270,  271,  367,  273,  274,  275,  276,  277,  278,
  279,  280,  878,  371,  371,  369,  285,  366,  287,  288,
  289,  290,  291,  292,  375,  367,  295,  367,  445,  366,
  299,  300,  371,  302,  303,  304,  427,  375,  369,  417,
  375,  417,  375,  367,  371,  314,  375,  316,  371,  318,
  319,  367,  371,  322,  367,  324,  325,  326,  327,  328,
  329,  330,  331,  332,  333,  334,  335,  417,  337,  371,
  366,  340,  341,  367,  367,  344,  345,  375,  366,    0,
  372,  315,  263,   25,  375,   26,  285,   10,  375,  375,
  375,  360,  361,  362,  375,  375,  513,  366,  367,  375,
  375,  370,    5,  976, 1118,  834,  375,  376,  377,  378,
  379,  734, 1358,  976,  383, 1321,  385,  596, 1174, 1374,
 1309, 1304,  391,  392, 1338,  758, 1190, 1203,  327, 1418,
  758, 1142,  998,  758, 1130,  752, 1002, 1412, 1331, 1080,
 1327, 1326, 1411,  465, 1245, 1190, 1024,  416,  417,  418,
  419, 1081,  421,  779,  522,  637,  713,  316,  427,  604,
  887, 1027,  708,   54,  347,  634,  348,  351, 1064, 1035,
 1036,  349,  352, 1039,  350,  901, 1042,  376,  377,  378,
  379, 1152,  381,  382,  383,  384,  385,  386,  387,  388,
  697, 1071,  391,  392,  393,  394,  395,  396,  397,  398,
 1002,  146,  964,  257,  856, 1071,  821,  261,  872,  263,
  954,  265,  463,  267,  799, 1081,  270,  956,  272,  273,
  371,  275, 1148,  277,   -1,  279,  945,  281,  282,  283,
  284, 1097, 1046,  287,  288,   -1,   -1,   -1,   -1,  293,
  294,  295,  296,  297,   -1,   -1,  300,  301,  302,   -1,
  304,    0,  306,  307,  308,  309,  310,  311,  312,  313,
   -1,  315,  316,  317,  318,   -1,   -1,  321,  322,  323,
   -1,  325,   -1,   -1,   -1,   -1,  330,  331,   -1,  333,
  334,   -1,  336,  337,  338,   -1, 1152, 1153,  342,   -1,
   -1,   -1,   -1,   -1, 1160,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,  363,
  364,   -1,   -1,   -1,   -1, 1181, 1182,   -1, 1184,    0,
   -1,   -1,  376,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  256,  257,   -1,   -1, 1205,
   -1,   -1, 1208,  264,  265,  266,  267,  268,   -1,  270,
  271,   -1,  273,  274,  275,  276,  277,  278,  279,   -1,
   -1,   -1,  779,  417,  285,   -1,  287,  288,  289,  290,
  291,  292,   -1,   -1,  295,   -1,   -1,   -1,  299,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,    0,   -1,
   -1,   -1,   -1,  314,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,  324,  325,  326,  327,  328,  329,  330,
  331,  332,  333,  334,  335,   -1,  337,   -1,   -1,  340,
  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,
   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,
  361,  362,   -1,   -1,   -1,  366,  367,   -1,   -1,  370,
   -1,   -1,   -1,   -1,  375,  376,  377,  378,  379,   -1,
   -1,   -1,  383,   -1,  385,   -1,   -1,   -1,   -1,   -1,
  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  416,  417,  418,  419,   -1,
  421,   -1,   -1,   -1,    0,   -1,  427,  256,  257,   -1,
   -1,   -1,  261,   -1,   -1,   -1,  265,   -1,  267,   -1,
   -1,  270,   -1,  272,  273,   -1,  275,   -1,  277,   -1,
  279,   -1,  281,  282,  283,  284,   -1,   -1,  287,  288,
   -1,   -1,   -1,   -1,  293,   -1,  295,  296,  297,   -1,
   -1,  300,  301,  302,   -1,  304,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,   -1,  316,  317,  318,
   -1,   -1,  321,  322,  323,   -1,  257,    0,   -1,   -1,
  261,  330,  331,   -1,  333,  334,   -1,  336,  337,  338,
   -1,  272,   -1,  342,   -1,   -1,  277,   -1,   -1,   -1,
  281,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,
  359,   -1,   -1,   -1,   -1,  296,  297,   -1,  367,  368,
  301,  302,   -1,   -1,   -1,   -1,  307,  376,  309,  310,
  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,
  321,   -1,  323,   -1,    0,  257,   -1,   -1,   -1,  261,
   -1,   -1,  333,   -1,  335,  336,   -1,  338,   -1,   -1,
  272,  342,   -1,   -1,   -1,  277,   -1,   -1,  417,  281,
   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,  359,   -1,
   -1,   -1,   -1,   -1,  296,  297,   -1,  368,  257,  301,
  302,   -1,  261,   -1,   -1,  307,   -1,  309,  310,  311,
  312,   -1,   -1,  272,   -1,  317,   -1,   -1,  277,  321,
   -1,  323,  281,    0,   -1,  284,   -1,   -1,   -1,   -1,
   -1,  333,   -1,   -1,  336,   -1,  338,  296,  297,   -1,
  342,   -1,  301,  302,   -1,   -1,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,   -1,  359,  317,   -1,
   -1,   -1,  321,   -1,  323,  367,  368,   -1,   -1,   -1,
   -1,  257,   -1,   -1,  333,  261,   -1,  336,   -1,  338,
   -1,   -1,   -1,  342,   -1,   -1,  272,   -1,   -1,   -1,
    0,  277,   -1,   -1,   -1,  281,   -1,   -1,  284,   -1,
  359,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  367,  368,
  296,  297,   -1,   -1,   -1,  301,  302,   -1,   -1,   -1,
   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,
   -1,  317,   -1,   -1,   -1,  321,   -1,  323,   -1,   -1,
   -1,   -1,   -1,   -1,  257,   -1,   -1,  333,  261,   -1,
  336,   -1,  338,   -1,   -1,   -1,  342,   -1,   -1,  272,
   -1,   -1,   -1,   -1,  277,   -1,   -1,   -1,  281,   -1,
   -1,  284,   -1,  359,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  368,  296,  297,   -1,   -1,   -1,  301,  302,
   -1,   -1,   -1,   -1,  307,   -1,  309,  310,  311,  312,
   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,  321,   -1,
  323,  257,   -1,   -1,   -1,  261,   -1,   -1,   -1,   -1,
  333,   -1,   -1,  336,   -1,  338,  272,   -1,   -1,  342,
   -1,  277,   -1,   -1,   -1,  281,   -1,   -1,  284,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,
  296,  297,   -1,   -1,   -1,  301,  302,   -1,   -1,   -1,
   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,
   -1,  317,   -1,   -1,   -1,  321,   -1,  323,   -1,   -1,
  257,   -1,   -1,   -1,  261,   -1,   -1,  333,   -1,   -1,
  336,   -1,  338,   -1,   -1,  272,  342,   -1,   -1,   -1,
  277,   -1,   -1,   -1,  281,   -1,   -1,  284,   -1,   -1,
   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,   -1,  296,
  297,   -1,   -1,   -1,  301,  302,   -1,   -1,   -1,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,
  317,   -1,   -1,   -1,  321,   -1,  323,  257,   -1,   -1,
   -1,  261,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,
   -1,  338,  272,   -1,   -1,  342,   -1,  277,   -1,   -1,
   -1,  281,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,   -1,   -1,   -1,  296,  297,   -1,  256,
   -1,  301,  302,   -1,  261,  262,   -1,  307,   -1,  309,
  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,
   -1,  321,   -1,  323,   -1,   -1,   -1,  284,   -1,   -1,
   -1,   -1,   -1,  333,   -1,   -1,  336,  294,  338,   -1,
  297,  298,  342,   -1,   -1,  302,   -1,   -1,  305,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,  359,
  317,   -1,   -1,   -1,  321,   -1,   -1,   -1,  325,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,
   -1,  338,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,  359,   -1,   -1,   -1,   -1,   -1,   -1,  366,
  367,   -1,  369,  370,  371,  372,  373,  374,  375,   -1,
  377,  378,   -1,  380,  381,  382,  383,  384,  385,  386,
  387,  388,  389,   -1,  391,  392,  393,  394,  395,  396,
  397,  398,  399,  400,  401,  402,  403,  404,  405,  406,
  407,  408,  409,  410,  411,  412,   -1,   -1,  415,   -1,
  417,   -1,  419,  256,   -1,  422,   -1,   -1,   -1,   -1,
  427,  264,  265,  266,  267,   -1,   -1,  270,  271,   -1,
  273,  274,  275,  276,  277,  278,  279,   -1,   -1,   -1,
   -1,   -1,  285,   -1,  287,  288,  289,  290,  291,  292,
   -1,   -1,  295,   -1,   -1,   -1,  299,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  314,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,  324,  325,  326,  327,  328,  329,  330,  331,  332,
  333,  334,  335,   -1,  337,   -1,   -1,  340,  341,   -1,
   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,  360,  361,  362,
   -1,  261,  262,  366,   -1,   -1,   -1,  370,   -1,   -1,
   -1,   -1,  375,  376,  377,  378,  379,   -1,   -1,   -1,
  383,   -1,  385,   -1,  284,   -1,   -1,   -1,  391,  392,
   -1,   -1,   -1,   -1,  294,   -1,   -1,  297,  298,   -1,
   -1,   -1,  302,   -1,   -1,  305,   -1,  307,   -1,  309,
  310,  311,  312,  416,  417,  418,  419,  317,   -1,   -1,
   -1,  321,   -1,   -1,  427,  325,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,  339,
   -1,   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,  357,   -1,  359,
   -1,   -1,   -1,   -1,   -1,   -1,  366,  367,  368,  369,
  370,  371,  372,  373,  374,  375,   -1,  377,  378,   -1,
   -1,  381,  382,  383,  384,  385,   -1,   -1,  388,  389,
   -1,   -1,   -1,  393,  394,  395,  396,  397,  398,  399,
  400,  256,   -1,   -1,   -1,   -1,  261,  262,   -1,   -1,
   -1,   -1,  412,   -1,   -1,  415,   -1,  417,   -1,  419,
   -1,   -1,  422,   -1,   -1,   -1,   -1,  427,   -1,  284,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  294,
   -1,   -1,  297,  298,   -1,   -1,   -1,  302,   -1,   -1,
  305,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
   -1,   -1,  317,   -1,   -1,   -1,  321,   -1,   -1,   -1,
  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,
   -1,  336,   -1,  338,  339,   -1,   -1,   -1,   -1,  344,
   -1,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,  359,   -1,   -1,   -1,   -1,   -1,
   -1,  366,  367,  368,  369,  370,  371,   -1,  373,  374,
  375,   -1,  377,  378,   -1,   -1,  381,  382,  383,  384,
   -1,   -1,   -1,  388,  389,   -1,   -1,   -1,  393,  394,
  395,  396,  397,  398,  399,  400,  256,   -1,   -1,   -1,
   -1,  261,  262,   -1,   -1,   -1,   -1,  412,   -1,   -1,
  415,   -1,  417,   -1,  419,   -1,   -1,  422,   -1,   -1,
   -1,   -1,  427,   -1,  284,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  294,   -1,   -1,  297,  298,   -1,
   -1,   -1,  302,   -1,   -1,  305,   -1,  307,   -1,  309,
  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,
   -1,  321,   -1,   -1,   -1,  325,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,  339,
   -1,   -1,  256,   -1,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,  359,
   -1,   -1,   -1,   -1,   -1,   -1,  366,  367,  368,  369,
  370,  371,   -1,  373,  374,  375,   -1,  377,  378,  256,
   -1,  381,  382,  383,  384,  262,   -1,   -1,  388,  389,
   -1,   -1,   -1,  393,  394,  395,  396,  397,  398,  399,
  400,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  412,   -1,   -1,  415,   -1,  417,   -1,  419,
   -1,  298,  422,   -1,   -1,  339,   -1,  427,   -1,   -1,
  344,   -1,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  367,   -1,  369,   -1,  371,   -1,  373,
  374,  375,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
  357,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  367,  368,  369,  370,  371,  372,  373,  374,  375,   -1,
  377,  378,   -1,  380,  381,  382,  383,  384,  385,  386,
  387,  388,  389,  427,  391,  392,  393,  394,  395,  396,
  397,  398,  399,  400,  401,  402,  403,  404,  405,  406,
  407,  408,  409,  410,  411,  412,   -1,   -1,  256,   -1,
  417,   -1,  419,  261,  262,  422,   -1,   -1,   -1,   -1,
  427,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  284,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  294,   -1,   -1,  297,
  298,   -1,   -1,   -1,  302,   -1,   -1,  305,   -1,  307,
   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,
   -1,   -1,   -1,  321,   -1,   -1,   -1,  325,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,
  338,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,  359,   -1,   -1,  256,   -1,   -1,   -1,  366,  367,
  262,  369,  370,  371,   -1,  373,  374,  375,   -1,  377,
  378,   -1,   -1,  381,  382,  383,  384,   -1,   -1,   -1,
  388,  389,   -1,   -1,   -1,  393,  394,  395,  396,  397,
  398,  399,  400,   -1,   -1,   -1,  298,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  412,   -1,   -1,  415,   -1,  417,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  427,
  256,   -1,   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  298,   -1,  366,  367,  368,  369,  370,  371,
  372,  373,  374,  375,   -1,  377,  378,   -1,  380,  381,
  382,  383,  384,  385,  386,  387,  388,  389,   -1,  391,
  392,  393,  394,  395,  396,  397,  398,  399,  400,  401,
  402,  403,  404,  405,  406,  407,  408,  409,  410,  411,
  412,   -1,  256,   -1,   -1,   -1,   -1,  419,  262,   -1,
   -1,   -1,   -1,   -1,   -1,  427,   -1,   -1,   -1,   -1,
   -1,  367,   -1,   -1,  370,   -1,  372,  373,   -1,   -1,
   -1,  377,  378,   -1,   -1,  381,  382,  383,  384,  385,
  386,  387,  388,  389,  298,  391,  392,  393,  394,  395,
  396,  397,  398,  399,  400,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  411,  412,   -1,   -1,   -1,
   -1,   -1,   -1,  419,  262,   -1,  422,   -1,   -1,   -1,
   -1,  427,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,   -1,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  298,   -1,  366,  367,   -1,  369,  370,  371,  372,  373,
  374,  375,   -1,  377,  378,   -1,  380,  381,  382,  383,
  384,  385,  386,  387,  388,  389,   -1,  391,  392,  393,
  394,  395,  396,  397,  398,  399,  400,  401,  402,  403,
  404,  405,  406,  407,  408,  409,  410,  411,  412,   -1,
  256,   -1,   -1,   -1,   -1,  419,  262,   -1,  422,  357,
   -1,   -1,   -1,  427,   -1,   -1,   -1,   -1,   -1,   -1,
  368,   -1,  370,   -1,  372,   -1,   -1,  375,   -1,  377,
  378,   -1,  380,  381,  382,  383,  384,  385,  386,  387,
  388,  389,  298,  391,  392,  393,  394,  395,  396,  397,
  398,  399,  400,  401,  402,  403,  404,  405,  406,  407,
  408,  409,  410,  411,  412,   -1,   -1,   -1,   -1,  417,
   -1,  419,  262,   -1,  422,   -1,   -1,   -1,   -1,  427,
   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  298,   -1,
   -1,  367,   -1,  369,  370,  371,  372,  373,  374,  375,
   -1,  377,  378,   -1,  380,  381,  382,  383,  384,  385,
  386,  387,  388,  389,   -1,  391,  392,  393,  394,  395,
  396,  397,  398,  399,  400,  401,  402,  403,  404,  405,
  406,  407,  408,  409,  410,  411,  412,   -1,  256,   -1,
   -1,   -1,   -1,  419,  262,   -1,  422,   -1,   -1,   -1,
   -1,  427,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,
  370,  371,  372,  373,   -1,  375,   -1,  377,  378,   -1,
  380,  381,  382,  383,  384,   -1,  386,  387,  388,  389,
  298,  391,  392,  393,  394,  395,  396,  397,  398,  399,
  400,  401,  402,  403,  404,  405,  406,  407,  408,  409,
  410,  411,  412,   -1,   -1,   -1,   -1,  417,   -1,  419,
  262,   -1,  422,   -1,   -1,   -1,   -1,  427,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  298,   -1,   -1,  367,
   -1,  369,  370,  371,  372,  373,  374,  375,   -1,  377,
  378,   -1,  380,  381,  382,  383,  384,  385,  386,  387,
  388,  389,   -1,  391,  392,  393,  394,  395,  396,  397,
  398,  399,  400,  401,  402,  403,  404,  405,  406,  407,
  408,  409,  410,  411,  412,   -1,  256,   -1,   -1,   -1,
   -1,  419,  262,   -1,  422,   -1,   -1,   -1,   -1,  427,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  369,  370,  371,
  372,  373,   -1,   -1,   -1,  377,  378,   -1,  380,  381,
  382,  383,  384,  385,  386,  387,  388,  389,  298,  391,
  392,  393,  394,  395,  396,  397,  398,  399,  400,  401,
  402,  403,  404,  405,  406,  407,  408,  409,  410,  411,
  412,   -1,   -1,   -1,   -1,   -1,   -1,  419,   -1,   -1,
  422,   -1,   -1,   -1,   -1,  427,   -1,   -1,   -1,  339,
   -1,   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  367,   -1,  369,
  370,  371,  372,  373,  374,  375,   -1,  377,   -1,   -1,
  380,  381,  382,  383,  384,  385,  386,  387,  388,  389,
   -1,  391,  392,  393,  394,  395,  396,  397,  398,  399,
  400,  401,  402,  403,  404,  405,  406,  407,  408,  409,
  410,  411,  412,   -1,  256,  256,   -1,   -1,   -1,  419,
  262,   -1,  422,   -1,  265,   -1,  267,  427,   -1,  270,
   -1,   -1,   -1,   -1,  275,   -1,   -1,   -1,  279,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,   -1,  298,   -1,   -1,  300,
   -1,   -1,   -1,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,   -1,   -1,
   -1,  322,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  330,
  331,   -1,   -1,  334,   -1,   -1,  337,  339,   -1,   -1,
   -1,  256,  344,   -1,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  367,   -1,  369,   -1,  371,
   -1,  373,  374,  375,   -1,  377,  378,   -1,  380,  381,
  382,  383,  384,  385,  386,  387,  388,  389,   -1,   -1,
   -1,  393,  394,  395,  396,  397,  398,  399,  400,  401,
  402,  403,  404,  405,  406,  407,  408,  409,  410,  256,
  412,   -1,   -1,   -1,   -1,  262,  417,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  339,  427,   -1,   -1,   -1,  344,
   -1,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1,   -1,  294,   -1,   -1,
   -1,  298,  367,   -1,  369,   -1,  371,   -1,  373,  374,
  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  389,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
  357,   -1,  427,   -1,   -1,   -1,   -1,   -1,   -1,  366,
  367,  368,  369,  370,  371,  372,  373,  374,  375,   -1,
  377,  378,   -1,   -1,  381,  382,  383,  384,  385,  256,
   -1,  388,  389,  261,   -1,  262,  393,  394,  395,  396,
  397,  398,  399,  400,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  412,  284,   -1,  415,   -1,
  417,   -1,  419,   -1,   -1,  422,   -1,  294,   -1,  297,
  427,  298,   -1,   -1,  302,   -1,   -1,  305,   -1,  307,
   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,
   -1,   -1,   -1,  321,   -1,   -1,   -1,  325,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,
  338,   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,  359,  256,   -1,   -1,   -1,   -1,   -1,  262,  366,
  367,   -1,  369,  370,  371,   -1,  373,  374,  375,   -1,
  377,  378,   -1,   -1,  381,  382,  383,  384,   -1,   -1,
   -1,  388,  389,   -1,   -1,   -1,  393,  394,  395,  396,
  397,  398,  399,  400,  298,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  412,   -1,   -1,  415,  417,
  417,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,
  427,   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,   -1,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  298,   -1,  367,   -1,  369,   -1,  371,   -1,  373,
  374,  375,   -1,  377,  378,   -1,   -1,  381,  382,  383,
  384,  385,  386,  387,  388,  389,   -1,   -1,   -1,  393,
  394,  395,  396,  397,  398,  399,  400,   -1,   -1,   -1,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  412,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,  256,  427,   -1,   -1,   -1,   -1,  262,   -1,
  367,  261,  369,  263,  371,   -1,  373,  374,  375,   -1,
  377,  378,   -1,   -1,  381,  382,  383,  384,   -1,   -1,
   -1,  388,  389,   -1,  284,   -1,  393,  394,  395,  396,
  397,  398,  399,  400,  298,   -1,   -1,  297,   -1,   -1,
   -1,   -1,  302,   -1,   -1,  412,   -1,  307,   -1,  309,
  310,  311,  312,   -1,   -1,  315,   -1,  317,   -1,  256,
  427,  321,   -1,   -1,   -1,  262,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  333,   -1,  339,  336,   -1,  338,   -1,
  344,   -1,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,   -1,   -1,  359,
   -1,  298,   -1,  367,   -1,  369,   -1,  371,   -1,  373,
  374,  375,   -1,  377,  378,   -1,   -1,  381,  382,  383,
  384,   -1,   -1,   -1,  388,  389,   -1,   -1,   -1,  393,
  394,  395,  396,  397,  398,  399,  400,   -1,   -1,   -1,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  412,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,  256,  427,   -1,   -1,   -1,   -1,  262,   -1,
  367,  261,  369,   -1,  371,   -1,  373,  374,  375,   -1,
  377,  378,   -1,   -1,  381,  382,  383,  384,   -1,   -1,
   -1,  388,  389,   -1,  284,   -1,  393,  394,  395,  396,
  397,  398,  399,  400,  298,   -1,   -1,  297,   -1,   -1,
   -1,  301,  302,   -1,   -1,  412,   -1,  307,   -1,  309,
  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,  256,
  427,  321,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  333,   -1,  339,  336,   -1,  338,   -1,
  344,   -1,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,   -1,   -1,  359,
   -1,   -1,   -1,  367,   -1,  369,   -1,  371,   -1,  373,
  374,  375,   -1,  377,  378,   -1,   -1,  381,  382,  383,
  384,   -1,   -1,   -1,  388,  389,  256,   -1,   -1,  393,
  394,  395,  396,  397,  398,  399,  400,   -1,   -1,   -1,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  412,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,  427,   -1,   -1,   -1,   -1,   -1,   -1,
  367,   -1,  369,   -1,  371,   -1,  373,  374,  375,   -1,
   -1,   -1,   -1,   -1,  381,  382,  383,  384,   -1,   -1,
   -1,  388,  389,  256,   -1,   -1,  393,  394,  395,  396,
  397,  398,  399,  400,   -1,   -1,   -1,   -1,   -1,  339,
   -1,   -1,   -1,   -1,  344,  412,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
  427,   -1,   -1,   -1,   -1,   -1,   -1,  367,   -1,  369,
   -1,  371,   -1,  373,  374,  375,   -1,   -1,   -1,   -1,
   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,  389,
  256,   -1,   -1,  393,  394,  395,  396,  397,  398,  399,
  400,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,
   -1,  344,  412,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,  427,   -1,   -1,
   -1,   -1,   -1,   -1,  367,   -1,  369,   -1,  371,   -1,
  373,  374,  375,   -1,   -1,   -1,   -1,   -1,  381,  382,
  383,  384,   -1,   -1,   -1,  388,  389,  256,   -1,   -1,
  393,  394,  395,  396,  397,  398,  399,  400,   -1,   -1,
   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  412,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,  427,   -1,   -1,   -1,   -1,   -1,
   -1,  367,   -1,  369,   -1,  371,   -1,  373,  374,  375,
   -1,   -1,   -1,   -1,   -1,  381,  382,  383,  384,   -1,
   -1,   -1,  388,  389,  256,   -1,   -1,   -1,   -1,  395,
  396,  397,  398,  399,  400,   -1,   -1,   -1,   -1,   -1,
  339,   -1,   -1,   -1,   -1,  344,  412,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,  427,   -1,   -1,   -1,   -1,   -1,   -1,  367,   -1,
  369,   -1,  371,   -1,  373,  374,  375,   -1,   -1,   -1,
   -1,   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,
  389,  256,   -1,   -1,   -1,   -1,  395,  396,  397,  398,
  399,  400,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,  412,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,  427,   -1,
   -1,   -1,   -1,   -1,   -1,  367,   -1,  369,   -1,  371,
   -1,  373,  374,  375,   -1,   -1,   -1,   -1,   -1,  381,
  382,  383,  384,   -1,   -1,   -1,  388,  389,  256,   -1,
   -1,   -1,   -1,  395,  396,  397,  398,  399,  400,   -1,
   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,
  412,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,  427,   -1,   -1,   -1,   -1,
   -1,   -1,  367,   -1,  369,   -1,  371,   -1,  373,  374,
  375,   -1,   -1,   -1,   -1,   -1,  381,  382,  383,  384,
   -1,   -1,   -1,  388,  389,  256,   -1,   -1,   -1,   -1,
  395,  396,  397,  398,  399,  400,   -1,   -1,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,  412,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,  427,   -1,   -1,   -1,   -1,   -1,   -1,  367,
   -1,  369,   -1,  371,   -1,  373,  374,  375,   -1,   -1,
   -1,   -1,   -1,  381,  382,  383,  384,   -1,   -1,   -1,
  388,  389,  256,   -1,   -1,   -1,   -1,  395,  396,  397,
  398,  399,  400,   -1,   -1,   -1,   -1,   -1,  339,   -1,
   -1,   -1,   -1,  344,  412,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,  427,
   -1,   -1,   -1,   -1,   -1,   -1,  367,   -1,  369,   -1,
  371,   -1,  373,  374,  375,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  383,  384,   -1,   -1,   -1,  388,  389,  256,
   -1,   -1,   -1,   -1,   -1,   -1,  397,  398,  399,  400,
   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,  412,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,  427,   -1,   -1,   -1,
   -1,   -1,   -1,  367,   -1,  369,   -1,  371,   -1,  373,
  374,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  383,
  384,   -1,   -1,   -1,  388,  389,  256,   -1,   -1,   -1,
   -1,   -1,   -1,  397,  398,  399,  400,   -1,   -1,   -1,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  412,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,  427,   -1,   -1,   -1,   -1,   -1,   -1,
  367,   -1,  369,   -1,  371,   -1,  373,  374,  375,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  383,  384,   -1,   -1,
   -1,  388,  389,  256,   -1,   -1,   -1,   -1,   -1,   -1,
  397,  398,  399,  400,   -1,   -1,   -1,   -1,   -1,  339,
   -1,   -1,   -1,   -1,  344,  412,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
  427,   -1,   -1,   -1,   -1,   -1,   -1,  367,   -1,  369,
   -1,  371,   -1,  373,  374,  375,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  383,  384,   -1,   -1,   -1,  388,  389,
  256,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  399,
  400,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,
   -1,  344,  412,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,  427,   -1,   -1,
   -1,   -1,   -1,   -1,  367,   -1,  369,   -1,  371,   -1,
  373,  374,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  383,  384,   -1,   -1,   -1,  388,  389,  256,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  399,  400,   -1,   -1,
   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  412,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,  427,   -1,   -1,   -1,   -1,   -1,
   -1,  367,   -1,  369,   -1,  371,   -1,  373,  374,  375,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  384,   -1,
   -1,   -1,  388,  389,  256,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  399,  400,   -1,   -1,   -1,   -1,   -1,
  339,   -1,   -1,   -1,   -1,  344,  412,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,  427,   -1,   -1,   -1,   -1,   -1,   -1,  367,   -1,
  369,   -1,  371,   -1,  373,  374,  375,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  384,   -1,   -1,   -1,  388,
  389,  256,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  399,  400,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,  412,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,  427,   -1,
   -1,   -1,   -1,   -1,   -1,  367,   -1,  369,   -1,  371,
   -1,  373,  374,  375,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  384,   -1,   -1,   -1,   -1,  389,  256,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  399,  400,   -1,
   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,
  412,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,  427,   -1,   -1,   -1,   -1,
   -1,   -1,  367,   -1,  369,   -1,  371,   -1,  373,  374,
  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  384,
   -1,   -1,   -1,   -1,  389,  256,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  399,  400,   -1,   -1,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,  412,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,  427,   -1,   -1,   -1,   -1,   -1,   -1,  367,
   -1,  369,   -1,  371,   -1,  373,  374,  375,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  389,  256,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  399,  400,   -1,   -1,   -1,   -1,   -1,  339,   -1,
   -1,   -1,   -1,  344,  412,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,  427,
   -1,   -1,   -1,   -1,   -1,   -1,  367,   -1,  369,   -1,
  371,   -1,  373,  374,  375,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  389,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  399,  400,
   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,  412,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,  427,   -1,   -1,   -1,
   -1,   -1,   -1,  367,   -1,  369,   -1,  371,   -1,  373,
  374,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  256,   -1,  389,   -1,   -1,   -1,   -1,
   -1,  264,  265,  266,  267,   -1,  400,  270,  271,   -1,
  273,  274,  275,  276,  277,  278,  279,   -1,  412,   -1,
   -1,   -1,  285,   -1,  287,  288,  289,  290,  291,  292,
   -1,   -1,  295,  427,   -1,   -1,  299,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  314,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,  324,  325,  326,  327,  328,  329,  330,  331,  332,
  333,  334,  335,   -1,  337,   -1,   -1,  340,  341,   -1,
   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,  361,  362,
   -1,   -1,   -1,  366,   -1,   -1,   -1,  370,   -1,   -1,
   -1,   -1,  375,  376,  377,  378,  379,   -1,   -1,   -1,
  383,   -1,  385,   -1,   -1,   -1,   -1,   -1,  391,  392,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,
   -1,   -1,   -1,  416,  417,  418,  419,  264,  265,  266,
  267,   -1,   -1,  270,  271,   -1,  273,  274,  275,  276,
  277,  278,  279,   -1,   -1,   -1,   -1,   -1,  285,   -1,
  287,  288,  289,  290,  291,  292,   -1,   -1,  295,   -1,
   -1,   -1,  299,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  314,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,  324,  325,  326,
  327,  328,  329,  330,  331,  332,  333,  334,  335,   -1,
  337,   -1,   -1,  340,  341,   -1,   -1,  344,  345,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  360,  361,  362,   -1,   -1,   -1,  366,
   -1,   -1,   -1,  370,   -1,   -1,   -1,   -1,  375,  376,
  377,  378,  379,   -1,   -1,   -1,  383,   -1,  385,   -1,
   -1,   -1,   -1,   -1,  391,  392,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  416,
  417,  418,  419,  264,  265,  266,  267,   -1,   -1,  270,
  271,   -1,  273,  274,  275,  276,  277,  278,  279,   -1,
   -1,   -1,   -1,   -1,  285,   -1,  287,  288,  289,  290,
  291,  292,   -1,   -1,  295,   -1,   -1,   -1,  299,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  314,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,  324,  325,  326,  327,  328,  329,  330,
  331,  332,  333,  334,  335,   -1,  337,   -1,   -1,  340,
  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,
  361,  362,   -1,   -1,   -1,  366,   -1,   -1,   -1,  370,
   -1,   -1,   -1,   -1,  375,  376,  377,  378,  379,   -1,
   -1,   -1,  383,   -1,  385,   -1,   -1,   -1,   -1,   -1,
  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  256,   -1,   -1,   -1,  416,  417,  418,  419,  264,
  265,  266,  267,   -1,   -1,  270,  271,   -1,  273,  274,
  275,  276,  277,  278,  279,   -1,   -1,   -1,   -1,   -1,
  285,   -1,  287,  288,  289,  290,  291,  292,   -1,   -1,
  295,   -1,   -1,   -1,  299,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  314,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,  324,
  325,  326,  327,  328,  329,  330,  331,  332,  333,  334,
  335,   -1,  337,   -1,   -1,  340,  341,   -1,   -1,  344,
  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  360,  361,  362,   -1,   -1,
   -1,  366,   -1,   -1,   -1,  370,   -1,   -1,   -1,   -1,
  375,  376,  377,  378,  379,   -1,   -1,   -1,  383,   -1,
  385,   -1,   -1,   -1,   -1,   -1,  391,  392,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,
   -1,  416,  417,  418,  419,  264,  265,  266,  267,   -1,
   -1,  270,  271,   -1,  273,  274,  275,  276,  277,  278,
  279,   -1,   -1,   -1,   -1,   -1,  285,   -1,  287,  288,
  289,  290,  291,  292,   -1,   -1,  295,   -1,   -1,   -1,
  299,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  314,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,  324,  325,  326,  327,  328,
  329,  330,  331,  332,  333,  334,  335,   -1,  337,   -1,
   -1,  340,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  360,  361,  362,   -1,   -1,   -1,  366,   -1,   -1,
   -1,  370,   -1,   -1,   -1,   -1,  375,  376,  377,  378,
  379,   -1,   -1,   -1,  383,   -1,  385,   -1,   -1,   -1,
   -1,   -1,  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  256,   -1,   -1,   -1,  416,  417,  418,
  419,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
  256,   -1,  275,  276,  277,   -1,  279,   -1,   -1,  265,
   -1,  267,  285,   -1,  270,  288,   -1,   -1,   -1,  275,
   -1,   -1,  295,  279,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,  316,  300,  318,  319,   -1,  304,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
  316,  334,  318,   -1,   -1,   -1,  322,   -1,  341,   -1,
   -1,  344,  345,   -1,  330,  331,   -1,   -1,  334,   -1,
   -1,  337,   -1,   -1,   -1,   -1,   -1,  360,  361,  362,
   -1,   -1,   -1,  366,  367,   -1,   -1,  370,   -1,   -1,
   -1,   -1,   -1,  376,  377,  378,  379,   -1,   -1,   -1,
  383,   -1,  385,   -1,   -1,   -1,   -1,   -1,  391,  392,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,
   -1,   -1,   -1,  416,  417,  418,  419,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,  256,   -1,  275,  276,
  277,  417,  279,   -1,   -1,  265,   -1,  267,  285,   -1,
  270,  288,   -1,   -1,   -1,  275,   -1,   -1,  295,  279,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,  288,   -1,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,  316,
  300,  318,  319,  320,  304,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,  316,  334,  318,   -1,
   -1,   -1,  322,   -1,  341,   -1,   -1,  344,  345,   -1,
  330,  331,   -1,   -1,  334,   -1,   -1,  337,   -1,   -1,
   -1,   -1,   -1,  360,  361,  362,   -1,   -1,   -1,  366,
   -1,   -1,   -1,  370,   -1,   -1,   -1,   -1,   -1,  376,
  377,  378,  379,   -1,   -1,   -1,  383,   -1,  385,   -1,
   -1,   -1,   -1,   -1,  391,  392,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  416,
  417,  418,  419,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,  256,   -1,  275,  276,  277,  417,  279,   -1,
   -1,  265,   -1,  267,  285,   -1,  270,  288,   -1,   -1,
   -1,  275,   -1,   -1,  295,  279,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,  288,   -1,   -1,   -1,   -1,   -1,
   -1,  295,   -1,   -1,   -1,  316,  300,  318,  319,   -1,
  304,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,  316,  334,  318,   -1,  337,   -1,  322,   -1,
  341,   -1,   -1,  344,  345,   -1,  330,  331,   -1,   -1,
  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,   -1,  360,
  361,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  370,
   -1,   -1,   -1,   -1,   -1,  376,  377,  378,  379,   -1,
   -1,   -1,  383,   -1,  385,   -1,   -1,   -1,   -1,   -1,
  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  256,   -1,   -1,   -1,  416,  417,  418,  419,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,  256,   -1,
  275,  276,  277,  417,  279,   -1,   -1,  265,   -1,  267,
  285,   -1,  270,  288,   -1,   -1,   -1,  275,   -1,   -1,
  295,  279,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,
   -1,  316,  300,  318,  319,   -1,  304,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,  316,  334,
  318,   -1,   -1,   -1,  322,   -1,  341,   -1,   -1,  344,
  345,   -1,  330,  331,   -1,   -1,  334,   -1,   -1,  337,
   -1,   -1,   -1,   -1,   -1,  360,  361,  362,   -1,   -1,
   -1,  366,   -1,   -1,   -1,  370,   -1,   -1,   -1,   -1,
   -1,  376,  377,  378,  379,   -1,   -1,   -1,  383,   -1,
  385,   -1,   -1,   -1,   -1,   -1,  391,  392,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,
   -1,  416,  417,  418,  419,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,  417,
  279,   -1,   -1,  265,   -1,  267,  285,   -1,  270,  288,
   -1,   -1,   -1,  275,   -1,   -1,  295,  279,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,  288,   -1,   -1,   -1,
   -1,   -1,   -1,  295,   -1,   -1,   -1,  316,  300,  318,
  319,   -1,  304,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,  316,  334,  318,   -1,   -1,   -1,
  322,   -1,  341,   -1,   -1,  344,  345,   -1,  330,  331,
   -1,   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,
   -1,  360,  361,  362,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  370,   -1,   -1,   -1,   -1,   -1,  376,  377,  378,
  379,   -1,   -1,   -1,  383,   -1,  385,   -1,   -1,   -1,
   -1,   -1,  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  256,   -1,   -1,   -1,  416,  417,  418,
  419,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,  417,  279,   -1,   -1,  265,
   -1,  267,  285,   -1,  270,  288,   -1,   -1,   -1,  275,
   -1,   -1,  295,  279,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,  316,  300,  318,  319,   -1,  304,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
  316,  334,  318,   -1,   -1,   -1,  322,   -1,  341,   -1,
   -1,  344,  345,   -1,  330,  331,   -1,   -1,  334,   -1,
   -1,  337,   -1,   -1,   -1,   -1,   -1,  360,  361,  362,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  370,   -1,   -1,
   -1,   -1,   -1,  376,  377,  378,  379,   -1,   -1,   -1,
  383,   -1,  385,   -1,   -1,   -1,   -1,   -1,  391,  392,
   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,
   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,
   -1,  279,   -1,  416,  417,  418,  419,  285,   -1,   -1,
  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,
   -1,  417,  300,   -1,  302,  303,  304,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,
  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,
   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,
   -1,   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  360,  361,  362,   -1,   -1,   -1,  366,  367,
   -1,   -1,  370,   -1,   -1,   -1,   -1,   -1,  376,  377,
  378,  379,   -1,   -1,   -1,  383,   -1,  385,   -1,   -1,
   -1,   -1,   -1,  391,  392,   -1,   -1,   -1,   -1,   -1,
   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,   -1,  279,   -1,  416,  417,
  418,  419,  285,   -1,   -1,  288,   -1,   -1,  426,   -1,
   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,
   -1,  344,  345,   -1,   -1,  261,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,  361,  362,
   -1,   -1,   -1,  366,   -1,   -1,   -1,  370,  284,   -1,
   -1,   -1,   -1,  376,  377,  378,  379,   -1,   -1,   -1,
  383,  297,  385,   -1,   -1,   -1,  302,   -1,  391,  392,
   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,
   -1,  317,   -1,   -1,   -1,  321,   -1,   -1,   -1,  325,
  256,   -1,  262,  416,  417,  418,  419,  333,  264,  265,
  336,  267,  338,  426,  270,  271,   -1,   -1,   -1,  275,
  276,  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,
   -1,   -1,  288,  359,   -1,   -1,   -1,   -1,  298,  295,
   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  417,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  360,  361,  362,   -1,   -1,   -1,
  370,  371,  372,  373,  370,   -1,   -1,  377,  378,   -1,
   -1,  381,  382,  383,  384,  385,  386,  387,  388,  389,
   -1,  391,  392,  393,  394,  395,  396,  397,  398,  399,
  400,  401,  402,  403,  404,  405,  406,  407,  408,  409,
  410,  411,  412,   -1,   -1,   -1,   -1,   -1,   -1,  419,
  416,  417,  422,  261,   -1,   -1,   -1,  265,   -1,  267,
   -1,   -1,  270,   -1,  272,  273,   -1,  275,   -1,  277,
   -1,  279,   -1,  281,  282,  283,  284,   -1,   -1,  287,
  288,   -1,   -1,   -1,   -1,  293,   -1,  295,  296,  297,
   -1,   -1,  300,   -1,  302,   -1,  304,   -1,   -1,  307,
   -1,  309,  310,  311,  312,   -1,   -1,   -1,  316,  317,
  318,   -1,   -1,  321,  322,  323,   -1,   -1,   -1,   -1,
   -1,   -1,  330,  331,   -1,  333,  334,   -1,  336,  337,
  338,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  261,   -1,   -1,   -1,  265,   -1,
  267,  359,   -1,  270,   -1,  272,  273,   -1,  275,  367,
  277,   -1,  279,   -1,  281,  282,  283,  284,  376,   -1,
  287,  288,   -1,   -1,   -1,   -1,  293,   -1,  295,  296,
  297,   -1,   -1,  300,   -1,  302,   -1,  304,   -1,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,  316,
  317,  318,   -1,   -1,  321,  322,  323,   -1,   -1,  417,
   -1,   -1,   -1,  330,  331,   -1,  333,  334,   -1,  336,
  337,  338,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  261,   -1,   -1,   -1,  265,
   -1,  267,  359,   -1,  270,   -1,  272,  273,   -1,  275,
  367,  277,   -1,  279,   -1,  281,  282,  283,  284,  376,
   -1,  287,  288,   -1,   -1,   -1,   -1,  293,   -1,  295,
  296,  297,   -1,   -1,  300,   -1,  302,   -1,  304,   -1,
   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,
  316,  317,  318,   -1,   -1,  321,  322,  323,   -1,   -1,
  417,   -1,   -1,   -1,  330,  331,   -1,  333,  334,   -1,
  336,  337,  338,   -1,   -1,   -1,  342,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  261,   -1,   -1,   -1,
  265,   -1,  267,  359,   -1,  270,   -1,  272,  273,   -1,
  275,  367,  277,   -1,  279,   -1,  281,  282,  283,  284,
  376,   -1,  287,  288,   -1,   -1,   -1,   -1,  293,   -1,
  295,  296,  297,   -1,   -1,  300,   -1,  302,   -1,  304,
   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
   -1,  316,  317,  318,   -1,   -1,  321,  322,  323,   -1,
   -1,  417,   -1,   -1,   -1,  330,  331,   -1,  333,  334,
   -1,  336,  337,  338,   -1,   -1,   -1,  342,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  261,   -1,   -1,
   -1,  265,   -1,  267,  359,   -1,  270,   -1,  272,  273,
   -1,  275,  367,  277,   -1,  279,   -1,  281,  282,  283,
  284,  376,   -1,  287,  288,   -1,   -1,   -1,   -1,  293,
   -1,  295,  296,  297,   -1,   -1,  300,   -1,  302,   -1,
  304,   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,
   -1,   -1,  316,  317,  318,   -1,   -1,  321,  322,  323,
   -1,   -1,  417,   -1,   -1,   -1,  330,  331,   -1,  333,
  334,   -1,  336,  337,  338,   -1,   -1,   -1,  342,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  261,   -1,
   -1,   -1,  265,   -1,  267,  359,   -1,  270,   -1,  272,
  273,   -1,  275,  367,  277,   -1,  279,   -1,  281,  282,
  283,  284,   -1,   -1,  287,  288,   -1,   -1,   -1,   -1,
  293,   -1,  295,  296,  297,   -1,   -1,  300,   -1,  302,
   -1,  304,  261,   -1,  307,   -1,  309,  310,  311,  312,
   -1,   -1,   -1,  316,  317,  318,   -1,   -1,  321,  322,
  323,   -1,   -1,  417,   -1,  284,   -1,  330,  331,   -1,
  333,  334,   -1,  336,  337,  338,   -1,   -1,  297,  342,
   -1,   -1,   -1,  302,   -1,   -1,  305,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,  359,   -1,  317,   -1,
   -1,   -1,  321,   -1,  367,   -1,  325,   -1,   -1,   -1,
   -1,  261,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  284,   -1,   -1,   -1,  357,   -1,
  359,  261,   -1,   -1,   -1,   -1,   -1,  297,   -1,  368,
   -1,  370,  302,  372,  417,  305,   -1,  307,   -1,  309,
  310,  311,  312,   -1,  284,   -1,  385,  317,   -1,   -1,
   -1,  321,   -1,   -1,   -1,  325,   -1,  297,   -1,   -1,
   -1,   -1,  302,  333,   -1,   -1,  336,  307,  338,  309,
  310,  311,  312,  264,  265,   -1,  267,  317,  417,  270,
  271,  321,   -1,   -1,  275,  276,  277,   -1,  279,  359,
   -1,   -1,   -1,  333,  285,   -1,  336,  288,  338,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,  306,   -1,   -1,   -1,  359,
   -1,   -1,  313,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,  417,   -1,   -1,
  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,
  361,  362,   -1,   -1,   -1,   -1,   -1,  417,   -1,  370,
  371,   -1,  373,   -1,   -1,  376,  377,  378,  379,   -1,
   -1,   -1,  383,   -1,  385,   -1,   -1,   -1,   -1,   -1,
  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,   -1,  279,   -1,  416,  417,  418,  419,  285,
   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,
  306,   -1,   -1,   -1,   -1,   -1,   -1,  313,   -1,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,
   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  360,  361,  362,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  370,   -1,   -1,  373,   -1,   -1,
  376,  377,  378,  379,   -1,   -1,   -1,  383,   -1,  385,
   -1,   -1,   -1,   -1,   -1,  391,  392,   -1,   -1,   -1,
   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
  416,  417,  418,  419,  285,   -1,   -1,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,  306,   -1,   -1,   -1,   -1,
   -1,   -1,  313,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,
  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,
  361,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  370,
   -1,   -1,   -1,   -1,   -1,  376,  377,  378,  379,   -1,
   -1,   -1,  383,   -1,  385,   -1,   -1,   -1,   -1,   -1,
  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,   -1,  279,   -1,  416,  417,  418,  419,  285,
   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,
   -1,  337,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  360,  361,  362,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  370,   -1,   -1,   -1,   -1,   -1,
  376,  377,  378,  379,   -1,   -1,   -1,  383,   -1,  385,
   -1,   -1,   -1,   -1,   -1,  391,  392,   -1,   -1,   -1,
   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
  416,  417,  418,  419,  285,   -1,   -1,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,
  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,
  361,  362,   -1,   -1,   -1,   -1,  367,   -1,   -1,  370,
   -1,   -1,   -1,   -1,   -1,  376,  377,  378,  379,   -1,
   -1,   -1,  383,   -1,  385,   -1,   -1,   -1,   -1,   -1,
  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,   -1,  279,   -1,  416,  417,  418,  419,  285,
   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,
   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  360,  361,  362,   -1,   -1,   -1,
  366,   -1,   -1,   -1,  370,   -1,   -1,   -1,   -1,   -1,
  376,  377,  378,  379,   -1,   -1,   -1,  383,   -1,  385,
   -1,   -1,   -1,   -1,   -1,  391,  392,   -1,   -1,   -1,
   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
  416,  417,  418,  419,  285,   -1,   -1,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,
  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,
  361,  362,   -1,   -1,   -1,  366,   -1,   -1,   -1,  370,
   -1,   -1,   -1,   -1,   -1,  376,  377,  378,  379,   -1,
   -1,   -1,  383,   -1,  385,   -1,   -1,   -1,   -1,   -1,
  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,   -1,  279,   -1,  416,  417,  418,  419,  285,
   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,
   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  360,  361,  362,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  370,   -1,   -1,   -1,   -1,   -1,
  376,  377,  378,  379,   -1,   -1,   -1,  383,   -1,  385,
   -1,   -1,   -1,   -1,   -1,  391,  392,   -1,   -1,   -1,
   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
  416,  417,  418,  419,  285,   -1,   -1,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,
  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,
  361,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  370,
   -1,   -1,   -1,   -1,   -1,  376,  377,  378,  379,   -1,
   -1,   -1,  383,   -1,  385,   -1,   -1,   -1,   -1,   -1,
  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,   -1,  279,   -1,  416,  417,  418,  419,  285,
   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,
   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  360,  361,  362,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  370,   -1,   -1,   -1,   -1,   -1,
  376,  377,  378,  379,   -1,   -1,   -1,  383,   -1,  385,
   -1,   -1,   -1,   -1,   -1,  391,  392,   -1,   -1,   -1,
   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
  416,  417,  418,  419,  285,   -1,   -1,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,
  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,
  361,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  370,
   -1,   -1,   -1,   -1,   -1,  376,  377,  378,  379,   -1,
   -1,   -1,  383,   -1,  385,   -1,   -1,   -1,   -1,   -1,
  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,   -1,  279,   -1,  416,  417,  418,  419,  285,
   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,
   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  360,  361,  362,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  370,   -1,   -1,   -1,   -1,   -1,
  376,  377,  378,  379,   -1,   -1,   -1,  383,   -1,  385,
   -1,   -1,   -1,   -1,   -1,  391,  392,   -1,   -1,   -1,
   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
  416,  417,  418,  419,  285,   -1,   -1,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,  265,   -1,  267,   -1,   -1,
  270,   -1,   -1,   -1,   -1,  275,   -1,   -1,   -1,  279,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  288,  360,
  361,  362,   -1,   -1,   -1,  295,   -1,   -1,   -1,  370,
  300,   -1,   -1,   -1,  304,  376,  377,  378,  379,   -1,
   -1,   -1,  383,   -1,  385,   -1,  316,   -1,  318,   -1,
  391,  392,  322,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  330,  331,   -1,   -1,  334,   -1,   -1,  337,   -1,   -1,
  263,   -1,  265,   -1,  267,  416,  417,  270,  419,  272,
  273,   -1,  275,   -1,  277,   -1,  279,   -1,  281,  282,
  283,   -1,   -1,   -1,  287,  288,   -1,   -1,   -1,   -1,
  293,   -1,  295,  296,   -1,   -1,   -1,  300,   -1,   -1,
   -1,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  315,  316,   -1,  318,   -1,   -1,   -1,  322,
  323,   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,   -1,
   -1,  334,   -1,   -1,  337,   -1,   -1,  417,   -1,  342,
   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
  363,  364,   -1,   -1,  285,   -1,   -1,  288,   -1,   -1,
   -1,   -1,   -1,  376,  295,   -1,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,  417,  265,  337,  267,   -1,   -1,
  270,   -1,  272,  273,   -1,  275,   -1,  277,   -1,  279,
   -1,  281,  282,  283,   -1,   -1,   -1,  287,  288,  360,
  361,  362,   -1,  293,   -1,  295,  296,   -1,   -1,  370,
  300,   -1,   -1,   -1,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,   -1,
   -1,   -1,  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,
  330,  331,   -1,   -1,  334,   -1,   -1,  337,   -1,   -1,
   -1,   -1,  342,   -1,   -1,  416,  417,  265,   -1,  267,
   -1,   -1,  270,   -1,  272,  273,   -1,  275,   -1,  277,
   -1,  279,   -1,  281,  282,  283,   -1,   -1,   -1,  287,
  288,   -1,   -1,   -1,   -1,  293,  376,  295,  296,  265,
   -1,  267,  300,   -1,  270,   -1,  304,  273,   -1,  275,
   -1,  277,   -1,  279,   -1,  281,  282,  283,  316,   -1,
  318,  287,  288,   -1,  322,  323,   -1,  293,   -1,  295,
   -1,   -1,  330,  331,  300,   -1,  334,  417,  304,  337,
   -1,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,   -1,
  316,   -1,  318,   -1,   -1,   -1,  322,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  330,  331,   -1,  265,  334,  267,
   -1,  337,  270,   -1,   -1,  273,  342,  275,   -1,  277,
   -1,  279,   -1,  281,  282,  283,   -1,   -1,   -1,  287,
  288,   -1,   -1,   -1,   -1,  293,   -1,  295,   -1,  265,
   -1,  267,  300,   -1,  270,   -1,  304,   -1,   -1,  275,
  376,   -1,   -1,  279,   -1,   -1,   -1,   -1,  316,  417,
  318,   -1,  288,   -1,  322,   -1,   -1,   -1,   -1,  295,
   -1,   -1,  330,  331,  300,   -1,  334,   -1,  304,  337,
  306,   -1,  308,  265,  342,  267,   -1,  313,  270,   -1,
  316,  417,  318,  275,   -1,   -1,  322,  279,   -1,  325,
   -1,   -1,   -1,   -1,  330,  331,  288,   -1,  334,   -1,
   -1,  337,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,
   -1,   -1,  304,  265,  306,  267,  308,   -1,  270,   -1,
   -1,  313,   -1,  275,  316,   -1,  318,  279,   -1,   -1,
  322,   -1,   -1,  325,   -1,  371,  288,   -1,  330,  331,
   -1,   -1,  334,  295,   -1,  337,   -1,   -1,  300,  417,
   -1,   -1,  304,   -1,  306,   -1,  308,  265,   -1,  267,
   -1,  313,  270,   -1,  316,   -1,  318,  275,   -1,   -1,
  322,  279,   -1,  325,   -1,   -1,   -1,  369,  330,  331,
  288,  417,  334,   -1,   -1,  337,   -1,  295,   -1,  265,
   -1,  267,  300,   -1,  270,   -1,  304,   -1,  306,  275,
   -1,   -1,   -1,  279,   -1,  313,   -1,   -1,  316,   -1,
  318,   -1,  288,   -1,  322,   -1,   -1,  325,   -1,  295,
   -1,   -1,  330,  331,  300,  417,  334,   -1,  304,  337,
   -1,   -1,   -1,  265,   -1,  267,   -1,   -1,  270,   -1,
  316,   -1,  318,  275,   -1,   -1,  322,  279,   -1,   -1,
   -1,   -1,   -1,   -1,  330,  331,  288,  265,  334,  267,
   -1,  337,  270,  295,   -1,  417,   -1,  275,  300,   -1,
   -1,  279,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  288,   -1,   -1,   -1,  316,   -1,  318,  295,   -1,   -1,
  322,   -1,  300,   -1,   -1,   -1,  304,   -1,  330,  331,
   -1,  265,  334,  267,   -1,  337,  270,   -1,  316,  417,
  318,  275,   -1,   -1,  322,  279,   -1,   -1,   -1,   -1,
   -1,   -1,  330,  331,  288,  265,  334,  267,   -1,  337,
  270,  295,   -1,   -1,   -1,  275,  300,   -1,   -1,  279,
  304,  417,   -1,   -1,   -1,   -1,   -1,   -1,  288,   -1,
   -1,   -1,  316,   -1,  318,  295,   -1,   -1,  322,   -1,
  300,   -1,   -1,   -1,  304,   -1,  330,  331,   -1,  265,
  334,  267,   -1,  337,  270,   -1,  316,   -1,  318,  275,
   -1,   -1,  322,  279,   -1,  417,   -1,   -1,   -1,   -1,
  330,  331,  288,  265,  334,  267,   -1,  337,  270,  295,
   -1,   -1,   -1,  275,  300,   -1,   -1,  279,  304,  417,
   -1,   -1,   -1,   -1,   -1,   -1,  288,   -1,   -1,   -1,
  316,   -1,  318,  295,   -1,   -1,  322,   -1,  300,   -1,
   -1,   -1,  304,   -1,  330,  331,   -1,  265,  334,  267,
   -1,  337,  270,   -1,  316,   -1,  318,  275,   -1,   -1,
  322,  279,   -1,  417,   -1,   -1,   -1,   -1,  330,  331,
  288,  265,  334,  267,   -1,  337,  270,  295,   -1,   -1,
   -1,  275,  300,   -1,   -1,  279,  304,  417,   -1,   -1,
   -1,   -1,   -1,   -1,  288,   -1,   -1,   -1,  316,   -1,
  318,  295,   -1,   -1,  322,   -1,  300,   -1,   -1,   -1,
  304,   -1,  330,  331,   -1,   -1,  334,   -1,   -1,  337,
   -1,   -1,  316,   -1,  318,   -1,   -1,   -1,  322,   -1,
  261,  417,   -1,   -1,   -1,   -1,  330,  331,   -1,   -1,
  334,  272,   -1,  337,   -1,   -1,  277,   -1,   -1,   -1,
  281,   -1,   -1,  284,   -1,  417,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  296,  297,   -1,   -1,   -1,
  301,  302,   -1,   -1,   -1,   -1,  307,   -1,  309,  310,
  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,
  321,   -1,  323,   -1,   -1,   -1,   -1,   -1,  261,  417,
   -1,   -1,  333,   -1,  335,  336,   -1,  338,   -1,  272,
   -1,  342,   -1,   -1,  277,   -1,   -1,   -1,  281,   -1,
   -1,  284,   -1,  417,   -1,   -1,   -1,   -1,  359,   -1,
   -1,   -1,   -1,  296,  297,   -1,  367,  368,  301,  302,
   -1,  261,   -1,   -1,  307,   -1,  309,  310,  311,  312,
   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,  321,   -1,
  323,   -1,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,
  333,   -1,   -1,  336,   -1,  338,   -1,  297,   -1,  342,
   -1,   -1,  302,   -1,  261,   -1,  263,  307,   -1,  309,
  310,  311,  312,   -1,   -1,  315,  359,  317,   -1,   -1,
   -1,  321,   -1,   -1,  367,  368,   -1,  284,   -1,   -1,
   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,   -1,
  297,   -1,   -1,   -1,   -1,  302,   -1,   -1,   -1,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,  359,
  317,   -1,   -1,   -1,  321,   -1,   -1,  367,  368,   -1,
   -1,   -1,  261,   -1,   -1,   -1,  333,   -1,   -1,  336,
   -1,  338,   -1,  272,   -1,   -1,   -1,   -1,  277,   -1,
   -1,   -1,  281,   -1,   -1,  284,   -1,   -1,   -1,   -1,
   -1,   -1,  359,   -1,   -1,   -1,   -1,  296,  297,   -1,
  367,  368,  301,  302,   -1,  261,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,  272,   -1,  317,   -1,
   -1,  277,  321,   -1,  323,  281,   -1,   -1,  284,   -1,
   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,
  296,  297,   -1,  342,   -1,  301,  302,   -1,  261,   -1,
   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,
  359,  317,   -1,   -1,   -1,  321,   -1,  323,  367,   -1,
   -1,  284,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,
  336,   -1,  338,  261,  297,   -1,  342,   -1,   -1,  302,
   -1,   -1,   -1,   -1,  307,   -1,  309,  310,  311,  312,
   -1,   -1,   -1,  359,  317,   -1,  284,   -1,  321,   -1,
   -1,  367,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  297,
  333,   -1,   -1,  336,  302,  338,   -1,   -1,   -1,  307,
   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,
   -1,   -1,  261,  321,   -1,   -1,  359,   -1,   -1,   -1,
  363,  364,   -1,   -1,  367,  333,   -1,   -1,  336,   -1,
  338,   -1,   -1,   -1,   -1,  284,   -1,   -1,   -1,   -1,
   -1,   -1,  261,   -1,  263,   -1,   -1,   -1,  297,   -1,
   -1,  359,   -1,  302,   -1,  363,  364,   -1,  307,  367,
  309,  310,  311,  312,   -1,  284,  315,   -1,  317,   -1,
   -1,   -1,  321,   -1,   -1,   -1,   -1,   -1,  297,   -1,
   -1,   -1,   -1,  302,  333,  261,   -1,  336,  307,  338,
  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,
   -1,   -1,  321,   -1,   -1,   -1,   -1,   -1,  284,   -1,
  359,   -1,   -1,   -1,  333,   -1,   -1,  336,  367,  338,
  261,  297,   -1,   -1,   -1,   -1,  302,   -1,   -1,   -1,
   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,
  359,  317,   -1,  284,   -1,  321,   -1,   -1,  367,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  297,  333,   -1,   -1,
  336,  302,  338,   -1,   -1,   -1,  307,   -1,  309,  310,
  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,
  321,   -1,   -1,  359,   -1,   -1,   -1,  363,  364,   -1,
   -1,   -1,  333,   -1,   -1,  336,   -1,  338,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,
  };

#line 6028 "cs-parser.jay"

// <summary>
//  A class used to hold info about an operator declarator
// </summary>
class OperatorDeclaration {
	public readonly Operator.OpType optype;
	public readonly FullNamedExpression ret_type;
	public readonly Location location;

	public OperatorDeclaration (Operator.OpType op, FullNamedExpression ret_type, Location location)
	{
		optype = op;
		this.ret_type = ret_type;
		this.location = location;
	}
}

void Error_ExpectingTypeName (Expression expr)
{
	if (expr is Invocation){
		Report.Error (1002, expr.Location, "Expecting `;'");
	} else {
		Expression.Error_InvalidExpressionStatement (Report, expr.Location);
	}
}

void Error_ParameterModifierNotValid (string modifier, Location loc)
{
	Report.Error (631, loc, "The parameter modifier `{0}' is not valid in this context",
			              modifier);
}

void Error_DuplicateParameterModifier (Location loc, Parameter.Modifier mod)
{
	Report.Error (1107, loc, "Duplicate parameter modifier `{0}'",
  		Parameter.GetModifierSignature (mod));
}

void Error_TypeExpected (Location loc)
{
	Report.Error (1031, loc, "Type expected");
}

void Error_UnsafeCodeNotAllowed (Location loc)
{
	Report.Error (227, loc, "Unsafe code requires the `unsafe' command line option to be specified");
}

void Warning_EmptyStatement (Location loc)
{
	Report.Warning (642, 3, loc, "Possible mistaken empty statement");
}

void Error_NamedArgumentExpected (NamedArgument a)
{
	Report.Error (1738, a.Location, "Named arguments must appear after the positional arguments");
}

void push_current_class (TypeContainer tc, object partial_token)
{
	if (module.Evaluator != null){
		tc.Definition.Modifiers = tc.ModFlags = (tc.ModFlags & ~Modifiers.AccessibilityMask) | Modifiers.PUBLIC;
		if (undo == null)
			undo = new Undo ();
		undo.AddTypeContainer (current_container, tc);
	}

	if (partial_token != null)
		current_container = current_container.AddPartial (tc);
	else
		current_container = current_container.AddTypeContainer (tc);

	++lexer.parsing_declaration;
	current_class = tc;
	ubag.PushTypeDeclaration (tc);
}

DeclSpace pop_current_class ()
{
	DeclSpace retval = current_class;

	current_class = current_class.Parent;
	current_container = current_class.PartialContainer;
	ubag.PopTypeDeclaration ();
	
	return retval;
}

// <summary>
//   Given the @class_name name, it creates a fully qualified name
//   based on the containing declaration space
// </summary>
MemberName
MakeName (MemberName class_name)
{
	Namespace ns = current_namespace.NS;

	if (current_container == module) {
		if (ns.Name.Length != 0)
			return new MemberName (ns.MemberName, class_name);
		else
			return class_name;
	} else {
		return new MemberName (current_container.MemberName, class_name);
	}
}

[System.Diagnostics.Conditional ("FULL_AST")]
void StoreModifierLocation (object token, Location loc)
{
	if (lbag == null)
		return;

	if (mod_locations == null)
  		mod_locations = new List<Tuple<Modifiers, Location>> ();

	mod_locations.Add (Tuple.Create ((Modifiers) token, loc));
}

List<Tuple<Modifiers, Location>> GetModifierLocations ()
{
	var result = mod_locations;
	mod_locations = null;
	return result;
}

string CheckAttributeTarget (string a, Location l)
{
	switch (a) {
	case "assembly" : case "module" : case "field" : case "method" : case "param" : case "property" : case "type" :
			return a;
	}

	Report.Warning (658, 1, l,
		 "`{0}' is invalid attribute target. All attributes in this attribute section will be ignored", a);
	return string.Empty;
}

static bool IsUnaryOperator (Operator.OpType op)
{
	switch (op) {
		
	case Operator.OpType.LogicalNot: 
	case Operator.OpType.OnesComplement: 
	case Operator.OpType.Increment:
	case Operator.OpType.Decrement:
	case Operator.OpType.True: 
	case Operator.OpType.False: 
	case Operator.OpType.UnaryPlus: 
	case Operator.OpType.UnaryNegation:
		return true;
	}
	return false;
}

void syntax_error (Location l, string msg)
{
	Report.Error (1003, l, "Syntax error, " + msg);
}

Tokenizer lexer;

public Tokenizer Lexer {
	get {
		return lexer;
	}
}		   

static CSharpParser ()
{
	oob_stack = new Stack<object> ();
}

public CSharpParser (SeekableStreamReader reader, CompilationSourceFile file)
{
	this.file = file;
	current_namespace = file.NamespaceContainer;
	
	this.module = current_namespace.Module;
	this.compiler = module.Compiler;
	this.settings = compiler.Settings;
	lang_version = settings.Version;
	doc_support = settings.DocumentationFile != null;
	current_class = current_namespace.SlaveDeclSpace;
	current_container = current_class.PartialContainer; // == RootContest.ToplevelTypes
	oob_stack.Clear ();
	lexer = new Tokenizer (reader, file, compiler);
	
	use_global_stacks = true;
}

public void parse ()
{
	eof_token = Token.EOF;
	Tokenizer.LocatedToken.Initialize ();
	
	try {
		if (yacc_verbose_flag > 1)
			yyparse (lexer, new yydebug.yyDebugSimple ());
		else
			yyparse (lexer);
			
		Tokenizer tokenizer = lexer as Tokenizer;
		tokenizer.cleanup ();		
	} catch (Exception e){
	  	if (e is yyParser.yyUnexpectedEof) {
			Error_SyntaxError (yyToken);
			UnexpectedEOF = true;
			return;
		}
			
		if (e is yyParser.yyException) {
			Report.Error (-25, lexer.Location, "Parsing error");
		} else {
			// Used by compiler-tester to test internal errors
			if (yacc_verbose_flag > 0)
				throw;
		
			Report.Error (589, lexer.Location, "Internal compiler error during parsing");
		}
	}
}

void CheckToken (int error, int yyToken, string msg, Location loc)
{
	if (yyToken >= Token.FIRST_KEYWORD && yyToken <= Token.LAST_KEYWORD)
		Report.Error (error, loc, "{0}: `{1}' is a keyword", msg, GetTokenName (yyToken));
	else
		Report.Error (error, loc, msg);
}

string ConsumeStoredComment ()
{
	string s = tmpComment;
	tmpComment = null;
	Lexer.doc_state = XmlCommentState.Allowed;
	return s;
}

void FeatureIsNotAvailable (Location loc, string feature)
{
	compiler.Report.FeatureIsNotAvailable (compiler, loc, feature);
}

Location GetLocation (object obj)
{
	var lt = obj as Tokenizer.LocatedToken;
	if (lt != null)
		return lt.Location;
		
	var mn = obj as MemberName;
	if (mn != null)
		return mn.Location;
		
	var expr = obj as Expression;
	if (expr != null)
		return expr.Location;

	return lexer.Location;
}

Report Report {
	get { return compiler.Report; }
}

public LocationsBag LocationsBag {
	get {
		return lbag;
	}
	set {
		lbag = value;
	}
}

public UsingsBag UsingsBag {
	get {
		return ubag;
	}
	set {
		ubag = value;
	}
}

void start_block (Location loc)
{
	if (current_block == null) {
		current_block = new ToplevelBlock (compiler, current_local_parameters, loc);
		parsing_anonymous_method = false;
	} else if (parsing_anonymous_method) {
		current_block = new ParametersBlock (current_block, current_local_parameters, loc);
		parsing_anonymous_method = false;
	} else {
		current_block = new ExplicitBlock (current_block, loc, Location.Null);
	}
}

Block
end_block (Location loc)
{
	Block retval = current_block.Explicit;
	retval.SetEndLocation (loc);
	current_block = retval.Parent;
	return retval;
}

void start_anonymous (bool lambda, ParametersCompiled parameters, Location loc)
{
	if (lang_version == LanguageVersion.ISO_1){
		FeatureIsNotAvailable (loc, "anonymous methods");
	}

	oob_stack.Push (current_anonymous_method);
	oob_stack.Push (current_local_parameters);
	oob_stack.Push (current_variable);

	current_local_parameters = parameters;

	current_anonymous_method = lambda 
		? new LambdaExpression (loc) 
		: new AnonymousMethodExpression (loc);

	// Force the next block to be created as a ToplevelBlock
	parsing_anonymous_method = true;
}

/*
 * Completes the anonymous method processing, if lambda_expr is null, this
 * means that we have a Statement instead of an Expression embedded 
 */
AnonymousMethodExpression end_anonymous (ParametersBlock anon_block)
{
	AnonymousMethodExpression retval;

	current_anonymous_method.Block = anon_block;
	retval = current_anonymous_method;

	current_variable = (BlockVariableDeclaration) oob_stack.Pop ();
	current_local_parameters = (ParametersCompiled) oob_stack.Pop ();
	current_anonymous_method = (AnonymousMethodExpression) oob_stack.Pop ();

	return retval;
}

public NamespaceEntry CurrentNamespace {
       get { 
       	   return current_namespace;
       }
}

void Error_SyntaxError (int token)
{
	Error_SyntaxError (0, token, "Unexpected symbol");
}

void Error_SyntaxError (int error_code, int token, string msg)
{
	// An error message has been reported by tokenizer
	if (token == Token.ERROR)
		return;

	string symbol = GetSymbolName (token);
	string expecting = GetExpecting ();
	var loc = lexer.Location - symbol.Length;
	
	if (error_code == 0) {
		if (expecting == "`identifier'") {
			if (token > Token.FIRST_KEYWORD && token < Token.LAST_KEYWORD) {
				Report.Error (1041, loc, "Identifier expected, `{0}' is a keyword", symbol);
				return;
			}
			
			error_code = 1001;
			expecting = "identifier";
		} else if (expecting == "`)'") {
			error_code = 1026;
		} else {
			error_code = 1525;
		}
	}
	
	if (string.IsNullOrEmpty (expecting))
		Report.Error (error_code, loc, "{1} `{0}'", symbol, msg);
	else
		Report.Error (error_code, loc, "{2} `{0}', expecting {1}", symbol, expecting, msg);	  
}

string GetExpecting ()
{
	int [] tokens = yyExpectingTokens (yyExpectingState);
	var names = new List<string> (tokens.Length);
	bool has_type = false;
	bool has_identifier = false;
	for (int i = 0; i < tokens.Length; i++){
		int token = tokens [i];
		has_identifier |= token == Token.IDENTIFIER;
		
		string name = GetTokenName (token);
		if (name == "<internal>")
			continue;
			
		has_type |= name == "type";
		if (names.Contains (name))
			continue;
		
		names.Add (name);
	}

	//
	// Too many tokens to enumerate
	//
	if (names.Count > 8)
		return null;

	if (has_type && has_identifier)
		names.Remove ("identifier");

	if (names.Count == 1)
		return "`" + GetTokenName (tokens [0]) + "'";
	
	StringBuilder sb = new StringBuilder ();
	names.Sort ();
	int count = names.Count;
	for (int i = 0; i < count; i++){
		bool last = i + 1 == count;
		if (last)
			sb.Append ("or ");
		sb.Append ('`');
		sb.Append (names [i]);
		sb.Append (last ? "'" : count < 3 ? "' " : "', ");
	}
	return sb.ToString ();
}


string GetSymbolName (int token)
{
	switch (token){
	case Token.LITERAL:
		return ((Constant)lexer.Value).GetValue ().ToString ();
	case Token.IDENTIFIER:
		return ((Tokenizer.LocatedToken)lexer.Value).Value;

	case Token.BOOL:
		return "bool";
	case Token.BYTE:
		return "byte";
	case Token.CHAR:
		return "char";
	case Token.VOID:
		return "void";
	case Token.DECIMAL:
		return "decimal";
	case Token.DOUBLE:
		return "double";
	case Token.FLOAT:
		return "float";
	case Token.INT:
		return "int";
	case Token.LONG:
		return "long";
	case Token.SBYTE:
		return "sbyte";
	case Token.SHORT:
		return "short";
	case Token.STRING:
		return "string";
	case Token.UINT:
		return "uint";
	case Token.ULONG:
		return "ulong";
	case Token.USHORT:
		return "ushort";
	case Token.OBJECT:
		return "object";
		
	case Token.PLUS:
		return "+";
	case Token.UMINUS:
	case Token.MINUS:
		return "-";
	case Token.BANG:
		return "!";
	case Token.BITWISE_AND:
		return "&";
	case Token.BITWISE_OR:
		return "|";
	case Token.STAR:
		return "*";
	case Token.PERCENT:
		return "%";
	case Token.DIV:
		return "/";
	case Token.CARRET:
		return "^";
	case Token.OP_INC:
		return "++";
	case Token.OP_DEC:
		return "--";
	case Token.OP_SHIFT_LEFT:
		return "<<";
	case Token.OP_SHIFT_RIGHT:
		return ">>";
	case Token.OP_LT:
		return "<";
	case Token.OP_GT:
		return ">";
	case Token.OP_LE:
		return "<=";
	case Token.OP_GE:
		return ">=";
	case Token.OP_EQ:
		return "==";
	case Token.OP_NE:
		return "!=";
	case Token.OP_AND:
		return "&&";
	case Token.OP_OR:
		return "||";
	case Token.OP_PTR:
		return "->";
	case Token.OP_COALESCING:	
		return "??";
	case Token.OP_MULT_ASSIGN:
		return "*=";
	case Token.OP_DIV_ASSIGN:
		return "/=";
	case Token.OP_MOD_ASSIGN:
		return "%=";
	case Token.OP_ADD_ASSIGN:
		return "+=";
	case Token.OP_SUB_ASSIGN:
		return "-=";
	case Token.OP_SHIFT_LEFT_ASSIGN:
		return "<<=";
	case Token.OP_SHIFT_RIGHT_ASSIGN:
		return ">>=";
	case Token.OP_AND_ASSIGN:
		return "&=";
	case Token.OP_XOR_ASSIGN:
		return "^=";
	case Token.OP_OR_ASSIGN:
		return "|=";
	}

	return GetTokenName (token);
}

static string GetTokenName (int token)
{
	switch (token){
	case Token.ABSTRACT:
		return "abstract";
	case Token.AS:
		return "as";
	case Token.ADD:
		return "add";
	case Token.ASYNC:
		return "async";
	case Token.BASE:
		return "base";
	case Token.BREAK:
		return "break";
	case Token.CASE:
		return "case";
	case Token.CATCH:
		return "catch";
	case Token.CHECKED:
		return "checked";
	case Token.CLASS:
		return "class";
	case Token.CONST:
		return "const";
	case Token.CONTINUE:
		return "continue";
	case Token.DEFAULT:
		return "default";
	case Token.DELEGATE:
		return "delegate";
	case Token.DO:
		return "do";
	case Token.ELSE:
		return "else";
	case Token.ENUM:
		return "enum";
	case Token.EVENT:
		return "event";
	case Token.EXPLICIT:
		return "explicit";
	case Token.EXTERN:
	case Token.EXTERN_ALIAS:
		return "extern";
	case Token.FALSE:
		return "false";
	case Token.FINALLY:
		return "finally";
	case Token.FIXED:
		return "fixed";
	case Token.FOR:
		return "for";
	case Token.FOREACH:
		return "foreach";
	case Token.GOTO:
		return "goto";
	case Token.IF:
		return "if";
	case Token.IMPLICIT:
		return "implicit";
	case Token.IN:
		return "in";
	case Token.INTERFACE:
		return "interface";
	case Token.INTERNAL:
		return "internal";
	case Token.IS:
		return "is";
	case Token.LOCK:
		return "lock";
	case Token.NAMESPACE:
		return "namespace";
	case Token.NEW:
		return "new";
	case Token.NULL:
		return "null";
	case Token.OPERATOR:
		return "operator";
	case Token.OUT:
		return "out";
	case Token.OVERRIDE:
		return "override";
	case Token.PARAMS:
		return "params";
	case Token.PRIVATE:
		return "private";
	case Token.PROTECTED:
		return "protected";
	case Token.PUBLIC:
		return "public";
	case Token.READONLY:
		return "readonly";
	case Token.REF:
		return "ref";
	case Token.RETURN:
		return "return";
	case Token.REMOVE:
		return "remove";
	case Token.SEALED:
		return "sealed";
	case Token.SIZEOF:
		return "sizeof";
	case Token.STACKALLOC:
		return "stackalloc";
	case Token.STATIC:
		return "static";
	case Token.STRUCT:
		return "struct";
	case Token.SWITCH:
		return "switch";
	case Token.THIS:
		return "this";
	case Token.THROW:
		return "throw";
	case Token.TRUE:
		return "true";
	case Token.TRY:
		return "try";
	case Token.TYPEOF:
		return "typeof";
	case Token.UNCHECKED:
		return "unchecked";
	case Token.UNSAFE:
		return "unsafe";
	case Token.USING:
		return "using";
	case Token.VIRTUAL:
		return "virtual";
	case Token.VOLATILE:
		return "volatile";
	case Token.WHERE:
		return "where";
	case Token.WHILE:
		return "while";
	case Token.ARGLIST:
		return "__arglist";
	case Token.REFVALUE:
		return "__refvalue";
	case Token.REFTYPE:
		return "__reftype";
	case Token.MAKEREF:
		return "__makeref";
	case Token.PARTIAL:
		return "partial";
	case Token.ARROW:
		return "=>";
	case Token.FROM:
	case Token.FROM_FIRST:
		return "from";
	case Token.JOIN:
		return "join";
	case Token.ON:
		return "on";
	case Token.EQUALS:
		return "equals";
	case Token.SELECT:
		return "select";
	case Token.GROUP:
		return "group";
	case Token.BY:
		return "by";
	case Token.LET:
		return "let";
	case Token.ORDERBY:
		return "orderby";
	case Token.ASCENDING:
		return "ascending";
	case Token.DESCENDING:
		return "descending";
	case Token.INTO:
		return "into";
	case Token.GET:
		return "get";
	case Token.SET:
		return "set";
	case Token.OPEN_BRACE:
		return "{";
	case Token.CLOSE_BRACE:
		return "}";
	case Token.OPEN_BRACKET:
	case Token.OPEN_BRACKET_EXPR:
		return "[";
	case Token.CLOSE_BRACKET:
		return "]";
	case Token.OPEN_PARENS_CAST:
	case Token.OPEN_PARENS_LAMBDA:
	case Token.OPEN_PARENS:
		return "(";
	case Token.CLOSE_PARENS:
		return ")";
	case Token.DOT:
		return ".";
	case Token.COMMA:
		return ",";
	case Token.DEFAULT_COLON:
		return "default:";
	case Token.COLON:
		return ":";
	case Token.SEMICOLON:
		return ";";
	case Token.TILDE:
		return "~";
		
	case Token.PLUS:
	case Token.UMINUS:
	case Token.MINUS:
	case Token.BANG:
	case Token.OP_LT:
	case Token.OP_GT:
	case Token.BITWISE_AND:
	case Token.BITWISE_OR:
	case Token.STAR:
	case Token.PERCENT:
	case Token.DIV:
	case Token.CARRET:
	case Token.OP_INC:
	case Token.OP_DEC:
	case Token.OP_SHIFT_LEFT:
	case Token.OP_SHIFT_RIGHT:
	case Token.OP_LE:
	case Token.OP_GE:
	case Token.OP_EQ:
	case Token.OP_NE:
	case Token.OP_AND:
	case Token.OP_OR:
	case Token.OP_PTR:
	case Token.OP_COALESCING:	
	case Token.OP_MULT_ASSIGN:
	case Token.OP_DIV_ASSIGN:
	case Token.OP_MOD_ASSIGN:
	case Token.OP_ADD_ASSIGN:
	case Token.OP_SUB_ASSIGN:
	case Token.OP_SHIFT_LEFT_ASSIGN:
	case Token.OP_SHIFT_RIGHT_ASSIGN:
	case Token.OP_AND_ASSIGN:
	case Token.OP_XOR_ASSIGN:
	case Token.OP_OR_ASSIGN:
		return "<operator>";

	case Token.BOOL:
	case Token.BYTE:
	case Token.CHAR:
	case Token.VOID:
	case Token.DECIMAL:
	case Token.DOUBLE:
	case Token.FLOAT:
	case Token.INT:
	case Token.LONG:
	case Token.SBYTE:
	case Token.SHORT:
	case Token.STRING:
	case Token.UINT:
	case Token.ULONG:
	case Token.USHORT:
	case Token.OBJECT:
		return "type";
	
	case Token.ASSIGN:
		return "=";
	case Token.OP_GENERICS_LT:
	case Token.GENERIC_DIMENSION:
		return "<";
	case Token.OP_GENERICS_GT:
		return ">";
	case Token.INTERR:
	case Token.INTERR_NULLABLE:
		return "?";
	case Token.DOUBLE_COLON:
		return "::";
	case Token.LITERAL:
		return "value";
	case Token.IDENTIFIER:
		return "identifier";

	case Token.EOF:
		return "end-of-file";

		// All of these are internal.
	case Token.NONE:
	case Token.ERROR:
	case Token.FIRST_KEYWORD:
	case Token.EVAL_COMPILATION_UNIT_PARSER:
	case Token.EVAL_USING_DECLARATIONS_UNIT_PARSER:
	case Token.EVAL_STATEMENT_PARSER:
	case Token.LAST_KEYWORD:
	case Token.GENERATE_COMPLETION:
	case Token.COMPLETE_COMPLETION:
		return "<internal>";

		// A bit more robust.
	default:
		return yyNames [token];
        }
}

/* end end end */
}
#line default
namespace yydebug {
        using System;
	 internal interface yyDebug {
		 void push (int state, Object value);
		 void lex (int state, int token, string name, Object value);
		 void shift (int from, int to, int errorFlag);
		 void pop (int state);
		 void discard (int state, int token, string name, Object value);
		 void reduce (int from, int to, int rule, string text, int len);
		 void shift (int from, int to);
		 void accept (Object value);
		 void error (string message);
		 void reject ();
	 }
	 
	 class yyDebugSimple : yyDebug {
		 void println (string s){
			 Console.Error.WriteLine (s);
		 }
		 
		 public void push (int state, Object value) {
			 println ("push\tstate "+state+"\tvalue "+value);
		 }
		 
		 public void lex (int state, int token, string name, Object value) {
			 println("lex\tstate "+state+"\treading "+name+"\tvalue "+value);
		 }
		 
		 public void shift (int from, int to, int errorFlag) {
			 switch (errorFlag) {
			 default:				// normally
				 println("shift\tfrom state "+from+" to "+to);
				 break;
			 case 0: case 1: case 2:		// in error recovery
				 println("shift\tfrom state "+from+" to "+to
					     +"\t"+errorFlag+" left to recover");
				 break;
			 case 3:				// normally
				 println("shift\tfrom state "+from+" to "+to+"\ton error");
				 break;
			 }
		 }
		 
		 public void pop (int state) {
			 println("pop\tstate "+state+"\ton error");
		 }
		 
		 public void discard (int state, int token, string name, Object value) {
			 println("discard\tstate "+state+"\ttoken "+name+"\tvalue "+value);
		 }
		 
		 public void reduce (int from, int to, int rule, string text, int len) {
			 println("reduce\tstate "+from+"\tuncover "+to
				     +"\trule ("+rule+") "+text);
		 }
		 
		 public void shift (int from, int to) {
			 println("goto\tfrom state "+from+" to "+to);
		 }
		 
		 public void accept (Object value) {
			 println("accept\tvalue "+value);
		 }
		 
		 public void error (string message) {
			 println("error\t"+message);
		 }
		 
		 public void reject () {
			 println("reject");
		 }
		 
	 }
}
// %token constants
 class Token {
  public const int EOF = 257;
  public const int NONE = 258;
  public const int ERROR = 259;
  public const int FIRST_KEYWORD = 260;
  public const int ABSTRACT = 261;
  public const int AS = 262;
  public const int ADD = 263;
  public const int BASE = 264;
  public const int BOOL = 265;
  public const int BREAK = 266;
  public const int BYTE = 267;
  public const int CASE = 268;
  public const int CATCH = 269;
  public const int CHAR = 270;
  public const int CHECKED = 271;
  public const int CLASS = 272;
  public const int CONST = 273;
  public const int CONTINUE = 274;
  public const int DECIMAL = 275;
  public const int DEFAULT = 276;
  public const int DELEGATE = 277;
  public const int DO = 278;
  public const int DOUBLE = 279;
  public const int ELSE = 280;
  public const int ENUM = 281;
  public const int EVENT = 282;
  public const int EXPLICIT = 283;
  public const int EXTERN = 284;
  public const int FALSE = 285;
  public const int FINALLY = 286;
  public const int FIXED = 287;
  public const int FLOAT = 288;
  public const int FOR = 289;
  public const int FOREACH = 290;
  public const int GOTO = 291;
  public const int IF = 292;
  public const int IMPLICIT = 293;
  public const int IN = 294;
  public const int INT = 295;
  public const int INTERFACE = 296;
  public const int INTERNAL = 297;
  public const int IS = 298;
  public const int LOCK = 299;
  public const int LONG = 300;
  public const int NAMESPACE = 301;
  public const int NEW = 302;
  public const int NULL = 303;
  public const int OBJECT = 304;
  public const int OPERATOR = 305;
  public const int OUT = 306;
  public const int OVERRIDE = 307;
  public const int PARAMS = 308;
  public const int PRIVATE = 309;
  public const int PROTECTED = 310;
  public const int PUBLIC = 311;
  public const int READONLY = 312;
  public const int REF = 313;
  public const int RETURN = 314;
  public const int REMOVE = 315;
  public const int SBYTE = 316;
  public const int SEALED = 317;
  public const int SHORT = 318;
  public const int SIZEOF = 319;
  public const int STACKALLOC = 320;
  public const int STATIC = 321;
  public const int STRING = 322;
  public const int STRUCT = 323;
  public const int SWITCH = 324;
  public const int THIS = 325;
  public const int THROW = 326;
  public const int TRUE = 327;
  public const int TRY = 328;
  public const int TYPEOF = 329;
  public const int UINT = 330;
  public const int ULONG = 331;
  public const int UNCHECKED = 332;
  public const int UNSAFE = 333;
  public const int USHORT = 334;
  public const int USING = 335;
  public const int VIRTUAL = 336;
  public const int VOID = 337;
  public const int VOLATILE = 338;
  public const int WHERE = 339;
  public const int WHILE = 340;
  public const int ARGLIST = 341;
  public const int PARTIAL = 342;
  public const int ARROW = 343;
  public const int FROM = 344;
  public const int FROM_FIRST = 345;
  public const int JOIN = 346;
  public const int ON = 347;
  public const int EQUALS = 348;
  public const int SELECT = 349;
  public const int GROUP = 350;
  public const int BY = 351;
  public const int LET = 352;
  public const int ORDERBY = 353;
  public const int ASCENDING = 354;
  public const int DESCENDING = 355;
  public const int INTO = 356;
  public const int INTERR_NULLABLE = 357;
  public const int EXTERN_ALIAS = 358;
  public const int ASYNC = 359;
  public const int REFVALUE = 360;
  public const int REFTYPE = 361;
  public const int MAKEREF = 362;
  public const int GET = 363;
  public const int SET = 364;
  public const int LAST_KEYWORD = 365;
  public const int OPEN_BRACE = 366;
  public const int CLOSE_BRACE = 367;
  public const int OPEN_BRACKET = 368;
  public const int CLOSE_BRACKET = 369;
  public const int OPEN_PARENS = 370;
  public const int CLOSE_PARENS = 371;
  public const int DOT = 372;
  public const int COMMA = 373;
  public const int COLON = 374;
  public const int SEMICOLON = 375;
  public const int TILDE = 376;
  public const int PLUS = 377;
  public const int MINUS = 378;
  public const int BANG = 379;
  public const int ASSIGN = 380;
  public const int OP_LT = 381;
  public const int OP_GT = 382;
  public const int BITWISE_AND = 383;
  public const int BITWISE_OR = 384;
  public const int STAR = 385;
  public const int PERCENT = 386;
  public const int DIV = 387;
  public const int CARRET = 388;
  public const int INTERR = 389;
  public const int DOUBLE_COLON = 390;
  public const int OP_INC = 391;
  public const int OP_DEC = 392;
  public const int OP_SHIFT_LEFT = 393;
  public const int OP_SHIFT_RIGHT = 394;
  public const int OP_LE = 395;
  public const int OP_GE = 396;
  public const int OP_EQ = 397;
  public const int OP_NE = 398;
  public const int OP_AND = 399;
  public const int OP_OR = 400;
  public const int OP_MULT_ASSIGN = 401;
  public const int OP_DIV_ASSIGN = 402;
  public const int OP_MOD_ASSIGN = 403;
  public const int OP_ADD_ASSIGN = 404;
  public const int OP_SUB_ASSIGN = 405;
  public const int OP_SHIFT_LEFT_ASSIGN = 406;
  public const int OP_SHIFT_RIGHT_ASSIGN = 407;
  public const int OP_AND_ASSIGN = 408;
  public const int OP_XOR_ASSIGN = 409;
  public const int OP_OR_ASSIGN = 410;
  public const int OP_PTR = 411;
  public const int OP_COALESCING = 412;
  public const int OP_GENERICS_LT = 413;
  public const int OP_GENERICS_LT_DECL = 414;
  public const int OP_GENERICS_GT = 415;
  public const int LITERAL = 416;
  public const int IDENTIFIER = 417;
  public const int OPEN_PARENS_LAMBDA = 418;
  public const int OPEN_PARENS_CAST = 419;
  public const int GENERIC_DIMENSION = 420;
  public const int DEFAULT_COLON = 421;
  public const int OPEN_BRACKET_EXPR = 422;
  public const int EVAL_STATEMENT_PARSER = 423;
  public const int EVAL_COMPILATION_UNIT_PARSER = 424;
  public const int EVAL_USING_DECLARATIONS_UNIT_PARSER = 425;
  public const int GENERATE_COMPLETION = 426;
  public const int COMPLETE_COMPLETION = 427;
  public const int UMINUS = 428;
  public const int yyErrorCode = 256;
 }
 namespace yyParser {
  using System;
  /** thrown for irrecoverable syntax errors and stack overflow.
    */
  internal class yyException : System.Exception {
    public yyException (string message) : base (message) {
    }
  }
  internal class yyUnexpectedEof : yyException {
    public yyUnexpectedEof (string message) : base (message) {
    }
    public yyUnexpectedEof () : base ("") {
    }
  }

  /** must be implemented by a scanner object to supply input to the parser.
    */
  internal interface yyInput {
    /** move on to next token.
        @return false if positioned beyond tokens.
        @throws IOException on input error.
      */
    bool advance (); // throws java.io.IOException;
    /** classifies current token.
        Should not be called if advance() returned false.
        @return current %token or single character.
      */
    int token ();
    /** associated with current token.
        Should not be called if advance() returned false.
        @return value for token().
      */
    Object value ();
  }
 }
} // close outermost namespace, that MUST HAVE BEEN opened in the prolog
