#include <QMessageBox>
#include "importevents.h"
#include "ui_importevents.h"
#include <QFileDialog>
#include <QFile>
#include <QDebug>
#include <QSqlDatabase>
#include <QSqlQuery>
#include <QSqlError>
#include <QSqlRecord>
#include <QtNetwork>
#include <QtEndian>

//QSqlRecord rec;
//QSqlDatabase db;
//QSqlDatabase db;

int iEventID = -1;

const int cFileVersion     = 1;
const int cHeaderSize      = 89;
const int cTeamSize        = 42;
const int cMatchSize       = 9;
const int cLeagueNameChars = 16;
const int cTeamNameChars   = 10;

QHash<int, QString> hTeamIDs;
QHash<int, int> hiTeamIDs;

importevents::importevents(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::importevents)
{
    ui->setupUi(this);

}

importevents::~importevents()
{
    delete ui;
}

void importevents::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void importevents::on_pushBrowse_clicked()
{

    QString fileName;

    QString homepath(QDir::home().path());

    fileName = QFileDialog::getOpenFileName(this,
         tr("Open Event Info"), homepath, tr("Event Files (*.txt)"));

    ui->plainFileName->setPlainText(fileName);
}

void importevents::on_pbTeamRooster_clicked()
{
    importTeamRooster();
}

void importevents::on_pbTeamStats_clicked()
{
    importTeamStats();
}

void importevents::importTeamStats()
{
//    LoadHeader();
}

void importevents::LoadMatch()
{
}

void importevents::LoadTeam()
{
}

void importevents::LoadHeader(int iSoccerDbID, int iEventRowID, QString sLatestGameDate)
{
    QString sSelectedSoccerDBID;
    QString sCurrentGameDate;
//    QString sLatestGameDate;
    QString sDay;
    QString sMonth;
    QNetworkAccessManager manager;
    QEventLoop loop;
    QString sURL;
    QString path;
    QSqlQuery qry;

//    sLatestGameDate = getLatestGameDate(iEventID);
//    qDebug() << sLatestGameDate;

    sSelectedSoccerDBID.setNum(iSoccerDbID);
    iEventID = iEventRowID;
    sURL = "http://www.aragon.ws/soccerdb/util/ppccreate.php?id=" + sSelectedSoccerDBID;
    qDebug() << sURL;

    // TO REMOVE COMMENT WHEN ENABLING ONLINE DOWNLOAD AGAIN
    QNetworkReply *reply = manager.get( QNetworkRequest(QUrl(sURL)));
    QObject::connect(reply, SIGNAL(finished()), &loop, SLOT(quit()));
    loop.exec();


#ifdef Q_OS_LINUX
        // NOTE: We have to store database file into user home folder in Linux
        path = QDir::home().path();
        path.append(QDir::separator()).append(".mobitifo").append(QDir::separator()).append("tempfile.ts");
        path = QDir::toNativeSeparators(path);
#else
        path = "tempfile.ts" ;
        // NOTE: File exists in the application private folder, in Symbian Qt implementation
#endif
    qDebug() << "path=" <<path;
    QFile file( path );

    // TO REMOVE COMMENT WHEN ENABLING ONLINE DOWNLOAD AGAIN
    file.open(QIODevice::WriteOnly);
    file.write(reply->readAll());
    file.close();
    delete reply;


    file.open(QIODevice::ReadOnly);
    QDataStream in(&file);    // read the data serialized from the file
    QString str;

    char pline[cLeagueNameChars * 4] = {0};
    int readLength ;
    int iGroupID;

    qint8 Version;
    qint16 Year;
    qint8 TeamCount;
    qint8 RoundCount;
    qint16 MatchCount;
    qint16 PlayedMatchCount;

    qint8 WinPoints;
    qint8 DrawPoints;
    qint8 LossPoints;

    qint8 TableSort;
    qint64 TableLines;


    readLength = in.readRawData(pline, 4);
    qDebug() << "readLength" << readLength ;
    qDebug() << "File Type (should be mbTS)" << pline;

    if (QString("mbTS").compare(QString(pline)) == 0)
    {

        deleteGames(iEventID);

        qry.prepare("BEGIN");
        if (!qry.exec())
        {
            qDebug() << qry.lastQuery();
            qDebug() << qry.lastError();
        }


        in >> Version;
        qDebug() << Version;

        char pline3[cLeagueNameChars * 4] = {0};
        readLength = in.readRawData(pline3, cLeagueNameChars * 4);
        qDebug() << "readLength" << readLength ;
        qDebug() << "LeagueName" << pline3;

        in >> Year;
        Year =  qFromBigEndian(Year);
        qDebug() << Year;
        in >> TeamCount;
  //      qDebug() << TeamCount;
        in >> RoundCount;
  //      qDebug() << RoundCount;
        in >> MatchCount;
        MatchCount =  qFromBigEndian(MatchCount);
//        qDebug() << MatchCount;
        in >> PlayedMatchCount;
        PlayedMatchCount =  qFromBigEndian(PlayedMatchCount);
//        qDebug() << PlayedMatchCount;

        in >> WinPoints;
//        qDebug() << WinPoints;
        in >> DrawPoints;
//        qDebug() << DrawPoints;
        in >> LossPoints;
//        qDebug() << LossPoints;
        in >> TableSort;
//        qDebug() << TableSort;
        in >> TableLines;
//        qDebug() << TableLines;

        qint8 BonusPoints;
        qint8 HiddenPoints;
        int teamID;
        hTeamIDs.clear();
        QString sTeamName;
//      Do away with the group table. Use event id instead.
//        iGroupID = createGroup(QString(pline3));
        iGroupID = iEventID ;

        for (int i=0; i<TeamCount; i++)
        {
            readLength = in.readRawData(pline, cTeamNameChars * 4);
//            qDebug() << "readLength" << readLength ;
            qDebug() << "pline" << pline;
            sTeamName = QString::fromUtf8(pline);

            in >> BonusPoints;
//            qDebug() << BonusPoints;

            in >> HiddenPoints;
//            qDebug() << HiddenPoints;

//            teamID = createTeam(QString(pline), iGroupID );
            teamID = createTeam(sTeamName, iGroupID );
 //           hTeamIDs[i] = QString(pline);
            hiTeamIDs[i] = teamID;
            // Create hash between row id in the database and id from the file.
        }
        qry.prepare("COMMIT");
        if (!qry.exec())
        {
            qDebug() << qry.lastQuery();
            qDebug() << qry.lastError();
        }

        qint8 match_Round;//      = (int)reader.ReadByte();
        qint16 year;//         = (int)reader.ReadInt16();
        qint8 month;//        = (int)reader.ReadByte();
        qint8 day;//          = (int)reader.ReadByte();
        qint8 HomeTeamId; // = (int)reader.ReadByte();
        qint8 AwayTeamId; // = (int)reader.ReadByte();
        qint8 HomeGoals; //  = (int)reader.ReadSByte();
        qint8 AwayGoals; //  = (int)reader.ReadSByte();


        qry.prepare("BEGIN");
        if (!qry.exec())
        {
            qDebug() << qry.lastQuery();
            qDebug() << qry.lastError();
        }


        while (!in.atEnd())
        {
            in >> match_Round;
//            qDebug() << match_Round;

            in >> year;
            year =  qFromBigEndian(year);
//            qDebug() << year;

            in >> month;
//            qDebug() << month;

            in >> day;
//            qDebug() << day;

            if (month <10)
            {
                sMonth = "0" + QString::number(month);
            }
            else
            {
                sMonth = QString::number(month);
            }
//            qDebug() << "Month:" << sMonth;
            if (day <10)
            {
                sDay = "0" + QString::number(day);
            }
            else
            {
                sDay = QString::number(day);
            }
//            qDebug() << "Day:" << sDay;

            sCurrentGameDate = QString::number(year).append("-").append(sMonth).append("-").append(sDay);
            qDebug() << sCurrentGameDate;

            in >> HomeTeamId;
//            qDebug() << HomeTeamId;
//            qDebug() << hTeamIDs.value(HomeTeamId);

            in >> AwayTeamId;
//            qDebug() << AwayTeamId;
//            qDebug() << hTeamIDs.value(AwayTeamId);

            in >> HomeGoals;
//            qDebug() << HomeGoals;

            in >> AwayGoals;
//            qDebug() << AwayGoals;

            if (sCurrentGameDate > sLatestGameDate)
            {
            createGame(QString(pline3),
                       match_Round,
                       sCurrentGameDate,
                       QString(hTeamIDs.value(HomeTeamId)),
                       QString(hTeamIDs.value(AwayTeamId)),
                       HomeGoals,
                       AwayGoals,
                       hiTeamIDs.value(HomeTeamId),
                       hiTeamIDs.value(AwayTeamId));
            }
        }

        qry.prepare("COMMIT");
        if (!qry.exec())
        {
            qDebug() << qry.lastQuery();
            qDebug() << qry.lastError();
        }

    }
    else
    {
        //Download failed
        qDebug() << "Download failed";
        QString message = QString("Download Failed!");
//        QMessageBox::warning ( this, tr("About"), message);
    }

    file.close();

    file.remove();

    return;
}

void importevents::deleteGames(int iEventID)
{
    QSqlQuery qry;
    qry.prepare("DELETE FROM games "
                "WHERE grouprowid=" + QString::number(iEventID));

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    return;
}

QString importevents::getLatestGameDate(int iEventID)
{

    QString sLatestGameDate;
    QSqlQuery qry;

/*
    qry.prepare("SELECT MAX(gametime) "
                "FROM games "
                "WHERE homegoals<>-1 AND awaygoals<>-1 "
                "AND grouprowid=" + QString::number(iEventID));
*/
    qry.prepare("SELECT gametime "
                "FROM games ");
//                "WHERE homegoals<>-1 AND awaygoals<>-1 "
//                "AND grouprowid=" + QString::number(iEventID) + " ORDER BY gametime DESC LIMIT 1");

    qDebug() << iEventID;

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    qry.next();

    if (qry.isValid())
    {
        sLatestGameDate = qry.value(0).toString();
        qDebug() << sLatestGameDate;
        if (sLatestGameDate == "")
        {
            sLatestGameDate = "1800-01-01";
        }
     }
    else
    {
        sLatestGameDate = "1800-01-01";
    }

    qDebug() << sLatestGameDate;

    return sLatestGameDate;
}


void importevents::on_pbSoccerDB_clicked()
{

    ui->lblImporting->setText("Importing...");

//    createDatabase();
//    purgeDatabase();
    qApp->processEvents();

    createDatabase();

    importSoccerDBLeagues();

    ui->lblImporting->setText("");

    return;

}


void importevents::on_pushImport_clicked()
{

    ui->lblImporting->setText("Importing...");

//    createDatabase();
//    purgeDatabase();
    qApp->processEvents();

    createDatabase();
    QSqlQuery qry;

    qry.prepare("BEGIN");
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    createEvent(ui->txtEventName->toPlainText(),QString(""),QString(""),QString(""),0);
    importGames(ui->plainFileName->toPlainText());
    qry.prepare("COMMIT");
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    ui->lblImporting->setText("");

    return;

}

void importevents::importdelimited(QString filename)
{
    QFile filedelimited(filename);
    QString strDelimiter;
    QSqlQuery qry;


    filedelimited.open( QIODevice::ReadOnly );

    QTextStream filestream(&filedelimited);
    filestream.setCodec("UTF-8");

    qry.prepare("BEGIN");
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    QString line;
    while (!filestream.atEnd()) {
    }


    filedelimited.close();

    qry.prepare("COMMIT");
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    filedelimited.setPermissions(QFile::ReadOwner | QFile::WriteOwner | QFile::ReadUser |QFile::WriteUser);

}


void importevents::importSoccerDBLeagues()
{
    QFile filedelimited(ui->plainFileName->toPlainText());
    int i;
    bool bisFirstLine =true;
    QString strDelimiter;
    QSqlQuery qry;


    filedelimited.open( QIODevice::ReadOnly );

    QTextStream filestream(&filedelimited);
    filestream.setCodec("UTF-8");

    qry.prepare("BEGIN");
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    QString line;
    while (!filestream.atEnd()) {
        line = filestream.readLine();
        line.truncate(line.length());

        if (bisFirstLine)
        {
//            qDebug() << line;
            //Identify the used delimiter
            if (line.indexOf("|")!= -1)
            {
                strDelimiter = "|";
            }
            else if (line.indexOf("\t")!= -1)
            {
                strDelimiter = "\t";
            }
            else if (line.indexOf(",")!= -1)
            {
                strDelimiter = ",";
            }
            else if (line.indexOf(";")!= -1)
            {
                strDelimiter = ";";
            }
            else if (strDelimiter=="")
            {
                qDebug() << "Unknown Delimiter";
                return;
            }
            bisFirstLine = false;

       }

        QStringList list1 = line.split(strDelimiter);

        for (i=0; i<list1.count(); i++)
        {
//            qDebug() << list1[i];
        }
        createEvent(list1[1], QString("Football"), list1[2], list1[0], list1[3].toInt());

    }

    qry.prepare("COMMIT");
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

}


void importevents::importTeamRooster()
{
    QFile filedelimited(ui->plainFileName->toPlainText());
    int i;
    bool bisFirstLine =true;
    QString strDelimiter;
    QSqlQuery qry;

    filedelimited.open( QIODevice::ReadOnly );

    QTextStream filestream(&filedelimited);
    filestream.setCodec("UTF-8");

    qry.prepare("BEGIN");
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    QString line;
    while (!filestream.atEnd()) {
        line = filestream.readLine();
        line.truncate(line.length());

        if (bisFirstLine)
        {
//            qDebug() << line;
            //Identify the used delimiter
            if (line.indexOf("|")!= -1)
            {
                strDelimiter = "|";
            }
            else if (line.indexOf("\t")!= -1)
            {
                strDelimiter = "\t";
            }
            else if (line.indexOf(",")!= -1)
            {
                strDelimiter = ",";
            }
            else if (line.indexOf(";")!= -1)
            {
                strDelimiter = ";";
            }
            else if (strDelimiter=="")
            {
                qDebug() << "Unknown Delimiter";
                return;
            }
            bisFirstLine = false;

       }

        QStringList list1 = line.split(strDelimiter);

        for (i=0; i<list1.count(); i++)
        {
//            qDebug() << list1[i];
        }
        createTeamRooster(list1[0], list1[1].toInt(), list1[2] );
    }

    qry.prepare("COMMIT");
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

}



void importevents::purgeDatabase()
{
    QSqlQuery qry;

    if (!qry.exec("DELETE FROM events"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("DELETE FROM teams"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("DELETE FROM teamgroups"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("DELETE FROM games"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

}

void importevents::importGames(QString sFileName)
{
    QFile filedelimited(sFileName);
    int i;
    int iGroupID;
    bool bisFirstLine =true;
    QString strDelimiter;
    QSqlQuery qry;


    filedelimited.open( QIODevice::ReadOnly );

    QTextStream filestream(&filedelimited);
    filestream.setCodec("UTF-8");

    qry.prepare("BEGIN");
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    QString line;
    while (!filestream.atEnd()) {
        line = filestream.readLine();
        line.truncate(line.length());

        if (bisFirstLine)
        {
//            qDebug() << line;
            //Identify the used delimiter
            if (line.indexOf("|")!= -1)
            {
                strDelimiter = "|";
            }
            else if (line.indexOf("\t")!= -1)
            {
                strDelimiter = "\t";
            }
            else if (line.indexOf(",")!= -1)
            {
                strDelimiter = ",";
            }
            else if (line.indexOf(";")!= -1)
            {
                strDelimiter = ";";
            }
            else if (strDelimiter=="")
            {
                qDebug() << "Unknown Delimiter";
                return;
            }
            bisFirstLine = false;

       }


        QStringList list1 = line.split(strDelimiter);

        for (i=0; i<list1.count(); i++)
        {
//            qDebug() << list1[i];
        }
        iGroupID = createGroup(list1[0]);
        createTeam(list1[3], iGroupID );
        createTeam(list1[4], iGroupID );
//        createGame(list1);
        if (list1.size()>5)
        {
            // Results have been provided. Pass them.
            createGame(list1[0], list1[1].toInt(), list1[2], list1[3], list1[4], list1[5].toInt(), list1[6].toInt());
        }
        else
        {
            // Results have not been provided. Pass -1.
            createGame(list1[0], list1[1].toInt(), list1[2], list1[3], list1[4], -1, -1);
        }
    }

    qry.prepare("COMMIT");
    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

}


//"(name TEXT, sport TEXT, season TEXT, region TEXT)"))

int importevents::getEventID(QString sEventName,
                            QString sSport,
                            QString sSeason,
                            QString sRegion)
{
    QSqlQuery qry;

//    qDebug() << "sEventName" << sEventName;

    qry.prepare("SELECT rowid FROM events WHERE sport=:sport and region=:region and name=:name and season=:season");
    qry.bindValue(":sport", sSport);
    qry.bindValue(":region", sRegion);
    qry.bindValue(":name", sEventName);
    qry.bindValue(":season", sSeason);

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    iEventID = -1;

    if (qry.next()) {
        iEventID = qry.value(0).toInt();
        qDebug() << qry.lastQuery();
        qDebug() << iEventID;
     }

    return iEventID;
}


void importevents::createEvent(QString sEventName,
                               QString sSport,
                               QString sSeason,
                               QString sRegion,
                               int iSoccerDbID)
{
    QSqlQuery qry;

    iEventID = getEventID(sEventName,
                          sSport,
                          sSeason,
                          sRegion);

    // Only insert if the Group does not already exist.
    if (iEventID < 1)
    {
        qry.prepare("INSERT INTO events (name, sport, season, region, soccerdbid) VALUES "
                    "(:name, :sport, :season, :region, :soccerdbid)");

        qry.bindValue(":name", sEventName);
        qry.bindValue(":sport", sSport);
        qry.bindValue(":season", sSeason);
        qry.bindValue(":region", sRegion);
        qry.bindValue(":soccerdbid", iSoccerDbID);


        if (!qry.exec())
        {
            qDebug() << qry.lastQuery();
            qDebug() << qry.lastError();
            qDebug() << qry.executedQuery();
            qDebug() << qry.boundValues();
        }
        else
        {
//            qDebug() << "Event:" << sEventName;
            iEventID = qry.lastInsertId().toInt();
            qDebug() << "EventID:" << iEventID;
        }
    }
}

void importevents::createTeamRooster(QString sTeamName,
                                     int iPlayerNumber,
                                     QString sPlayerName)
{
    QSqlQuery qry;

//    qDebug() << "sEventName" << sEventName;


    qry.prepare("SELECT rowid FROM teamrooster WHERE team=:teamname and name=:playername and number=:number");
    qry.bindValue(":teamname", sTeamName);
    qry.bindValue(":playername", sPlayerName);
    qry.bindValue(":number", iPlayerNumber);

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    iEventID = -1;

    while (qry.next()) {
        iEventID = qry.value(0).toInt();
//        qDebug() << iEventID;
     }

    // Only insert if the Group does not already exist.
    if (iEventID < 1)
    {
        qry.prepare("INSERT INTO teamrooster (team, name, number) VALUES "
                    "(:teamname, :playername, :number)");

        qry.bindValue(":teamname", sTeamName);
        qry.bindValue(":playername", sPlayerName);
        qry.bindValue(":number", iPlayerNumber);


        if (!qry.exec())
        {
            qDebug() << qry.lastQuery();
            qDebug() << qry.lastError();
            qDebug() << qry.executedQuery();
            qDebug() << qry.boundValues();
        }
        else
        {
//            qDebug() << "Event:" << sEventName;
            iEventID = qry.lastInsertId().toInt();
            qDebug() << "EventID:" << iEventID;
        }
    }
}

int importevents::createGroup(QString sGroupName)
{
    QSqlQuery qry;
    int iGroupRowID = -1;

//    qDebug() << "sGroupName" << sGroupName;

    qry.prepare("SELECT rowid FROM teamgroups WHERE name=:name and eventrowid=:eventrowid");
    qry.bindValue(":name", sGroupName);
    qry.bindValue(":eventrowid", iEventID);

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (qry.next()) {
        iGroupRowID = qry.value(0).toInt();
//        qDebug() << iGroupRowID;
     }

    // Only insert if the Group does not already exist.
    if (iGroupRowID < 0)
    {
        qry.prepare("INSERT INTO teamgroups (rowid, name, eventrowid) VALUES "
                    "(:rowid, :name, :eventrowid)");

        qry.bindValue(":name", sGroupName);
        qry.bindValue(":eventrowid", iEventID);
        qry.bindValue(":rowid", iEventID);

        if (!qry.exec())
        {
            qDebug() << qry.lastQuery();
            qDebug() << qry.lastError();
            qDebug() << qry.executedQuery();
            qDebug() << qry.boundValues();
        }
        else
        {
//            qDebug() << "Group:" << sGroupName;
//            qDebug() << "EventID:" << iEventID;
            iGroupRowID = qry.lastInsertId().toInt();
        }
    }
//    qDebug() << "RowID:" << iGroupRowID;
    return iGroupRowID;
}



int importevents::createTeam(QString sTeamName, int iGroupRowID)
{
    QSqlQuery qry;
    int iTeamCount;
    int rowID;

//    qDebug() << "sTeamName" << sTeamName;

    qry.prepare("SELECT COUNT(*) as teamcount FROM teams WHERE name=:name and grouprowid=:grouprowid");
    qry.bindValue(":name", sTeamName);
    qry.bindValue(":grouprowid", iGroupRowID);

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

//    qDebug() << "rowid" << qry.value(0).toInt();
//    qDebug() << "name" << qry.value(1).toString();
//    qDebug() << "teams qry.size()" << qry.size() ;

    while (qry.next()) {
        iTeamCount= qry.value(0).toInt();
//        qDebug() << iTeamCount;
     }

    // Only insert if the Team does not already exist.
    if (iTeamCount< 1)
    {
        qry.prepare("INSERT INTO teams (name, grouprowid) VALUES "
                    "(:name, :grouprowid)");

        qry.bindValue(":name", sTeamName);
        qry.bindValue(":grouprowid", iGroupRowID);

        if (!qry.exec())
        {
            qDebug() << qry.lastQuery();
            qDebug() << qry.lastError();
            qDebug() << qry.executedQuery();
            qDebug() << qry.boundValues();
            rowID = -1;
        }
        else
        {
            rowID = qry.lastInsertId().toInt();
//            qDebug() << "Team:" << sTeamName << iGroupRowID;
        }
    }
    return rowID;
}

void importevents::createGame(QString sEventName,
                              int iRound,
                              QString sGameTime,
                              QString sHomeTeamName,
                              QString sAwayTeamName,
                              int iHomeGoals,
                              int iAwayGoals,
                              int iHomeTeamID,
                              int iAwayTeamID)
{
/*
    qDebug() << sEventName;
    qDebug() << iRound;
    qDebug() << sGameTime;
    qDebug() << sHomeTeamName;
    qDebug() << sAwayTeamName;
    qDebug() << iHomeGoals;
    qDebug() << iAwayGoals;
*/
    int ihometeamrowid;
    int iawayteamrowid;
    int igrouprowid;
    QSqlQuery qry;

    if (iHomeTeamID == -1)
    {
        qry.prepare("SELECT rowid FROM teams WHERE name=:name");
        qry.bindValue(":name", sHomeTeamName);

        if (!qry.exec())
        {
            qDebug() << qry.lastQuery();
            qDebug() << qry.lastError();
        }
        qry.next();
        ihometeamrowid = qry.value(0).toInt();
    }
    else
    {
        ihometeamrowid = iHomeTeamID;
    }

    if (iAwayTeamID== -1)
    {
        qry.prepare("SELECT rowid FROM teams WHERE name=:name");
        qry.bindValue(":name", sAwayTeamName);

        if (!qry.exec())
        {
            qDebug() << qry.lastQuery();
            qDebug() << qry.lastError();
        }
        qry.next();
        iawayteamrowid = qry.value(0).toInt();
    }
    else
    {
        iawayteamrowid = iAwayTeamID;
    }


    /*
    if (iEventID != -1)
    {
        qry.prepare("SELECT rowid FROM teamgroups WHERE name=:name");
        qry.bindValue(":name", sEventName);

        if (!qry.exec())
        {
            qDebug() << qry.lastQuery();
            qDebug() << qry.lastError();
        }
        qry.next();
        igrouprowid = qry.value(0).toInt();
    }
    else
    {
        igrouprowid = iEventID;
    }
    */

    /*
    // Update if the game already exists in the database.
    qry.prepare("UPDATE games "
                "SET gametime=:gametime, "
                "homegoals=:homegoals, "
                "awaygoals=:awaygoals "
                "WHERE grouprowid=:grouprowid "
                "AND hometeamrowid=:hometeamrowid "
                "AND awayteamrowid=:awayteamrowid "
                "AND round=:round");

    qry.bindValue(":grouprowid", igrouprowid);
    qry.bindValue(":round", iRound);
    qry.bindValue(":gametime", sGameTime);
    qry.bindValue(":hometeamrowid", ihometeamrowid);
    qry.bindValue(":awayteamrowid", iawayteamrowid);
    qry.bindValue(":homegoals", iHomeGoals);
    qry.bindValue(":awaygoals", iAwayGoals);

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
        qDebug() << qry.executedQuery();
        qDebug() << qry.boundValues();
    }
    qDebug() << qry.numRowsAffected();
    */
    //If the game did not exist, INSERT it.
//    if (qry.numRowsAffected() == 99)
//    {
        qry.prepare("INSERT INTO games (grouprowid, hometeamrowid, awayteamrowid, gametime, homegoals, awaygoals, round) VALUES "
                    "(:grouprowid, :hometeamrowid, :awayteamrowid, :gametime, :homegoals, :awaygoals, :round)");

//        qry.bindValue(":grouprowid", igrouprowid);
        qry.bindValue(":grouprowid", iEventID);
        qry.bindValue(":round", iRound);
        qry.bindValue(":gametime", sGameTime);
        qry.bindValue(":hometeamrowid", ihometeamrowid);
        qry.bindValue(":awayteamrowid", iawayteamrowid);

    //    if (iHomeGoals>-1)
    //    {
            qry.bindValue(":homegoals", iHomeGoals);
            qry.bindValue(":awaygoals", iAwayGoals);
    //    }
    //    else
    //    {
    //        qry.bindValue(":homegoals", 0);
    //        qry.bindValue(":awaygoals", 0);
    //    }

        if (!qry.exec())
        {
            qDebug() << qry.lastQuery();
            qDebug() << qry.lastError();
            qDebug() << qry.executedQuery();
            qDebug() << qry.boundValues();
        }
//    }
}

void importevents::upgradeDatabase()
{
    QSqlQuery qry;
    QString sVersion;

    qry.prepare("SELECT value "
                "FROM settings "
                "WHERE name='version'");

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    qry.next();

    if (qry.isValid())
    {
        sVersion = qry.value(0).toString();
     }
    else
    {
        sVersion = "0.0.7";
    }

}

void importevents::createDatabase()
{

    QSqlDatabase db;
    db = QSqlDatabase::addDatabase("QSQLITE");

    #ifdef Q_OS_LINUX
                // NOTE: We have to store database file into user home folder in Linux
                QString path(QDir::home().path());
                path.append(QDir::separator()).append(".mobitifo").append(QDir::separator()).append("mobitifo.db");
//                path.append(QDir::separator()).append("mobitifo.db");
                path = QDir::toNativeSeparators(path);
//        qDebug() << "Db path:" << path;
                db.setDatabaseName(path);
    #else
                // NOTE: File exists in the application private folder, in Symbian Qt implementation
                db.setDatabaseName("mobitifo.db");
    #endif

    if (!db.open())
    {
        qDebug() << "Failed to connect";
        qDebug() << db.lastError();
    }

    QSqlQuery qry;

    if (!qry.exec("CREATE TABLE IF NOT EXISTS teams "
        "(name TEXT, flag TEXT, grouprowid INT)"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("CREATE TABLE IF NOT EXISTS games "
        "(hometeamrowid INT, awayteamrowid INT, grouprowid INT, gametime TEXT, homegoals INT, awaygoals INT, round INT)"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("CREATE TABLE IF NOT EXISTS teamgroups "
                  "(name TEXT, eventrowid INT )"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("CREATE TABLE IF NOT EXISTS events "
                  "(name TEXT, sport TEXT, season TEXT, region TEXT, soccerdbid INT)"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("CREATE TABLE IF NOT EXISTS favourites "
                  "(showdefault INT, sport TEXT, region TEXT, name TEXT, url TEXT)"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("CREATE TABLE IF NOT EXISTS teamrooster "
                  "(team TEXT, name TEXT, number INT, rating INT)"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("CREATE TABLE IF NOT EXISTS settings "
                  "(name TEXT, value TEXT)"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

    if (!qry.exec("CREATE TABLE IF NOT EXISTS gametracking "
                  "(playername TEXT, event TEXT, eventtime TIME)"))
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }

}

