#include <QDebug>
#include <QSqlQuery>
//#include <QSqlDatabase>
#include <QSqlQuery>
#include <QSqlError>
//#include <QSqlRecord>
#include <QColor>
#include "teamrooster.h"
#include "ui_teamrooster.h"

QString sHomeTeam = "";
QString sAwayTeam = "";


/*
teamrooster::teamrooster(QWidget *parent)
    : QDialog(parent), ui(new Ui::teamrooster)
{
    ui->setupUi(this);
}
*/

//teamrooster::teamrooster(QWidget *parent)
//    : QMainWindow(parent), window(0)

teamrooster::teamrooster(QWidget *parent, QString sTeam1, QString sTeam2)
    : QMainWindow(parent), ui(new Ui::teamrooster)
{


    ui->setupUi(this);

//#ifndef Q_WS_HILDON
//    ui->centralwidget->setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
//#endif
    sHomeTeam = sTeam1;
    sAwayTeam = sTeam2;

    populateTeamRooster(sHomeTeam);
//   setWindowTitle("This is a main window");
//    #ifdef Q_WS_MAEMO_5
//        setAttribute(Qt::WA_Maemo5StackedWindow);
//    #endif
//    connect(button, SIGNAL(clicked(bool)), this, SLOT(buttonClicked(bool)));
}

teamrooster::~teamrooster()
{
    delete ui;
}

void teamrooster::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void teamrooster::populateTeamRooster(QString sTeamName)
{
    QSqlQuery qry;
    QString sql;
    int i, j, iRating;
    int iRowCount;

    i=0;

    qDebug() << sTeamName;

    ui->txtTeamName->setText(sTeamName);

    sql ="SELECT number, name, rating from teamrooster "
         "WHERE team=:teamname "
         "ORDER BY number ";

    qry.prepare(sql);
    qry.bindValue(":teamname", sTeamName);
    qDebug() << sTeamName;

    if (!qry.exec())
    {
        qDebug() << qry.lastQuery();
        qDebug() << qry.lastError();
    }


    iRowCount = ui->twTeamRooster->rowCount();
    for (j = 0; j<=iRowCount-1; j++)
    {
        ui->twTeamRooster->removeRow(0);
    }
    while (qry.next()) {
        ui->twTeamRooster->setRowCount(ui->twTeamRooster->rowCount()+1);
        QTableWidgetItem *newItem;

        qDebug() << qry.value(0).toString();
        qDebug() << qry.value(1).toString();
        iRating = qry.value(2).toInt();

        if (iRating>127)
        {
            iRating = 127;

        }

        if (iRating<-127)
        {
            iRating = -127;

        }

        newItem = new QTableWidgetItem(qry.value(0).toString() + ". " + qry.value(1).toString()); //Number & name
        newItem->setFlags(Qt::NoItemFlags);
/*
        if (iRating < 0)
        {
            newItem->setBackgroundColor(QColor(-1 * iRating,0,0));
        }
        else
        {
            newItem->setBackgroundColor(QColor(0,iRating,0));
        }
*/
        ui->twTeamRooster->setItem(ui->twTeamRooster->rowCount()-1, 0, newItem);

        newItem = new QTableWidgetItem(1);//add
        newItem->setIcon(QIcon(":/images/icons/resource/lightblue_64/Plus-64.png")); //Add Icon
        ui->twTeamRooster->setItem(ui->twTeamRooster->rowCount()-1, 1, newItem);

        newItem = new QTableWidgetItem(2);//remove
        newItem->setIcon(QIcon(":/images/icons/resource/lightblue_64/Minus-64.png")); //Remove Icon
        ui->twTeamRooster->setItem(ui->twTeamRooster->rowCount()-1, 2, newItem);

        i++;
    }

}

void teamrooster::on_twTeamRooster_clicked ( const QModelIndex & index )
{
    QSqlQuery qry;
    QString sql;
    QTableWidgetItem *qtwiItem;
    int row, column, iRating;
    QString sPlayerName;
    QColor bgColor;

    row = index.row();
    column = index.column();

    if (column != 1)
    {

        qtwiItem = ui->twTeamRooster->item(row,1);
        sPlayerName = qtwiItem->text();

        sql = "UPDATE teamrooster SET rating=rating+:rating "
              "WHERE name=:name ";

        qry.prepare(sql);
        if (column == 0)
        {
            iRating = 1;
        }
        else if (column == 2)
        {
            iRating = -1;
        }
        qry.bindValue(":name", sPlayerName);
        qry.bindValue(":rating", iRating);

        if (!qry.exec())
        {
            qDebug() << qry.lastQuery();
            qDebug() << qry.lastError();
        }

        bgColor = qtwiItem->backgroundColor();
//        bgColor.setAlpha(127);
        if (iRating>0)
        {
            if (bgColor.red()>0)
            {
                bgColor.setRed(bgColor.red() - iRating);
            }
            else
            {
                bgColor.setGreen(bgColor.green() + iRating);
            }
        }
        else
        {
            if (bgColor.red()>0)
            {
                bgColor.setRed(bgColor.red() - iRating);
            }
            else
            {
                bgColor.setGreen(bgColor.green() + iRating);
            }
        }

        qDebug() << bgColor.red();
        qDebug() << bgColor.green();

        qtwiItem->setBackgroundColor(bgColor);

    }
}

void teamrooster::setHomeTeam(QString sTemp)
{
    sHomeTeam = sTemp;
    qDebug() << sHomeTeam;
}

void teamrooster::setAwayTeam(QString sTemp)
{
    sAwayTeam = sTemp;
    qDebug() << sAwayTeam;
}

void teamrooster::on_pbRemoveSelected_clicked()
{
    int row;

    row =  ui->twTeamRooster->selectedItems().first()->row();
    qDebug() << row;
    ui->twTeamRooster->removeRow(row);
}

void teamrooster::on_pbSwitchTeamSelected_clicked()
{
    if (ui->txtTeamName->text() == sHomeTeam)
    {
        populateTeamRooster(sAwayTeam);
    }
    else
    {
        populateTeamRooster(sHomeTeam);
    }
}
