#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include "importevents.h"
#include "teamrooster.h"
#include <QTreeWidgetItem>
#include <QSqlDatabase>

namespace Ui {
    class MainWindow;
}

const int typeSport = 1;
const int typeRegion = 2;
const int typeEvent = 3;
const int typeSeason = 4;

class MainWindow : public QMainWindow {
    Q_OBJECT
public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::MainWindow *ui;
    QSqlDatabase db;
    importevents *dlgImportEvents;
    void loadMenu();
    void displayGames();
    void populateSelect();
    void populateGroupCombo();
    void populateRoundCombo(int iSelectedEventID);
    void populateEventCombo(QString sSport, QString sRegion);
    void populateTeamCombo();
    void populateSeasonCombo(QString sSport, QString sRegion, QString sEventName);
    void populateRegionCombo(QString sSport);
    void populateSportCombo();
    void populateSeason(QString sSeason);
    void removeEventGames(int iEventRowID);
    void removeEventTeams(int iEventRowID);
    int populateFavourites();
    void showOnlineLeague(int sSelectedSoccerDBID);
    QList<QTreeWidgetItem *> getRegions(QString sSport);
    QList<QTreeWidgetItem *> getEvents(QString sSport, QString sRegion);
    QList<QTreeWidgetItem *> getSeasons(QString sSport, QString sRegion, QString sEventName);
    void showURL();
    int iEventID;
    bool existDatabase();
    void showStandings();
    void showRooster(QString, QString);
    QPointer<QMainWindow> window;
    QString getCurrentSeason(QString sSport, QString sRegion, QString sEvent);
    int getMaxPlayedRound(int iSelectedEventID);
    void setCustomStyleSheets();
    void showLiveScores();
    void showSelectedEvent2();
    void showOnlineTable();
    QString getLatestGameDate(int iEventID);
    QString getNextGameDate(int iEventID);



public slots:
    void showImportEvents();
    void showAbout();
    void showSelectedEvent(QTreeWidgetItem*);

private slots:
    void on_cbGroups_activated(QString);
    void on_cbRounds_activated(QString);
    void on_cbTeam_activated(QString);
//    void on_cbEvents_activated(QString);
//    void on_cbSport_activated(QString);
//    void on_cbRegion_activated(QString);
    void on_cbSeason_activated(QString);
    void on_pbAddFavourite_clicked();
    void on_pbRemoveFavourite_clicked();
    void on_twFavourites_clicked ( const QModelIndex & index );
    void on_tabWidget_currentChanged ( int index );
    void on_twFavourites_cellChanged ( int row, int column );
    void on_pbMatchRating_clicked();
    void on_twSelect_itemExpanded (QTreeWidgetItem *item);
    void on_pbDownloadStats_clicked();
    void on_pbBack_clicked();
    void on_pbBackLiveScore_clicked();
    void on_pbUpdateScoreBack_clicked();
    void on_webView_LiveScore_loadFinished(bool ok);
    void on_webView_Chat_loadFinished(bool ok);
    void on_webView_Predict_loadFinished(bool ok);
    void on_pbDumpHTML_clicked();
    void fromRoundChanged(int);
    void toRoundChanged(int);
    void on_pbZoomIn_clicked();
    void on_pbZoomOut_clicked();
    void on_pbZoomOutURL_clicked();
    void on_pbZoomInURL_clicked();
};

#endif // MAINWINDOW_H
