#ifndef IMPORTEVENTS_H
#define IMPORTEVENTS_H

#include <QDialog>
#include <QFile>

namespace Ui {
    class importevents;
}

class importevents : public QDialog {
    Q_OBJECT
public:
    importevents(QWidget *parent = 0);
    ~importevents();
    void purgeDatabase();
    void LoadHeader(int iSoccerDbID, int iEventRowID, QString sLatestGameDate);
    int getEventID(QString sEventName,
                     QString sSport,
                     QString sSeason,
                     QString sRegion);

protected:
    void changeEvent(QEvent *e);

private:
    Ui::importevents *ui;
    void importdelimited(QString filename);
    void import();
    void importTeams();
    void importGames(QString);
    int createGroup(QString);
    int createTeam(QString, int);
    void createGame(QStringList);
    void createGame(QString sEventName,
                    int iRound ,
                    QString sGameTime,
                    QString sHomeTeamName,
                    QString sAwayTeamName,
                    int sHomeGoals,
                    int sAwayGoals,
                    int iHomeTeamID=-1,
                    int iAwayTeamID=-1);
    QString getLatestGameDate(int iEventID);
    void deleteGames(int iEventID);
    void createEvent(QString, QString, QString, QString, int);
    void createDatabase();
    void importSoccerDBLeagues();
    void importTeamRooster();
    void createTeamRooster(QString, int, QString);
    void importTeamStats();
    void LoadMatch();
    void LoadTeam();
    void upgradeDatabase();


private slots:

    void on_pushBrowse_clicked();
    void on_pushImport_clicked();
    void on_pbSoccerDB_clicked();
    void on_pbTeamRooster_clicked();
    void on_pbTeamStats_clicked();
//    void on_pbDownloadStats_clicked();
};

#endif // IMPORTFLASHCARD_H
