#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QImage>
#include "Camera/camera.h"
#include "Bluetooth/bluetoothadapter.h"
#include "Bluetooth/bluetoothdialog.h"
#include "ImageProcessing/imageprocessor.h"
#include "ImageProcessing/colorconfiguration.h"
#include <QTime>
#include <QTimer>
#include <QSettings>
#include <QColor>

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow {
    Q_OBJECT
    public:

        MainWindow(QWidget *parent = 0);
        ~MainWindow();

    private slots:

        void on_actionConnect_to_device_triggered();
        void Turn(bool i);
        void Distance(quint16 i);
        void Rotation(qint8);
        void Objects(int i);

        void on_actionConfigure_Sign_Color_triggered();
        void ImageReady(QImage *img);
        void Connected(BluetoothAdapter *device);
        void TakeTime();

    protected:

        void changeEvent(QEvent *e);

    private:

        int _ellapsedMsecsFromRefresh;
        bool _connected;
        Ui::MainWindow *ui;
        Camera *_cam;
        ImageProcessor *_imgProcessor;
        QTime _prevTake;
        QTimer _takeTimer;
        QColor _selectedColor;
        QSettings _settings;
        BluetoothAdapter *_btDevice;
        BluetoothDialog *_btDlg;
        ColorConfiguration *_colorDlg;
};

#endif // MAINWINDOW_H
