#ifndef IMAGEPROCESSOR_H
#define IMAGEPROCESSOR_H

#include <QObject>
#include <QColor>
#include <QImage>
#include <QList>
#include <QSettings>

struct PointT
{
    int x;
    int y;
};

struct BorderSign
{
    PointT LeftTop;
    PointT RightBottom;
    float rotation;
};

class ImageProcessor : public QObject
{
    Q_OBJECT

    public:

        explicit ImageProcessor(int width, int height, QObject *parent = 0);

    signals:

        void Distance(quint16 i);
        void TurnExceed(bool i);
        void ImageProcessingCompletted(QImage* filteredImg);
        void Rotation(qint8 i);
        void ObjectCount(int i);


    public slots:

        void PictureReady(QImage* image);
        void SetSignColor(QColor color);
        void SetFiltering(bool filtering);
        void SetColorTolerance(int colorTolerance);
        void SetTurnLimit(int turnLimit);

    private:

        int _turnLimit;
        QColor _sign;
        int _colorTolerance;
        int _distanceTolerance;
        bool _filtering;

        QImage _filteredImg;
        int _width;
        int _height;
        QList<BorderSign> _borderSigns;
        QSettings _settings;

        void AnalysePixels();
        bool IsNearColor(uchar r, uchar g, uchar b);
        bool IsNearLineColor(uchar r, uchar g, uchar b);
        void ColorAndSobelFilter(const QImage *source);

};

#endif // IMAGEPROCESSOR_H
