#ifndef COLORCONFIGURATION_H
#define COLORCONFIGURATION_H

#include <QDialog>
#include <QtGui>

namespace Ui {
    class ColorConfiguration;
}

class ColorConfiguration : public QDialog {
    Q_OBJECT

    public:

        ColorConfiguration(QWidget *parent = 0);
        ~ColorConfiguration();

    signals:

        void ColorChoosed(QColor color);
        void ColorToleranceChanged(int value);
        void RefreshPicture();

    public slots:

        void PositionRecived(QPoint pos);
        void accept();
        void ImageRecived(QImage *img);

    protected:

        void changeEvent(QEvent *e);

    private:

        QImage *_img;
        QColor _color;
        Ui::ColorConfiguration *ui;

private slots:
    void on_pushButton_clicked();
};

#endif // COLORCONFIGURATION_H
