#include "colorconfiguration.h"
#include "ui_colorconfiguration.h"
#include <QSettings>

ColorConfiguration::ColorConfiguration(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::ColorConfiguration)
{
    QSettings settings;
    ui->setupUi(this);
    _color = QColor::fromRgb(settings.value("sign").toInt());

    QPixmap tmp(40,40);
    tmp.fill(_color);
    ui->_colorLabel->setPixmap(tmp);

    connect(ui->_imgLabel, SIGNAL(ClickCoords(QPoint)), this, SLOT(PositionRecived(QPoint)));

    ui->_colorTolSlider->setValue((int)sqrt(settings.value("colortolerance", 2500).toFloat()));
}

ColorConfiguration::~ColorConfiguration()
{
    delete ui;
}

void ColorConfiguration::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void ColorConfiguration::ImageRecived(QImage *img)
{
    ui->_imgLabel->setPixmap(QPixmap::fromImage(*img));
    _img = img;
}

void ColorConfiguration::PositionRecived(QPoint pos)
{
    int innerX = pos.x() - (ui->_imgLabel->width() - _img->width()) / 2;
    int innerY = pos.y() - (ui->_imgLabel->height() - _img->height()) / 2;
    if (innerX < 0 || innerX >= _img->width()) return;
    if (innerY < 0 || innerY >= _img->height()) return;
    _color = QColor(_img->pixel(innerX,innerY));
    QPixmap tmp(40,40);
    tmp.fill(_color);
    ui->_colorLabel->setPixmap(tmp);
}

void ColorConfiguration::accept()
{
    emit ColorChoosed(_color);
    emit ColorToleranceChanged(ui->_colorTolSpin->value());
    this->close();
}

void ColorConfiguration::on_pushButton_clicked()
{
    emit RefreshPicture();
}
