#ifndef CAMERA_H
#define CAMERA_H

#include <QObject>
#include <QTimer>
#include <QImage>
#include <gst/gst.h>
#include "ImageProcessing/imageprocessor.h"

class Camera : public QObject
{
    Q_OBJECT
    public:

        explicit Camera(char* source, int width, int height, QObject *parent = 0);
        guint GetBuffCallbackNum();
        void CreateImg(unsigned char *data);

    signals:

        void PhotoTaked(QImage *pic);

    public slots:

        void TakePhoto();

    private:

        QImage _takedImage;
        int _width;
        int _height;

        GstElement *_pipeline;
        guint _buffCallbackNum;

        gboolean InitGStreamer(char* source);
        static void BusCallback(GstBus *bus, GstMessage *message, gpointer data);
        static gboolean HandOffImage(
                        GstElement *image_sink,
                        GstBuffer *buffer,
                        GstPad *pad,
                        Camera *camera);

};

#endif // CAMERA_H
