#ifndef BLUETOOTHDIALOG_H
#define BLUETOOTHDIALOG_H

#include <QDialog>
#include <QSettings>
#include "bluetoothadapter.h"

namespace Ui {
    class BluetoothDialog;
}

class BluetoothDialog : public QDialog {
    Q_OBJECT

    public:

        BluetoothDialog(QWidget *parent = 0);
        ~BluetoothDialog();

    signals:
        void NewConnection(BluetoothAdapter *device);

    protected:

        void changeEvent(QEvent *e);

    public slots:

        void btScanCompleted(int deviceID, QVector<DestinationDescriptor> &result);

    private:

        Ui::BluetoothDialog *ui;
        BluetoothAdapter *_btDevice;
        int _deviceID;
        QVector<DestinationDescriptor> _destinationDescriptions;
        QSettings _settings;

    private slots:

        void on_buttonBox_accepted();
        void on__refreshBtn_clicked();
};

#endif // BLUETOOTHDIALOG_H
