#include "bluetoothdialog.h"
#include "ui_bluetoothdialog.h"
#include <QMessageBox>

BluetoothDialog::BluetoothDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::BluetoothDialog)
{
    ui->setupUi(this);

    try
    {
        _btDevice = new BluetoothAdapter();
    }
    catch (BluetoothAdapterError error)
    {
        QMessageBox::warning(
            this,
            tr("Critical error!"),
            tr("Critical error on initializing of the Bluetooth adapter: %1 Is the Bluetooth enabled?")
                .arg(error.errNo)
        );
        exit(1);
    }

    connect(_btDevice, SIGNAL(ScanCompleted(int,QVector<DestinationDescriptor>&)),
            this, SLOT(btScanCompleted(int,QVector<DestinationDescriptor>&)));
    connect(this->ui->_refreshBtn, SIGNAL(clicked()), _btDevice, SLOT(Scan()));

    ui->_portChangeBox->setValue(_settings.value("port", 1).toInt());
    DestinationDescriptor temp;
    temp.address = _settings.value("btaddress", "").toString();
    if (temp.address != "")
    {
        QVector<DestinationDescriptor> tempVector;
        temp.deviceName = _settings.value("btname", "").toString();
        str2ba(temp.address.toLatin1(), &temp.btAddress);
        tempVector.push_back(temp);
        btScanCompleted(hci_get_route(NULL), tempVector);
    }
}

void BluetoothDialog::btScanCompleted(int deviceID,
                                 QVector<DestinationDescriptor> &result)
{
    _destinationDescriptions = result;
    _deviceID = deviceID;
    ui->_btDevicesCombo->clear();
    foreach (DestinationDescriptor curr, _destinationDescriptions)
    {
        ui->_btDevicesCombo->addItem(curr.deviceName);
    }
}

BluetoothDialog::~BluetoothDialog()
{
    delete ui;
}



void BluetoothDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void BluetoothDialog::on__refreshBtn_clicked()
{

}

void BluetoothDialog::on_buttonBox_accepted()
{
    int connection;
    if ((connection = _btDevice->NewConnection(
            _destinationDescriptions[ui->_btDevicesCombo->currentIndex()].btAddress,
            ui->_portChangeBox->value())) == -1)
    {
        QMessageBox::warning(0, tr("Error!"), tr("Error during connecting!"));
        return;
    }
    _settings.setValue("btaddress", _destinationDescriptions[ui->_btDevicesCombo->currentIndex()].address);
    _settings.setValue("btname", _destinationDescriptions[ui->_btDevicesCombo->currentIndex()].deviceName);
    _settings.setValue("port", ui->_portChangeBox->value());
    emit NewConnection(_btDevice);
}
