#ifndef BLUETOOTHCONNECTION_H
#define BLUETOOTHCONNECTION_H

#include <QObject>
#include <bluetooth/bluetooth.h>
#include <bluetooth/rfcomm.h>

class BluetoothConnection : public QObject
{
    Q_OBJECT
    public:
        explicit BluetoothConnection(QObject *parent = 0);
        int ConnectToServer(bdaddr_t destAddress, int channel);
        int Send(QByteArray* message);
        QByteArray* Read();

    public slots:
        void CloseSocket();

    private:
        sockaddr_rc _destSocketAddress;
        int _socket;
        int _status;
        bdaddr_t _destAddress;

};

#endif // BLUETOOTHCONNECTION_H
