#include "bluetoothconnection.h"
#include <QMessageBox>

namespace sysSocket
{
    #include "sys/socket.h"
    int connectEx(int fd, __CONST_SOCKADDR_ARG addr, socklen_t len)
    {
        return connect(fd, addr, len);
    }
}

BluetoothConnection::BluetoothConnection(QObject *parent) :
    QObject(parent)
{
}

int BluetoothConnection::ConnectToServer(bdaddr_t destAddress, int channel)
{
    _socket = socket(AF_BLUETOOTH, SOCK_STREAM, BTPROTO_RFCOMM);

    _destAddress = destAddress;
    _destSocketAddress.rc_family = AF_BLUETOOTH;
    _destSocketAddress.rc_channel = channel;
    _destSocketAddress.rc_bdaddr = _destAddress;

    _status = sysSocket::connectEx(_socket,
        (struct sockaddr *)&_destSocketAddress,
        sizeof(_destSocketAddress));

    if( _status < 0 )
    {
        CloseSocket();
        return -1;
    }

    return (_status = 0);
}

int BluetoothConnection::Send(QByteArray* message)
{
    if (_status == 0)
    {
        _status += write(_socket, message->data(), message->length());
    }

    if (_status != message->length())
    {
        return -1;
    }
    return (_status = 0);
}

QByteArray* BluetoothConnection::Read()
{
    quint8 messageLength, buffer;
    _status += read(_socket, &messageLength, 1);
    _status += read(_socket, &buffer, 1);

    if (messageLength <= 0 || _status !=2)
        return 0;

    QByteArray* result = new QByteArray();

    for (int ck = 0; ck < messageLength;  ck++)
    {
        _status += read(_socket, &buffer, 1);
        result->push_back(buffer);
    }

    if (_status != messageLength + 2)
        return 0;

    _status = 0;
    return(result);
}

void BluetoothConnection::CloseSocket()
{
    close(_socket);
}
