#ifndef BLUETOOTHADAPTER_H
#define BLUETOOTHADAPTER_H

#include <QObject>
#include <QVector>
#include "bluetoothconnection.h"
#include <bluetooth/bluetooth.h>
#include <bluetooth/hci.h>
#include <bluetooth/hci_lib.h>

struct BluetoothAdapterError
{
    int errNo;
    BluetoothAdapterError(int number)
    {
        errNo = number;
    }
};

typedef struct
{
    bdaddr_t btAddress;
    QString address;
    QString deviceName;

} DestinationDescriptor;

class BluetoothAdapter : public QObject
{
    Q_OBJECT
    public:
        explicit BluetoothAdapter(
                int searchTime = 8,
                int maxDestinationCount = 255,
                QString deviceID = "",
                QObject *parent = 0);
        int NewConnection(bdaddr_t destAddress, int channel);
        QByteArray* SendOnConnection(int connection, QByteArray* message);

    signals:
        void ScanCompleted(int deviceID, QVector<DestinationDescriptor> &result);
        void Connected(int);
        void Disconnected(int);

    public slots:
        void Scan(int searchTime = -1);

    private:
        QByteArray* ReadOnConnection(int connection);
        QVector<BluetoothConnection*> _connections;
        QVector<DestinationDescriptor> _availableDestinatoins;
        int _maxDestinationCount;
        int _availableDastinationCount;
        int _deviceID;
        int _socket;
        int _searchTime;
        int _adapterFlags;
};

#endif // BLUETOOTHADAPTER_H
