#include "bluetoothadapter.h"
#include <QMessageBox>

BluetoothAdapter::BluetoothAdapter(
        int searchTime,
        int maxDestinationCount,
        QString deviceID,
        QObject *parent) :
    QObject(parent)
{
    _searchTime = searchTime;

    if (deviceID == "")
    {
        _deviceID = hci_get_route(NULL);
    }
    else
    {
        _deviceID = hci_devid((const char*)deviceID.toLatin1());
    }

    _socket = hci_open_dev(_deviceID);

    if (_deviceID < 0 || _socket < 0)
    {
        throw BluetoothAdapterError(_deviceID);
    }

    _maxDestinationCount = maxDestinationCount;
    _adapterFlags = IREQ_CACHE_FLUSH;
}

void BluetoothAdapter::Scan(int searchTime)
{
    _availableDestinatoins.clear();
    char rawAddress[19] = { 0 };
    char rawName[248] = { 0 };
    inquiry_info *rawDescriptors;
    if (searchTime == -1)
        searchTime = _searchTime;

    rawDescriptors = new inquiry_info[_maxDestinationCount];

    _availableDastinationCount = hci_inquiry(
            _deviceID,
            searchTime,
            _maxDestinationCount,
            NULL,
            &rawDescriptors,
            _adapterFlags);

    if( _availableDastinationCount < 0 )
    {
        throw BluetoothAdapterError(_availableDastinationCount);
    }

    DestinationDescriptor tmp;

    for (int ck = 0; ck < _availableDastinationCount; ck++)
    {
        ba2str(&(rawDescriptors + ck)->bdaddr, rawAddress);
        memset(rawName, 0, sizeof(rawName));

        if (hci_read_remote_name(_socket,
                                 &(rawDescriptors + ck)->bdaddr,
                                 sizeof(rawName),
                                 rawName, 0) < 0)
        strcpy(rawName, tr("[unkown]").toLatin1());

        tmp.btAddress = (rawDescriptors + ck)->bdaddr;
        tmp.address = rawAddress;
        tmp.deviceName = QString(rawName);

        _availableDestinatoins.push_back(tmp);
    }

    delete rawDescriptors;

    emit ScanCompleted(_deviceID, _availableDestinatoins);
}

int BluetoothAdapter::NewConnection(bdaddr_t destAddress, int channel)
{
    BluetoothConnection *tmp = new BluetoothConnection(this);
    if (tmp->ConnectToServer(destAddress, channel) < 0)
    {
        delete tmp;
        return -1;
    }
    _connections.push_back(tmp);
    emit Connected(_connections.indexOf(tmp));
    return _connections.indexOf(tmp);
}

QByteArray* BluetoothAdapter::ReadOnConnection(int connection)
{
    QByteArray* result = _connections[connection]->Read();
    if (result == 0)
    {
        _connections[connection]->CloseSocket();
        emit Disconnected(connection);
    }
    return result;
}

QByteArray* BluetoothAdapter::SendOnConnection(int connection, QByteArray* message)
{
    int result = _connections[connection]->Send(message);
    if (result < 0)
    {
        _connections[connection]->CloseSocket();
        emit Disconnected(connection);
        throw BluetoothAdapterError(1);
    }
    if (message->at(0) == (char)0x00)
        return ReadOnConnection(connection);
    return 0;
}
