#!/usr/bin/run-standalone.sh python2.5

def exec_cmd(cmd, expect_code = 0):
    """Executes the given command, if return code does not match expected one raise error"""
    print('DEBUG: executing ' + cmd)
    import commands
    return_tuple = commands.getstatusoutput(cmd)
    return_code = return_tuple[0]
    return_output = return_tuple[1]
    if ( return_code != expect_code ):
        print "DEBUG: Command output: " + return_output
        raise Exception("Command '" + cmd + "' returned with code " + str(return_code) + " (" + str(expect_code) + " expected)")
    return return_output


def get_default_network():
    hwaddr = exec_cmd("/sbin/ifconfig  wlan0 | grep HWaddr | awk '{print $5 }'")
    network = '10.' + str(int(hwaddr.split(':')[4], 16)) + '.' + str(int(hwaddr.split(':')[5], 16)) + '.'
    return network

def verify_wep_key(key_bytes):
    # pad to next suitable size
    if len(key_bytes) <= 5:
        return key_bytes.ljust(5, '0')
    if len(key_bytes) <= 13:
        return key_bytes.ljust(13, '0')
    # limit to 13 bytes
    return key_bytes[0:13]
    

def hex_encode(input_str):
    output_str = ''
    for char in input_str:
        output_str = output_str + '%X' % ord(char)
    return output_str
