#include <iostream>
#include <fstream>
#include <QtTest/QtTest>
#include <QApplication>

// Test Model Class
#include "TestOrder.h"
#include "TestManager.h"


using namespace std;

ofstream logfile;

/*!
 * \function DebugOutputHandler is handled erros before the system existed
 */ 
void DebugOutputHandler(QtMsgType type, const char *msg)
{
    switch( type ) {
	case QtDebugMsg:
		logfile << QTime::currentTime().toString().toAscii().data() << "Debug: " << msg << "\n";
		logfile.flush();
		break;
	case QtCriticalMsg:
		logfile << QTime::currentTime().toString().toAscii().data() << "Critical: " << msg << "\n";
		logfile.flush();
		break;
	case QtWarningMsg:
		logfile << QTime::currentTime().toString().toAscii().data() << "Warning: " << msg << "\n";
                logfile.flush();
                break;
	case QtFatalMsg:
		logfile << QTime::currentTime().toString().toAscii().data() << "Fatal: " << msg << "\n";
                logfile.flush();
    }
}

		



int main(int argc, char *argv[])
{

    #ifdef DEBUG_OUTPUT_TO_FILE 
    logfile.open("debuglogfile.log", ios::app);
    qInstallMsgHandler(DebugOutputHandler);
    #endif 

    QApplication app( argc, argv);

    /************Database Tests***********/
    //QTest::qExec(&dbtests);
  
    /************Business Logic Tests***********/
    //QTest::qExec(&dbtests);

    /************Network Tests***********/
    //QTest::qExec(&dbtests);

    /************Model Tests***********/
    //TestOrder tOrder;
    //QTest::qExec(&tOrder);

    TestManager tManager;
    QTest::qExec(&tManager);

    /************User Interface Tests***********/
    //QTest::qExec(&dbtests);

    return app.exec();


}
