#include "Test1.h"
#include "../../src/database/mdb.h"
#include <QtTest/QtTest>
#include <QVector>

#define NAME_OF_FILE "../TestDatabase.xml"
#define NAME_OF_CLASS "TestDatabase"


void Test1::initTestCase()
{

    QString fileName = QString(NAME_OF_FILE);
    QFile file(fileName);
    if(!file.open(QFile::ReadOnly | QFile::Text)) qDebug("Error in opening the file");
    /*retranslating it to Dom structure*/
    QString errorStr;
    int errorLine;
    int errorColumn;
    if(!domDocument.setContent(&file, true, &errorStr, &errorLine, &errorColumn))
    {
        qDebug(errorStr.toAscii());
        qDebug(QString("%1").arg(errorLine).toAscii());
        qDebug(QString("%1").arg(errorColumn).toAscii());
    }

    /*Moving to the root*/
    root = domDocument.documentElement();
    if (root.tagName() != NAME_OF_CLASS) qDebug(root.tagName().toAscii());

    /*Creating objects*/
    db = new Mdb();
    QVERIFY( db != 0 );
}

void Test1::cleanupTestCase()
{
    delete db;
    db = 0;
    QVERIFY( db == 0);
}

void Test1::statusTest()
{
    QVERIFY( db->status() == 0);
}

void Test1::createTableTest()
{
    QVector<QString> fieldName;
    QVector<QString> fieldType;

    testCase = root.firstChildElement("createTableTest");
    simpleTest = testCase.firstChildElement("Test");
    while(!simpleTest.isNull())
    {
        /*Get parameters from xml*/
        parametr = simpleTest.firstChildElement("param");
        QString nameOfTable = parametr.text();
        parametr=parametr.nextSiblingElement("param");
        while(!parametr.isNull())
        {
            fieldType.push_back(parametr.text());
            parametr=parametr.nextSiblingElement("param");
            fieldName.push_back(parametr.text());
            parametr=parametr.nextSiblingElement("param");
        }
        /*fulling object with data*/
        QCOMPARE(db->createTable(QString(nameOfTable), fieldName, fieldType),0);
        simpleTest = simpleTest.nextSiblingElement("Test");
    }
}

void Test1::getUnusedIdTest()
{

    testCase = root.firstChildElement("getUnusedId");
    simpleTest = testCase.firstChildElement("Test");
    while(!simpleTest.isNull())
    {
        /*Get parameters from xml*/
        parametr = simpleTest.firstChildElement("param");
        QString nameOfTable = parametr.text();
        int unusedId = parametr.nextSiblingElement("param").text().toInt();
        int rezult = db->getUnusedId(QString(nameOfTable));
        QCOMPARE(rezult,unusedId);
        simpleTest = simpleTest.nextSiblingElement("Test");
    }
}

void Test1::addToDatabaseTestFuncWith4Params()
{
    testCase = root.firstChildElement("addToDatabaseTestFuncWith4Params");
    simpleTest = testCase.firstChildElement("Test");
    QString nameOfTable;
    long myId;
    while(!simpleTest.isNull())
    {
        QVector<QString> fieldValue;
        QVector<QString> fieldName;
        int countOfParams=1; //Id should be in table
        parametr = simpleTest.firstChildElement("param");
        myId = db->getUnusedId(QString(parametr.text()));
        nameOfTable = parametr.text();
        /*first element should be id*/
        fieldName.push_back(QString("id"));
        /*if value of id is -1, then give new id*/
        parametr=parametr.nextSiblingElement("param");
        if(parametr.text().toInt()==-1)
            {
                fieldValue.push_back(QString("%1").arg(myId));
            }
        else
        {
            fieldValue.push_back(parametr.text());
            myId=parametr.text().toInt();
        }
        parametr=parametr.nextSiblingElement("param");
        while(!parametr.isNull())
        {
            fieldName.push_back(parametr.text());
            parametr=parametr.nextSiblingElement("param");
            fieldValue.push_back(parametr.text());
            parametr=parametr.nextSiblingElement("param");
            countOfParams++;
        }
        /*Checking adding to the table*/
        db->addToDb(nameOfTable, &fieldValue, &fieldName, myId);
        simpleTest = simpleTest.nextSiblingElement("Test");
        QSqlQueryModel* model = db->find(nameOfTable,myId);
        for(int i=1; i<countOfParams;i++)
        {
            QCOMPARE(model->record(0).value(i).toString(), fieldValue.at(i));
        }
     }
}

void Test1::addToDatabaseTestFuncWith2Params()
{


    testCase = root.firstChildElement("addToDbTest2Param");
    simpleTest = testCase.firstChildElement("Test");
    QString nameOfTable;
    long myId;
    while(!simpleTest.isNull())
    {
        int countOfParams=1;
        QVector<QString> fieldValue;
        parametr = simpleTest.firstChildElement("param");
        nameOfTable = parametr.text();
        myId = db->getUnusedId(nameOfTable);
        /*if value of id is -1, then give new id*/
        parametr=parametr.nextSiblingElement("param");
        if(parametr.text().toInt()==-1)
        {
            fieldValue.push_back(QString("%1").arg(myId));
        }
        else
        {
            fieldValue.push_back(parametr.text());
        }

        parametr=parametr.nextSiblingElement("param");
        while(!parametr.isNull())
        {
            fieldValue.push_back(parametr.text());
            parametr=parametr.nextSiblingElement("param");
            countOfParams++;
        }

        /*Checking adding to the table*/
        db->addToDb(nameOfTable, fieldValue);
        QSqlQueryModel* model = db->find(nameOfTable,myId);
        for(int i=1; i<countOfParams;i++)
        {
            QCOMPARE(model->record(0).value(i).toString(), fieldValue.at(i));
        }
        db->deleteFromDb(nameOfTable, myId);
        simpleTest = simpleTest.nextSiblingElement("Test");
    }
}

void Test1::deleteTableTest()
{
    /*   .  .*/
/*    testCase = root.firstChildElement("deleteTableTest");
    simpleTest = testCase.firstChildElement("Test");
    while(!simpleTest.isNull())
    {
        /*Get parameters from xml*/
  /*      parametr = simpleTest.firstChildElement("param");
        QString nameOfTable = parametr.text();
        QCOMPARE(db->deleteTable(nameOfTable),0);
        simpleTest = simpleTest.nextSiblingElement("Test");
    }*/
}
