#ifndef NEWORDER_H
#define NEWORDER_H

#include <QFrame>
#include <QLineEdit>
#include <QGridLayout>
#include <QPushButton>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QGridLayout>
#include <QScrollArea>
#include <QCheckBox>

#include "orderslistdialog.h"
#include "InformationObjects/ordersinfoobject.h"
#include "contractorselectwidget.h"
#include "salepointselectwidget.h"
#include "goodselectwidget.h"

class NewOrder : public QFrame
{
    Q_OBJECT;

    QHBoxLayout *qhblRootLayout;
    QVBoxLayout *qvblLeft;
    QVBoxLayout *qvblRight;
    QGridLayout *qglGrid;

    QPushButton *qpbContractors;
    QPushButton *qpbSalePoints;
    QPushButton *qpbGoodsList;

    QLineEdit *qleStartDate;
    QLineEdit *qleLastDate;

    QCheckBox *qcbCheck;

    QScrollArea *qsaScrollArea;

    OrdersInfoObject *oioOrdersInfo;

public:
    NewOrder(QWidget *parent  = 0);

private slots:
    void openOrdersView();

    void openContractorsList();

    void openSalePoints();

    void openGoodsList();

    void nextStep(int state);

public slots:
    void createConnectManager();

signals:
    void clientOrdersInfoOblectRegistered(OrdersInfoObject *ordersInfo);

};

#endif // NEWORDER_H
