#include "neworder.h"

NewOrder::NewOrder(QWidget *parent)
    :QFrame(parent)
{
    #if defined(Q_OS_LINUX)
    setAttribute(Qt::WA_Maemo5StackedWindow);
    #endif

    setStyleSheet(
            "NewOrder{"
            " background-color:black;"
            "}"

            "QPushButton:hover{"
            "  background-color: qlineargradient(x1:0, y1:0, x2:0, y2:1,stop:0 gray, stop: 0.5 black, stop:1 gray);"
            "  color:rgb(255, 165, 0);"
            "}"
            "QPushButton{"
            " color:rgb(255, 165, 0);"
            " border-radius:8px;"
            " background-color: rgb(72,72,72); "
            " margin-bottom:8px;"
            " font-style:bold;"
            " margin-left:5px;"
            " margin-right:5px;"
            "}"
            "QPushButton:pressed{"
            " color:white;"
            " border-radius:8px;"
            " background:qlineargradient(x1:0, y1:0, x2:0, y2:1,stop:0 rgb(210, 105, 30),stop:0.5 rgb(255,140,0),stop:1 rgb(255,165,0));"
            "}"
            "QLineEdit{"
            " background-color:white;"
            " font-size:16px;"
            "}"
            "QCheckBox{"
            " background-color:black;"
            "}"
            );

    qhblRootLayout = new QHBoxLayout();
    qvblLeft = new QVBoxLayout();
    qvblRight = new QVBoxLayout();
    qglGrid = new QGridLayout();

    qleLastDate = new QLineEdit(this);
    qleStartDate = new QLineEdit(this);

    qcbCheck = new QCheckBox(this);

    qpbContractors = new QPushButton(tr("Selects Contractors"),this);
    qpbSalePoints = new QPushButton(tr("Selects sale points"),this);
    qpbGoodsList = new QPushButton(tr("Selects Goods"),this);

    qglGrid->addWidget(qpbContractors,0,0,Qt::AlignTop);
    qglGrid->addWidget(qpbSalePoints,1,0,Qt::AlignTop);
    qglGrid->addWidget(qpbGoodsList,2,0,Qt::AlignTop);

    qglGrid->addWidget(qleLastDate,1,2,Qt::AlignTop);
    qglGrid->addWidget(qleStartDate,0,2,Qt::AlignTop);
    qglGrid->addWidget(qcbCheck,2,2,Qt::AlignTop);

    qglGrid->setRowStretch(0,0);
    qglGrid->setRowStretch(1,0);
    qglGrid->setRowStretch(2,0);

    qglGrid->setSpacing(20);
    qglGrid->setContentsMargins(4,8,4,4);

    setLayout(qglGrid);
    //setLayout(qhblRootLayout);

    connect(qpbContractors,SIGNAL(clicked()),this,SLOT(openContractorsList()));
    connect(qpbSalePoints,SIGNAL(clicked()),this,SLOT(openSalePoints()));
    connect(qpbGoodsList,SIGNAL(clicked()),this,SLOT(openGoodsList()));
}

void NewOrder::openOrdersView()
{
    OrdersListDialog *ordersDialog = new OrdersListDialog();

    ordersDialog->show();
}

void NewOrder::createConnectManager()
{
    oioOrdersInfo = new OrdersInfoObject();

    emit clientOrdersInfoOblectRegistered(oioOrdersInfo);
}

void NewOrder::openContractorsList()
{
    ContractorSelectWidget *contractorList = new ContractorSelectWidget(this);
    contractorList->show();
}

void NewOrder::openSalePoints()
{
    SalePointSelectWidget *spswSalePoint = new SalePointSelectWidget(this);
    spswSalePoint->show();
}

void NewOrder::nextStep(int state)
{

}

void NewOrder::openGoodsList()
{
    GoodSelectWidget *gswGoodsSelect = new GoodSelectWidget(this);
    gswGoodsSelect->show();
}
