#include "navigationbutton.h"

NavigationButton::NavigationButton(const QIcon &icon, const QString &text, QWidget *parent)
    :QToolButton()
{
    qsFloatText = QString();
    floatTextVisible = false;
    setIcon(icon);
    setText(text);
}

NavigationButton::NavigationButton(const QString &text, QWidget *parent)
    :QToolButton(parent)
{
    qsFloatText = text;
    setText(text);
    floatTextVisible = false;
    createConnects();
    setToolButtonStyle(Qt::ToolButtonTextUnderIcon);

    setStyleSheet(
            "NavigationButton{"
                "background-color:#1C1C1C;"
                "border-style:none;"
                "margin-right:0px;"
                "font-weight:bold;"
                "padding-right:0px;"
                "color:rgb(255, 165, 0);"
            "}"
            "NavigationButton:hover{"
                "background: qlineargradient(x1:0, y1:0, x2:1, y2:0,stop:0 black, stop: 0.9 gray, stop:1 white);"
                "border-width:0px;"
                "color:rgb(255, 165, 0);"
            "}"
            "NavigationButton:checked{"
                "color:rgb(255, 165, 0);"
                "background: qlineargradient(x1:0, y1:0, x2:1, y2:0,stop:0 black, stop: 0.9 gray, stop:1 white);"
            "}"
            );
}

NavigationButton::NavigationButton(QWidget *parent)
    :QToolButton(parent)
{
    floatTextVisible = false;
}

void NavigationButton::setId(int id)
{
    Id = id;
}

int NavigationButton::id()
{
    return Id;
}

void NavigationButton::clickReact()
{
    emit checkedChanged(this);
    emit clickId(Id);
}

QString NavigationButton::floatText()
{
    return qsFloatText;
}

void NavigationButton::setFloatText(const QString &text)
{
    qsFloatText = text;
    setFloatTextVisible(true);
}

void NavigationButton::setFloatTextVisible(bool visible)
{
  /*  if(floatTextVisible!=visible)
    {
        if(visible)
        {
            setText(qsFloatText);
            //setStyleSheet("border-radius:0px;");
        }
        else
        {
            setText(tr(""));
        }
        floatTextVisible = visible;
    }*/
}

void NavigationButton::createConnects()
{
    connect(this,SIGNAL(clicked()),this,SLOT(clickReact()));
}

