/***************************************************************************

     orderwidget.cpp
     -------------
     Copyright (c) 2010 by Mihailov Sergei <smihailo@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/
#include "orderwidget.h"

OrderWidget::OrderWidget(int type_id, QWidget *parent)
    :QFrame(parent)
{
    setStyleSheet("background-color:white;");

    qhblOrderLayout = new QHBoxLayout();
    currentState = NOTHING;
    previousState = NOTHING;
    setLayout(qhblOrderLayout);
    setContentsMargins(0,0,0,0);
}

void OrderWidget::setState(int newState)
{
    if(newState!=currentState)
    {
        switch(newState)
        {
        case MENU_STATE:
            previousState = currentState;
            currentState = MENU_STATE;
            omcOrderMenu = new OrderMenuControl(this);
            currentWidget = omcOrderMenu;

            connect(omcOrderMenu,SIGNAL(stateChanged(int)),this,SLOT(setState(int)));

            //connect(omcOrderMenu,SIGNAL(serviseChoose(int)),this,SIGNAL(serviceChanged(int)));
            connect(omcOrderMenu,SIGNAL(clientServiceInfoOblectRegistered(ServiceInfoObject*)),
                    this,SIGNAL(clientServiceInfoOblectRegistered(ServiceInfoObject*)));

            connect(this,SIGNAL(connectCreated()),omcOrderMenu,SLOT(createConnectionManager()));

            emit connectCreated();
            break;
        case NEW_ORDER_STATE:
            /*nothing*/
            break;
        case VIEW_GOODS_STATE:
            previousState = currentState;
            currentState = VIEW_GOODS_STATE;
            delete currentWidget;
            gwGoods = new GoodsWidget(this);
            qhblOrderLayout->addWidget(gwGoods);
            currentWidget = gwGoods;

            connect(gwGoods,SIGNAL(clientGoodInfoOblectRegistered(GoodInfoObject*)),
                    this,SIGNAL(clientGoodInfoOblectRegistered(GoodInfoObject*)));
            connect(gwGoods,SIGNAL(clientGoodsViewInfoOblectRegistered(GoodsViewInfoObject*)),
                    this,SIGNAL(clientGoodsViewInfoOblectRegistered(GoodsViewInfoObject*)));
            connect(gwGoods,SIGNAL(clientPathInfoOblectRegistered(PathInfoObject*)),
                    this,SIGNAL(clientPathInfoOblectRegistered(PathInfoObject*)));
            connect(gwGoods,SIGNAL(clientServiceInfoOblectRegistered(ServiceInfoObject*)),
                    this,SIGNAL(clientServiceInfoOblectRegistered(ServiceInfoObject*)));

            connect(this,SIGNAL(connectCreated()),gwGoods,SLOT(createConnectionManager()));

            emit connectCreated();
            break;
        case VIEW_ORDER_STATE:
            break;
        default:
            break;
        }
    }
}

void OrderWidget::createConnectionManager()
{
    setState(MENU_STATE);
}

