#include "ordermenucontrol.h"

#include <QDebug>

OrderMenuControl::OrderMenuControl(QWidget *parent)
{
    serviceInfo = new ServiceInfoObject(this);
    qwParent = parent;
    omwOrderCommonDialog = new OrderMenuWidget(parent);
    qdCurrentDialog = omwOrderCommonDialog;
    currentState = COMMON_ORDER_MENU;
    prevState = COMMON_ORDER_MENU;
    omwOrderCommonDialog->show();

    connect(omwOrderCommonDialog,SIGNAL(viewGoodsSelected()),this,SLOT(showServiceChooseDialog()));
}

void OrderMenuControl::showCommonOrdersDialog()
{
    prevState = currentState;
    qdCurrentDialog->close();
    delete qdCurrentDialog;
    omwOrderCommonDialog = new OrderMenuWidget(qwParent);
    qdCurrentDialog = omwOrderCommonDialog;
    currentState = COMMON_ORDER_MENU;
    omwOrderCommonDialog->show();
}

void OrderMenuControl::showServiceChooseDialog()
{
    prevState = currentState;
    qdCurrentDialog->close();
    delete qdCurrentDialog;
    scwServiceDialog = new ServiceChooseWidget(qwParent);
    qdCurrentDialog = scwServiceDialog;
    currentState = SERVICE_CHOOSE_DIALOG;
    scwServiceDialog->show();

    connect(scwServiceDialog,SIGNAL(serviceChoose(int)),
            this,SLOT(signalFromServiceDialog(int)));

    //connect(scwServiceDialog,SIGNAL(serviceChoose(int)),
    //        serviceInfo,SIGNAL(serviceSelected(int)));
}
void OrderMenuControl::signalFromServiceDialog(int id)
{
    serviceInfo->sendServiceSelectedInfo(id);
    qdCurrentDialog->close();
    delete qdCurrentDialog;
    emit serviseChoose(id);
    emit stateChanged(VIEW_GOODS_STATE);
    //serviceInfo->sendServiceSelectedInfo(id);
}

void OrderMenuControl::createConnectionManager()
{
    qDebug()<<"IN CREATE CONNECTED IN CONTROL";

    //connect(this,SIGNAL(serviceChoose(int)),
    //        serviceInfo,SIGNAL(serviceSelected(int)));
    emit clientServiceInfoOblectRegistered(serviceInfo);
}
