#ifndef COMMONMENUCONTENTWIDGET_H
#define COMMONMENUCONTENTWIDGET_H

#include <QWidget>
#include <QHBoxLayout>
#include <QAction>
#include <QList>
#include <QPushButton>
#include <QDialog>

#define MAX_ITEM_COUNT 10
#define MAX_MENU_LAYOUT_COUNT 5

class CommonMenuContentWidget : public QDialog
{
    Q_OBJECT;

protected:
    QGridLayout *qglMenuLayout;
    QHBoxLayout *qhblMenuLayoutItem[MAX_MENU_LAYOUT_COUNT];
    QVBoxLayout *qvblMenuRoot;
    QPushButton *qpbMenuButton[MAX_ITEM_COUNT];
    int currentItemCount;
    int currentLayoutCount;

public:
    CommonMenuContentWidget(QWidget *parent = 0);
    void addMenuItem(QPushButton *menuItem);
    int getCurrentActionsCount();
    int getMaxActionsCount();

};

#endif // COMMONMENUCONTENTWIDGET_H
