#include "goodsinfodialog.h"

#include <QDebug>

GoodsInfoDialog::GoodsInfoDialog(QWidget *parent)
{
    /**
      *Layouts
      */
   qhblRootLayout = new QHBoxLayout();
   qvblLeftLayout = new QVBoxLayout();
   qflInfoForm = new QFormLayout();
   qhblPriceLayout = new QHBoxLayout();

   qwFormWidget = new QWidget(this);

   QVBoxLayout *rightLayout = new QVBoxLayout();
   qpbCloseButton = new QPushButton(tr("Close"),this);
   qtbServiceLogo = new QToolButton(this);
   qteType = new QLabel(qwFormWidget);
   qteName = new QLabel(qwFormWidget);
   qtePrice = new QLabel(qwFormWidget);
   qteCurrency = new QLabel(qwFormWidget);
   qteQuantity = new QLabel(qwFormWidget);
   qteRemains = new QLabel(qwFormWidget);
   qteNote = new QTextEdit(qwFormWidget);

   qtbServiceLogo->setIcon(QIcon(":/image/none.png"));
   qtbServiceLogo->setIconSize(QSize(SERVICE_LOGO_WIDTH,SERVICE_LOGO_HEIGHT));
   qvblLeftLayout->addWidget(qtbServiceLogo,1,Qt::AlignTop);
   qvblLeftLayout->addWidget(qpbCloseButton,1,Qt::AlignBottom);

   qteCurrency->setMaximumWidth(90);

   qhblPriceLayout->addWidget(qtePrice,1,Qt::AlignLeft);
   qhblPriceLayout->addWidget(qteCurrency,1,Qt::AlignLeft);

   qflInfoForm->addRow(tr("Type"),qteType);
   qflInfoForm->addRow(tr("Name"),qteName);
   qflInfoForm->addRow(tr("Price"),qhblPriceLayout);
   qflInfoForm->addRow(tr("Quantity"),qteQuantity);
   qflInfoForm->addRow(tr("Remains"),qteRemains);

   qwFormWidget->setLayout(qflInfoForm);
   rightLayout->addWidget(qwFormWidget,1);
   rightLayout->addWidget(qteNote,1);
   qhblRootLayout->addItem(qvblLeftLayout);
   qhblRootLayout->addItem(rightLayout);;
   setLayout(qhblRootLayout);

   connect(qpbCloseButton,SIGNAL(clicked()),this,SLOT(close()));
}

void GoodsInfoDialog::setType(const QString &type)
{
    qteType->setText(type);
    qDebug()<<type;
}

void GoodsInfoDialog::setName(const QString &name)
{
    qteName->setText(name);
    qDebug()<<name;
}

void GoodsInfoDialog::setPrice(const QString &price)
{
    qtePrice->setText(price);
    qDebug()<<price;
}

void GoodsInfoDialog::setCurrency(const QString &currency)
{
    qteCurrency->setText(currency);
}
void GoodsInfoDialog::setQuantity(const QString &quantity)
{
    qteQuantity->setText(quantity);
}
void GoodsInfoDialog::setRemains(const QString &remains)
{
    qteRemains->setText(remains);
}
void GoodsInfoDialog::setServiseLogo(const QString &logo)
{
    //qteName->setText(model->index(0,0).data().toString());
}
