#include "treesearchdialog.h"

TreeSearchDialog::TreeSearchDialog(QWidget *parent)
    :QDialog(parent)
{
    //setOrientation(Qt::Vertical);

    qglDialogGrid = new QGridLayout();

    qtvTreeSearch = new QTreeView(this);
    qpbCansel = new QPushButton(tr("Cansel"),this);

    qglDialogGrid->addWidget(qtvTreeSearch,0,0,9,0,Qt::AlignTop);
    qglDialogGrid->addWidget(qpbCansel,10,0,0,0,Qt::AlignRight|Qt::AlignBottom);

    setLayout(qglDialogGrid);

    setStyleSheet("TreeSearchDialog{"
                    "background-color:rgb(72,72,72);"
                  "}"
                  "QPushButton{"
                      "background-color:#1C1C1C;"
                      "border-bottom-left-radius:10px;"
                      "border-top-left-radius:10px;"
                      "border-style:none;"
                      "margin-right:0px;"
                      "font-weight:bold;"
                      "padding-right:0px;}"
                  "}"
                  "QPushButton:hover{"
                      "background: qlineargradient(x1:0, y1:0, x2:1, y2:0,stop:0 black, stop: 0.9 gray, stop:1 white);"
                      "border-width:0px;"
                      "border-radius:10px;"
                      "color:rgb(255, 165, 0);"
                  "}"
                  );
}

void TreeSearchDialog::setModel(QAbstractItemModel *model)
{
    qtvTreeSearch->setModel(model);
    show();
}
