#include "servicechoosewidget.h"

ServiceChooseWidget::ServiceChooseWidget(QWidget *parent)
    :CommonMenuContentWidget(parent)
{
    qpbLocalDB = new QPushButton(QIcon(":/image/localserv.png"),"Local DB",this);
    qpbTestServise = new QPushButton(QIcon(":/image/mgtrader.png"),tr("Test Service"),this);

    qpbLocalDB->setIconSize(QSize(ICO_WIDTH_HEIGHT,ICO_WIDTH_HEIGHT));
    qpbTestServise->setIconSize(QSize(ICO_WIDTH_HEIGHT,ICO_WIDTH_HEIGHT));

    connect(qpbLocalDB,SIGNAL(clicked()),this,SLOT(localDBCliced()));
    connect(qpbTestServise,SIGNAL(clicked()),this,SLOT(testServiceClocked()));

    qpbLocalDB->setMinimumHeight(30);
    qpbTestServise->setMinimumHeight(30);

    addDialogItem(qpbLocalDB);
    addDialogItem(qpbTestServise);

    setMinimumHeight(300);

    setStyleSheet(
                  "font-size:23px;"
                  "border-radius:10px;"
                  "background-color:black;"
                  "font-weight:bold;"
                  "border-style:solid;"
                  "border-width:3px;"
                  "border-color:rgb(88,88,88);"
                  );

    //qvblRootLayout->setAlignment(qglMenuLayout,Qt::AlignHCenter);
}

void ServiceChooseWidget::setServicesList(QAbstractItemModel *servicesList)
{

}

void ServiceChooseWidget::localDBClicked()
{
    //emit serviceChoose(0);
}

void ServiceChooseWidget::testServiceClocked()
{
    emit serviceChoose(1);
}
