#ifndef ORDERMENUWIDGET_H
#define ORDERMENUWIDGET_H

#include <QWidget>
#include <QMenu>
#include <QStackedWidget>

#include "commonmenucontentwidget.h"
#include "servicechoosewidget.h"

class OrderMenuWidget : public CommonMenuContentWidget
{
    Q_OBJECT;

private:
    QMenu qmOrederMenu;
    QPushButton *qpbGoodsView;
    QPushButton *qpbOrderView;
    QPushButton *qpbCreateNewOrder;
    QDialog *qdServiceCoose;
    QStackedWidget *qswRootWidget;

    ServiceChooseWidget *scwServiceDialog;

private:
    void createMenuButton();


public:
    OrderMenuWidget(QWidget *parent =0);

private slots:
    void newOrderClick();
    void viewGoodsClick();
    void viewOrdersClick();
    void canselClick();

signals:
    void stateChanged(int newState);
    /**
      *    
      */
    void newOrderSelected();
    void viewGoodsSelected();
    void viewOrdersSelected();
    void canselSelected();
};

#endif // ORDERMENUWIDGET_H
