#include "ordermenuwidget.h"

OrderMenuWidget::OrderMenuWidget(QWidget *parent)
    :CommonMenuContentWidget(parent)
{
    createMenuButton();


    connect(qpbCreateNewOrder,SIGNAL(clicked()),this,SLOT(newOrderClick()));
    connect(qpbGoodsView,SIGNAL(clicked()),this,SLOT(viewGoodsClick()));
    connect(qpbOrderView,SIGNAL(clicked()),this,SLOT(viewOrdersClick()));
}

void OrderMenuWidget::createMenuButton()
{
    qpbCreateNewOrder = new QPushButton(tr("New Order"),this);
    qpbGoodsView = new QPushButton(tr("Goods"),this);
    qpbOrderView = new QPushButton(tr("Orders"),this);

    addDialogItem(qpbGoodsView);
    addDialogItem(qpbOrderView);
    addDialogItem(qpbCreateNewOrder);

    setMinimumHeight(300);

    setStyleSheet(
                  "font-size:23px;"
                  "border-radius:10px;"
                  "background-color:black;"
                  "font-weight:bold;"
                  "border-style:solid;"
                  "border-width:3px;"
                  "border-color:rgb(88,88,88);"
                  );

    //qslRootLayout->addItem(qvblMenuRoot);
    //qslRootLayout->setCurrentIndex(0);
    setLayout(qvblMenuRoot);
}

void OrderMenuWidget::newOrderClick()
{
    emit newOrderSelected();
}

void OrderMenuWidget::viewGoodsClick()
{
    emit viewGoodsSelected();
}

void OrderMenuWidget::viewOrdersClick()
{
    emit viewOrdersSelected();
}

void OrderMenuWidget::canselClick()
{
    emit canselSelected();
}
