#include "ordermenucontrol.h"

OrderMenuControl::OrderMenuControl(QWidget *parent)
{
    qwParent = parent;
    omwOrderCommonDialog = new OrderMenuWidget(parent);
    qdCurrentDialog = omwOrderCommonDialog;
    currentState = COMMON_ORDER_MENU;
    prevState = COMMON_ORDER_MENU;
    omwOrderCommonDialog->show();

    connect(omwOrderCommonDialog,SIGNAL(viewGoodsSelected()),this,SLOT(showServiceListDialog()));
    connect(omwOrderCommonDialog,SIGNAL(viewOrdersSelected()),this,SLOT(ordersViewSelected()));
    connect(omwOrderCommonDialog,SIGNAL(newOrderSelected()),this,SLOT(newOrderSelected()));
}

void OrderMenuControl::showCommonOrdersDialog()
{
    prevState = currentState;
    qdCurrentDialog->close();
    delete qdCurrentDialog;
    omwOrderCommonDialog = new OrderMenuWidget(qwParent);
    qdCurrentDialog = omwOrderCommonDialog;
    currentState = COMMON_ORDER_MENU;
    omwOrderCommonDialog->show();
}

void OrderMenuControl::showServiceListDialog()
{
    prevState = currentState;
    qdCurrentDialog->close();
    delete qdCurrentDialog;
    sldServicesList = new ServicesListDialog(qwParent);
    qdCurrentDialog = sldServicesList;
    currentState = SERVICE_CHOOSE_DIALOG;
    sldServicesList->show();

    connect(sldServicesList,SIGNAL(serviceSelected(int)),SLOT(signalFromServiceDialog(int)));
}
void OrderMenuControl::signalFromServiceDialog(int id)
{
    qdCurrentDialog->close();
    delete qdCurrentDialog;
    emit serviseChoose(id);
    emit stateChanged(VIEW_GOODS_STATE);
}

void OrderMenuControl::ordersViewSelected()
{
    qdCurrentDialog->close();
    delete qdCurrentDialog;
    emit stateChanged(VIEW_ORDER_STATE);
}

void OrderMenuControl::newOrderSelected()
{
    qdCurrentDialog->close();
    delete qdCurrentDialog;
    emit stateChanged(NEW_ORDER_STATE);
}
