/***************************************************************************

     tableproduct.cpp
     -------------
     Copyright (c) 2010 by Mihailov Sergei <smihailo@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/
#include "tableproduct.h"

#include <QDebug>

TableProduct::TableProduct(QWidget *parent)
    :QTableView(parent)
{
    setSelectionBehavior(QAbstractItemView::SelectRows);
    setSelectionMode(QAbstractItemView::SingleSelection);
    setStyleSheet(
            "TableProduct{"
               "background-color:black;"
               "color:rgb(255, 165, 0);"
               "border-radius:10px;"
               "font-size:18px;"
               "font-weight:bold;"
               "margin:0px;"
               "selection-background-color:"
                    "qlineargradient(x1: 0, y1: 0, x2: 0, y2:1,"
                    "stop: 0 rgb(255,140,0), stop: 1 rgb(255,165,0));"
            "}"
            "QHeaderView{"
                "color:white;"
                "font-weight:bold;"
                "font-size:14px;"
                "background-color:rgb(72,72,72);"
            "}"
            );
    setProperty("FingerScrollable",true);
    setContentsMargins(0,0,0,0);
    setSortingEnabled(true);
    connect(this,SIGNAL(doubleClicked(QModelIndex)),this,SLOT(openGoodInfo(QModelIndex)));

}

void TableProduct::setGoodsTableModel(QAbstractItemModel *goodsTable)
{
    qDebug()<<"IN TABLEPRODUCT SET MODEL"<<goodsTable->rowCount()<<goodsTable->columnCount();
    setModel(goodsTable);
    horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    verticalHeader()->setResizeMode(QHeaderView::Fixed);
    verticalHeader()->setVisible(false);
}

void TableProduct::openGoodInfo(QModelIndex modelindex)
{
    qDebug()<<modelindex.data();
    GoodsInfoDialog *dialogInfo = new GoodsInfoDialog(this);
    /******************set connects for fill content good info dialog*******/
    connect(gioGoodInfo,SIGNAL(readyGoodsNameInfo(QString)),
            dialogInfo,SLOT(setName(QString)));
    connect(gioGoodInfo,SIGNAL(readyGoodsTypeInfo(QString)),
            dialogInfo,SLOT(setType(QString)));
    connect(gioGoodInfo,SIGNAL(readyGoodsPriceInfo(QString)),
            dialogInfo,SLOT(setPrice(QString)));
    connect(gioGoodInfo,SIGNAL(readyGoodsCurrencyInfo(QString)),
            dialogInfo,SLOT(setCurrency(QString)));
    connect(gioGoodInfo,SIGNAL(readyGoodsQuantityInfo(QString)),
            dialogInfo,SLOT(setQuantity(QString)));
    connect(gioGoodInfo,SIGNAL(readyGoodsRemainsInfo(QString)),
            dialogInfo,SLOT(setRemains(QString)));
    connect(gioGoodInfo,SIGNAL(readyServiceLogo(QString)),
            dialogInfo,SLOT(setServiseLogo(QString)));
     /***********************************************************************/
    if(model()->index(modelindex.row(),0).data().canConvert(QVariant::Int))
    {
        qDebug()<<"WAS SELECT GOOD";      
        gioGoodInfo->sendGoodInfoRequest(model()->index(modelindex.row(),0).data().toInt());
    }
    else
    {
        qDebug()<<"Error uncorrect Id type";
        return;
    }
    dialogInfo->show();
}

void TableProduct::createConnectionManager()
{
    gioGoodInfo = new GoodInfoObject(this);

    emit clientGoodInfoOblectRegistered(gioGoodInfo);
}
