/***************************************************************************

     pathwidget.cpp
     -------------
     Copyright (c) 2010 by Mihailov Sergei <smihailo@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/
#include "pathwidget.h"
#include <QDebug>

PathWidget::PathWidget(QWidget *parent)
{

    setStyleSheet(
                "PathWidget{"
                    "background-color:black;"
                    "color:rgb(255, 165, 0);"
                    "font-size:16px;"
                    "font-weight:bold;"
                    "border-width:2px;"
                    "border-radius:0px;"
                "}"
                );
    qlPathItemList = QList<PathWidgetItem *>();
    qhblPathItemLayout = new QHBoxLayout();
    pathItemsCount = 0;
    startPathModelIndex = 0;
    endPathModelIndex = 0;
    pathItemLenght = 0;

    setLayout(qhblPathItemLayout);
    setContentsMargins(0,0,0,0);
    qhblPathItemLayout->setContentsMargins(0,0,15,0);
}

void PathWidget::setPathModel(QAbstractItemModel *pathModel)
{
    /******for test*/
    qDebug()<<"IN PATHWIDGET SET MODEL";
    for(int i=0;i<pathModel->rowCount();i++)
    {
        qDebug()<<pathModel->index(i,1).data().toString();
    }

    pathWidgetClear();
    qaimPathModel = pathModel;
    qDebug()<<qaimPathModel->rowCount();
    startPathModelIndex = qaimPathModel->rowCount();
    for(int i=qaimPathModel->rowCount()-1;i>=0;i--)
    {
        if((qaimPathModel->index(i,1).data().convert(QVariant::String))&&
           (qaimPathModel->index(i,0).data().convert(QVariant::Int)))
        {
            PathWidgetItem *newPathItem = new PathWidgetItem(qaimPathModel->index(i,0).data().toInt(),
                                                             qaimPathModel->index(i,1).data().toString(),
                                                             this);
            if((pathItemLenght+newPathItem->width())<=(width()-18))
            {
                qlPathItemList<<newPathItem;
                pathItemsCount++;
                pathItemLenght+=newPathItem->width();
                qhblPathItemLayout->insertWidget(0,newPathItem);
                qhblPathItemLayout->setAlignment(newPathItem,Qt::AlignLeft);
                connect(newPathItem,SIGNAL(neesGoodsPath(int)),this,SIGNAL(needGoodsPath(int)));
            }
            else
            {
                delete newPathItem;
                endPathModelIndex = i+1;
                break;
            }
        }
        else
        {
            qDebug()<<tr("error in the data model, you can not convert data");
            break;
        }
    }
}

void PathWidget::setTreeModel(QAbstractItemModel *treeModel)
{

}

void PathWidget::addSeparator()
{

}

void PathWidget::addPathItem(PathWidgetItem *newPathItem)
{

}

void PathWidget::createConnectionManager()
{
    pioPathInfo = new PathInfoObject(this);
    connect(pioPathInfo,SIGNAL(readyGoodsPath(QAbstractItemModel*)),
            this,SLOT(setPathModel(QAbstractItemModel*)));
    /**
      *register the object in the manager
      */
    emit clientPathInfoOblectRegistered(pioPathInfo);
}

void PathWidget::pathWidgetClear()
{
    for(int i=1; i<qlPathItemList.count();i++)
    {
        PathWidgetItem* item = qlPathItemList.at(i);
        qlPathItemList.removeAt(i);
        delete item;
    }
    pathItemLenght = 0;
    pathItemsCount = 0;
}
