#include "navigationbutton.h"

NavigationButton::NavigationButton(const QIcon &icon, const QString &text, QWidget *parent)
    :QPushButton(icon,text,parent)
{
    qsFloatText = QString();
    floatTextVisible = false;
    //connect(this,SIGNAL(changeStyleSheet(QString)),this,SLOT(setStyleSheet(QString)));
}

NavigationButton::NavigationButton(const QString &text, QWidget *parent)
    :QPushButton(parent)
{
    qsFloatText = text;
    floatTextVisible = false;
    createConnects();

    setStyleSheet(
            "NavigationButton{"
                "background-color:#1C1C1C;"
               // "border-bottom-left-radius:10px;"
               // "border-top-left-radius:10px;"
                "border-style:none;"
                "margin-right:0px;"
                "font-weight:bold;"
                "padding-right:0px;}"
            "}"
            "NavigationButton:hover{"
                "background: qlineargradient(x1:0, y1:0, x2:1, y2:0,stop:0 black, stop: 0.9 gray, stop:1 white);"
                "border-width:0px;"
                "color:rgb(255, 165, 0);"
            "}"
            "NavigationButton:checked{"
//                "border-bottom-left-radius:10px;"
//                "border-top-left-radius:10px;"
//                "border-radius:10px;"
                "color:rgb(255, 165, 0);"
                "background: qlineargradient(x1:0, y1:0, x2:1, y2:0,stop:0 black, stop: 0.9 gray, stop:1 white);"
            "}"
            );
}

NavigationButton::NavigationButton(QWidget *parent)
    :QPushButton(parent)
{
    floatTextVisible = false;
}

void NavigationButton::setId(int id)
{
    Id = id;
}

int NavigationButton::id()
{
    return Id;
}

void NavigationButton::clickReact()
{
    emit checkedChanged(this);
    emit clickId(Id);
}

QString NavigationButton::floatText()
{
    return qsFloatText;
}

void NavigationButton::setFloatText(const QString &text)
{
    qsFloatText = text;
    setFloatTextVisible(true);
}

void NavigationButton::setFloatTextVisible(bool visible)
{
    if(floatTextVisible!=visible)
    {
        if(visible)
        {
            setText(qsFloatText);
            //setStyleSheet("border-radius:0px;");
        }
        else
        {
            setText(tr(""));
        }
        floatTextVisible = visible;
    }
}

/*void NavigationButton::focusInEvent(QFocusEvent *)
{
    if(!isChecked())
    {
        setStyleSheet(
                      ":hover{"
                        "  background-color:green;"
                        "  border-bottom-left-radius:10px;"
                        "  border-top-left-radius:10px;"
                        "  border-bottom-right-radius:0px;"
                        "  border-top-right-radius:0px;"
                      "}"
                      ":checked{"
                        " border-bottom-left-radius:10px;"
                        " border-top-left-radius:10px;"
                        " background-color:yellow;"
                        " color:rgb(255, 215, 0);"
                        " padding-right:3px;}"
                     "}"
                     );

    }
    else
    {
        setStyleSheet("border-radius:10px;");
    }
}*/

void NavigationButton::createConnects()
{
    connect(this,SIGNAL(clicked()),this,SLOT(clickReact()));
}

