#ifndef GOODSINFODIALOG_H
#define GOODSINFODIALOG_H

#include <QDialog>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QGridLayout>
#include <QPushButton>
#include <QToolButton>
#include <QFormLayout>
#include <QLabel>
#include <QTextEdit>
#include <QLineEdit>
#include <QIcon>
#include <QModelIndex>

#include "commoncontentwidget.h"

#define SERVICE_LOGO_WIDTH 64
#define SERVICE_LOGO_HEIGHT 64

class GoodsInfoDialog : public QDialog
{
    Q_OBJECT;

    QVBoxLayout *qvblLeftLayout;
    QHBoxLayout *qhblRootLayout;
    QFormLayout *qflInfoForm;
    QHBoxLayout *qhblPriceLayout;
    QToolButton *qtbServiceLogo;
    QLabel *qlGroup;
    QLabel *qlGoodName;
    QLabel *qlPrice;
    QLabel *qlCurrency;
    QLabel *qlQuantity;
    QLabel *qlRemains;
    QLineEdit *qteType;
    QLineEdit *qteName;
    QLineEdit *qtePrice;
    QLineEdit *qteCurrency;
    QLineEdit *qteQuantity;
    QLineEdit *qteRemains;
    QTextEdit *qteNote;
    QPushButton *qpbCloseButton;


public:
    GoodsInfoDialog(QWidget *parent = 0);

public slots:
    void setType(const QString &type);
    void setName(const QString &name);
    void setPrice(const QString &price);
    void setCurrency(const QString &currency);
    void setQuantity(const QString &quantity);
    void setRemains(const QString &remains);
    void setServiseLogo(const QString &logo);
};

#endif // GOODSINFODIALOG_H
