#include "goodsinfodialog.h"

#include <QDebug>

GoodsInfoDialog::GoodsInfoDialog(QWidget *parent)
{
   qhblRootLayout = new QHBoxLayout();
   qvblLeftLayout = new QVBoxLayout();
   qflInfoForm = new QFormLayout();
   qhblPriceLayout = new QHBoxLayout();

   QWidget *rightWidget = new QWidget(this);
   qpbCloseButton = new QPushButton(tr("Close"),this);
   qtbServiceLogo = new QToolButton(this);
   qteType = new QLineEdit(rightWidget);
   qteName = new QLineEdit(rightWidget);
   qtePrice = new QLineEdit(rightWidget);
   qteCurrency = new QLineEdit(rightWidget);
   qteQuantity = new QLineEdit(rightWidget);
   qteRemains = new QLineEdit(rightWidget);
   qteNote = new QTextEdit(this);


   qteType->setReadOnly(true);
   qteName->setReadOnly(true);
   qtePrice->setReadOnly(true);
   qteCurrency->setReadOnly(true);
   qteQuantity->setReadOnly(true);
   qteRemains->setReadOnly(true);
   qtbServiceLogo->setEnabled(false);

   qtbServiceLogo->setIcon(QIcon(":/image/none.png"));
   qtbServiceLogo->setIconSize(QSize(SERVICE_LOGO_WIDTH,SERVICE_LOGO_HEIGHT));
   qvblLeftLayout->addWidget(qtbServiceLogo,1,Qt::AlignTop);
   qvblLeftLayout->addWidget(qpbCloseButton,1,Qt::AlignBottom);

   qteCurrency->setMaximumWidth(40);

   qhblPriceLayout->addWidget(qtePrice,2.3);
   qhblPriceLayout->addWidget(qteCurrency,1);

   qflInfoForm->addRow(tr("Type"),qteType);
   qflInfoForm->addRow(tr("Name"),qteName);
   qflInfoForm->addRow(tr("Price"),qhblPriceLayout);
   qflInfoForm->addRow(tr("Quantity"),qteQuantity);
   qflInfoForm->addRow(tr("Remains"),qteRemains);
   qflInfoForm->addRow(qteNote);

   rightWidget->setLayout(qflInfoForm);
   qhblRootLayout->addItem(qvblLeftLayout);
   qhblRootLayout->addWidget(rightWidget);
   setLayout(qhblRootLayout);

   connect(qpbCloseButton,SIGNAL(clicked()),this,SLOT(close()));
}

void GoodsInfoDialog::setType(const QString &type)
{
    qteType->setText(type);
    qDebug()<<type;
}

void GoodsInfoDialog::setName(const QString &name)
{
    qteName->setText(name);
    qDebug()<<name;
}

void GoodsInfoDialog::setPrice(const QString &price)
{
    qtePrice->setText(price);
    qDebug()<<price;
}

void GoodsInfoDialog::setCurrency(const QString &currency)
{
    qteCurrency->setText(currency);
}
void GoodsInfoDialog::setQuantity(const QString &quantity)
{
    qteQuantity->setText(quantity);
}
void GoodsInfoDialog::setRemains(const QString &remains)
{
    qteRemains->setText(remains);
}
void GoodsInfoDialog::setServiseLogo(const QString &logo)
{
    //qteName->setText(model->index(0,0).data().toString());
}
