#ifndef GOODSELECTWIDGET_H
#define GOODSELECTWIDGET_H

#include <QDialog>
#include <QTableView>
#include <QAbstractItemModel>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QToolButton>

#include "filteredit.h"

class GoodSelectWidget : public QDialog
{
    Q_OBJECT;

    QHBoxLayout *qhblRootLayout;
    QVBoxLayout *qvblContent;
    QVBoxLayout *qvblRight;

    QToolButton *qtbNext;
    QToolButton *qtbBack;
    QToolButton *qtbOk;
    QToolButton *qtbCansel;
    QTableView *qtvContractorsTable;
    FilterEdit *feFilter;

public:
    GoodSelectWidget(QWidget *parent = 0);

signals:
    void contractorSelected(int id,bool next);

public slots:
    /**
      *slots set model of data
      */
    void setContractorModel(QAbstractItemModel *model);

private slots:
    /**
      *slot take info from table
      */
    void openInfo(const QModelIndex &modelOndex);
    /**
      *click on OK button
      */
    void clickOk();

};

#endif // GOODSELECTWIDGET_H
