#include "commonmenucontentwidget.h"

CommonMenuContentWidget::CommonMenuContentWidget(QWidget *parent)
    :QDialog(parent)
{
    currentItemCount = 0;
    currentLayoutCount = 0;
    qglMenuLayout = new QGridLayout();
    qhblMenuLayoutItem[0] = new QHBoxLayout();
    qvblMenuRoot = new QVBoxLayout();

    qglMenuLayout->addItem(qhblMenuLayoutItem[0],0,0);
    qglMenuLayout->setAlignment(qhblMenuLayoutItem[0],Qt::AlignTop);
    qglMenuLayout->setSpacing(5);

    qvblMenuRoot->addItem(qglMenuLayout);
    qvblMenuRoot->setAlignment(qglMenuLayout,Qt::AlignTop);
    setLayout(qvblMenuRoot);

    setStyleSheet("QPushButton{font-size:20px;}"
                  "CommonMenuContentWidget{"
                                "font-size:23px;"
                                "border-radius:10px;"
                                "background-color:black;"
                                "font-weight:bold;"
                                "border-style:solid;"
                                "border-width:3px;"
                                "border-color:rgb(88,88,88);"
                                "}"
                  );

    maxItemCount = MAX_ITEM_COUNT;
}

void CommonMenuContentWidget::addDialogItem(QPushButton *menuItem)
{
    if(currentItemCount<maxItemCount)
    {
        int i = currentItemCount/2;
        if(currentLayoutCount<i)
        {
            qhblMenuLayoutItem[i] = new QHBoxLayout();
            qglMenuLayout->addItem(qhblMenuLayoutItem[i],i+1,0,1,1,Qt::AlignTop);
        }
        qhblMenuLayoutItem[i]->addWidget(menuItem,0,Qt::AlignTop);
        qglMenuLayout->setAlignment(qhblMenuLayoutItem[i],Qt::AlignTop);
        qpbMenuButton[i] = menuItem;

        qpbMenuButton[i]->setMinimumHeight(30);

        qpbMenuButton[i]->setStyleSheet(
                ":hover{"
                "  background-color: qlineargradient(x1:0, y1:0, x2:1, y2:1,stop:0 black, stop: 0.7 gray, stop:1 white);"
                "  color:rgb(255, 165, 0);"
                "}"
                ":active{"
                " color:rgb(255, 165, 0);"
                " border-radius:8px;"
                " background-color: rgb(72,72,72); "
                " margin-bottom:8px;"
                " margin-left:5px;"
                " margin-right:5px;"
                "}"
                ":pressed{"
                " color:white;"
                " border-radius:8px;"
                " background:qlineargradient(x1:0, y1:0, x2:0, y2:1,stop:0 rgb(210, 105, 30),stop:0.5 rgb(255,140,0),stop:1 rgb(255,165,0));"
                "}"
                );

        currentItemCount++;
    }
}

int CommonMenuContentWidget::getCurrentActionsCount()
{
    return currentItemCount;
}

int CommonMenuContentWidget::getMaxActionsCount()
{
    return MAX_ITEM_COUNT;
}
