#ifndef GOODSVIEWINFOOBJECT_H
#define GOODSVIEWINFOOBJECT_H

#include <QObject>
#include <QAbstractItemModel>

/**
  * Class representing an interface for receiving
  * list of goods and goods directory
  */
class GoodsViewInfoObject : public QObject
{
    Q_OBJECT;

public:
    GoodsViewInfoObject(QObject *parent = 0);

public slots:
    void sendGoodsViewRequest(const QString &text);

signals:
    /**
     * @brief Demand signal products
     * Signal for what's postrebnosti in the list of products
     * @param filter - a filter query string indicating the goods
     */
    void needGoodsTable(const QString &filtr = tr(""));
    /**
      * Signal updates the list of goods ProductWidget
      * @param transmitted data model;
      */
    void readyGoodsTable(QAbstractItemModel *model);
    /**
      * Signal carries information about the list of goods subdirectories of the current node
      * @param transmitted data model;
      */
    void readyGoodsDirectory(QAbstractItemModel *model);//readyGoodsTree last name
    /**
      * transmits the information and products and catalogs
      * together, to synchronize with
      * @param models of goods and directory data
      */
    void readyGoodsAndDirectory(QAbstractItemModel *typeModel,
                                QAbstractItemModel *goodsModel);


};

#endif // GOODSVIEWINFOOBJECT_H
