#include "simpleservice.h"

SimpleService::SimpleService()
{
    connect(&http, SIGNAL(responseReady()), SLOT(getResponse()));
    http.setHost(SimpleService::host, SimpleService::port);
    http.setAction(SimpleService::action);
}
SimpleService::SimpleService(const QString host, const int port)
{
    connect(&http, SIGNAL(responseReady()), SLOT(getResponse()));
    http.setHost(host, port);
}

SimpleService::SimpleService(const QString host, const int port, const QString action)
{
    connect(&http, SIGNAL(responseReady()), SLOT(getResponse()));
    http.setHost(host, port);
    http.setAction(action);
}

void SimpleService::submitRequest(QString method)
{
    QtSoapMessage request;
    request.setMethod(QtSoapQName(method, SimpleService::action));
    SimpleService::path = "/testws/Service.asmx";
    http.submitRequest(request, SimpleService::path);
}

void SimpleService::submitRequest()
{
}

void SimpleService::getResponse()
{
    const QtSoapMessage &resp = http.getResponse();
    response = resp;
    qDebug() << response.toXmlString();
    //emit ResponseIsReady();
}
