/***************************************************************************

     goodstree.cpp
     -------------
     Copyright (c) 2010 by Andrianov Pavel <andriano@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/
// TODO: add ifdef to all debug messages
#define DEBUG

#include "goodstree.h"

GoodsTree::GoodsTree(Mdb* db)
{
    this->mdb = db;
}


/**
  In start we have a swarm of unlinked leawes

  We must build two structures:
    tree[j]:
        int         id_in_db
        GoodsType*  link_to_goods_type
        int         link to parent in tree[]

  Also we need to keep the amount of its elements

    were[j]:
        -1              if not were
        index_in_tree   if were

  In result we need only the tree (maybe)

  */

/// Pseudo code algorithm
/**
//    for i in model {
//        stack.add(i)
//        were[i]=no
//    }
//
//    while (stack!=empty)
//    {
//        j = stack.pop;
//        were[j] = yes;
//        tree.add(j)
//        stack.add(j,parent);
//    }
*/

QStack<int>* GoodsTree::getInitTypesIds(QString filter)
{
    QSqlQueryModel* model;

    QString sqlQuery = "select distinct type from tblGoods where name like '%"+filter+"%';";
    //QString sqlQuery = "select distinct type from tblGoods where name like '"+filter+"%';";

    model = mdb->dirty_hacked_exec(sqlQuery);

    QStack<int>* stack = new QStack<int>;
    /// Push all vertices to stack
    for (int i=0; i < model->rowCount(); i++)
    {
        stack->push(model->record(i).value(0).toInt());
    }

    return stack;
}

void GoodsTree::clearTree(){
    // TODO: >>>
    //    int were[mdb->getUnusedId(tableName)];
    //    were[*] = -1;

    // TODO: make were[] dynamic array
    for (int i=0;i<100;i++)
    {
        were[i] = -1;
    }
    // TODO: <<<

    tree.clear();
}

//#ifdef DEBUG
//    qDebug() << ">>> Start filtering by "<< filter;
//#endif

void GoodsTree::setFilter(QString filter)
{
    qDebug() << "\n===============================";
    qDebug() << "Start filtering by "<< filter;

    this->clearTree();

    qDebug() << "Tree cleared";

    QStack<int>* stack = this->getInitTypesIds(filter); /// list of filtered types

    qDebug() << "Initial types ready";

    int parent_index;         /// index of the parent node for processed type in the tree

    while ( !stack->isEmpty() )
    {
        GoodsType* type = new GoodsType(mdb, stack->pop());
        qDebug() << "Processing type " << type->getId() << type->getName();

        /// Make the new node
        TreeNode node;
        node.type = type;

        /// Prove, was parent of this vertice already added to tree or not
        if ( were[ type->getParentId() ] == -1 ) {
            /// If not added, it will be added after this vertice in next iteration of while
            /// Add the vertice with the current type to tree
            if ( type->getId() != 0 ) {
                /// Push the parent to stack
                stack->push(type->getParentId());
                parent_index = tree.size() + 1;
            } else {
                parent_index = tree.size();
            }
        } else {
            /// In added, search for the index of the parent element in tree
            parent_index = were[type->getParentId()];
        }

        /// Add the vertice with the current type to tree
        node.parent_index = parent_index;

        /// Add node to tree
        tree.push_back(node);
        were[type->getId()] = tree.size() - 1;
    }
    /// Now we got a tree of linked types
    /// Set current_filter = filter
    current_filter = filter;
    /// Add filter to the list of used filters

    qDebug() << "\n===============================\n";
}

GoodsType* GoodsTree::getRoot()
{
    GoodsType* root = new GoodsType(mdb, 0);
    return root;
}

QSqlQueryModel* GoodsTree::getGoods(GoodsType* type)
{
    QVector<QString> fieldName;
    QVector<QString> fieldValue;
    QVector<QString> columnName;
    QVector<QString> fieldEquality;
    QString tableName;

    /// Prove, have tree this type or not
    /// If not, cause error
    if (were[type->getId()]!=-1){
        /// If have
        /// Select subgoods by this type with last used filter from mdb

        qDebug() << "Current filter is " << current_filter;

        tableName = "tblGoods";

        fieldName.push_back("type");
        fieldEquality.push_back("=");
        fieldValue.push_back(QString::QString("%1").arg(type->getId()));

        fieldName.push_back("name");
        fieldEquality.push_back("like");
        fieldValue.push_back("%"+this->current_filter+"%");

        columnName.push_back("id");
        columnName.push_back("2");
        columnName.push_back("name");
        columnName.push_back("count");

        /// return the selection result
        return mdb->find(tableName, &fieldName, &fieldEquality, &fieldValue, &columnName);
    } else {
        return mdb->find(tableName, &fieldName, &fieldEquality, &fieldValue, &columnName);
    }
}

QAbstractItemModel* errorModel()
{
    QStandardItemModel* model = new QStandardItemModel(1,1);
    QStandardItem *item0 = new QStandardItem("Error");
    model->setItem(0, 0, item0);
    return model;
}

//QStandardItemModel* GoodsTree::getSub(GoodsType *type)
//{
//    /// Find this type in our tree
//    /// If not found, cause error
//    if (were[type->getId()]!=-1)
//    {
//        QStandardItemModel* types = this->getTypes(type);
//        QSqlQueryModel* goods = this->getGoods(type);
//
//        int columns = types->columnCount() > goods->columnCount()? types->columnCount() : goods->columnCount();
//
//        QStandardItemModel* model = new QStandardItemModel(types->rowCount() + goods->rowCount() ,columns);
//
//        for (int i=0; i<types->rowCount(); i++){
//            for (int j=0; j<types->columnCount(); j++) {
//                model->setItem(i, j, types->item(i,j));
//            }
//        }
//
//        for (int i=0; i<goods->rowCount(); i++){
//            for (int j=0; j<goods->columnCount(); j++) {
//                model->setItem(i+types->rowCount(), j, goods->item(i,j));
//            }
//        }
//
//        /// Return it
//        return model;
//    } else {
//        QStandardItemModel* model = new QStandardItemModel(1,1);
//        QStandardItem *item0 = new QStandardItem("Error");
//        model->setItem(0, 0, item0);
//        return model;
//    }
//}

QAbstractItemModel* GoodsTree::getTypes(GoodsType* type)
{
    qDebug() << "type id = " << type->getId();
    qDebug() << "type name = " << type->getName();
    qDebug() << "type parent = " << type->getParentId();

    /// Find this type in our tree
    /// If not found, cause error
    if (were[type->getId()]!=-1){
        /// If found, make a model including its child types
        // TODO: >>> refactor that code

        /// Find the number of rows in result model
        int k = 0;

        for (int i=0; i<tree.size(); i++)
        {
            qDebug() << "tree at  " << i
                    << "id = " << tree.at(i).type->getId()
                    <<" parent id = " << tree.at(i).type->getParentId();
            if ((tree.at(i).type->getParentId() == type->getId()) && (type->getId() != tree.at(i).type->getId()))
            {
                k++;
            }
        }
        // TODO: <<<

        qDebug() << "Number of subtypes: " << k;

        int have_parent_type_row = 0;

        if (type->getId() != 0)
        {
            have_parent_type_row = 1;
        }

        /// Model with this number of rows
        QStandardItemModel* model = new QStandardItemModel(k+have_parent_type_row,3);

        if (type->getId() != 0)
        {

            QStandardItem *item0 = new QStandardItem(QString("%0").arg(type->getParentId()));
            model->setItem(0, 0, item0);
            QStandardItem *item1 = new QStandardItem(QString("0"));
            model->setItem(0, 1, item1);
            QStandardItem *item2 = new QStandardItem(QString("..."));
            model->setItem(0, 2, item2);

        }
        k = have_parent_type_row;

        /// Fill the model with child types
        for (int i=0; i<tree.size(); i++)
        {
            if ((tree.at(i).type->getParentId() == type->getId()) && (type->getId() != tree.at(i).type->getId()))
            {
                QStandardItem *item0 = new QStandardItem(QString("%0").arg(tree.at(i).type->getId()));
                model->setItem(k, 0, item0);
                QStandardItem *item1 = new QStandardItem(QString("1"));
                model->setItem(k, 1, item1);
                QStandardItem *item2 = new QStandardItem(tree.at(i).type->getName());
                model->setItem(k, 2, item2);
                k++;
            }
        }

        /// Return it
        return model;
    } else {
        QStandardItemModel* model = new QStandardItemModel(1,1);
        QStandardItem *item0 = new QStandardItem("Error");
        model->setItem(0, 0, item0);
        return model;
    }
}

QString GoodsTree::getCurrentFilter()
{
    return this->current_filter;
}

QStandardItemModel* GoodsTree::errorModel()
{
    QStandardItemModel* model = new QStandardItemModel(1,1);
    QStandardItem *item0 = new QStandardItem("Error");
    model->setItem(0, 0, item0);
    return model;
}

QStandardItemModel* GoodsTree::getPath(GoodsType* type)
{
    QStack<int> stack;
    int i,n;

    /// Find this type in our tree
    /// If not found, cause error
    if ( were[type->getId()] != -1 )
    {
        /// If found
        if (type->getId() == 0) {
            QStandardItemModel* model = new QStandardItemModel(1,2);
            QStandardItem *item0 = new QStandardItem(QString("%0").arg(0));
            model->setItem(0, 0, item0);
            QStandardItem *item1 = new QStandardItem(QString("%0").arg("General"));
            model->setItem(0, 1, item1);
            return model;
        } else {
            n = 0;

            i = tree.at(were[type->getId()]).parent_index;

            qDebug() << "index of type in tree is " << i;

            /// Make a stack with the upway from this type to root
            // TODO: >> root
            while (tree.at(i).type->getId() != tree.at(i).type->getParentId())
            {
                n++;
                stack.push(i);
                i = tree.at(i).parent_index;
            }

            /// Model with this number of rows
            // TODO: errors with n+2 (if type == root, it will be as n+1)
            QStandardItemModel* model = new QStandardItemModel(n+2,2);

            /// Pooping from the stack, make a horisontal model, containing id and name

            n = 0;

            QStandardItem *item00 = new QStandardItem(QString("%0").arg(0));
            model->setItem(n, 0, item00);
            // todo: remove this
            QStandardItem *item10 = new QStandardItem(QString("%0").arg("General"));
            model->setItem(n, 1, item10);

            n++;

            while (!stack.isEmpty())
            {
                i = stack.pop();

                QStandardItem *item0 = new QStandardItem(QString("%0").arg(tree.at(i).type->getId()));
                model->setItem(n, 0, item0);
                QStandardItem *item1 = new QStandardItem(tree.at(i).type->getName());
                model->setItem(n, 1, item1);

                n++;
            }

            QStandardItem *item0 = new QStandardItem(QString("%0").arg(type->getId()));
            model->setItem(n, 0, item0);
            QStandardItem *item1 = new QStandardItem(type->getName());
            model->setItem(n, 1, item1);

            /// Return it
            return model;
        }
    } else {
        QStandardItemModel* model = new QStandardItemModel(1,1);
        QStandardItem *item0 = new QStandardItem("Error");
        model->setItem(0, 0, item0);
        return model;
    }
}



