/***************************************************************************

     good.h
     -------------
     Copyright (c) 2010 by Andrianov Pavel <andriano@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/

#ifndef GOOD_H
#define GOOD_H

#include <QString>
#include "../database/mdb.h"

/*
TODO:
      view (  )

      
     
*/
/**
 * @class Goods model class
 * @short Goods model class
 *
 * Class provides functions and variables to work with
 * information about nomenclature
 *
 * @author Andrianov Pavel, Nikiforov Artem
 */
class Good
{
public:
    /// Get the id
    /**
     * @brief Returns id of current object
     * @return int id
     **/
    int getId();

    /// Set the id
    /**
     * @brief Sets id of current good
     * @param new_id, int, id of current good
     **/
    void setId(int);

    /// Get name
    /**
     * @brief Returns name of current good
     * @return QString, name of current good
     **/
    QString getName();
    /// Set name
    /**
     * @brief Sets name of current good
     * @param new_name, QString, name of current good
     **/
    void setName(QString);

    /// Get quantity of this good in the store
    /**
     *@brief Returns quantity of current good
     *@return int, quantity of current good
     **/
    int getQuantity();

    /// Set quantity of this good in the store
    /**
     * @brief Sets quantity of current good
     * @param new_quantity, int, quantity of current good
     **/
    void setQuantity(int);

    /// Get price
    /**
     * @brief Returns price of current good
     * @return double, price of current good
     **/
    double getPrice();

    /// Set price
    /**
     * @brief Sets price of current good
     * @param new_price, double, price of current good
     **/
    void setPrice(double);

    /// Get type of this good
    /**
     * @brief Gets type of current good
     * @return type of current good
     **/
    int getType();

    /// Set type of this good
    /**
     * @brief Sets type of current good
     * @param new_type, int, type of current good
     **/
    void setType(int);

    /// Get type of currency of this good
    /**
     * @brief Gets type of currency of current good
     * @return int, type of current good
     **/
    int getCurrencyType();

    /// Set type of currency of this good
    /**
     * @brief Sets type of currency of current good
     * @param new_currencyId, int, type of currency  of current good
     **/
    void setCurrencyType(int);

    /// Get remains of this good
    /**
     * @brief Gets remains of current goods
     * @return int, remains of current goods
     **/
    int getRemains();

    /// Set remains of this good
    /**
     * @brief Set remains of current goods
     * @param new_remain, int, remain of current goods
     **/
    void setRemains(int);

    /// Loads the information from the database
    /**
     * @brief Create the good using loading from database
     * Load good from database
     * @param db pointer to the database module object
     * @param id identifier of good in the database
     * @see Mdb::find()
     */
    Good(Mdb* db, int id);

    /// Saves the good to database
    /**
     * @brief Save good to database
     * @param db pointer to the database module object
     */
    void set(Mdb* db);
    void setDescription(QString tmp_description);
    QString getDescription();

    /// Get table name
    /**
     * @brief Get table name
     * Get table name in the database, where goods is located
     * @return name of the table
     */
    QString tableName();

protected:
    /// Identifier in the database
    int id;

    /// Name of this good
    QString name;

    /// Quantity of this good in the store
    int quantity;

    /// Identifier of type of this good
    int type;

    /// Identifier of the currency in the database
    int currencyid;

    /// Price of this good
    double price;

    /// Remains of this good in the store
    int remain;

    /// Descripton
    QString description;

public:
    /// Standard constructor
    Good();

private:
    /// Constuctor with the required fields
    /// @note deprecated
    Good( int, QString, int, int );

    /// Constuctor with the required fields and price field
    /// @note deprecated
    Good( int, QString, int, int, double );

    /// Constuctor with the required fields and currency identifier field
    /// @note deprecated
    Good( int, QString, int, int, int );

    /// Constuctor with the required fields and with the price and currency identifier field
    /// @note deprecated
    Good( QString, int, int, double, int, int );
};

#endif // GOOD_H
