/***************************************************************************

     good.cpp
     -------------
     Copyright (c) 2010 by Andrianov Pavel <andriano@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/

#include "good.h"

Good::Good()
{
    this->id = NEW_ID;
    this->name = "";
    this->type = 0;
    this->price = 0;
    this->currencyid = 0;
    this->remain = 0;
}

Good::Good( QString name, int quantity, int type, double price, int currencyid, int remain )
{
    this->quantity = quantity;
    this->name = name;
    this->type = type;
    this->id = NEW_ID;
    this->price = price;
    this->currencyid = currencyid;
    this->remain = remain;
}

int Good::getId()
{
    return this->id;
}

void Good::setId(int new_id)
{
    this->id = new_id;
}

QString Good::getName()
{
    return this->name;
}

void Good::setName(QString new_name)
{
    this->name = new_name;
}

int Good::getQuantity()
{
    return this->quantity;
}

void Good::setQuantity(int new_quantity)
{
    this->quantity = new_quantity;
}

double Good::getPrice()
{
    return this->price;
}

void Good::setPrice(double new_price)
{
    this->price = new_price;
}

int Good::getType()
{
    return this->type;
}

void Good::setType(int new_type)
{
     this->type = new_type;
}

int Good::getCurrencyType()
{
    return this->currencyid;
}

void Good::setCurrencyType(int new_currencyId)
{
    this->currencyid = new_currencyId;
}

int Good::getRemains()
{
    return this->remain;
}

void Good::setRemains(int new_remain)
{
    this->remain = new_remain;
}

Good::Good(Mdb* mdb, int id)
{
    /// Find values with such id in database
    QSqlQueryModel* model = mdb->find(this->tableName(),id);

    /// Parse fields
    this->id = id;
    this->name = model->record(0).value(1).toString();
    this->quantity = model->record(0).value(2).toInt();
    this->price = model->record(0).value(3).toDouble();
    this->type = model->record(0).value(4).toInt();
    this->currencyid = model->record(0).value(5).toInt();
    this->remain = model->record(0).value(6).toInt();
}

QString toQString(int value)
{
    QString string = QString("%1").arg(value);
    return string;
}

QString Good::tableName()
{
    return QString::QString("tblGoods");
}

QString toQString(double value)
{
    QString string = QString("%1").arg(value);
    return string;
}

void Good::setDescription(QString tmp_description)
{
    this->description = tmp_description;
}

QString Good::getDescription()
{
    return this->description;
}

void Good::set(Mdb* mdb)
{
    QVector<QString> fieldsValue;

    fieldsValue.push_back(toQString(this->id));
    fieldsValue.push_back(this->name);
    fieldsValue.push_back(toQString(this->quantity));
    fieldsValue.push_back(toQString(this->price));
    fieldsValue.push_back(toQString(this->currencyid));
    fieldsValue.push_back(toQString(this->type));
    fieldsValue.push_back(toQString(this->remain));
    fieldsValue.push_back(this->description);

    /// If this is the new good
    if ( this->id == NEW_ID )
    {
        /// Get the id
        this->id = mdb->getUnusedId(this->tableName());
        fieldsValue[0] = toQString(this->id);

        /// Insert this good into mdb
        mdb->addToDb(this->tableName(), fieldsValue);
    }
    else
    {
        /// Creating additional vector with field names
        QVector<QString> fieldsName;

        /// Fill with names
        fieldsName.push_back("id");
        fieldsName.push_back("name");
        //TODO: quantity ,   count
        fieldsName.push_back("count");
        fieldsName.push_back("price");
        fieldsName.push_back("type");
        fieldsName.push_back("currencyid");
        fieldsName.push_back("remain");
        fieldsName.push_back("description");

        /// Update this good in the database
        mdb->addToDb(this->tableName(),&fieldsValue,&fieldsName,this->id);
    }
}
