/***************************************************************************

     contractor.h
     -------------
     Copyright (c) 2010 by Andrianov Pavel <andriano@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/

#ifndef CONTRACTOR_H
#define CONTRACTOR_H

#include <QString>
#include "../database/mdb.h"

/**
 * @class Contractor model class
 * @short Contractor model class
 *
 * Class provides functions and variables to work with
 * information about contractors
 *
 * @author Andrianov Pavel, Zabirokhin Denis(doxygen & structure)
 */
class Contractor {
public:
        /**
         * @brief Standart constructor model class Contractor
         * Init standart values in object of contractor
         * @return
         */
        Contractor();
        ///
        /**
         * @brief Constructor
         * Standart constructor with  avaliable fields.
         * @param id integer parameter, id in db of contractor object
         * @param name QString parameter, name in db of contractor object
         * @param address QString parameter, address of contractor
         * @return exit code
         */
        Contractor(int id, QString name, QString address);
        /// Standart constructor + phone parametr
        /**
         * @brief Constructor
         * Standart constructor with  avaliable fields.
         * @param id integer parameter, id in db of contractor object
         * @param name QString parameter, name in db of contractor object
         * @param address QString parameter, address of contractor
         * @param phone QString parameter, phone of contractor
         * @return exit code
         */
        Contractor(int id, QString name, QString address, QString phone);

        /**
         * @brief getID()
         * GetID of this contractor
         * @return int, id of contractor
         */

        int getId();

        /**
         * @brief setId(int new_id)
         * Set id of this contractor
         * @param new_id integer, new id of contractor
         * @return none
         */
        void setId(int new_id);

        /**
         * @brief getName()
         * Get name of contractor
         * @return QString
         */
        QString getName();

        /**
         * @brief setName(new_name) Set name of contractor
         * Set name of contractor
         * @param new_name QString parameter, new name of contractor
         * @return void
         */
        void setName(QString new_name);

        /// Get phone
        /**
         * @brief Get phone
         * get phone of contractor from object of contractor
         * @return QString, phone of contractor
         */
        QString getPhone();

        /**
         * @brief Set phone
         * Set phone in object of contractor
         * @param new_phone QString parameter, phone
         * @return void
         */
        void setPhone(QString new_phone);

        /**
         * @brief Get address in this contractor
         * Get address of contractor
         * @return QString, address
         */
        QString getAddress();

        /**
         * @brief Set address
         * Set address in object contractor
         * @param new_address QString parameter, address
         * @return void
         */
        void setAddress(QString new_address);

        /// Loads the information from the database
        /**
         * @brief Create the contractor using loading from database
         * Load contractor from database
         * @param db pointer to the database module object
         * @param id identifier of contractor in the database
         * @see Mdb::find()
         */
        Contractor(Mdb* db, int id);

        /// Saves the contractor to database
        /**
         * @brief Save contractor to database
         * @param db pointer to the database module object
         */
        void set(Mdb* db);

        /// Get table name
        /**
         * @brief Get table name
         * Get table name in the database, where contractors is located
         * @return name of the table
         */
        QString tableName();

private:
        /**
         * @brief toQString(int)
         * Convert value toQString
         * @param value integer parameter, none
         * @return QString value
         */
        QString toQString(int);

        /**
         * @brief toQString(double)
         * Converts double to QString
         * @param value double parameter, none
         * @return QString value
         */
        QString toQString(double);

protected:
        /// Identifier of the contractor record in the mobile database
        int id;

        /// Name of the contractor
        QString name;

        /// Contractors phone
        QString phone;

        /// Address of the contractor
        QString address;
};
#endif
