/***************************************************************************

     contractor.cpp
     -------------
     Copyright (c) 2010 by Andrianov Pavel <andriano@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/

#include "contractor.h"

Contractor::Contractor() {
}

Contractor::Contractor(int id, QString name, QString address) {
	this->id = id;
	this->name = name;
	this->address = address;
}

Contractor::Contractor(int id, QString name, QString address, QString phone) {
	*this = Contractor(id, name, address);
	this->phone = phone;
}

int Contractor::getId()
{
    return this->id;
}

void Contractor::setId(int new_id)
{
    this->id = new_id;
}

QString Contractor::getName()
{
    return this->name;
}

void Contractor::setName(QString new_name)
{
    this->name = new_name ;
}

QString Contractor::getPhone()
{
    return this->phone;
}

void Contractor::setPhone(QString new_phone)
{
    this->phone = new_phone ;
}

QString Contractor::getAddress()
{
    return this->address;
}

void Contractor::setAddress(QString new_address)
{
    this->address = new_address ;
}

QString Contractor::tableName()
{
    return QString::QString("tblContractor");
}

Contractor::Contractor(Mdb* mdb, int id)
{
    /// Find values with such id in database
    QSqlQueryModel* model = mdb->find(this->tableName(),id);

    /// Parse fields
    this->id = id;
    this->name = model->record(0).value(1).toString();
    this->phone = model->record(0).value(2).toString();
    this->address = model->record(0).value(3).toString();
}

QString Contractor::toQString(int value)
{
    QString string = QString("%1").arg(value);
    return string;
}

QString Contractor::toQString(double value)
{
    QString string = QString("%1").arg(value);
    return string;
}

void Contractor::set(Mdb* mdb)
{
    QVector<QString> fieldsValue;

    fieldsValue.push_back(toQString(this->id));
    fieldsValue.push_back(this->name);
    fieldsValue.push_back(this->phone);
    fieldsValue.push_back(this->address);

    /// If this is the new contractor
    if ( this->id == NEW_ID )
    {
        /// Get the id
        this->id = mdb->getUnusedId(this->tableName());
        fieldsValue[0] = toQString(this->id);

        /// Insert this good into mdb
        mdb->addToDb(this->tableName(), fieldsValue);
    }
    else
    {
        /// Creating additional vector with field names
        QVector<QString> fieldsName;

        /// Fill with names
        fieldsName.push_back("id");
        fieldsName.push_back("name");
        fieldsName.push_back("phone");
        fieldsName.push_back("address");

        /// Update this good in the database
        mdb->addToDb(this->tableName(),&fieldsValue,&fieldsName,this->id);
    }
}

